/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.filter.Analyzer;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.text.TextWindow;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class HistogramWindow
extends ImageWindow
implements Measurements,
ActionListener,
ClipboardOwner {
    static final int WIN_WIDTH = 300;
    static final int WIN_HEIGHT = 240;
    static final int HIST_WIDTH = 256;
    static final int HIST_HEIGHT = 128;
    static final int BAR_HEIGHT = 12;
    static final int XMARGIN = 20;
    static final int YMARGIN = 10;
    protected ImageStatistics stats;
    protected int[] histogram;
    protected LookUpTable lut;
    protected Rectangle frame = null;
    protected Button list;
    protected Button save;
    protected Button copy;
    protected Button log;
    protected Label value;
    protected Label count;
    protected static String defaultDirectory = null;
    protected int decimalPlaces;
    protected int digits;
    protected int newMaxCount;
    protected int plotScale = 1;
    protected boolean logScale;
    protected Calibration cal;
    public static int nBins = 256;

    public HistogramWindow(ImagePlus imp) {
        super(NewImage.createByteImage("Histogram of " + imp.getShortTitle(), 300, 240, 1, 0));
        this.showHistogram(imp, nBins);
    }

    public HistogramWindow(String title, ImagePlus imp, int bins) {
        super(NewImage.createByteImage(title, 300, 240, 1, 0));
        this.showHistogram(imp, bins);
    }

    public void showHistogram(ImagePlus imp, int bins) {
        boolean color;
        ImageProcessor ip;
        this.setup();
        this.cal = imp.getCalibration();
        boolean limitToThreshold = (Analyzer.getMeasurements() & 0x100) != 0;
        imp.getMask();
        this.stats = imp.getStatistics(27 + (limitToThreshold ? 256 : 0), bins);
        this.histogram = this.stats.histogram;
        if (limitToThreshold && this.histogram.length == 256 && (ip = imp.getProcessor()).getMinThreshold() != -808080.0) {
            int lower = this.scaleDown(ip, ip.getMinThreshold());
            int upper = this.scaleDown(ip, ip.getMaxThreshold());
            int i = 0;
            while (i < lower) {
                this.histogram[i] = 0;
                ++i;
            }
            int i2 = upper + 1;
            while (i2 < 256) {
                this.histogram[i2] = 0;
                ++i2;
            }
        }
        this.lut = imp.createLut();
        int type = imp.getType();
        boolean fixedRange = type == 0 || type == 3 || type == 4;
        ImageProcessor ip2 = this.imp.getProcessor();
        boolean bl = color = !(imp.getProcessor() instanceof ColorProcessor) && !this.lut.isGrayscale();
        if (color) {
            ip2 = ip2.convertToRGB();
        }
        this.drawHistogram(ip2, fixedRange);
        if (color) {
            this.imp.setProcessor(null, ip2);
        } else {
            this.imp.updateAndDraw();
        }
    }

    public void setup() {
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(2));
        this.list = new Button("List");
        this.list.addActionListener(this);
        buttons.add(this.list);
        this.copy = new Button("Copy");
        this.copy.addActionListener(this);
        buttons.add(this.copy);
        this.log = new Button("Log");
        this.log.addActionListener(this);
        buttons.add(this.log);
        Panel valueAndCount = new Panel();
        valueAndCount.setLayout(new GridLayout(2, 1));
        this.value = new Label("                  ");
        this.value.setFont(new Font("Monospaced", 0, 12));
        valueAndCount.add(this.value);
        this.count = new Label("                  ");
        this.count.setFont(new Font("Monospaced", 0, 12));
        valueAndCount.add(this.count);
        buttons.add(valueAndCount);
        this.add(buttons);
        this.pack();
    }

    public void mouseMoved(int x, int y) {
        if (this.value == null || this.count == null) {
            return;
        }
        if (this.frame != null && x >= this.frame.x && x <= this.frame.x + this.frame.width) {
            if ((x -= this.frame.x) > 255) {
                x = 255;
            }
            int index = (int)((double)x * (double)this.histogram.length / 256.0);
            this.value.setText("  Value: " + IJ.d2s(this.cal.getCValue(this.stats.histMin + (double)index * this.stats.binSize), this.digits));
            this.count.setText("  Count: " + this.histogram[index]);
        } else {
            this.value.setText("");
            this.count.setText("");
        }
    }

    protected void drawHistogram(ImageProcessor ip, boolean fixedRange) {
        int maxCount2 = 0;
        int mode2 = 0;
        ip.setColor(Color.black);
        ip.setLineWidth(1);
        this.decimalPlaces = Analyzer.getPrecision();
        this.digits = this.cal.calibrated() || this.stats.binSize != 1.0 ? this.decimalPlaces : 0;
        int saveModalCount = this.histogram[this.stats.mode];
        int i = 0;
        while (i < this.histogram.length) {
            if (this.histogram[i] > maxCount2 && i != this.stats.mode) {
                maxCount2 = this.histogram[i];
                mode2 = i;
            }
            ++i;
        }
        this.newMaxCount = this.stats.maxCount;
        if (this.newMaxCount > maxCount2 * 2 && maxCount2 != 0) {
            this.newMaxCount = (int)((double)maxCount2 * 1.5);
        }
        this.drawPlot(this.newMaxCount, ip);
        this.histogram[this.stats.mode] = saveModalCount;
        int x = 21;
        int y = 140;
        this.lut.drawUnscaledColorBar(ip, x - 1, y, 256, 12);
        this.drawText(ip, x, y += 27, fixedRange);
    }

    int scaleDown(ImageProcessor ip, double threshold) {
        double min = ip.getMin();
        double max = ip.getMax();
        if (max > min) {
            return (int)((threshold - min) / (max - min) * 255.0);
        }
        return 0;
    }

    void drawPlot(int maxCount, ImageProcessor ip) {
        this.frame = new Rectangle(20, 10, 256, 128);
        ip.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        int i = 0;
        while (i < 256) {
            int index = (int)((double)i * (double)this.histogram.length / 256.0);
            int y = 128 * this.histogram[index] / maxCount;
            if (y > 128) {
                y = 128;
            }
            ip.drawLine(i + 20, 138, i + 20, 138 - y);
            ++i;
        }
    }

    void drawLogPlot(int maxCount, ImageProcessor ip) {
        this.frame = new Rectangle(20, 10, 256, 128);
        ip.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        double max = Math.log(maxCount);
        ip.setColor(Color.gray);
        int i = 0;
        while (i < 256) {
            int y;
            int index = (int)((double)i * (double)this.histogram.length / 256.0);
            int n = y = this.histogram[index] == 0 ? 0 : (int)(128.0 * Math.log(this.histogram[index]) / max);
            if (y > 128) {
                y = 128;
            }
            ip.drawLine(i + 20, 138, i + 20, 138 - y);
            ++i;
        }
        ip.setColor(Color.black);
    }

    void drawText(ImageProcessor ip, int x, int y, boolean fixedRange) {
        ip.setFont(new Font("SansSerif", 0, 12));
        ip.setAntialiasedText(true);
        double hmin = this.cal.getCValue(this.stats.histMin);
        double hmax = this.cal.getCValue(this.stats.histMax);
        ip.drawString(this.d2s(hmin), x - 4, y);
        ip.drawString(this.d2s(hmax), x + 256 - this.getWidth(hmax, ip) + 10, y);
        double binWidth = fixedRange && !this.cal.calibrated() ? this.stats.binSize : (hmax - hmin) / (double)this.stats.nBins;
        binWidth = Math.abs(binWidth);
        boolean showBins = binWidth != 1.0 || !fixedRange;
        int col1 = 25;
        int col2 = 148;
        int row1 = y + 25;
        if (showBins) {
            row1 -= 8;
        }
        int row2 = row1 + 15;
        int row3 = row2 + 15;
        int row4 = row3 + 15;
        ip.drawString("Count: " + this.stats.pixelCount, col1, row1);
        ip.drawString("Mean: " + this.d2s(this.stats.mean), col1, row2);
        ip.drawString("StdDev: " + this.d2s(this.stats.stdDev), col1, row3);
        ip.drawString("Mode: " + this.d2s(this.stats.dmode) + " (" + this.stats.maxCount + ")", col2, row3);
        ip.drawString("Min: " + this.d2s(this.stats.min), col2, row1);
        ip.drawString("Max: " + this.d2s(this.stats.max), col2, row2);
        if (showBins) {
            ip.drawString("Bins: " + this.d2s(this.stats.nBins), col1, row4);
            ip.drawString("Bin Width: " + this.d2s(binWidth), col2, row4);
        }
    }

    String d2s(double d) {
        if ((double)((int)d) == d) {
            return IJ.d2s(d, 0);
        }
        return IJ.d2s(d, this.decimalPlaces);
    }

    int getWidth(double d, ImageProcessor ip) {
        return ip.getStringWidth(this.d2s(d));
    }

    void showList() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.stats.nBins) {
            sb.append(IJ.d2s(this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize), this.digits) + "\t" + this.histogram[i] + "\n");
            ++i;
        }
        TextWindow textWindow = new TextWindow(this.getTitle(), "value\tcount", sb.toString(), 200, 400);
    }

    void copyToClipboard() {
        Clipboard systemClipboard = null;
        try {
            systemClipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            systemClipboard = null;
        }
        if (systemClipboard == null) {
            IJ.error("Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus("Copying histogram values...");
        CharArrayWriter aw = new CharArrayWriter(this.stats.nBins * 4);
        PrintWriter pw = new PrintWriter(aw);
        int i = 0;
        while (i < this.stats.nBins) {
            pw.print(IJ.d2s(this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize), this.digits) + "\t" + this.histogram[i] + "\n");
            ++i;
        }
        String text = aw.toString();
        pw.close();
        StringSelection contents = new StringSelection(text);
        systemClipboard.setContents(contents, this);
        IJ.showStatus(text.length() + " characters copied to Clipboard");
    }

    void replot() {
        this.logScale = !this.logScale;
        ImageProcessor ip = this.imp.getProcessor();
        this.frame = new Rectangle(20, 10, 256, 128);
        ip.setColor(Color.white);
        ip.setRoi(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height);
        ip.fill();
        ip.resetRoi();
        ip.setColor(Color.black);
        if (this.logScale) {
            this.drawLogPlot(this.newMaxCount, ip);
            this.drawPlot(this.newMaxCount, ip);
        } else {
            this.drawPlot(this.newMaxCount, ip);
        }
        this.imp.updateAndDraw();
    }

    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        if (b == this.list) {
            this.showList();
        } else if (b == this.copy) {
            this.copyToClipboard();
        } else if (b == this.log) {
            this.replot();
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public int[] getHistogram() {
        return this.histogram;
    }
}

