/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.plugin.frame.Recorder;
import ij.util.Java2;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.IndexColorModel;

public class ImageCanvas
extends Canvas
implements MouseListener,
MouseMotionListener,
Cloneable {
    protected static Cursor defaultCursor = new Cursor(0);
    protected static Cursor handCursor = new Cursor(12);
    protected static Cursor moveCursor = new Cursor(13);
    protected static Cursor crosshairCursor = new Cursor(1);
    public static boolean usePointer = Prefs.usePointerCursor;
    protected ImagePlus imp;
    protected boolean imageUpdated;
    protected Rectangle srcRect;
    protected int imageWidth;
    protected int imageHeight;
    private ImageJ ij;
    private double magnification;
    private int dstWidth;
    private int dstHeight;
    private int xMouseStart;
    private int yMouseStart;
    private int xSrcStart;
    private int ySrcStart;
    private int xMouse;
    private int yMouse;
    private int flags;
    int count;
    private static final double[] zoomLevels = new double[]{0.03125, 0.041666666666666664, 0.0625, 0.08333333333333333, 0.125, 0.16666666666666666, 0.25, 0.3333333333333333, 0.5, 0.75, 1.0, 2.0, 3.0, 4.0, 6.0, 8.0, 12.0, 16.0, 24.0, 32.0};

    public ImageCanvas(ImagePlus imp) {
        this.imp = imp;
        this.ij = IJ.getInstance();
        int width = imp.getWidth();
        int height = imp.getHeight();
        this.imageWidth = width;
        this.imageHeight = height;
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        this.setDrawingSize(width, height);
        this.magnification = 1.0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this.ij);
    }

    public void setDrawingSize(int width, int height) {
        this.dstWidth = width;
        this.dstHeight = height;
        this.setSize(this.dstWidth, this.dstHeight);
    }

    public void setImageUpdated() {
        this.imageUpdated = true;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            roi.updatePaste();
        }
        try {
            Image img;
            if (this.imageUpdated) {
                this.imageUpdated = false;
                this.imp.updateImage();
            }
            if (IJ.isJava2()) {
                if (this.magnification < 1.0) {
                    Java2.setBilinearInterpolation(g, true);
                } else if (IJ.isMacOSX()) {
                    Java2.setBilinearInterpolation(g, false);
                }
            }
            if ((img = this.imp.getImage()) != null) {
                g.drawImage(img, 0, 0, (int)((double)this.srcRect.width * this.magnification), (int)((double)this.srcRect.height * this.magnification), this.srcRect.x, this.srcRect.y, this.srcRect.x + this.srcRect.width, this.srcRect.y + this.srcRect.height, null);
            }
            if (roi != null) {
                roi.draw(g);
            }
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory("Paint");
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.dstWidth, this.dstHeight);
    }

    public Point getCursorLoc() {
        return new Point(this.xMouse, this.yMouse);
    }

    public int getModifiers() {
        return this.flags;
    }

    public void setCursor(int sx, int sy, int ox, int oy) {
        this.xMouse = ox;
        this.yMouse = oy;
        Roi roi = this.imp.getRoi();
        ImageWindow win = this.imp.getWindow();
        if (win == null) {
            return;
        }
        if (IJ.spaceBarDown()) {
            this.setCursor(handCursor);
            return;
        }
        switch (Toolbar.getToolId()) {
            case 11: {
                if (IJ.isMacintosh()) {
                    this.setCursor(defaultCursor);
                    break;
                }
                this.setCursor(moveCursor);
                break;
            }
            case 12: {
                this.setCursor(handCursor);
                break;
            }
            default: {
                if (roi != null && roi.getState() != 0 && roi.isHandle(sx, sy) >= 0) {
                    this.setCursor(handCursor);
                    break;
                }
                if (usePointer || roi != null && roi.getState() != 0 && roi.contains(ox, oy)) {
                    this.setCursor(defaultCursor);
                    break;
                }
                this.setCursor(crosshairCursor);
            }
        }
    }

    public int offScreenX(int x) {
        return this.srcRect.x + (int)((double)x / this.magnification);
    }

    public int offScreenY(int y) {
        return this.srcRect.y + (int)((double)y / this.magnification);
    }

    public int screenX(int x) {
        return (int)((double)(x - this.srcRect.x) * this.magnification);
    }

    public int screenY(int y) {
        return (int)((double)(y - this.srcRect.y) * this.magnification);
    }

    public double getMagnification() {
        return this.magnification;
    }

    public void setMagnification(double magnification) {
        this.magnification = magnification;
        this.imp.setTitle(this.imp.getTitle());
    }

    public Rectangle getSrcRect() {
        return this.srcRect;
    }

    void resizeCanvas(int width, int height) {
        if (this.srcRect.width < this.imageWidth || this.srcRect.height < this.imageHeight) {
            if ((double)width > (double)this.imageWidth * this.magnification) {
                width = (int)((double)this.imageWidth * this.magnification);
            }
            if ((double)height > (double)this.imageHeight * this.magnification) {
                height = (int)((double)this.imageHeight * this.magnification);
            }
            this.setDrawingSize(width, height);
            this.srcRect.width = (int)((double)this.dstWidth / this.magnification);
            this.srcRect.height = (int)((double)this.dstHeight / this.magnification);
            if (this.srcRect.x + this.srcRect.width > this.imageWidth) {
                this.srcRect.x = this.imageWidth - this.srcRect.width;
            }
            if (this.srcRect.y + this.srcRect.height > this.imageHeight) {
                this.srcRect.y = this.imageHeight - this.srcRect.height;
            }
            this.repaint();
        }
    }

    static double getLowerZoomLevel(double currentMag) {
        double newMag = zoomLevels[0];
        int i = 0;
        while (i < zoomLevels.length) {
            if (!(zoomLevels[i] < currentMag)) break;
            newMag = zoomLevels[i];
            ++i;
        }
        return newMag;
    }

    static double getHigherZoomLevel(double currentMag) {
        double newMag = 32.0;
        int i = zoomLevels.length - 1;
        while (i >= 0) {
            if (!(zoomLevels[i] > currentMag)) break;
            newMag = zoomLevels[i];
            --i;
        }
        return newMag;
    }

    public void zoomIn(int x, int y) {
        int newHeight;
        if (this.magnification >= 32.0) {
            return;
        }
        double newMag = ImageCanvas.getHigherZoomLevel(this.magnification);
        int newWidth = (int)((double)this.imageWidth * newMag);
        if (this.canEnlarge(newWidth, newHeight = (int)((double)this.imageHeight * newMag))) {
            this.setDrawingSize(newWidth, newHeight);
            this.imp.getWindow().pack();
        } else {
            int h;
            int w = (int)Math.round((double)this.dstWidth / newMag);
            if ((double)w * newMag < (double)this.dstWidth) {
                ++w;
            }
            if ((double)(h = (int)Math.round((double)this.dstHeight / newMag)) * newMag < (double)this.dstHeight) {
                ++h;
            }
            x = this.offScreenX(x);
            y = this.offScreenY(y);
            Rectangle r = new Rectangle(x - w / 2, y - h / 2, w, h);
            if (r.x < 0) {
                r.x = 0;
            }
            if (r.y < 0) {
                r.y = 0;
            }
            if (r.x + w > this.imageWidth) {
                r.x = this.imageWidth - w;
            }
            if (r.y + h > this.imageHeight) {
                r.y = this.imageHeight - h;
            }
            this.srcRect = r;
        }
        this.setMagnification(newMag);
        this.repaint();
    }

    boolean canEnlarge(int newWidth, int newHeight) {
        if ((this.flags & 1) != 0) {
            return false;
        }
        Rectangle r1 = this.imp.getWindow().getBounds();
        r1.width = newWidth + 20;
        r1.height = newHeight + 50;
        if (this.imp.getStackSize() > 1) {
            r1.height += 20;
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        boolean fitsOnScreen = r1.x + r1.width < screen.width && r1.y + r1.height + 30 < screen.height;
        return fitsOnScreen;
    }

    public void zoomOut(int x, int y) {
        if (this.magnification <= 0.03125) {
            return;
        }
        double newMag = ImageCanvas.getLowerZoomLevel(this.magnification);
        if ((double)this.imageWidth * newMag > (double)this.dstWidth) {
            int h;
            int w = (int)Math.round((double)this.dstWidth / newMag);
            if ((double)w * newMag < (double)this.dstWidth) {
                ++w;
            }
            if ((double)(h = (int)Math.round((double)this.dstHeight / newMag)) * newMag < (double)this.dstHeight) {
                ++h;
            }
            x = this.offScreenX(x);
            y = this.offScreenY(y);
            Rectangle r = new Rectangle(x - w / 2, y - h / 2, w, h);
            if (r.x < 0) {
                r.x = 0;
            }
            if (r.y < 0) {
                r.y = 0;
            }
            if (r.x + w > this.imageWidth) {
                r.x = this.imageWidth - w;
            }
            if (r.y + h > this.imageHeight) {
                r.y = this.imageHeight - h;
            }
            this.srcRect = r;
        } else {
            this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
            this.setDrawingSize((int)((double)this.imageWidth * newMag), (int)((double)this.imageHeight * newMag));
            this.imp.getWindow().pack();
        }
        this.setMagnification(newMag);
        this.repaint();
    }

    void unzoom() {
        double imag = this.imp.getWindow().getInitialMagnification();
        if (this.magnification == imag) {
            return;
        }
        this.setMagnification(imag);
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        ImageWindow win = this.imp.getWindow();
        this.setDrawingSize((int)((double)this.imageWidth * imag), (int)((double)this.imageHeight * imag));
        win.pack();
        this.repaint();
    }

    void scroll(int sx, int sy) {
        int ox = this.xSrcStart + (int)((double)sx / this.magnification);
        int oy = this.ySrcStart + (int)((double)sy / this.magnification);
        int newx = this.xSrcStart + (this.xMouseStart - ox);
        int newy = this.ySrcStart + (this.yMouseStart - oy);
        if (newx < 0) {
            newx = 0;
        }
        if (newy < 0) {
            newy = 0;
        }
        if (newx + this.srcRect.width > this.imageWidth) {
            newx = this.imageWidth - this.srcRect.width;
        }
        if (newy + this.srcRect.height > this.imageHeight) {
            newy = this.imageHeight - this.srcRect.height;
        }
        this.srcRect.x = newx;
        this.srcRect.y = newy;
        this.imp.draw();
        Thread.yield();
    }

    Color getColor(int index) {
        IndexColorModel cm = (IndexColorModel)this.imp.getProcessor().getColorModel();
        return new Color(cm.getRGB(index));
    }

    protected void setDrawingColor(int ox, int oy, boolean setBackground) {
        Color c;
        int type = this.imp.getType();
        int[] v = this.imp.getPixel(ox, oy);
        switch (type) {
            case 0: {
                if (setBackground) {
                    this.setBackgroundColor(this.getColor(v[0]));
                    break;
                }
                this.setForegroundColor(this.getColor(v[0]));
                break;
            }
            case 1: 
            case 2: {
                double min = this.imp.getProcessor().getMin();
                double max = this.imp.getProcessor().getMax();
                double value = type == 2 ? (double)Float.intBitsToFloat(v[0]) : (double)v[0];
                int index = (int)(255.0 * ((value - min) / (max - min)));
                if (index < 0) {
                    index = 0;
                }
                if (index > 255) {
                    index = 255;
                }
                if (setBackground) {
                    this.setBackgroundColor(this.getColor(index));
                    break;
                }
                this.setForegroundColor(this.getColor(index));
                break;
            }
            case 3: 
            case 4: {
                Color c2 = new Color(v[0], v[1], v[2]);
                if (setBackground) {
                    this.setBackgroundColor(c2);
                    break;
                }
                this.setForegroundColor(c2);
                break;
            }
        }
        if (setBackground) {
            c = Toolbar.getBackgroundColor();
        } else {
            c = Toolbar.getForegroundColor();
            this.imp.setColor(c);
        }
        IJ.showStatus("(" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + ")");
    }

    private void setForegroundColor(Color c) {
        Toolbar.setForegroundColor(c);
        if (Recorder.record) {
            Recorder.record("setForegroundColor", c.getRed(), c.getGreen(), c.getBlue());
        }
    }

    private void setBackgroundColor(Color c) {
        Toolbar.setBackgroundColor(c);
        if (Recorder.record) {
            Recorder.record("setBackgroundColor", c.getRed(), c.getGreen(), c.getBlue());
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.ij == null) {
            return;
        }
        int toolID = Toolbar.getToolId();
        ImageWindow win = this.imp.getWindow();
        if (win != null && win.running && toolID != 11) {
            win.running = false;
            return;
        }
        int x = e.getX();
        int y = e.getY();
        this.flags = e.getModifiers();
        if (IJ.debugMode) {
            IJ.log("Mouse pressed: (" + x + "," + y + ")" + ImageJ.modifiers(this.flags));
        }
        if (toolID != 11 && (e.isPopupTrigger() || (this.flags & 4) != 0)) {
            this.handlePopupMenu(e);
            return;
        }
        int ox = this.offScreenX(x);
        int oy = this.offScreenY(y);
        this.xMouse = ox;
        this.yMouse = oy;
        if (IJ.spaceBarDown()) {
            this.setupScroll(ox, oy);
            return;
        }
        if ((this.flags & 8) != 0 && toolID != 11 && toolID != 13) {
            this.setDrawingColor(ox, oy, false);
            return;
        }
        switch (toolID) {
            case 11: {
                if ((this.flags & 0xE) != 0) {
                    this.zoomOut(x, y);
                    break;
                }
                this.zoomIn(x, y);
                break;
            }
            case 12: {
                this.setupScroll(ox, oy);
                break;
            }
            case 13: {
                this.setDrawingColor(ox, oy, IJ.altKeyDown());
                break;
            }
            case 7: {
                IJ.doCommand("Measure");
                break;
            }
            case 8: {
                int handle;
                Roi roi = this.imp.getRoi();
                if (roi != null && roi.contains(ox, oy)) {
                    Rectangle r = roi.getBoundingRect();
                    if (r.width == this.imageWidth && r.height == this.imageHeight) {
                        this.imp.killRoi();
                    } else {
                        this.handleRoiMouseDown(x, y);
                        return;
                    }
                }
                if (roi != null && (handle = roi.isHandle(x, y)) >= 0) {
                    roi.mouseDownInHandle(handle, x, y);
                    return;
                }
                int npoints = IJ.doWand(ox, oy);
                if (!Recorder.record || npoints <= 0) break;
                Recorder.record("doWand", ox, oy);
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                Toolbar.getInstance().runMacroTool(toolID);
                break;
            }
            default: {
                this.handleRoiMouseDown(x, y);
            }
        }
    }

    void setupScroll(int ox, int oy) {
        this.xMouseStart = ox;
        this.yMouseStart = oy;
        this.xSrcStart = this.srcRect.x;
        this.ySrcStart = this.srcRect.y;
    }

    protected void handlePopupMenu(MouseEvent e) {
        if (IJ.debugMode) {
            IJ.log("show popup: " + (e.isPopupTrigger() ? "true" : "false"));
        }
        int x = e.getX();
        int y = e.getY();
        Roi roi = this.imp.getRoi();
        if (roi != null && (roi.getType() == 2 || roi.getType() == 6 || roi.getType() == 8) && roi.getState() == 0) {
            roi.handleMouseUp(x, y);
            roi.handleMouseUp(x, y);
            return;
        }
        PopupMenu popup = Menus.getPopupMenu();
        if (popup != null) {
            this.add(popup);
            popup.show(this, x, y);
        }
    }

    public void mouseExited(MouseEvent e) {
        ImageWindow win = this.imp.getWindow();
        if (win != null) {
            this.setCursor(defaultCursor);
        }
        IJ.showStatus("");
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.xMouse = this.offScreenX(x);
        this.yMouse = this.offScreenY(y);
        this.flags = e.getModifiers();
        if (this.flags == 0) {
            this.flags = 16;
        }
        if (Toolbar.getToolId() == 12 || IJ.spaceBarDown()) {
            this.scroll(x, y);
        } else {
            Roi roi = this.imp.getRoi();
            if (roi != null) {
                roi.handleMouseDrag(x, y, (this.flags & 1) != 0);
            }
        }
    }

    void handleRoiMouseDown(int sx, int sy) {
        int ox = this.offScreenX(sx);
        int oy = this.offScreenY(sy);
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            Rectangle r = roi.getBoundingRect();
            int type = roi.getType();
            if (type == 0 && r.width == this.imp.getWidth() && r.height == this.imp.getHeight() && roi.getPasteMode() == -1) {
                this.imp.killRoi();
                return;
            }
            int handle = roi.isHandle(sx, sy);
            if (handle >= 0) {
                roi.mouseDownInHandle(handle, sx, sy);
                return;
            }
            if (roi.contains(ox, oy)) {
                roi.handleMouseDown(sx, sy);
                return;
            }
            if ((type == 2 || type == 6 || type == 8) && roi.getState() == 0) {
                return;
            }
        }
        this.imp.createNewRoi(ox, oy);
    }

    public void mouseReleased(MouseEvent e) {
        this.flags = e.getModifiers();
        this.flags &= 0xFFFFFFEF;
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            Rectangle r = roi.getBoundingRect();
            if (!(r.width != 0 && r.height != 0 || roi.getType() == 2 || roi.getType() == 6 || roi.getType() == 8 || roi instanceof TextRoi || roi.getState() != 0)) {
                this.imp.killRoi();
            } else {
                roi.handleMouseUp(e.getX(), e.getY());
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.ij == null) {
            return;
        }
        int sx = e.getX();
        int sy = e.getY();
        int ox = this.offScreenX(sx);
        int oy = this.offScreenY(sy);
        this.flags = e.getModifiers();
        this.setCursor(sx, sy, ox, oy);
        Roi roi = this.imp.getRoi();
        if (roi != null && (roi.getType() == 2 || roi.getType() == 6 || roi.getType() == 8) && roi.getState() == 0) {
            PolygonRoi pRoi = (PolygonRoi)roi;
            pRoi.handleMouseMove(ox, oy);
        } else if (ox < this.imageWidth && oy < this.imageHeight) {
            ImageWindow win = this.imp.getWindow();
            if (win != null) {
                win.mouseMoved(ox, oy);
            }
        } else {
            IJ.showStatus("");
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }
}

