/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.ImageCanvas;
import ij.gui.ImageLayout;
import ij.gui.Roi;
import ij.gui.SaveChangesDialog;
import ij.gui.StackWindow;
import ij.gui.Toolbar;
import ij.io.FileSaver;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class ImageWindow
extends Frame
implements FocusListener,
WindowListener {
    protected ImagePlus imp;
    protected ImageJ ij;
    protected ImageCanvas ic;
    private double initialMagnification = 1.0;
    private int newWidth;
    private int newHeight;
    protected static ImagePlus clipboard;
    protected boolean closed;
    private static final int XINC = 8;
    private static final int YINC = 12;
    private static final int TEXT_GAP = 10;
    private static final int MENU_BAR_HEIGHT = 40;
    private static int xbase;
    private static int ybase;
    private static int xloc;
    private static int yloc;
    private static int count;
    private static boolean centerOnScreen;
    public boolean running;

    public ImageWindow(ImagePlus imp) {
        this(imp, new ImageCanvas(imp));
    }

    public ImageWindow(ImagePlus imp, ImageCanvas ic) {
        super(imp.getTitle());
        ((Component)this).setBackground(Color.white);
        this.setForeground(Color.black);
        this.ij = IJ.getInstance();
        this.imp = imp;
        this.ic = ic;
        ImageWindow previousWindow = imp.getWindow();
        this.setLayout(new ImageLayout(ic));
        this.add(ic);
        this.addFocusListener(this);
        this.addWindowListener(this);
        this.addKeyListener(this.ij);
        this.setResizable(true);
        WindowManager.addWindow(this);
        imp.setWindow(this);
        if (previousWindow != null) {
            this.setLocationAndSize();
            Point loc = previousWindow.getLocation();
            ((Component)this).setLocation(loc.x, loc.y);
            this.show();
            boolean unlocked = imp.lockSilently();
            boolean changes = imp.changes;
            imp.changes = false;
            previousWindow.close();
            imp.changes = changes;
            if (unlocked) {
                imp.unlock();
            }
            WindowManager.setCurrentWindow(this);
        } else {
            Image img;
            this.setLocationAndSize();
            if (this.ij != null && !IJ.isMacintosh() && (img = this.ij.getIconImage()) != null) {
                this.setIconImage(img);
            }
            if (centerOnScreen) {
                GUI.center(this);
                centerOnScreen = false;
            }
            this.show();
        }
    }

    private void setLocationAndSize() {
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        if (WindowManager.getWindowCount() <= 1) {
            xbase = -1;
        }
        if (xbase == -1) {
            Rectangle ijBounds;
            Rectangle rectangle = ijBounds = this.ij != null ? this.ij.getBounds() : new Rectangle(10, 5, 0, 0);
            if (IJ.isMacintosh()) {
                ijBounds.height += 24;
            }
            count = 0;
            xbase = 5;
            ybase = ijBounds.y + ijBounds.height;
            if (ybase > 140) {
                ybase = ijBounds.height;
            }
            xloc = xbase;
            yloc = ybase;
        }
        int x = xloc;
        int y = yloc;
        xloc += 8;
        yloc += 12;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (++count % 6 == 0) {
            xloc = xbase;
            yloc = ybase;
        }
        int taskbarHeight = IJ.isWindows() ? 30 : 0;
        int sliderHeight = this instanceof StackWindow ? 20 : 0;
        int screenHeight = screen.height - 40 - taskbarHeight - sliderHeight;
        double mag = 1.0;
        while ((double)(xbase + 32) + (double)width * mag > (double)screen.width || (double)ybase + (double)height * mag > (double)screenHeight) {
            mag = ImageCanvas.getLowerZoomLevel(mag);
        }
        this.ic.setMagnification(mag);
        if (mag < 1.0) {
            this.initialMagnification = mag;
            this.ic.setDrawingSize((int)((double)width * mag), (int)((double)height * mag));
        }
        if ((double)y + (double)height * mag > (double)screenHeight) {
            y = ybase;
        }
        ((Component)this).setLocation(x, y);
        if (Prefs.open100Percent && this.ic.getMagnification() < 1.0) {
            while (this.ic.getMagnification() < 1.0) {
                this.ic.zoomIn(0, 0);
            }
            ((Component)this).setSize(Math.min(width, screen.width - x), Math.min(height, screenHeight - y));
            this.validate();
        } else {
            this.pack();
        }
    }

    public double getInitialMagnification() {
        return this.initialMagnification;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 10, insets.left, insets.bottom, insets.right);
    }

    public void drawInfo(Graphics g) {
        String s = "";
        Insets insets = super.getInsets();
        int nSlices = this.imp.getStackSize();
        if (nSlices > 1) {
            int newline;
            ImageStack stack = this.imp.getStack();
            int currentSlice = this.imp.getCurrentSlice();
            s = s + currentSlice + "/" + nSlices;
            boolean isLabel = false;
            String label = stack.getSliceLabel(currentSlice);
            int n = newline = label != null ? label.indexOf(10) : -1;
            if (newline > 0) {
                label = label.substring(0, newline);
            }
            if (label != null && label.length() > 0) {
                s = s + " (" + label + ")";
            }
            if (this instanceof StackWindow && this.running) {
                g.drawString(s, 5, insets.top + 10);
                return;
            }
            s = s + "; ";
        }
        int type = this.imp.getType();
        Calibration cal = this.imp.getCalibration();
        s = cal.pixelWidth != 1.0 || cal.pixelHeight != 1.0 ? s + IJ.d2s((double)this.imp.getWidth() * cal.pixelWidth, 2) + "x" + IJ.d2s((double)this.imp.getHeight() * cal.pixelHeight, 2) + " " + cal.getUnits() + " (" + this.imp.getWidth() + "x" + this.imp.getHeight() + "); " : s + this.imp.getWidth() + "x" + this.imp.getHeight() + " pixels; ";
        int size = this.imp.getWidth() * this.imp.getHeight() * this.imp.getStackSize() / 1024;
        switch (type) {
            case 0: {
                s = s + "8-bit";
                break;
            }
            case 1: {
                s = s + "16-bit grayscale";
                size *= 2;
                break;
            }
            case 2: {
                s = s + "32-bit grayscale";
                size *= 4;
                break;
            }
            case 3: {
                s = s + "8-bit color";
                break;
            }
            case 4: {
                s = s + "RGB";
                size *= 4;
            }
        }
        s = s + "; " + size + "K";
        g.drawString(s, 5, insets.top + 10);
    }

    public void paint(Graphics g) {
        this.drawInfo(g);
        Point loc = this.ic.getLocation();
        Dimension csize = this.ic.getSize();
        g.drawRect(loc.x - 1, loc.y - 1, csize.width + 1, csize.height + 1);
    }

    public boolean close() {
        boolean isRunning = this.running;
        this.running = false;
        if (isRunning) {
            IJ.wait(500);
        }
        ImageJ ij = IJ.getInstance();
        if (this.imp.changes && IJ.getApplet() == null && !IJ.macroRunning() && ij != null) {
            FileSaver fs;
            SaveChangesDialog d = new SaveChangesDialog((Frame)ij, this.imp.getTitle());
            if (d.cancelPressed()) {
                return false;
            }
            if (d.savePressed() && !(fs = new FileSaver(this.imp)).save()) {
                return false;
            }
        }
        this.closed = true;
        if (WindowManager.getWindowCount() == 0) {
            xloc = 0;
            yloc = 0;
        }
        WindowManager.removeWindow(this);
        ((Component)this).setVisible(false);
        this.dispose();
        this.imp.flush();
        return true;
    }

    public ImagePlus getImagePlus() {
        return this.imp;
    }

    void setImagePlus(ImagePlus imp) {
        this.imp = imp;
        this.repaint();
    }

    public ImageCanvas getCanvas() {
        return this.ic;
    }

    static ImagePlus getClipboard() {
        return clipboard;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void focusGained(FocusEvent e) {
        WindowManager.setCurrentWindow(this);
    }

    public void windowActivated(WindowEvent e) {
        if (IJ.isMacintosh() && IJ.getInstance() != null) {
            this.setMenuBar(Menus.getMenuBar());
        }
        if (!this.closed) {
            WindowManager.setCurrentWindow(this);
        }
    }

    public void windowClosing(WindowEvent e) {
        if (this.closed) {
            return;
        }
        if (IJ.getInstance() != null) {
            WindowManager.setCurrentWindow(this);
            IJ.doCommand("Close");
        } else {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void copy(boolean cut) {
        Roi roi = this.imp.getRoi();
        String msg = cut ? "Cut" : "Copy";
        IJ.showStatus(msg + "ing...");
        ImageProcessor ip = this.imp.getProcessor();
        ImageProcessor ip2 = ip.crop();
        clipboard = new ImagePlus("Clipboard", ip2);
        if (roi != null && roi.getType() != 0) {
            clipboard.setRoi((Roi)roi.clone());
        }
        if (cut) {
            ip.snapshot();
            ip.setColor(Toolbar.getBackgroundColor());
            ip.fill();
            if (roi != null && roi.getType() != 0) {
                ip.reset(this.imp.getMask());
            }
            this.imp.setColor(Toolbar.getForegroundColor());
            Undo.setup(1, this.imp);
            this.imp.updateAndDraw();
        }
        int bytesPerPixel = 1;
        switch (clipboard.getType()) {
            case 1: {
                bytesPerPixel = 2;
                break;
            }
            case 2: 
            case 4: {
                bytesPerPixel = 4;
            }
        }
        IJ.showStatus(msg + ": " + clipboard.getWidth() * clipboard.getHeight() * bytesPerPixel / 1024 + "k");
    }

    public void paste() {
        if (IJ.macroRunning()) {
            IJ.wait(500);
        }
        if (clipboard == null) {
            return;
        }
        int cType = clipboard.getType();
        int iType = this.imp.getType();
        boolean sameType = false;
        if (cType == 0 | cType == 3 && iType == 0 | iType == 3) {
            sameType = true;
        } else if (cType == 4 | cType == 0 | cType == 3 && iType == 4) {
            sameType = true;
        } else if (cType == 1 && iType == 1) {
            sameType = true;
        } else if (cType == 2 && iType == 2) {
            sameType = true;
        }
        if (!sameType) {
            IJ.error("Images must be the same type to paste.");
            return;
        }
        int w = clipboard.getWidth();
        int h = clipboard.getHeight();
        if (w > this.imp.getWidth() || h > this.imp.getHeight()) {
            IJ.error("Image is too large to paste.");
            return;
        }
        Roi roi = this.imp.getRoi();
        Rectangle r = null;
        if (roi != null) {
            r = roi.getBoundingRect();
        }
        if (r == null || r != null && (w != r.width || h != r.height)) {
            Rectangle srcRect = this.ic.getSrcRect();
            int xCenter = srcRect.x + srcRect.width / 2;
            int yCenter = srcRect.y + srcRect.height / 2;
            Roi cRoi = clipboard.getRoi();
            if (cRoi != null && cRoi.getType() != 0) {
                cRoi.setImage(this.imp);
                cRoi.setLocation(xCenter - w / 2, yCenter - h / 2);
                this.imp.setRoi(cRoi);
            } else {
                this.imp.setRoi(xCenter - w / 2, yCenter - h / 2, w, h);
            }
            roi = this.imp.getRoi();
        }
        roi.startPaste(clipboard);
        if (IJ.macroRunning()) {
            roi.endPaste();
            this.imp.killRoi();
        } else {
            Undo.setup(3, this.imp);
        }
        this.imp.changes = true;
    }

    public void mouseMoved(int x, int y) {
        this.imp.mouseMoved(x, y);
    }

    public String toString() {
        return this.imp.getTitle();
    }

    public static void centerNextImage() {
        centerOnScreen = true;
    }

    static {
        xbase = -1;
    }
}

