/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class MultiLineLabel
extends Canvas {
    String[] lines;
    int num_lines;
    int margin_width = 6;
    int margin_height = 6;
    int line_height;
    int line_ascent;
    int[] line_widths;
    int max_width;

    public MultiLineLabel(String label) {
        StringTokenizer t = new StringTokenizer(label, "\n");
        this.num_lines = t.countTokens();
        this.lines = new String[this.num_lines];
        this.line_widths = new int[this.num_lines];
        int i = 0;
        while (i < this.num_lines) {
            this.lines[i] = t.nextToken();
            ++i;
        }
    }

    protected void measure() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm == null) {
            return;
        }
        this.line_height = fm.getHeight();
        this.line_ascent = fm.getAscent();
        this.max_width = 0;
        int i = 0;
        while (i < this.num_lines) {
            this.line_widths[i] = fm.stringWidth(this.lines[i]);
            if (this.line_widths[i] > this.max_width) {
                this.max_width = this.line_widths[i];
            }
            ++i;
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.measure();
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.max_width + 2 * this.margin_width, this.num_lines * this.line_height + 2 * this.margin_height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.max_width, this.num_lines * this.line_height);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        int y = this.line_ascent + (d.height - this.num_lines * this.line_height) / 2;
        int i = 0;
        while (i < this.num_lines) {
            int x = this.margin_width;
            g.drawString(this.lines[i], x, y);
            ++i;
            y += this.line_height;
        }
    }
}

