/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.gui.GUI;
import ij.gui.Line;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class OvalRoi
extends Roi {
    public OvalRoi(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.type = 1;
    }

    public OvalRoi(int x, int y, ImagePlus imp) {
        super(x, y, imp);
        this.type = 1;
    }

    public OvalRoi(int x, int y, int width, int height, ImagePlus imp) {
        this(x, y, width, height);
        this.setImage(imp);
    }

    protected void moveHandle(int ox, int oy) {
        if (this.clipboard != null) {
            return;
        }
        int x1 = this.x;
        int y1 = this.y;
        int x2 = x1 + this.width;
        int y2 = this.y + this.height;
        int w2 = (int)(0.14645 * (double)this.width);
        int h2 = (int)(0.14645 * (double)this.height);
        switch (this.activeHandle) {
            case 0: {
                this.x = ox - w2;
                this.y = oy - h2;
                break;
            }
            case 1: {
                this.y = oy;
                break;
            }
            case 2: {
                x2 = ox + w2;
                this.y = oy - h2;
                break;
            }
            case 3: {
                x2 = ox;
                break;
            }
            case 4: {
                x2 = ox + w2;
                y2 = oy + h2;
                break;
            }
            case 5: {
                y2 = oy;
                break;
            }
            case 6: {
                this.x = ox - w2;
                y2 = oy + h2;
                break;
            }
            case 7: {
                this.x = ox;
            }
        }
        if (this.x < 0) {
            this.x = 0;
        }
        if (this.y < 0) {
            this.y = 0;
        }
        if (this.x < x2) {
            this.width = x2 - this.x;
        } else {
            this.width = 1;
            this.x = x2;
        }
        if (this.y < y2) {
            this.height = y2 - this.y;
        } else {
            this.height = 1;
            this.y = y2;
        }
        if (this.constrain) {
            this.height = this.width;
        }
        if (this.x + this.width > this.xMax) {
            this.width = this.xMax - this.x;
        }
        if (this.y + this.height > this.yMax) {
            this.height = this.yMax - this.y;
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    public void draw(Graphics g) {
        if (this.ic == null) {
            return;
        }
        g.setColor(Roi.ROIColor);
        this.mag = this.ic != null ? this.ic.getMagnification() : 1.0;
        int sw = (int)((double)this.width * this.mag);
        int sh = (int)((double)this.height * this.mag);
        int sw2 = (int)(0.14645 * (double)this.width * this.mag);
        int sh2 = (int)(0.14645 * (double)this.height * this.mag);
        int sx1 = this.ic.screenX(this.x);
        int sy1 = this.ic.screenY(this.y);
        int sx2 = sx1 + sw / 2;
        int sy2 = sy1 + sh / 2;
        int sx3 = sx1 + sw;
        int sy3 = sy1 + sh;
        g.drawOval(sx1, sy1, sw, sh);
        if (this.state != 0 && this.clipboard == null) {
            int size2 = 2;
            this.drawHandle(g, sx1 + sw2 - size2, sy1 + sh2 - size2);
            this.drawHandle(g, sx3 - sw2 - size2, sy1 + sh2 - size2);
            this.drawHandle(g, sx3 - sw2 - size2, sy3 - sh2 - size2);
            this.drawHandle(g, sx1 + sw2 - size2, sy3 - sh2 - size2);
            this.drawHandle(g, sx2 - size2, sy1 - size2);
            this.drawHandle(g, sx3 - size2, sy2 - size2);
            this.drawHandle(g, sx2 - size2, sy3 - size2);
            this.drawHandle(g, sx1 - size2, sy2 - size2);
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
        this.showStatus();
    }

    public void drawPixels() {
        double yy;
        ImageProcessor ip = this.imp.getProcessor();
        int a = this.width / 2;
        int b = this.height / 2;
        double a2 = a * a;
        double b2 = b * b;
        int xbase = this.x + a;
        int ybase = this.y + b;
        ip.moveTo(this.x, this.y + b);
        int i = -a + 1;
        while (i <= a) {
            yy = Math.sqrt(b2 * (1.0 - (double)(i * i) / a2));
            ip.lineTo(xbase + i, ybase + (int)(yy + 0.5));
            ++i;
        }
        ip.moveTo(this.x, this.y + b);
        int i2 = -a + 1;
        while (i2 <= a) {
            yy = Math.sqrt(b2 * (1.0 - (double)(i2 * i2) / a2));
            ip.lineTo(xbase + i2, ybase - (int)(yy + 0.5));
            ++i2;
        }
        if (Line.getWidth() > 1) {
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int x, int y) {
        double b;
        double a;
        if (!super.contains(x, y)) {
            return false;
        }
        return (double)((x = Math.abs(x - (this.x + this.width / 2))) * x) / ((a = (double)(this.width / 2)) * a) + (double)((y = Math.abs(y - (this.y + this.height / 2))) * y) / ((b = (double)(this.height / 2)) * b) <= 1.0;
    }

    int isHandle(int sx, int sy) {
        if (this.clipboard != null) {
            return -1;
        }
        double mag = this.ic.getMagnification();
        int size = 8;
        int halfSize = size / 2;
        int sx1 = this.ic.screenX(this.x) - halfSize;
        int sy1 = this.ic.screenY(this.y) - halfSize;
        int sx3 = this.ic.screenX(this.x + this.width) - halfSize;
        int sy3 = this.ic.screenY(this.y + this.height) - halfSize;
        int sx2 = sx1 + (sx3 - sx1) / 2;
        int sy2 = sy1 + (sy3 - sy1) / 2;
        int sw2 = (int)(0.14645 * (double)(sx3 - sx1));
        int sh2 = (int)(0.14645 * (double)(sy3 - sy1));
        if (sx >= sx1 + sw2 && sx <= sx1 + sw2 + size && sy >= sy1 + sh2 && sy <= sy1 + sh2 + size) {
            return 0;
        }
        if (sx >= sx2 && sx <= sx2 + size && sy >= sy1 && sy <= sy1 + size) {
            return 1;
        }
        if (sx >= sx3 - sw2 && sx <= sx3 - sw2 + size && sy >= sy1 + sh2 && sy <= sy1 + sh2 + size) {
            return 2;
        }
        if (sx >= sx3 && sx <= sx3 + size && sy >= sy2 && sy <= sy2 + size) {
            return 3;
        }
        if (sx >= sx3 - sw2 && sx <= sx3 - sw2 + size && sy >= sy3 - sh2 && sy <= sy3 - sh2 + size) {
            return 4;
        }
        if (sx >= sx2 && sx <= sx2 + size && sy >= sy3 && sy <= sy3 + size) {
            return 5;
        }
        if (sx >= sx1 + sw2 && sx <= sx1 + sw2 + size && sy >= sy3 - sh2 && sy <= sy3 - sh2 + size) {
            return 6;
        }
        if (sx >= sx1 && sx <= sx1 + size && sy >= sy2 && sy <= sy2 + size) {
            return 7;
        }
        return -1;
    }

    public int[] getMask() {
        Image img = GUI.createBlankImage(this.width, this.height);
        Graphics g = img.getGraphics();
        g.setColor(Color.black);
        g.fillOval(0, 0, this.width, this.height);
        g.dispose();
        ColorProcessor cp = new ColorProcessor(img);
        return (int[])cp.getPixels();
    }

    public double getLength() {
        double pw = 1.0;
        double ph = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            pw = cal.pixelWidth;
            ph = cal.pixelHeight;
        }
        return Math.PI * ((double)this.width * pw + (double)this.height * ph) / 2.0;
    }

    public double getFeretsDiameter() {
        double pw = 1.0;
        double ph = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            pw = cal.pixelWidth;
            ph = cal.pixelHeight;
        }
        return (double)this.width * pw >= (double)this.height * ph ? (double)this.width * pw : (double)this.height * ph;
    }
}

