/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.io.FileInfo;
import ij.io.RandomAccessStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class TiffDecoder {
    public static final int NEW_SUBFILE_TYPE = 254;
    public static final int IMAGE_WIDTH = 256;
    public static final int IMAGE_LENGTH = 257;
    public static final int BITS_PER_SAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTO_INTERP = 262;
    public static final int IMAGE_DESCRIPTION = 270;
    public static final int STRIP_OFFSETS = 273;
    public static final int SAMPLES_PER_PIXEL = 277;
    public static final int ROWS_PER_STRIP = 278;
    public static final int STRIP_BYTE_COUNT = 279;
    public static final int X_RESOLUTION = 282;
    public static final int Y_RESOLUTION = 283;
    public static final int PLANAR_CONFIGURATION = 284;
    public static final int RESOLUTION_UNIT = 296;
    public static final int SOFTWARE = 305;
    public static final int DATE_TIME = 306;
    public static final int COLOR_MAP = 320;
    public static final int SAMPLE_FORMAT = 339;
    public static final int METAMORPH1 = 33628;
    public static final int IPLAB = 34122;
    public static final int NIH_IMAGE_HDR = 43314;
    static final int UNSIGNED = 1;
    static final int SIGNED = 2;
    static final int FLOATING_POINT = 3;
    static final int SHORT = 3;
    static final int LONG = 4;
    private String directory;
    private String name;
    private String url;
    protected RandomAccessStream in;
    protected boolean debugMode;
    private boolean littleEndian;
    private String dInfo;
    private int ifdCount;

    public TiffDecoder(String directory, String name) {
        this.directory = directory;
        this.name = name;
    }

    public TiffDecoder(InputStream in, String name) {
        this.directory = "";
        this.name = name;
        this.url = "";
        this.in = new RandomAccessStream(in);
    }

    final int getInt() throws IOException {
        int b1 = this.in.read();
        int b2 = this.in.read();
        int b3 = this.in.read();
        int b4 = this.in.read();
        if (this.littleEndian) {
            return (b4 << 24) + (b3 << 16) + (b2 << 8) + (b1 << 0);
        }
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    int getShort() throws IOException {
        int b1 = this.in.read();
        int b2 = this.in.read();
        if (this.littleEndian) {
            return (b2 << 8) + b1;
        }
        return (b1 << 8) + b2;
    }

    int OpenImageFileHeader() throws IOException {
        short byteOrder = this.in.readShort();
        if (byteOrder == 18761) {
            this.littleEndian = true;
        } else if (byteOrder == 19789) {
            this.littleEndian = false;
        } else {
            this.in.close();
            return -1;
        }
        int magicNumber = this.getShort();
        int offset = this.getInt();
        return offset;
    }

    int getValue(int fieldType, int count) throws IOException {
        int value = 0;
        if (fieldType == 3 && count == 1) {
            value = this.getShort();
            int unused = this.getShort();
        } else {
            value = this.getInt();
        }
        return value;
    }

    void getColorMap(int offset, FileInfo fi) throws IOException {
        byte[] colorTable16 = new byte[1536];
        int saveLoc = this.in.getFilePointer();
        this.in.seek(offset);
        this.in.readFully(colorTable16);
        this.in.seek(saveLoc);
        fi.lutSize = 256;
        fi.reds = new byte[256];
        fi.greens = new byte[256];
        fi.blues = new byte[256];
        int j = 0;
        if (this.littleEndian) {
            ++j;
        }
        int i = 0;
        while (i < 256) {
            fi.reds[i] = colorTable16[j];
            fi.greens[i] = colorTable16[512 + j];
            fi.blues[i] = colorTable16[1024 + j];
            j += 2;
            ++i;
        }
        fi.fileType = 5;
    }

    byte[] getString(int count, int offset) throws IOException {
        if (--count == 0) {
            return null;
        }
        byte[] bytes = new byte[count];
        int saveLoc = this.in.getFilePointer();
        this.in.seek(offset);
        this.in.readFully(bytes);
        this.in.seek(saveLoc);
        return bytes;
    }

    public void decodeImageDescription(byte[] description, FileInfo fi) {
        if (description.length < 7) {
            return;
        }
        if (IJ.debugMode) {
            IJ.log("Image Description: " + new String(description).replace('\n', ' '));
        }
        if (!new String(description, 0, 6).equals("ImageJ")) {
            return;
        }
        fi.description = new String(description);
    }

    void decodeNIHImageHeader(int offset, FileInfo fi) throws IOException {
        int saveLoc = this.in.getFilePointer();
        this.in.seek(offset + 12);
        short version = this.in.readShort();
        this.in.seek(offset + 160);
        double scale = this.in.readDouble();
        if (version > 106 && scale != 0.0) {
            fi.pixelHeight = fi.pixelWidth = 1.0 / scale;
        }
        this.in.seek(offset + 172);
        int units = this.in.readShort();
        if (version <= 153) {
            units += 5;
        }
        switch (units) {
            case 5: {
                fi.unit = "nanometer";
                break;
            }
            case 6: {
                fi.unit = "micrometer";
                break;
            }
            case 7: {
                fi.unit = "mm";
                break;
            }
            case 8: {
                fi.unit = "cm";
                break;
            }
            case 9: {
                fi.unit = "meter";
                break;
            }
            case 10: {
                fi.unit = "km";
                break;
            }
            case 11: {
                fi.unit = "inch";
                break;
            }
            case 12: {
                fi.unit = "ft";
                break;
            }
            case 13: {
                fi.unit = "mi";
            }
        }
        this.in.seek(offset + 182);
        int fitType = this.in.read();
        int unused = this.in.read();
        int nCoefficients = this.in.readShort();
        if (fitType == 11) {
            fi.calibrationFunction = 21;
            fi.valueUnit = "U. OD";
        } else if (fitType >= 0 && fitType <= 8 && nCoefficients >= 1 && nCoefficients <= 5) {
            switch (fitType) {
                case 0: {
                    fi.calibrationFunction = 0;
                    break;
                }
                case 1: {
                    fi.calibrationFunction = 1;
                    break;
                }
                case 2: {
                    fi.calibrationFunction = 2;
                    break;
                }
                case 3: {
                    fi.calibrationFunction = 3;
                    break;
                }
                case 5: {
                    fi.calibrationFunction = 4;
                    break;
                }
                case 6: {
                    fi.calibrationFunction = 5;
                    break;
                }
                case 7: {
                    fi.calibrationFunction = 6;
                    break;
                }
                case 8: {
                    fi.calibrationFunction = 7;
                }
            }
            fi.coefficients = new double[nCoefficients];
            int i = 0;
            while (i < nCoefficients) {
                fi.coefficients[i] = this.in.readDouble();
                ++i;
            }
            this.in.seek(offset + 234);
            int size = this.in.read();
            StringBuffer sb = new StringBuffer();
            if (size >= 1 && size <= 16) {
                int i2 = 0;
                while (i2 < size) {
                    sb.append((char)this.in.read());
                    ++i2;
                }
                fi.valueUnit = new String(sb);
            } else {
                fi.valueUnit = " ";
            }
        }
        this.in.seek(offset + 260);
        short nImages = this.in.readShort();
        if (nImages >= 2 && (fi.fileType == 0 || fi.fileType == 5)) {
            fi.nImages = nImages;
            fi.pixelDepth = this.in.readFloat();
            short skip = this.in.readShort();
            fi.frameInterval = this.in.readFloat();
        }
        this.in.seek(offset + 272);
        float aspectRatio = this.in.readFloat();
        if (version > 140 && (double)aspectRatio != 0.0) {
            fi.pixelHeight = fi.pixelWidth / (double)aspectRatio;
        }
        this.in.seek(saveLoc);
    }

    void dumpTag(int tag, int count, int value, FileInfo fi) {
        String name;
        switch (tag) {
            case 254: {
                name = "NewSubfileType";
                break;
            }
            case 256: {
                name = "ImageWidth";
                break;
            }
            case 257: {
                name = "ImageLength";
                break;
            }
            case 273: {
                name = "StripOffsets";
                break;
            }
            case 262: {
                name = "PhotoInterp";
                break;
            }
            case 270: {
                name = "ImageDescription";
                break;
            }
            case 258: {
                name = "BitsPerSample";
                break;
            }
            case 277: {
                name = "SamplesPerPixel";
                break;
            }
            case 278: {
                name = "RowsPerStrip";
                break;
            }
            case 279: {
                name = "StripByteCount";
                break;
            }
            case 282: {
                name = "XResolution";
                break;
            }
            case 283: {
                name = "YResolution";
                break;
            }
            case 296: {
                name = "ResolutionUnit";
                break;
            }
            case 305: {
                name = "Software";
                break;
            }
            case 306: {
                name = "DateTime";
                break;
            }
            case 284: {
                name = "PlanarConfiguration";
                break;
            }
            case 259: {
                name = "Compression";
                break;
            }
            case 320: {
                name = "ColorMap";
                break;
            }
            case 339: {
                name = "SampleFormat";
                break;
            }
            case 43314: {
                name = "NIHImageHeader";
                break;
            }
            default: {
                name = "???";
            }
        }
        String cs = count == 1 ? "" : ", count=" + count;
        this.dInfo = this.dInfo + "    " + tag + ", \"" + name + "\", value=" + value + cs + "\n";
    }

    double getRational(int loc) throws IOException {
        int saveLoc = this.in.getFilePointer();
        this.in.seek(loc);
        int numerator = this.getInt();
        int denominator = this.getInt();
        this.in.seek(saveLoc);
        if (denominator != 0) {
            return (double)numerator / (double)denominator;
        }
        return 0.0;
    }

    FileInfo OpenIFD() throws IOException {
        int nEntries = this.getShort();
        if (nEntries < 1) {
            return null;
        }
        ++this.ifdCount;
        FileInfo fi = new FileInfo();
        int i = 0;
        while (i < nEntries) {
            int tag = this.getShort();
            int fieldType = this.getShort();
            int count = this.getInt();
            int value = this.getValue(fieldType, count);
            if (this.debugMode) {
                this.dumpTag(tag, count, value, fi);
            }
            switch (tag) {
                case 256: {
                    fi.width = value;
                    break;
                }
                case 257: {
                    fi.height = value;
                    break;
                }
                case 273: {
                    if (count == 1) {
                        fi.offset = value;
                        break;
                    }
                    int saveLoc = this.in.getFilePointer();
                    this.in.seek(value);
                    fi.offset = this.getInt();
                    this.in.seek(saveLoc);
                    break;
                }
                case 262: {
                    fi.whiteIsZero = value == 0;
                    break;
                }
                case 258: {
                    if (count == 1) {
                        if (value == 8) {
                            fi.fileType = 0;
                            break;
                        }
                        if (value == 16) {
                            fi.fileType = 2;
                            fi.intelByteOrder = this.littleEndian;
                            break;
                        }
                        if (value == 32) {
                            fi.fileType = 3;
                            fi.intelByteOrder = this.littleEndian;
                            break;
                        }
                        if (value == 1) {
                            fi.fileType = 8;
                            break;
                        }
                        throw new IOException("Unsupported BitsPerSample: " + value);
                    }
                    if (count != 3) break;
                    int saveLoc = this.in.getFilePointer();
                    this.in.seek(value);
                    if (this.getShort() != 8) {
                        throw new IOException("ImageJ can only open 8-bit/channel RGB images");
                    }
                    this.in.seek(saveLoc);
                    break;
                }
                case 277: {
                    if (value == 3) {
                        fi.fileType = 6;
                        break;
                    }
                    if (value == 1) break;
                    throw new IOException("Unsupported SamplesPerPixel: " + value);
                }
                case 282: {
                    double xScale = this.getRational(value);
                    if (xScale == 0.0) break;
                    fi.pixelWidth = 1.0 / xScale;
                    break;
                }
                case 283: {
                    double yScale = this.getRational(value);
                    if (yScale == 0.0) break;
                    fi.pixelHeight = 1.0 / yScale;
                    break;
                }
                case 296: {
                    if (value == 1 && fi.unit == null) {
                        fi.unit = " ";
                        break;
                    }
                    if (value == 2) {
                        fi.unit = "inch";
                        break;
                    }
                    if (value != 3) break;
                    fi.unit = "cm";
                    break;
                }
                case 284: {
                    if (value != 2 || fi.fileType != 6) break;
                    fi.fileType = 7;
                    break;
                }
                case 259: {
                    if (value == 1 || value == 7) break;
                    throw new IOException("ImageJ cannot open compressed TIFF files (" + value + ")");
                }
                case 320: {
                    if (count != 768 || fi.fileType != 0) break;
                    this.getColorMap(value, fi);
                    break;
                }
                case 339: {
                    if (fi.fileType == 3 && value == 3) {
                        fi.fileType = 4;
                    }
                    if (fi.fileType != 2 || value != 2) break;
                    fi.fileType = 1;
                    break;
                }
                case 270: {
                    byte[] s;
                    if (this.ifdCount != 1 || (s = this.getString(count, value)) == null) break;
                    this.decodeImageDescription(s, fi);
                    break;
                }
                case 33628: {
                    if (this.name.indexOf(".STK") <= 0 && this.name.indexOf(".stk") <= 0) break;
                    fi.nImages = 9999;
                    break;
                }
                case 34122: {
                    fi.nImages = value;
                    break;
                }
                case 43314: {
                    if (count != 256) break;
                    this.decodeNIHImageHeader(value, fi);
                    break;
                }
            }
            ++i;
        }
        fi.fileFormat = 2;
        fi.fileName = this.name;
        fi.directory = this.directory;
        if (this.url != null) {
            fi.url = this.url;
        }
        if (this.debugMode) {
            this.dInfo = this.dInfo + "    offset=" + fi.offset + "\n";
        }
        return fi;
    }

    public void enableDebugging() {
        this.debugMode = true;
    }

    public FileInfo[] getTiffInfo() throws IOException {
        FileInfo[] fi;
        if (this.in == null) {
            this.in = new RandomAccessStream(new RandomAccessFile(this.directory + this.name, "r"));
        }
        Vector<FileInfo[]> info = new Vector<FileInfo[]>();
        int ifdOffset = this.OpenImageFileHeader();
        if (ifdOffset < 0) {
            this.in.close();
            return null;
        }
        if (this.debugMode) {
            this.dInfo = "\n  " + this.name + ": opening\n";
        }
        while (ifdOffset > 0) {
            this.in.seek(ifdOffset);
            fi = this.OpenIFD();
            if (fi != null) {
                info.addElement(fi);
            }
            ifdOffset = this.getInt();
            if (this.debugMode) {
                this.dInfo = this.dInfo + "  nextIFD=" + ifdOffset + "\n";
            }
            if (fi == null || fi.nImages <= 1) continue;
            ifdOffset = 0;
        }
        if (info.size() == 0) {
            this.in.close();
            return null;
        }
        fi = new FileInfo[info.size()];
        info.copyInto(fi);
        if (this.debugMode) {
            fi[0].info = this.dInfo;
        }
        if (this.url != null) {
            this.in.seek(0);
            fi[0].inputStream = this.in;
        } else {
            this.in.close();
        }
        return fi;
    }
}

