/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.IJ;
import ij.gui.GenericDialog;

public class CurveFitter {
    public static final int STRAIGHT_LINE = 0;
    public static final int POLY2 = 1;
    public static final int POLY3 = 2;
    public static final int POLY4 = 3;
    public static final int EXPONENTIAL = 4;
    public static final int POWER = 5;
    public static final int LOG = 6;
    public static final int RODBARD = 7;
    public static final int GAMMA_VARIATE = 8;
    public static final int IterFactor = 500;
    public static final String[] fitList = new String[]{"Straight Line", "2nd Degree Polynomial", "3rd Degree Polynomial", "4th Degree Polynomial", "Exponential", "Power", "log", "Rodbard", "Gamma Variate"};
    public static final String[] fList = new String[]{"y = a+bx", "y = a+bx+cx^2", "y = a+bx+cx^2+dx^3", "y = a+bx+cx^2+dx^3+ex^4", "y = a*exp(bx)", "y = ax^b", "y = a*ln(bx)", "y = c*((a-x)/(x-d))^(1/b)", "y = a*(x-b)^c*exp(-(x-b)/d)"};
    private static final double alpha = -1.0;
    private static final double beta = 0.5;
    private static final double gamma = 2.0;
    private static final double root2 = 1.414214;
    private int fit;
    private double[] xData;
    private double[] yData;
    private int numPoints;
    private int numParams;
    private int numVertices;
    private int worst;
    private int nextWorst;
    private int best;
    private double[][] simp;
    private double[] next;
    private int numIter;
    private int maxIter;
    private int restarts;
    private double maxError;

    public CurveFitter(double[] xData, double[] yData) {
        this.xData = xData;
        this.yData = yData;
        this.numPoints = xData.length;
    }

    public void doFit(int fitType) {
        this.doFit(fitType, false);
    }

    public void doFit(int fitType, boolean showSettings) {
        if (fitType < 0 || fitType > 8) {
            throw new IllegalArgumentException("Invalid fit type");
        }
        this.fit = fitType;
        this.initialize();
        if (showSettings) {
            this.settingsDialog();
        }
        this.restart(0);
        this.numIter = 0;
        boolean done = false;
        double[] center = new double[this.numParams];
        while (!done) {
            ++this.numIter;
            int i = 0;
            while (i < this.numParams) {
                center[i] = 0.0;
                ++i;
            }
            int i2 = 0;
            while (i2 < this.numVertices) {
                if (i2 != this.worst) {
                    int j = 0;
                    while (j < this.numParams) {
                        int n = j;
                        center[n] = center[n] + this.simp[i2][j];
                        ++j;
                    }
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < this.numParams) {
                int n = i3;
                center[n] = center[n] / (double)this.numParams;
                this.next[i3] = center[i3] + -1.0 * (this.simp[this.worst][i3] - center[i3]);
                ++i3;
            }
            this.sumResiduals(this.next);
            if (this.next[this.numParams] <= this.simp[this.best][this.numParams]) {
                this.newVertex();
                int i4 = 0;
                while (i4 < this.numParams) {
                    this.next[i4] = center[i4] + 2.0 * (this.simp[this.worst][i4] - center[i4]);
                    ++i4;
                }
                this.sumResiduals(this.next);
                if (this.next[this.numParams] <= this.simp[this.worst][this.numParams]) {
                    this.newVertex();
                }
            } else if (this.next[this.numParams] <= this.simp[this.nextWorst][this.numParams]) {
                this.newVertex();
            } else {
                int i5 = 0;
                while (i5 < this.numParams) {
                    this.next[i5] = center[i5] + 0.5 * (this.simp[this.worst][i5] - center[i5]);
                    ++i5;
                }
                this.sumResiduals(this.next);
                if (this.next[this.numParams] <= this.simp[this.nextWorst][this.numParams]) {
                    this.newVertex();
                } else {
                    int i6 = 0;
                    while (i6 < this.numVertices) {
                        if (i6 != this.best) {
                            int j = 0;
                            while (j < this.numVertices) {
                                this.simp[i6][j] = 0.5 * (this.simp[i6][j] + this.simp[this.best][j]);
                                ++j;
                            }
                            this.sumResiduals(this.simp[i6]);
                        }
                        ++i6;
                    }
                }
            }
            this.order();
            double rtol = 2.0 * Math.abs(this.simp[this.best][this.numParams] - this.simp[this.worst][this.numParams]) / (Math.abs(this.simp[this.best][this.numParams]) + Math.abs(this.simp[this.worst][this.numParams]) + 1.0E-10);
            if (this.numIter >= this.maxIter) {
                done = true;
                continue;
            }
            if (!(rtol < this.maxError)) continue;
            --this.restarts;
            if (this.restarts < 0) {
                done = true;
                continue;
            }
            this.restart(this.best);
        }
    }

    void initialize() {
        this.numParams = this.getNumParams();
        this.numVertices = this.numParams + 1;
        this.simp = new double[this.numVertices][this.numVertices];
        this.next = new double[this.numVertices];
        double firstx = this.xData[0];
        double firsty = this.yData[0];
        double lastx = this.xData[this.numPoints - 1];
        double lasty = this.yData[this.numPoints - 1];
        double xmean = (firstx + lastx) / 2.0;
        double ymean = (firsty + lasty) / 2.0;
        double slope = lastx - firstx != 0.0 ? (lasty - firsty) / (lastx - firstx) : 1.0;
        double yintercept = firsty - slope * firstx;
        this.maxIter = 500 * this.numParams * this.numParams;
        this.restarts = 1;
        this.maxError = 1.0E-9;
        switch (this.fit) {
            case 0: {
                this.simp[0][0] = yintercept;
                this.simp[0][1] = slope;
                break;
            }
            case 1: {
                this.simp[0][0] = yintercept;
                this.simp[0][1] = slope;
                this.simp[0][2] = 0.0;
                break;
            }
            case 2: {
                this.simp[0][0] = yintercept;
                this.simp[0][1] = slope;
                this.simp[0][2] = 0.0;
                this.simp[0][3] = 0.0;
                break;
            }
            case 3: {
                this.simp[0][0] = yintercept;
                this.simp[0][1] = slope;
                this.simp[0][2] = 0.0;
                this.simp[0][3] = 0.0;
                this.simp[0][4] = 0.0;
                break;
            }
            case 4: {
                this.simp[0][0] = 0.1;
                this.simp[0][1] = 0.01;
                break;
            }
            case 5: {
                this.simp[0][0] = 0.0;
                this.simp[0][1] = 1.0;
                break;
            }
            case 6: {
                this.simp[0][0] = 0.5;
                this.simp[0][1] = 0.05;
                break;
            }
            case 7: {
                this.simp[0][0] = firsty;
                this.simp[0][1] = 1.0;
                this.simp[0][2] = xmean;
                this.simp[0][3] = lasty;
                break;
            }
            case 8: {
                this.simp[0][0] = firstx;
                double ab = this.xData[CurveFitter.getMax(this.yData)] - firstx;
                this.simp[0][2] = Math.sqrt(ab);
                this.simp[0][3] = Math.sqrt(ab);
                this.simp[0][1] = this.yData[CurveFitter.getMax(this.yData)] / (Math.pow(ab, this.simp[0][2]) * Math.exp(-ab / this.simp[0][3]));
            }
        }
    }

    private void settingsDialog() {
        GenericDialog gd = new GenericDialog("Simplex Fitting Options", IJ.getInstance());
        gd.addMessage("Function name: " + fitList[this.fit] + "\n" + "Formula: " + fList[this.fit]);
        char pChar = 'a';
        int i = 0;
        while (i < this.numParams) {
            gd.addNumericField("Initial " + new Character(pChar).toString() + ":", this.simp[0][i], 2);
            pChar = (char)(pChar + '\u0001');
            ++i;
        }
        gd.addNumericField("Maximum iterations:", this.maxIter, 0);
        gd.addNumericField("Number of restarts:", this.restarts, 0);
        gd.addNumericField("Error tolerance [1*10^(-x)]:", -(Math.log(this.maxError) / Math.log(10.0)), 0);
        gd.showDialog();
        if (gd.wasCanceled() || gd.invalidNumber()) {
            IJ.error("Parameter setting canceled.\nUsing default parameters.");
        }
        int i2 = 0;
        while (i2 < this.numParams) {
            this.simp[0][i2] = gd.getNextNumber();
            ++i2;
        }
        this.maxIter = (int)gd.getNextNumber();
        this.restarts = (int)gd.getNextNumber();
        this.maxError = Math.pow(10.0, -gd.getNextNumber());
    }

    void restart(int n) {
        int i = 0;
        while (i < this.numParams) {
            this.simp[0][i] = this.simp[n][i];
            ++i;
        }
        this.sumResiduals(this.simp[0]);
        double[] step = new double[this.numParams];
        int i2 = 0;
        while (i2 < this.numParams) {
            step[i2] = this.simp[0][i2] / 2.0;
            if (step[i2] == 0.0) {
                step[i2] = 0.01;
            }
            ++i2;
        }
        double[] p = new double[this.numParams];
        double[] q = new double[this.numParams];
        int i3 = 0;
        while (i3 < this.numParams) {
            p[i3] = step[i3] * (Math.sqrt(this.numVertices) + (double)this.numParams - 1.0) / ((double)this.numParams * 1.414214);
            q[i3] = step[i3] * (Math.sqrt(this.numVertices) - 1.0) / ((double)this.numParams * 1.414214);
            ++i3;
        }
        int i4 = 1;
        while (i4 < this.numVertices) {
            int j = 0;
            while (j < this.numParams) {
                this.simp[i4][j] = this.simp[i4 - 1][j] + q[j];
                ++j;
            }
            this.simp[i4][i4 - 1] = this.simp[i4][i4 - 1] + p[i4 - 1];
            this.sumResiduals(this.simp[i4]);
            ++i4;
        }
        this.best = 0;
        this.worst = 0;
        this.nextWorst = 0;
        this.order();
    }

    void showSimplex(int iter) {
        IJ.write("" + iter);
        int i = 0;
        while (i < this.numVertices) {
            String s = "";
            int j = 0;
            while (j < this.numVertices) {
                s = s + "  " + IJ.d2s(this.simp[i][j], 6);
                ++j;
            }
            IJ.write(s);
            ++i;
        }
    }

    public int getNumParams() {
        switch (this.fit) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 4;
            }
        }
        return 0;
    }

    public static double f(int fit, double[] p, double x) {
        switch (fit) {
            case 0: {
                return p[0] + p[1] * x;
            }
            case 1: {
                return p[0] + p[1] * x + p[2] * x * x;
            }
            case 2: {
                return p[0] + p[1] * x + p[2] * x * x + p[3] * x * x * x;
            }
            case 3: {
                return p[0] + p[1] * x + p[2] * x * x + p[3] * x * x * x + p[4] * x * x * x * x;
            }
            case 4: {
                return p[0] * Math.exp(p[1] * x);
            }
            case 5: {
                if (x == 0.0) {
                    return 0.0;
                }
                return p[0] * Math.exp(p[1] * Math.log(x));
            }
            case 6: {
                if (x == 0.0) {
                    x = 0.5;
                }
                return p[0] * Math.log(p[1] * x);
            }
            case 7: {
                double ex = x == 0.0 ? 0.0 : Math.exp(Math.log(x / p[2]) * p[1]);
                double y = p[0] - p[3];
                return (y /= 1.0 + ex) + p[3];
            }
            case 8: {
                if (p[0] >= x) {
                    return 0.0;
                }
                if (p[1] <= 0.0) {
                    return -100000.0;
                }
                if (p[2] <= 0.0) {
                    return -100000.0;
                }
                if (p[3] <= 0.0) {
                    return -100000.0;
                }
                double pw = Math.pow(x - p[0], p[2]);
                double e = Math.exp(-(x - p[0]) / p[3]);
                return p[1] * pw * e;
            }
        }
        return 0.0;
    }

    public double[] getParams() {
        this.order();
        return this.simp[this.best];
    }

    public double[] getResiduals() {
        double[] params = this.getParams();
        double[] residuals = new double[this.numPoints];
        int i = 0;
        while (i < this.numPoints) {
            residuals[i] = this.yData[i] - CurveFitter.f(this.fit, params, this.xData[i]);
            ++i;
        }
        return residuals;
    }

    public double getSumResidualsSqr() {
        double sumResidualsSqr = this.getParams()[this.getNumParams()];
        return sumResidualsSqr;
    }

    public double getSD() {
        double sd = Math.sqrt(this.getSumResidualsSqr() / (double)this.numVertices);
        return sd;
    }

    public double getFitGoodness() {
        double sumY = 0.0;
        int i = 0;
        while (i < this.numPoints) {
            sumY += this.yData[i];
            ++i;
        }
        double mean = sumY / (double)this.numVertices;
        double sumMeanDiffSqr = 0.0;
        int degreesOfFreedom = this.numPoints - this.getNumParams();
        double fitGoodness = 0.0;
        int i2 = 0;
        while (i2 < this.numPoints) {
            sumMeanDiffSqr += this.sqr(this.yData[i2] - mean);
            ++i2;
        }
        if (sumMeanDiffSqr > 0.0 && degreesOfFreedom != 0) {
            fitGoodness = 1.0 - this.getSumResidualsSqr() / (double)degreesOfFreedom * ((double)this.numParams / sumMeanDiffSqr);
        }
        return fitGoodness;
    }

    public String getResultString() {
        StringBuffer results = new StringBuffer("\nNumber of iterations: " + this.getIterations() + "\nMaximum number of iterations: " + this.getMaxIterations() + "\nSum of residuals squared: " + this.getSumResidualsSqr() + "\nStandard deviation: " + this.getSD() + "\nGoodness of fit: " + this.getFitGoodness() + "\nParameters:");
        char pChar = 'a';
        double[] pVal = this.getParams();
        int i = 0;
        while (i < this.numParams) {
            results.append("\n" + pChar + " = " + pVal[i]);
            pChar = (char)(pChar + '\u0001');
            ++i;
        }
        return results.toString();
    }

    double sqr(double d) {
        return d * d;
    }

    void sumResiduals(double[] x) {
        x[this.numParams] = 0.0;
        int i = 0;
        while (i < this.numPoints) {
            x[this.numParams] = x[this.numParams] + this.sqr(CurveFitter.f(this.fit, x, this.xData[i]) - this.yData[i]);
            ++i;
        }
    }

    void newVertex() {
        int i = 0;
        while (i < this.numVertices) {
            this.simp[this.worst][i] = this.next[i];
            ++i;
        }
    }

    void order() {
        int i = 0;
        while (i < this.numVertices) {
            if (this.simp[i][this.numParams] < this.simp[this.best][this.numParams]) {
                this.best = i;
            }
            if (this.simp[i][this.numParams] > this.simp[this.worst][this.numParams]) {
                this.worst = i;
            }
            ++i;
        }
        this.nextWorst = this.best;
        int i2 = 0;
        while (i2 < this.numVertices) {
            if (i2 != this.worst && this.simp[i2][this.numParams] > this.simp[this.nextWorst][this.numParams]) {
                this.nextWorst = i2;
            }
            ++i2;
        }
    }

    public int getIterations() {
        return this.numIter;
    }

    public int getMaxIterations() {
        return this.maxIter;
    }

    public void setMaxIterations(int x) {
        this.maxIter = x;
    }

    public int getRestarts() {
        return this.restarts;
    }

    public void setRestarts(int x) {
        this.restarts = x;
    }

    public static int getMax(double[] array) {
        double max = array[0];
        int index = 0;
        int i = 1;
        while (i < array.length) {
            if (max < array[i]) {
                max = array[i];
                index = i;
            }
            ++i;
        }
        return index;
    }
}

