/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.DicomDecoder;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.IOException;

public class DICOM
extends ImagePlus
implements PlugIn {
    public void run(String arg) {
        FileInfo fi;
        DicomDecoder dd;
        String fileName;
        block13: {
            OpenDialog od = new OpenDialog("Open Dicom...", arg);
            String directory = od.getDirectory();
            fileName = od.getFileName();
            if (fileName == null) {
                return;
            }
            IJ.showStatus("Opening: " + directory + fileName);
            dd = new DicomDecoder(directory, fileName);
            fi = null;
            try {
                fi = dd.getFileInfo();
            }
            catch (IOException e) {
                String msg = e.getMessage();
                IJ.showStatus("");
                if (msg.indexOf("EOF") < 0) {
                    IJ.showMessage("DicomDecoder", msg);
                    return;
                }
                if (dd.dicmFound()) break block13;
                msg = "This does not appear to be a valid\nDICOM file. It does not have the\ncharacters 'DICM' at offset 128.";
                IJ.showMessage("DicomDecoder", msg);
                return;
            }
        }
        if (fi != null && fi.width > 0 && fi.height > 0 && fi.offset > 0) {
            FileOpener fo = new FileOpener(fi);
            ImagePlus imp = fo.open(false);
            if (fi.fileType == 1 && imp.getStackSize() == 1) {
                this.convertToUnsigned(imp, fi);
            }
            if (dd.windowWidth > 0.0) {
                ImageProcessor ip = imp.getProcessor();
                double min = dd.windowCenter - dd.windowWidth / 2.0;
                double max = dd.windowCenter + dd.windowWidth / 2.0;
                if (fi.fileType == 1) {
                    min += 32768.0;
                    max += 32768.0;
                }
                ip.setMinAndMax(min, max);
                if (IJ.debugMode) {
                    IJ.log("window: " + min + "-" + max);
                }
            }
            if (imp.getStackSize() > 1) {
                this.setStack(fileName, imp.getStack());
            } else {
                this.setProcessor(fileName, imp.getProcessor());
            }
            this.setCalibration(imp.getCalibration());
            this.setProperty("Info", dd.getDicomInfo());
            this.setFileInfo(fi);
            if (arg.equals("")) {
                this.show();
            }
        } else {
            IJ.showMessage("DicomDecoder", "Unable to decode DICOM header.");
        }
        IJ.showStatus("");
    }

    void convertToUnsigned(ImagePlus imp, FileInfo fi) {
        ImageProcessor ip = imp.getProcessor();
        short[] pixels = (short[])ip.getPixels();
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < pixels.length) {
            int value = pixels[i] & 0xFFFF;
            if (value < min) {
                min = value;
            }
            ++i;
        }
        if (IJ.debugMode) {
            IJ.log("min: " + (min - 32768));
        }
        if (min >= 32768) {
            int i2 = 0;
            while (i2 < pixels.length) {
                pixels[i2] = (short)(pixels[i2] - 32768);
                ++i2;
            }
            ip.resetMinAndMax();
            Calibration cal = imp.getCalibration();
            cal.setFunction(20, null, "Gray Value");
            fi.fileType = 2;
        }
    }
}

