/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;

public class RGBStackMerge
implements PlugIn {
    private ImagePlus imp;
    private byte[] blank;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        this.mergeStacks();
    }

    public void mergeStacks() {
        String none;
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.error("No images are open.");
            return;
        }
        String[] titles = new String[wList.length + 1];
        int i = 0;
        while (i < wList.length) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            titles[i] = imp != null ? imp.getTitle() : "";
            ++i;
        }
        titles[wList.length] = none = "*None*";
        GenericDialog gd = new GenericDialog("RGB Stack Merge");
        gd.addChoice("Red Stack:", titles, titles[0]);
        gd.addChoice("Green Stack:", titles, titles[1]);
        String title3 = titles.length > 2 ? titles[2] : none;
        gd.addChoice("Blue Stack:", titles, title3);
        gd.addCheckbox("Keep source stacks", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int[] index = new int[]{gd.getNextChoiceIndex(), gd.getNextChoiceIndex(), gd.getNextChoiceIndex()};
        boolean keep = gd.getNextBoolean();
        ImagePlus[] image = new ImagePlus[3];
        int stackSize = 0;
        int width = 0;
        int height = 0;
        int i2 = 0;
        while (i2 < 3) {
            if (index[i2] < wList.length) {
                image[i2] = WindowManager.getImage(wList[index[i2]]);
                width = image[i2].getWidth();
                height = image[i2].getHeight();
                stackSize = image[i2].getStackSize();
            }
            ++i2;
        }
        if (width == 0) {
            IJ.error("There must be at least one 8-bit or RGB source stack.");
            return;
        }
        int i3 = 0;
        while (i3 < 3) {
            ImagePlus img = image[i3];
            if (img != null) {
                if (img.getStackSize() != stackSize) {
                    IJ.error("The source stacks must all have the same number of slices.");
                    return;
                }
                if (img.getType() != 0 && img.getType() != 4) {
                    IJ.error("The source stacks must be 8-bit grayscale or RGB.");
                    return;
                }
                if (img.getWidth() != width || image[i3].getHeight() != height) {
                    IJ.error("The source stacks must have the same width and height.");
                    return;
                }
            }
            ++i3;
        }
        ImageStack red = image[0] != null ? image[0].getStack() : null;
        ImageStack green = image[1] != null ? image[1].getStack() : null;
        ImageStack blue = image[2] != null ? image[2].getStack() : null;
        ImageStack rgb = this.mergeStacks(width, height, stackSize, red, green, blue, keep);
        if (!keep) {
            int i4 = 0;
            while (i4 < 3) {
                if (image[i4] != null) {
                    image[i4].changes = false;
                    ImageWindow win = image[i4].getWindow();
                    if (win != null) {
                        win.close();
                    }
                }
                ++i4;
            }
        }
        ImagePlus imp2 = new ImagePlus("RGB", rgb);
        if (image[0] != null) {
            imp2.setCalibration(image[0].getCalibration());
        }
        imp2.show();
    }

    public ImageStack mergeStacks(int w, int h, int d, ImageStack red, ImageStack green, ImageStack blue, boolean keep) {
        ImageStack rgb = new ImageStack(w, h);
        int inc = d / 10;
        if (inc < 1) {
            inc = 1;
        }
        int slice = 1;
        this.blank = new byte[w * h];
        boolean invertedRed = red != null ? red.getProcessor(1).isInvertedLut() : false;
        boolean invertedGreen = green != null ? green.getProcessor(1).isInvertedLut() : false;
        boolean invertedBlue = blue != null ? blue.getProcessor(1).isInvertedLut() : false;
        try {
            int i = 1;
            while (i <= d) {
                ColorProcessor cp = new ColorProcessor(w, h);
                byte[] redPixels = this.getPixels(red, slice, 0);
                byte[] greenPixels = this.getPixels(green, slice, 1);
                byte[] bluePixels = this.getPixels(blue, slice, 2);
                if (invertedRed) {
                    this.invert(redPixels);
                }
                if (invertedGreen) {
                    this.invert(greenPixels);
                }
                if (invertedBlue) {
                    this.invert(bluePixels);
                }
                cp.setRGB(redPixels, greenPixels, bluePixels);
                if (keep) {
                    ++slice;
                    if (invertedRed) {
                        this.invert(redPixels);
                    }
                    if (invertedGreen) {
                        this.invert(greenPixels);
                    }
                    if (invertedBlue) {
                        this.invert(bluePixels);
                    }
                } else {
                    if (red != null) {
                        red.deleteSlice(1);
                    }
                    if (green != null && green != red) {
                        green.deleteSlice(1);
                    }
                    if (blue != null && blue != red && blue != green) {
                        blue.deleteSlice(1);
                    }
                }
                rgb.addSlice(null, cp);
                if (i % inc == 0) {
                    IJ.showProgress((double)i / (double)d);
                }
                ++i;
            }
            IJ.showProgress(1.0);
        }
        catch (OutOfMemoryError o) {
            IJ.outOfMemory("Merge Stacks");
            IJ.showProgress(1.0);
        }
        return rgb;
    }

    byte[] getPixels(ImageStack stack, int slice, int color) {
        if (stack == null) {
            return this.blank;
        }
        if (stack.getPixels(slice) instanceof byte[]) {
            return (byte[])stack.getPixels(slice);
        }
        int size = stack.getWidth() * stack.getHeight();
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        ColorProcessor cp = (ColorProcessor)stack.getProcessor(slice);
        cp.getRGB(r, g, b);
        switch (color) {
            case 0: {
                return r;
            }
            case 1: {
                return g;
            }
            case 2: {
                return b;
            }
        }
        return null;
    }

    void invert(byte[] pixels) {
        int i = 0;
        while (i < pixels.length) {
            pixels[i] = (byte)(255 - pixels[i] & 0xFF);
            ++i;
        }
    }
}

