/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Prefs;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.plugin.PlugIn;
import java.util.StringTokenizer;

public class RawReader
implements PlugIn {
    public void run(String args) {
        StringTokenizer st = new StringTokenizer(args, ", \t");
        int nTokens = st.countTokens();
        if (nTokens < 6) {
            IJ.write("RawReader expects at least 6 arguments: " + args);
            return;
        }
        FileInfo fi = new FileInfo();
        fi.fileFormat = 1;
        fi.url = Prefs.getImagesURL();
        fi.fileName = st.nextToken();
        fi.width = this.getNextArg(st);
        fi.height = this.getNextArg(st);
        fi.nImages = this.getNextArg(st);
        fi.fileType = this.getNextArg(st) == 8 ? 0 : 2;
        fi.offset = this.getNextArg(st);
        int i = 7;
        while (i <= nTokens) {
            String arg = st.nextToken();
            if (arg.startsWith("white")) {
                fi.whiteIsZero = true;
            } else if (arg.startsWith("black")) {
                fi.whiteIsZero = false;
            } else if (arg.startsWith("little")) {
                fi.intelByteOrder = true;
            } else if (arg.startsWith("big")) {
                fi.intelByteOrder = false;
            }
            ++i;
        }
        if (IJ.debugMode) {
            IJ.log("RawReader: " + fi);
        }
        IJ.showStatus(fi.url + fi.fileName);
        new FileOpener(fi).open();
    }

    int getNextArg(StringTokenizer st) {
        int arg = 0;
        try {
            arg = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException e) {
            IJ.write("" + e);
        }
        return arg;
    }
}

