/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class Selection
implements PlugIn {
    ImagePlus imp;
    float[] kernel = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    float[] kernel3 = new float[]{1.0f, 1.0f, 1.0f};

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (arg.equals("all")) {
            this.imp.setRoi(0, 0, this.imp.getWidth(), this.imp.getHeight());
            return;
        }
        if (arg.equals("none")) {
            this.imp.killRoi();
            return;
        }
        if (arg.equals("restore")) {
            this.imp.restoreRoi();
            return;
        }
        if (arg.equals("spline")) {
            this.fitSpline();
            return;
        }
    }

    void fitSpline() {
        double mag;
        boolean segmentedSelection;
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            IJ.showMessage("Spline", "Selection required");
            return;
        }
        int type = roi.getType();
        boolean bl = segmentedSelection = type == 2 || type == 6;
        if (!segmentedSelection && type != 3 && type != 4 && type != 7) {
            IJ.showMessage("Spline", "Polygon or polyline selection required");
            return;
        }
        PolygonRoi p = (PolygonRoi)roi;
        double length = this.getLength(p);
        if (!segmentedSelection) {
            p = this.trimPolygon(p, length);
        }
        int evaluationPoints = (int)(length / 2.0);
        ImageWindow win = this.imp.getWindow();
        if (win != null && (mag = win.getCanvas().getMagnification()) < 1.0) {
            evaluationPoints = (int)((double)evaluationPoints * mag);
        }
        if (evaluationPoints < 100) {
            evaluationPoints = 100;
        }
        p.fitSpline(evaluationPoints);
        this.imp.draw();
    }

    double getLength(PolygonRoi roi) {
        Calibration cal = this.imp.getCalibration();
        double spw = cal.pixelWidth;
        double sph = cal.pixelHeight;
        cal.pixelWidth = 1.0;
        cal.pixelHeight = 1.0;
        double length = roi.getLength();
        cal.pixelWidth = spw;
        cal.pixelHeight = sph;
        return length;
    }

    PolygonRoi trimPolygon(PolygonRoi roi, double length) {
        int type;
        int[] x = roi.getXCoordinates();
        int[] y = roi.getYCoordinates();
        int n = roi.getNCoordinates();
        float[] curvature = this.getCurvature(x, y, n);
        Rectangle r = roi.getBoundingRect();
        double threshold = this.rodbard(length);
        double distance = Math.sqrt((x[1] - x[0]) * (x[1] - x[0]) + (y[1] - y[0]) * (y[1] - y[0]));
        x[0] = x[0] + r.x;
        y[0] = y[0] + r.y;
        int i2 = 1;
        int x2 = 0;
        int y2 = 0;
        int i = 1;
        while (i < n - 1) {
            int x1 = x[i];
            int y1 = y[i];
            x2 = x[i + 1];
            y2 = y[i + 1];
            distance += Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) + 1.0;
            if ((distance += (double)(curvature[i] * 2.0f)) >= threshold) {
                x[i2] = x2 + r.x;
                y[i2] = y2 + r.y;
                ++i2;
                distance = 0.0;
            }
            ++i;
        }
        int n2 = type = roi.getType() == 7 ? 6 : 2;
        if (type == 6 && distance > 0.0) {
            x[i2] = x2 + r.x;
            y[i2] = y2 + r.y;
            ++i2;
        }
        PolygonRoi p = new PolygonRoi(x, y, i2, type);
        this.imp.setRoi(p);
        return p;
    }

    double rodbard(double x) {
        double ex = x == 0.0 ? 5.0 : Math.exp(Math.log(x / 700.0) * 0.88);
        double y = -40.1;
        return (y /= 1.0 + ex) + 44.0;
    }

    float[] getCurvature(int[] x, int[] y, int n) {
        float[] x2 = new float[n];
        float[] y2 = new float[n];
        int i = 0;
        while (i < n) {
            x2[i] = x[i];
            y2[i] = y[i];
            ++i;
        }
        FloatProcessor ipx = new FloatProcessor(n, 1, x2, null);
        FloatProcessor ipy = new FloatProcessor(n, 1, y2, null);
        ((ImageProcessor)ipx).convolve(this.kernel, this.kernel.length, 1);
        ((ImageProcessor)ipy).convolve(this.kernel, this.kernel.length, 1);
        float[] indexes = new float[n];
        float[] curvature = new float[n];
        int i2 = 0;
        while (i2 < n) {
            indexes[i2] = i2;
            curvature[i2] = (float)Math.sqrt((x2[i2] - (float)x[i2]) * (x2[i2] - (float)x[i2]) + (y2[i2] - (float)y[i2]) * (y2[i2] - (float)y[i2]));
            ++i2;
        }
        return curvature;
    }
}

