/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.PlotWindow;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.measure.Measurements;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.util.StringTokenizer;

public class Calibrator
implements PlugInFilter,
Measurements {
    private static final String NONE = "None";
    private static final String INVERTER = "Pixel Inverter";
    private static final String UNCALIBRATED_OD = "Uncalibrated OD";
    private static boolean showSettings;
    static boolean global;
    private static boolean oldGlobal;
    private ImagePlus imp;
    private int choiceIndex;
    private String[] functions;
    private int nFits = CurveFitter.fitList.length;
    private int spacerIndex = this.nFits + 1;
    private int inverterIndex = this.nFits + 2;
    private int odIndex = this.nFits + 3;
    private String xText;
    private static String yText;
    private String unit;
    private double lx = 0.02;
    private double ly = 0.1;
    private int oldFunction;
    private String sumResiduals;
    private String fitGoodness;
    static /* synthetic */ Class class$ij$plugin$filter$Calibrator;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        IJ.register(class$ij$plugin$filter$Calibrator == null ? (class$ij$plugin$filter$Calibrator = Calibrator.class$("ij.plugin.filter.Calibrator")) : class$ij$plugin$filter$Calibrator);
        return 135;
    }

    public void run(ImageProcessor ip) {
        oldGlobal = global;
        if (!this.showDialog(this.imp)) {
            return;
        }
        this.calibrate(this.imp);
        if (global || global != oldGlobal) {
            int[] list = WindowManager.getIDList();
            if (list == null) {
                return;
            }
            int i = 0;
            while (i < list.length) {
                ImagePlus imp2 = WindowManager.getImage(list[i]);
                if (imp2 != null) {
                    imp2.getWindow().repaint();
                }
                ++i;
            }
        } else {
            this.imp.getWindow().repaint();
        }
    }

    public boolean showDialog(ImagePlus imp) {
        int function;
        Calibration cal = imp.getCalibration();
        this.functions = this.getFunctionList();
        this.oldFunction = function = cal.getFunction();
        double[] p = cal.getCoefficients();
        this.unit = cal.getValueUnit();
        String defaultChoice = function == 20 ? NONE : (function < this.nFits && function == 0 && p != null && p[0] == 255.0 && p[1] == -1.0 ? INVERTER : (function < this.nFits ? CurveFitter.fitList[function] : (function == 21 ? UNCALIBRATED_OD : NONE)));
        this.xText = this.getMeans();
        GenericDialog gd = new GenericDialog("Calibrate...");
        gd.addChoice("Function:", this.functions, defaultChoice);
        gd.addStringField("Unit:", this.unit, 16);
        gd.addTextAreas(this.xText, yText, 20, 14);
        gd.addCheckbox("Global Calibration", global);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.choiceIndex = gd.getNextChoiceIndex();
        this.unit = gd.getNextString();
        this.xText = gd.getNextText();
        yText = gd.getNextText();
        global = gd.getNextBoolean();
        return true;
    }

    public void calibrate(ImagePlus imp) {
        Calibration cal = imp.getCalibration();
        int function = 20;
        boolean is16Bits = imp.getType() == 1;
        double[] parameters = null;
        double[] x = null;
        double[] y = null;
        boolean zeroClip = false;
        if (this.choiceIndex <= 0) {
            if (this.oldFunction == 20 && !yText.equals("") && !this.xText.equals("")) {
                IJ.showMessage("Calibrator", "Please select a function");
            }
            function = 20;
        } else if (this.choiceIndex <= this.nFits) {
            function = this.choiceIndex - 1;
            if (function > 0 && is16Bits) {
                IJ.error("Calibration of 16-bit images, except with straight\nline functions, is currently not supported.");
                return;
            }
            x = this.getData(this.xText);
            y = this.getData(yText);
            if (!(cal.calibrated() && y.length == 0 && function == this.oldFunction || (parameters = this.doCurveFitting(x, y, function)) != null)) {
                return;
            }
            zeroClip = true;
            int i = 0;
            while (i < y.length) {
                if (y[i] < 0.0) {
                    zeroClip = false;
                }
                ++i;
            }
        } else if (this.choiceIndex == this.inverterIndex) {
            function = 0;
            parameters = new double[]{is16Bits ? 65535.0 : 255.0, -1.0};
            this.unit = "Inverted Gray Value";
        } else if (this.choiceIndex == this.odIndex) {
            if (is16Bits) {
                IJ.error("Uncalibrated OD is not supported on 16-bit images.");
                return;
            }
            function = 21;
            this.unit = UNCALIBRATED_OD;
        }
        cal.setFunction(function, parameters, this.unit, zeroClip);
        if (global) {
            imp.setGlobalCalibration(cal);
        } else {
            imp.setCalibration(cal);
            imp.setGlobalCalibration(null);
        }
        if (function != 20) {
            this.showPlot(x, y, cal, this.sumResiduals, this.fitGoodness);
        }
    }

    double[] doCurveFitting(double[] x, double[] y, int fitType) {
        if (x.length != y.length || y.length == 0) {
            IJ.showMessage("Calibrator", "To create a calibration curve, the left column must\ncontain a list of measured mean pixel values and the\nright column must contain the same number of calibration\nstandard values. Use the Measure command to add mean\npixel value measurements to the left column.\n \n    Left column: " + x.length + " values\n" + "    Right column: " + y.length + " values\n");
            return null;
        }
        int n = x.length;
        double xmin = 0.0;
        double xmax = this.imp.getType() == 1 ? 65535.0 : 255.0;
        double[] a = Tools.getMinMax(y);
        double ymin = a[0];
        double ymax = a[1];
        CurveFitter cf = new CurveFitter(x, y);
        cf.doFit(fitType, showSettings);
        int np = cf.getNumParams();
        double[] p = cf.getParams();
        double sumResidualsSqr = p[np];
        double sumY = 0.0;
        int i = 0;
        while (i < n) {
            sumY += y[i];
            ++i;
        }
        this.sumResiduals = IJ.d2s(Math.sqrt(sumResidualsSqr / (double)n), 6);
        double mean = sumY / (double)n;
        double sumMeanDiffSqr = 0.0;
        int degreesOfFreedom = n - np;
        double goodness = 1.0;
        int i2 = 0;
        while (i2 < n) {
            if ((sumMeanDiffSqr += this.sqr(y[i2] - mean)) > 0.0 && degreesOfFreedom != 0) {
                goodness = 1.0 - sumResidualsSqr / (double)degreesOfFreedom * ((double)(n - 1) / sumMeanDiffSqr);
            }
            ++i2;
        }
        this.fitGoodness = IJ.d2s(goodness, 6);
        double[] parameters = new double[np];
        int i3 = 0;
        while (i3 < np) {
            parameters[i3] = p[i3];
            ++i3;
        }
        return parameters;
    }

    void showPlot(double[] x, double[] y, Calibration cal, String sumResiduals, String fitGoodness) {
        int xmax;
        boolean xmin;
        if (!cal.calibrated()) {
            return;
        }
        float[] ctable = cal.getCTable();
        if (ctable.length == 256) {
            xmin = false;
            xmax = 255;
        } else {
            xmin = false;
            xmax = 65535;
        }
        int range = 256;
        float[] px = new float[range];
        float[] py = new float[range];
        int i = 0;
        while (i < range) {
            px[i] = (float)((double)i / 255.0 * (double)xmax);
            ++i;
        }
        int i2 = 0;
        while (i2 < range) {
            py[i2] = ctable[(int)px[i2]];
            ++i2;
        }
        double[] a = Tools.getMinMax(py);
        double ymin = a[0];
        double ymax = a[1];
        int fit = cal.getFunction();
        String unit = cal.getValueUnit();
        PlotWindow pw = new PlotWindow("Calibration Function", "pixel value", unit, px, py);
        pw.setLimits((double)xmin, xmax, ymin, ymax);
        if (x != null && y != null && x.length > 0 && y.length > 0) {
            pw.addPoints(x, y, 0);
        }
        double[] p = cal.getCoefficients();
        if (fit <= 8) {
            this.drawLabel(pw, CurveFitter.fList[fit]);
            this.ly += 0.04;
        }
        if (p != null) {
            int np = p.length;
            this.drawLabel(pw, "a=" + IJ.d2s(p[0], 6));
            this.drawLabel(pw, "b=" + IJ.d2s(p[1], 6));
            if (np >= 3) {
                this.drawLabel(pw, "c=" + IJ.d2s(p[2], 6));
            }
            if (np >= 4) {
                this.drawLabel(pw, "d=" + IJ.d2s(p[3], 6));
            }
            if (np >= 5) {
                this.drawLabel(pw, "e=" + IJ.d2s(p[4], 6));
            }
            this.ly += 0.04;
        }
        if (sumResiduals != null) {
            this.drawLabel(pw, "S.D.=" + sumResiduals);
            sumResiduals = null;
        }
        if (fitGoodness != null) {
            this.drawLabel(pw, "R^2=" + fitGoodness);
            fitGoodness = null;
        }
        pw.draw();
    }

    void drawLabel(PlotWindow pw, String label) {
        pw.addLabel(this.lx, this.ly, label);
        this.ly += 0.08;
    }

    double sqr(double x) {
        return x * x;
    }

    String[] getFunctionList() {
        String[] list = new String[this.nFits + 4];
        list[0] = NONE;
        int i = 0;
        while (i < this.nFits) {
            list[1 + i] = CurveFitter.fitList[i];
            ++i;
        }
        list[this.spacerIndex] = "-";
        list[this.inverterIndex] = INVERTER;
        list[this.odIndex] = UNCALIBRATED_OD;
        return list;
    }

    String getMeans() {
        float[] umeans = Analyzer.getUMeans();
        int count = Analyzer.getCounter();
        if (umeans == null || count == 0) {
            return "";
        }
        if (count > 20) {
            count = 20;
        }
        String s = "";
        int i = 0;
        while (i < count) {
            s = s + IJ.d2s(umeans[i], 2) + "\n";
            ++i;
        }
        return s;
    }

    double[] getData(String xData) {
        StringTokenizer st = new StringTokenizer(xData);
        int nTokens = st.countTokens();
        if (nTokens < 1) {
            return new double[0];
        }
        int n = nTokens;
        double[] data = new double[n];
        int i = 0;
        while (i < n) {
            data[i] = this.getNum(st);
            ++i;
        }
        return data;
    }

    double getNum(StringTokenizer st) {
        Double d;
        String token = st.nextToken();
        try {
            d = new Double(token);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        yText = "";
    }
}

