/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Measurements;
import ij.plugin.ContrastEnhancer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Rectangle;
import java.util.Hashtable;

public class FFT
implements PlugInFilter,
Measurements {
    private ImagePlus imp;
    private String arg;
    private float[] C;
    private float[] S;
    private int[] bitrev;
    float[] tempArr;
    private boolean customFilter;
    private boolean bandpassFilter;
    private static int filterIndex = 1;
    private ImageProcessor fht;
    private int slice;
    private int stackSize = 1;
    private static double filterLargeDia = 40.0;
    private static double filterSmallDia = 3.0;
    private static int choiceIndex = 0;
    private static String[] choices = new String[]{"None", "Horizontal", "Vertical"};
    private static String choiceDia = choices[0];
    private static double toleranceDia = 5.0;
    private static boolean doScalingDia = true;
    private static boolean saturateDia = true;
    private static boolean displayFilter;
    private static boolean processStack;

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        if (imp == null) {
            IJ.noImage();
            return 4096;
        }
        this.stackSize = imp.getStackSize();
        this.fht = (ImageProcessor)imp.getProperty("FHT");
        if (arg.equals("bandpass")) {
            this.bandpassFilter = true;
        } else if (arg.equals("custom")) {
            this.customFilter = true;
        }
        int flags = 13;
        if (this.bandpassFilter) {
            if (this.fht != null) {
                IJ.showMessage("FFT", "Spatial domain image required");
                return 4096;
            }
            if (!this.showBandpassDialog(imp)) {
                return 4096;
            }
            return processStack ? flags + 32 : flags;
        }
        if (arg.equals("redisplay")) {
            this.redisplayPowerSpectrum();
            return 4096;
        }
        return flags + 128 + 256;
    }

    public void run(ImageProcessor ip) {
        boolean inverse;
        ++this.slice;
        if (this.bandpassFilter) {
            this.filter(ip);
            return;
        }
        if (this.fht == null) {
            if (this.arg.equals("inverse") || this.customFilter) {
                IJ.showMessage("FFT", "Frequency domain image required");
                return;
            }
            if (!this.powerOf2Size(ip)) {
                IJ.error("A square, power of two size image or selection\n(128x128, 256x256, etc.) is required.");
                return;
            }
        }
        if (this.fht != null) {
            ip = this.fht;
            this.imp.killRoi();
            Undo.setup(6, this.imp);
            inverse = true;
            if (this.customFilter && !this.customFilter(this.fht)) {
                return;
            }
        } else {
            if (this.imp.getRoi() == null) {
                Undo.setup(6, this.imp);
            }
            inverse = false;
        }
        this.doTransform(ip, inverse);
    }

    void doTransform(ImageProcessor ip, boolean inverse) {
        IJ.showProgress(0.01);
        ip = ip.crop();
        IJ.showProgress(0.1);
        ip = ip.convertToFloat();
        IJ.showProgress(0.2);
        this.fft(ip, inverse);
        String title = this.imp.getTitle();
        if (title.startsWith("FFT of ")) {
            this.imp.setTitle(title.substring(6));
        }
        if (!inverse && this.imp.getRoi() == null) {
            this.imp.setTitle("FFT of " + this.imp.getTitle());
        }
        IJ.showProgress(1.0);
    }

    void filter(ImageProcessor ip) {
        Rectangle roiRect = ip.getRoi();
        int maxN = Math.max(roiRect.width, roiRect.height);
        double filterLarge = filterLargeDia / (double)maxN;
        double filterSmall = filterSmallDia / (double)maxN;
        double sharpness = (100.0 - toleranceDia) / 100.0;
        boolean doScaling = doScalingDia;
        boolean saturate = saturateDia;
        IJ.showProgress(1, 20);
        int i = 2;
        while ((double)i < 1.5 * (double)maxN) {
            i *= 2;
        }
        Rectangle fitRect = new Rectangle();
        fitRect.x = (int)Math.round((double)(i - roiRect.width) / 2.0);
        fitRect.y = (int)Math.round((double)(i - roiRect.height) / 2.0);
        fitRect.width = roiRect.width;
        fitRect.height = roiRect.height;
        this.showStatus("Pad to " + i + "x" + i);
        ImageProcessor ip2 = this.tileMirror(ip, i, i, fitRect.x, fitRect.y);
        ImagePlus imp2 = new ImagePlus(this.imp.getTitle() + "-filtered", ip2);
        int imagetype = imp2.getType();
        if (imagetype != 2) {
            new ImageConverter(imp2).convertToGray32();
            ip2 = imp2.getProcessor();
            System.gc();
        }
        IJ.showProgress(2, 20);
        this.showStatus("Forward transform");
        boolean inverse = false;
        this.fft2(ip2, inverse);
        System.gc();
        IJ.showProgress(9, 20);
        this.showStatus("Filter in frequency domain");
        this.filterLargeSmall(ip2, filterLarge, filterSmall, choiceIndex, sharpness);
        IJ.showProgress(11, 20);
        this.showStatus("Inverse transform");
        inverse = true;
        this.fft2(ip2, inverse);
        IJ.showProgress(19, 20);
        this.showStatus("Crop and convert to original type");
        ip2.setRoi(fitRect);
        ip2 = ip2.crop();
        imp2.setProcessor(null, ip2);
        if (doScaling) {
            new ContrastEnhancer().stretchHistogram(imp2, saturate ? 1.0 : 0.0);
        }
        if (imagetype != 2) {
            boolean defaultscaling = ImageConverter.getDoScaling();
            ImageConverter.setDoScaling(doScaling);
            if (imagetype == 0) {
                new ImageConverter(imp2).convertToGray8();
            } else if (imagetype == 1) {
                new ImageConverter(imp2).convertToGray16();
            }
            ImageConverter.setDoScaling(defaultscaling);
        }
        ip.snapshot();
        ip.copyBits(imp2.getProcessor(), roiRect.x, roiRect.y, 0);
        imp2.flush();
        System.gc();
        IJ.showProgress(20, 20);
    }

    void showStatus(String msg) {
        if (this.slice > 1) {
            IJ.showStatus(this.slice + "/" + this.stackSize);
        } else {
            IJ.showStatus(msg);
        }
    }

    public void fft2(ImageProcessor ip, boolean inverse) {
        int maxN = ip.getWidth();
        this.makeSinCosTables(maxN);
        this.makeBitReverseTable(maxN);
        this.tempArr = new float[maxN];
        float[] fht = (float[])ip.getPixels();
        this.rc2DFHT(fht, inverse, maxN);
    }

    ImageProcessor tileMirror(ImageProcessor ip, int width, int height, int x, int y) {
        if (x < 0 || x > width - 1 || y < 0 || y > height - 1) {
            IJ.error("Image to be tiled is out of bounds.");
            return null;
        }
        ImageProcessor ipout = ip.createProcessor(width, height);
        ImageProcessor ip2 = ip.crop();
        int w2 = ip2.getWidth();
        int h2 = ip2.getHeight();
        int i1 = (int)Math.ceil((double)x / (double)w2);
        int i2 = (int)Math.ceil((double)(width - x) / (double)w2);
        int j1 = (int)Math.ceil((double)y / (double)h2);
        int j2 = (int)Math.ceil((double)(height - y) / (double)h2);
        if ((double)(i1 % 2) > 0.5) {
            ip2.flipHorizontal();
        }
        if ((double)(j1 % 2) > 0.5) {
            ip2.flipVertical();
        }
        int i = -i1;
        while (i < i2) {
            int j = -j1;
            while (j < j2) {
                ipout.insert(ip2, x - i * w2, y - j * h2);
                j += 2;
            }
            i += 2;
        }
        ip2.flipHorizontal();
        int i3 = -i1 + 1;
        while (i3 < i2) {
            int j = -j1;
            while (j < j2) {
                ipout.insert(ip2, x - i3 * w2, y - j * h2);
                j += 2;
            }
            i3 += 2;
        }
        ip2.flipVertical();
        int i4 = -i1 + 1;
        while (i4 < i2) {
            int j = -j1 + 1;
            while (j < j2) {
                ipout.insert(ip2, x - i4 * w2, y - j * h2);
                j += 2;
            }
            i4 += 2;
        }
        ip2.flipHorizontal();
        int i5 = -i1;
        while (i5 < i2) {
            int j = -j1 + 1;
            while (j < j2) {
                ipout.insert(ip2, x - i5 * w2, y - j * h2);
                j += 2;
            }
            i5 += 2;
        }
        return ipout;
    }

    void filterLargeSmall(ImageProcessor ip, double filterLarge, double filterSmall, int stripesHorVert, double scaleStripes) {
        float colFactSmall;
        float colFactLarge;
        int backcol;
        int col;
        float rowFactSmall;
        float rowFactLarge;
        int backrow;
        int row;
        int maxN = ip.getWidth();
        float[] fht = (float[])ip.getPixels();
        float[] filter = new float[maxN * maxN];
        int i = 0;
        while (i < maxN * maxN) {
            filter[i] = 1.0f;
            ++i;
        }
        double scaleLarge = filterLarge * filterLarge;
        double scaleSmall = filterSmall * filterSmall;
        scaleStripes *= scaleStripes;
        int j = 1;
        while (j < maxN / 2) {
            row = j * maxN;
            backrow = (maxN - j) * maxN;
            rowFactLarge = (float)Math.exp((double)(-(j * j)) * scaleLarge);
            rowFactSmall = (float)Math.exp((double)(-(j * j)) * scaleSmall);
            col = 1;
            while (col < maxN / 2) {
                backcol = maxN - col;
                colFactLarge = (float)Math.exp((double)(-(col * col)) * scaleLarge);
                colFactSmall = (float)Math.exp((double)(-(col * col)) * scaleSmall);
                float factor = (1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall;
                switch (stripesHorVert) {
                    case 1: {
                        factor *= 1.0f - (float)Math.exp((double)(-(col * col)) * scaleStripes);
                        break;
                    }
                    case 2: {
                        factor *= 1.0f - (float)Math.exp((double)(-(j * j)) * scaleStripes);
                    }
                }
                int n = col + row;
                fht[n] = fht[n] * factor;
                int n2 = col + backrow;
                fht[n2] = fht[n2] * factor;
                int n3 = backcol + row;
                fht[n3] = fht[n3] * factor;
                int n4 = backcol + backrow;
                fht[n4] = fht[n4] * factor;
                int n5 = col + row;
                filter[n5] = filter[n5] * factor;
                int n6 = col + backrow;
                filter[n6] = filter[n6] * factor;
                int n7 = backcol + row;
                filter[n7] = filter[n7] * factor;
                int n8 = backcol + backrow;
                filter[n8] = filter[n8] * factor;
                ++col;
            }
            ++j;
        }
        int rowmid = maxN * (maxN / 2);
        rowFactLarge = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleLarge);
        rowFactSmall = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleSmall);
        float factStripes = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleStripes);
        int n = maxN / 2;
        fht[n] = fht[n] * ((1.0f - rowFactLarge) * rowFactSmall);
        int n9 = rowmid;
        fht[n9] = fht[n9] * ((1.0f - rowFactLarge) * rowFactSmall);
        int n10 = maxN / 2 + rowmid;
        fht[n10] = fht[n10] * ((1.0f - rowFactLarge * rowFactLarge) * rowFactSmall * rowFactSmall);
        int n11 = maxN / 2;
        filter[n11] = filter[n11] * ((1.0f - rowFactLarge) * rowFactSmall);
        int n12 = rowmid;
        filter[n12] = filter[n12] * ((1.0f - rowFactLarge) * rowFactSmall);
        int n13 = maxN / 2 + rowmid;
        filter[n13] = filter[n13] * ((1.0f - rowFactLarge * rowFactLarge) * rowFactSmall * rowFactSmall);
        switch (stripesHorVert) {
            case 1: {
                int n14 = maxN / 2;
                fht[n14] = fht[n14] * (1.0f - factStripes);
                fht[rowmid] = 0.0f;
                int n15 = maxN / 2 + rowmid;
                fht[n15] = fht[n15] * (1.0f - factStripes);
                int n16 = maxN / 2;
                filter[n16] = filter[n16] * (1.0f - factStripes);
                filter[rowmid] = 0.0f;
                int n17 = maxN / 2 + rowmid;
                filter[n17] = filter[n17] * (1.0f - factStripes);
                break;
            }
            case 2: {
                fht[maxN / 2] = 0.0f;
                int n18 = rowmid;
                fht[n18] = fht[n18] * (1.0f - factStripes);
                int n19 = maxN / 2 + rowmid;
                fht[n19] = fht[n19] * (1.0f - factStripes);
                filter[maxN / 2] = 0.0f;
                int n20 = rowmid;
                filter[n20] = filter[n20] * (1.0f - factStripes);
                int n21 = maxN / 2 + rowmid;
                filter[n21] = filter[n21] * (1.0f - factStripes);
            }
        }
        rowFactLarge = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleLarge);
        rowFactSmall = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleSmall);
        col = 1;
        while (col < maxN / 2) {
            backcol = maxN - col;
            colFactLarge = (float)Math.exp((double)(-(col * col)) * scaleLarge);
            colFactSmall = (float)Math.exp((double)(-(col * col)) * scaleSmall);
            switch (stripesHorVert) {
                case 0: {
                    int n22 = col;
                    fht[n22] = fht[n22] * ((1.0f - colFactLarge) * colFactSmall);
                    int n23 = backcol;
                    fht[n23] = fht[n23] * ((1.0f - colFactLarge) * colFactSmall);
                    int n24 = col + rowmid;
                    fht[n24] = fht[n24] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall);
                    int n25 = backcol + rowmid;
                    fht[n25] = fht[n25] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall);
                    int n26 = col;
                    filter[n26] = filter[n26] * ((1.0f - colFactLarge) * colFactSmall);
                    int n27 = backcol;
                    filter[n27] = filter[n27] * ((1.0f - colFactLarge) * colFactSmall);
                    int n28 = col + rowmid;
                    filter[n28] = filter[n28] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall);
                    int n29 = backcol + rowmid;
                    filter[n29] = filter[n29] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall);
                    break;
                }
                case 1: {
                    factStripes = (float)Math.exp((double)(-(col * col)) * scaleStripes);
                    int n30 = col;
                    fht[n30] = fht[n30] * ((1.0f - colFactLarge) * colFactSmall * (1.0f - factStripes));
                    int n31 = backcol;
                    fht[n31] = fht[n31] * ((1.0f - colFactLarge) * colFactSmall * (1.0f - factStripes));
                    int n32 = col + rowmid;
                    fht[n32] = fht[n32] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    int n33 = backcol + rowmid;
                    fht[n33] = fht[n33] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    int n34 = col;
                    filter[n34] = filter[n34] * ((1.0f - colFactLarge) * colFactSmall * (1.0f - factStripes));
                    int n35 = backcol;
                    filter[n35] = filter[n35] * ((1.0f - colFactLarge) * colFactSmall * (1.0f - factStripes));
                    int n36 = col + rowmid;
                    filter[n36] = filter[n36] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    int n37 = backcol + rowmid;
                    filter[n37] = filter[n37] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    break;
                }
                case 2: {
                    factStripes = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleStripes);
                    fht[col] = 0.0f;
                    fht[backcol] = 0.0f;
                    int n38 = col + rowmid;
                    fht[n38] = fht[n38] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    int n39 = backcol + rowmid;
                    fht[n39] = fht[n39] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    filter[col] = 0.0f;
                    filter[backcol] = 0.0f;
                    int n40 = col + rowmid;
                    filter[n40] = filter[n40] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    int n41 = backcol + rowmid;
                    filter[n41] = filter[n41] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                }
            }
            ++col;
        }
        colFactLarge = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleLarge);
        colFactSmall = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleSmall);
        int j2 = 1;
        while (j2 < maxN / 2) {
            row = j2 * maxN;
            backrow = (maxN - j2) * maxN;
            rowFactLarge = (float)Math.exp((double)(-(j2 * j2)) * scaleLarge);
            rowFactSmall = (float)Math.exp((double)(-(j2 * j2)) * scaleSmall);
            switch (stripesHorVert) {
                case 0: {
                    int n42 = row;
                    fht[n42] = fht[n42] * ((1.0f - rowFactLarge) * rowFactSmall);
                    int n43 = backrow;
                    fht[n43] = fht[n43] * ((1.0f - rowFactLarge) * rowFactSmall);
                    int n44 = row + maxN / 2;
                    fht[n44] = fht[n44] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall);
                    int n45 = backrow + maxN / 2;
                    fht[n45] = fht[n45] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall);
                    int n46 = row;
                    filter[n46] = filter[n46] * ((1.0f - rowFactLarge) * rowFactSmall);
                    int n47 = backrow;
                    filter[n47] = filter[n47] * ((1.0f - rowFactLarge) * rowFactSmall);
                    int n48 = row + maxN / 2;
                    filter[n48] = filter[n48] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall);
                    int n49 = backrow + maxN / 2;
                    filter[n49] = filter[n49] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall);
                    break;
                }
                case 1: {
                    factStripes = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleStripes);
                    fht[row] = 0.0f;
                    fht[backrow] = 0.0f;
                    int n50 = row + maxN / 2;
                    fht[n50] = fht[n50] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    int n51 = backrow + maxN / 2;
                    fht[n51] = fht[n51] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    filter[row] = 0.0f;
                    filter[backrow] = 0.0f;
                    int n52 = row + maxN / 2;
                    filter[n52] = filter[n52] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    int n53 = backrow + maxN / 2;
                    filter[n53] = filter[n53] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    break;
                }
                case 2: {
                    factStripes = (float)Math.exp((double)(-(j2 * j2)) * scaleStripes);
                    int n54 = row;
                    fht[n54] = fht[n54] * ((1.0f - rowFactLarge) * rowFactSmall * (1.0f - factStripes));
                    int n55 = backrow;
                    fht[n55] = fht[n55] * ((1.0f - rowFactLarge) * rowFactSmall * (1.0f - factStripes));
                    int n56 = row + maxN / 2;
                    fht[n56] = fht[n56] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    int n57 = backrow + maxN / 2;
                    fht[n57] = fht[n57] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    int n58 = row;
                    filter[n58] = filter[n58] * ((1.0f - rowFactLarge) * rowFactSmall * (1.0f - factStripes));
                    int n59 = backrow;
                    filter[n59] = filter[n59] * ((1.0f - rowFactLarge) * rowFactSmall * (1.0f - factStripes));
                    int n60 = row + maxN / 2;
                    filter[n60] = filter[n60] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    int n61 = backrow + maxN / 2;
                    filter[n61] = filter[n61] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                }
            }
            ++j2;
        }
        if (displayFilter && this.stackSize == 1) {
            FloatProcessor filterIP = new FloatProcessor(maxN, maxN, filter, null);
            this.swapQuadrants(filterIP);
            new ImagePlus("Filter", filterIP).show();
        }
    }

    boolean showBandpassDialog(ImagePlus imp) {
        GenericDialog gd = new GenericDialog("FFT Bandpass Filter");
        gd.addNumericField("Filter_Large Structures Down to", filterLargeDia, 0, 4, "pixels");
        gd.addNumericField("Filter_Small Structures Up to", filterSmallDia, 0, 4, "pixels");
        gd.addChoice("Suppress Stripes:", choices, choiceDia);
        gd.addNumericField("Tolerance of Direction:", toleranceDia, 0, 2, "%");
        gd.addCheckbox("Autoscale After Filtering", doScalingDia);
        gd.addCheckbox("Saturate Image when Autoscaling", saturateDia);
        gd.addCheckbox("Display Filter", displayFilter);
        if (this.stackSize > 1) {
            gd.addCheckbox("Process Entire Stack", processStack);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        if (gd.invalidNumber()) {
            IJ.showMessage("Error", "Invalid input number");
            return false;
        }
        filterLargeDia = gd.getNextNumber();
        filterSmallDia = gd.getNextNumber();
        choiceIndex = gd.getNextChoiceIndex();
        choiceDia = choices[choiceIndex];
        toleranceDia = gd.getNextNumber();
        doScalingDia = gd.getNextBoolean();
        saturateDia = gd.getNextBoolean();
        displayFilter = gd.getNextBoolean();
        if (this.stackSize > 1) {
            processStack = gd.getNextBoolean();
        }
        return true;
    }

    public boolean powerOf2Size(ImageProcessor ip) {
        Rectangle r = ip.getRoi();
        return this.powerOf2(r.width) && r.width == r.height;
    }

    boolean powerOf2(int n) {
        int i = 2;
        while (i < n) {
            i *= 2;
        }
        return i == n;
    }

    public void fft(ImageProcessor ip, boolean inverse) {
        int maxN = ip.getWidth();
        this.makeSinCosTables(maxN);
        this.makeBitReverseTable(maxN);
        this.tempArr = new float[maxN];
        float[] fht = (float[])ip.getPixels();
        if (inverse) {
            this.doMasking(fht);
        }
        this.rc2DFHT(fht, inverse, maxN);
        if (inverse) {
            ip.resetMinAndMax();
            if (!this.bandpassFilter) {
                this.imp.setProcessor(null, ip);
            }
            if (this.imp.getProperty("FHT") != null) {
                ((Hashtable)this.imp.getProperties()).remove("FHT");
            }
        } else {
            ImageProcessor ps = this.calculatePowerSpectrum(fht, maxN);
            ImagePlus imp2 = this.imp;
            if (this.imp.getRoi() != null) {
                imp2 = new ImagePlus("FFT", ps);
                imp2.show();
            } else {
                imp2.setProcessor(null, ps);
            }
            imp2.setProperty("FHT", ip);
            if (IJ.altKeyDown()) {
                ImageProcessor amp = this.calculateAmplitude(fht, maxN);
                new ImagePlus("Amplitude", amp).show();
            }
        }
    }

    void makeSinCosTables(int maxN) {
        int n = maxN / 4;
        this.C = new float[n];
        this.S = new float[n];
        double theta = 0.0;
        double dTheta = Math.PI * 2 / (double)maxN;
        int i = 0;
        while (i < n) {
            this.C[i] = (float)Math.cos(theta);
            this.S[i] = (float)Math.sin(theta);
            theta += dTheta;
            ++i;
        }
    }

    void makeBitReverseTable(int maxN) {
        this.bitrev = new int[maxN];
        int nLog2 = this.log2(maxN);
        int i = 0;
        while (i < maxN) {
            this.bitrev[i] = this.bitRevX(i, nLog2);
            ++i;
        }
    }

    void rc2DFHT(float[] x, boolean inverse, int maxN) {
        int row = 0;
        while (row < maxN) {
            this.dfht3(x, row * maxN, inverse, maxN);
            ++row;
        }
        this.progress(0.4);
        this.transposeR(x, maxN);
        this.progress(0.5);
        int row2 = 0;
        while (row2 < maxN) {
            this.dfht3(x, row2 * maxN, inverse, maxN);
            ++row2;
        }
        this.progress(0.7);
        this.transposeR(x, maxN);
        this.progress(0.8);
        int row3 = 0;
        while (row3 < maxN / 2) {
            int col = 0;
            while (col < maxN / 2) {
                int mRow = (maxN - row3) % maxN;
                int mCol = (maxN - col) % maxN;
                float A = x[row3 * maxN + col];
                float B = x[mRow * maxN + col];
                float C = x[row3 * maxN + mCol];
                float D = x[mRow * maxN + mCol];
                float E = (A + D - (B + C)) / 2.0f;
                x[row3 * maxN + col] = A - E;
                x[mRow * maxN + col] = B + E;
                x[row3 * maxN + mCol] = C + E;
                x[mRow * maxN + mCol] = D - E;
                ++col;
            }
            ++row3;
        }
        this.progress(0.95);
    }

    void progress(double percent) {
        if (!this.bandpassFilter) {
            IJ.showProgress(percent);
        }
    }

    void dfht3(float[] x, int base, boolean inverse, int maxN) {
        float rt2;
        float rt1;
        int Ad4;
        int Ad3;
        int Ad2;
        int Ad1;
        int Nlog2 = this.log2(maxN);
        this.BitRevRArr(x, base, Nlog2, maxN);
        int gpSize = 2;
        int numGps = maxN / 4;
        int gpNum = 0;
        while (gpNum < numGps) {
            Ad1 = gpNum * 4;
            Ad2 = Ad1 + 1;
            Ad3 = Ad1 + gpSize;
            Ad4 = Ad2 + gpSize;
            rt1 = x[base + Ad1] + x[base + Ad2];
            rt2 = x[base + Ad1] - x[base + Ad2];
            float rt3 = x[base + Ad3] + x[base + Ad4];
            float rt4 = x[base + Ad3] - x[base + Ad4];
            x[base + Ad1] = rt1 + rt3;
            x[base + Ad2] = rt2 + rt4;
            x[base + Ad3] = rt1 - rt3;
            x[base + Ad4] = rt2 - rt4;
            ++gpNum;
        }
        if (Nlog2 > 2) {
            gpSize = 4;
            int numBfs = 2;
            numGps /= 2;
            int stage = 2;
            while (stage < Nlog2) {
                gpNum = 0;
                while (gpNum < numGps) {
                    int Ad0;
                    Ad1 = Ad0 = gpNum * gpSize * 2;
                    Ad2 = Ad1 + gpSize;
                    Ad3 = Ad1 + gpSize / 2;
                    Ad4 = Ad3 + gpSize;
                    rt1 = x[base + Ad1];
                    x[base + Ad1] = x[base + Ad1] + x[base + Ad2];
                    x[base + Ad2] = rt1 - x[base + Ad2];
                    rt1 = x[base + Ad3];
                    x[base + Ad3] = x[base + Ad3] + x[base + Ad4];
                    x[base + Ad4] = rt1 - x[base + Ad4];
                    int bfNum = 1;
                    while (bfNum < numBfs) {
                        Ad1 = bfNum + Ad0;
                        Ad2 = Ad1 + gpSize;
                        Ad3 = gpSize - bfNum + Ad0;
                        Ad4 = Ad3 + gpSize;
                        int CSAd = bfNum * numGps;
                        rt1 = x[base + Ad2] * this.C[CSAd] + x[base + Ad4] * this.S[CSAd];
                        rt2 = x[base + Ad4] * this.C[CSAd] - x[base + Ad2] * this.S[CSAd];
                        x[base + Ad2] = x[base + Ad1] - rt1;
                        x[base + Ad1] = x[base + Ad1] + rt1;
                        x[base + Ad4] = x[base + Ad3] + rt2;
                        x[base + Ad3] = x[base + Ad3] - rt2;
                        ++bfNum;
                    }
                    ++gpNum;
                }
                gpSize *= 2;
                numBfs *= 2;
                numGps /= 2;
                ++stage;
            }
        }
        if (inverse) {
            int i = 0;
            while (i < maxN) {
                x[base + i] = x[base + i] / (float)maxN;
                ++i;
            }
        }
    }

    void transposeR(float[] x, int maxN) {
        int r = 0;
        while (r < maxN) {
            int c = r;
            while (c < maxN) {
                if (r != c) {
                    float rTemp = x[r * maxN + c];
                    x[r * maxN + c] = x[c * maxN + r];
                    x[c * maxN + r] = rTemp;
                }
                ++c;
            }
            ++r;
        }
    }

    int log2(int x) {
        int count = 15;
        while (!this.btst(x, count)) {
            --count;
        }
        return count;
    }

    private boolean btst(int x, int bit) {
        return (x & 1 << bit) != 0;
    }

    void BitRevRArr(float[] x, int base, int bitlen, int maxN) {
        int i = 0;
        while (i < maxN) {
            this.tempArr[i] = x[base + this.bitrev[i]];
            ++i;
        }
        int i2 = 0;
        while (i2 < maxN) {
            x[base + i2] = this.tempArr[i2];
            ++i2;
        }
    }

    private int bitRevX(int x, int bitlen) {
        int temp = 0;
        int i = 0;
        while (i <= bitlen) {
            if ((x & 1 << i) != 0) {
                temp |= 1 << bitlen - i - 1;
            }
            ++i;
        }
        return temp & 0xFFFF;
    }

    private int bset(int x, int bit) {
        return x |= 1 << bit;
    }

    ImageProcessor calculatePowerSpectrum(float[] fht, int maxN) {
        float r;
        int base;
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        float[] fps = new float[maxN * maxN];
        byte[] ps = new byte[maxN * maxN];
        int row = 0;
        while (row < maxN) {
            this.FHTps(row, maxN, fht, fps);
            base = row * maxN;
            int col = 0;
            while (col < maxN) {
                r = fps[base + col];
                if (r < min) {
                    min = r;
                }
                if (r > max) {
                    max = r;
                }
                ++col;
            }
            ++row;
        }
        min = (double)min < 1.0 ? 0.0f : (float)Math.log(min);
        max = (float)Math.log(max);
        float scale = (float)(253.0 / (double)(max - min));
        int row2 = 0;
        while (row2 < maxN) {
            base = row2 * maxN;
            int col = 0;
            while (col < maxN) {
                r = fps[base + col];
                r = r < 1.0f ? 0.0f : (float)Math.log(r);
                ps[base + col] = (byte)((double)((r - min) * scale) + 0.5 + 1.0);
                ++col;
            }
            ++row2;
        }
        ByteProcessor ip = new ByteProcessor(maxN, maxN, ps, null);
        this.swapQuadrants(ip);
        return ip;
    }

    void FHTps(int row, int maxN, float[] fht, float[] ps) {
        int base = row * maxN;
        int c = 0;
        while (c < maxN) {
            int l = (maxN - row) % maxN * maxN + (maxN - c) % maxN;
            ps[base + c] = (this.sqr(fht[base + c]) + this.sqr(fht[l])) / 2.0f;
            ++c;
        }
    }

    ImageProcessor calculateAmplitude(float[] fht, int maxN) {
        float[] amp = new float[maxN * maxN];
        int row = 0;
        while (row < maxN) {
            this.amplitude(row, maxN, fht, amp);
            ++row;
        }
        FloatProcessor ip = new FloatProcessor(maxN, maxN, amp, null);
        this.swapQuadrants(ip);
        return ip;
    }

    void amplitude(int row, int maxN, float[] fht, float[] amplitude) {
        int base = row * maxN;
        int c = 0;
        while (c < maxN) {
            int l = (maxN - row) % maxN * maxN + (maxN - c) % maxN;
            amplitude[base + c] = (float)Math.sqrt(this.sqr(fht[base + c]) + this.sqr(fht[l]));
            ++c;
        }
    }

    float sqr(float x) {
        return x * x;
    }

    public void swapQuadrants(ImageProcessor ip) {
        int size = ip.getWidth() / 2;
        ip.setRoi(size, 0, size, size);
        ImageProcessor t1 = ip.crop();
        ip.setRoi(0, size, size, size);
        ImageProcessor t2 = ip.crop();
        ip.insert(t1, 0, size);
        ip.insert(t2, size, 0);
        ip.setRoi(0, 0, size, size);
        t1 = ip.crop();
        ip.setRoi(size, size, size, size);
        t2 = ip.crop();
        ip.insert(t1, size, size);
        ip.insert(t2, 0, 0);
    }

    void doMasking(float[] fht) {
        boolean passMode;
        ImageProcessor mask = this.imp.getProcessor();
        ImageStatistics stats = ImageStatistics.getStatistics(mask, 16, null);
        if (stats.histogram[0] == 0 && stats.histogram[255] == 0) {
            return;
        }
        mask = mask.duplicate();
        boolean bl = passMode = stats.histogram[255] != 0;
        if (passMode) {
            this.changeValues(mask, 0, 254, 0);
        } else {
            this.changeValues(mask, 1, 255, 255);
        }
        int i = 0;
        while (i < 3) {
            mask.smooth();
            ++i;
        }
        this.imp.updateAndDraw();
        this.swapQuadrants(mask);
        byte[] pixels = (byte[])mask.getPixels();
        int i2 = 0;
        while (i2 < pixels.length) {
            fht[i2] = (float)((double)(fht[i2] * (float)(pixels[i2] & 0xFF)) / 255.0);
            ++i2;
        }
    }

    void changeValues(ImageProcessor ip, int v1, int v2, int v3) {
        byte[] pixels = (byte[])ip.getPixels();
        int i = 0;
        while (i < pixels.length) {
            int v = pixels[i] & 0xFF;
            if (v >= v1 && v <= v2) {
                pixels[i] = (byte)v3;
            }
            ++i;
        }
    }

    public void redisplayPowerSpectrum() {
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        ImageProcessor fht = (ImageProcessor)this.imp.getProperty("FHT");
        if (fht == null) {
            IJ.showMessage("FFT", "Frequency domain image required");
            return;
        }
        float[] pixels = (float[])fht.getPixels();
        ImageProcessor ps = this.calculatePowerSpectrum(pixels, fht.getWidth());
        this.imp.setProcessor(null, ps);
    }

    boolean customFilter(ImageProcessor fht) {
        int size = fht.getWidth();
        ImageProcessor filter = this.getFilter(size);
        if (filter == null) {
            return false;
        }
        this.swapQuadrants(filter);
        float[] fhtPixels = (float[])fht.getPixels();
        byte[] filterPixels = (byte[])filter.getPixels();
        int i = 0;
        while (i < fhtPixels.length) {
            fhtPixels[i] = (float)((double)(fhtPixels[i] * (float)(filterPixels[i] & 0xFF)) / 255.0);
            ++i;
        }
        this.swapQuadrants(filter);
        return true;
    }

    ImageProcessor getFilter(int size) {
        int[] wList = WindowManager.getIDList();
        if (wList == null || wList.length < 2) {
            IJ.showMessage("FFT", "Filter (as an open image) required.");
            return null;
        }
        String[] titles = new String[wList.length];
        int i = 0;
        while (i < wList.length) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            titles[i] = imp != null ? imp.getTitle() : "";
            ++i;
        }
        if (filterIndex < 0 || filterIndex >= titles.length) {
            filterIndex = 1;
        }
        GenericDialog gd = new GenericDialog("FFT Filter");
        gd.addChoice("Frequency Domain Filter:", titles, titles[filterIndex]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        filterIndex = gd.getNextChoiceIndex();
        ImageProcessor filter = WindowManager.getImage(wList[filterIndex]).getProcessor();
        if (filter.getWidth() != size || filter.getHeight() != size) {
            IJ.showMessage("FFT", "Filter must be a " + size + "x" + size);
            filter = null;
        }
        return filter.convertToByte(true);
    }
}

