/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.measure.Measurements;
import ij.plugin.filter.GaussianBlur;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.awt.Rectangle;

public class UnsharpMask
implements PlugInFilter,
Measurements {
    private ImagePlus imp;
    private int slice;
    private boolean canceled;
    private ImageWindow win;
    private static double radius = 2.0;
    private static double weight = 0.6;
    private boolean isLineRoi;
    static /* synthetic */ Class class$ij$plugin$filter$UnsharpMask;

    public int setup(String arg, ImagePlus imp) {
        IJ.register(class$ij$plugin$filter$UnsharpMask == null ? (class$ij$plugin$filter$UnsharpMask = UnsharpMask.class$("ij.plugin.filter.UnsharpMask")) : class$ij$plugin$filter$UnsharpMask);
        this.imp = imp;
        if (imp != null) {
            this.win = imp.getWindow();
            this.win.running = true;
            Roi roi = imp.getRoi();
            boolean bl = this.isLineRoi = roi != null && roi.getType() >= 5;
        }
        if (imp != null && !this.showDialog()) {
            return 4096;
        }
        return IJ.setupDialog(imp, 31);
    }

    public void run(ImageProcessor ip) {
        if (this.canceled) {
            return;
        }
        if (!this.win.running) {
            this.canceled = true;
            IJ.beep();
            return;
        }
        ++this.slice;
        if (this.slice > 1) {
            IJ.showStatus("Unsharp Mask: " + this.slice + "/" + this.imp.getStackSize());
        }
        if (this.isLineRoi) {
            ip.resetRoi();
        }
        this.sharpen(ip, radius, weight);
    }

    public void sharpen(ImageProcessor ip, double radius, double weight) {
        boolean convertToFloat;
        ip.setCalibrationTable(null);
        Rectangle rect = ip.getRoi();
        boolean isRoi = rect.width != ip.getWidth() || rect.height != ip.getHeight();
        boolean nonRectRoi = ip.getMask() != null;
        ImageProcessor ip2 = ip;
        if (isRoi) {
            ip2.setRoi(rect);
            ip2 = ip2.crop();
        }
        boolean bl = convertToFloat = ip instanceof ByteProcessor || ip instanceof ShortProcessor;
        if (convertToFloat) {
            ip2 = ip2.convertToFloat();
        }
        ImageStatistics stats = ImageStatistics.getStatistics(ip2, 16, null);
        double min = stats.min;
        double max = stats.max;
        ImageProcessor mask = ip2.duplicate();
        new GaussianBlur().blur(mask, radius);
        mask.multiply(weight);
        ip2.copyBits(mask, 0, 0, 4);
        ip2.multiply(1.0 / (1.0 - weight));
        if (!(ip2 instanceof ColorProcessor)) {
            ip2.min(min);
            ip2.max(max);
        }
        if (nonRectRoi) {
            ip.snapshot();
        }
        if (convertToFloat) {
            boolean bytes = ip instanceof ByteProcessor;
            boolean scale = bytes && this.imp.getStackSize() == 1;
            ImageProcessor ip3 = bytes ? ip2.convertToByte(scale) : ip2.convertToShort(scale);
            ip.insert(ip3, rect.x, rect.y);
        } else if (isRoi) {
            ip.insert(ip2, rect.x, rect.y);
        }
        if (nonRectRoi) {
            ip.reset(ip.getMask());
        }
    }

    public boolean showDialog() {
        GenericDialog gd = new GenericDialog("Unsharp Mask...");
        gd.addNumericField("Gaussian Radius (1-15)", radius, 0);
        gd.addNumericField("Mask Weight (0.2-0.9)", weight, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.canceled = true;
            return false;
        }
        radius = gd.getNextNumber();
        weight = gd.getNextNumber();
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

