/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.ImagePlus;
import ij.measure.Measurements;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

class ThresholdPlot
extends Canvas
implements Measurements,
MouseListener {
    static final int WIDTH = 256;
    static final int HEIGHT = 48;
    double minThreshold = 85.0;
    double maxThreshold = 170.0;
    int[] histogram;
    Color[] hColors;
    int hmax;
    Image os;
    Graphics osg;
    int mode;

    public ThresholdPlot() {
        this.addMouseListener(this);
        this.setSize(257, 49);
    }

    void setHistogram(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        if (!(ip instanceof ByteProcessor)) {
            double min = ip.getMin();
            double max = ip.getMax();
            ip.setMinAndMax(min, max);
            Rectangle r = ip.getRoi();
            ip = new ByteProcessor(ip.createImage());
            ip.setRoi(r);
        }
        ip.setMask(imp.getMask());
        ImageStatistics stats = ImageStatistics.getStatistics(ip, 9, null);
        int maxCount2 = 0;
        this.histogram = stats.histogram;
        int i = 0;
        while (i < stats.nBins) {
            if (this.histogram[i] > maxCount2 && i != stats.mode) {
                maxCount2 = this.histogram[i];
            }
            ++i;
        }
        this.hmax = stats.maxCount;
        if (this.hmax > maxCount2 * 2 && maxCount2 != 0) {
            this.histogram[stats.mode] = this.hmax = (int)((double)maxCount2 * 1.5);
        }
        this.os = null;
        ColorModel cm = ip.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            return;
        }
        IndexColorModel icm = (IndexColorModel)cm;
        int mapSize = icm.getMapSize();
        if (mapSize != 256) {
            return;
        }
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        icm.getReds(r);
        icm.getGreens(g);
        icm.getBlues(b);
        this.hColors = new Color[256];
        int i2 = 0;
        while (i2 < 256) {
            this.hColors[i2] = new Color(r[i2] & 0xFF, g[i2] & 0xFF, b[i2] & 0xFF);
            ++i2;
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.histogram != null) {
            if (this.os == null) {
                this.os = this.createImage(256, 48);
                this.osg = this.os.getGraphics();
                this.osg.setColor(Color.white);
                this.osg.fillRect(0, 0, 256, 48);
                this.osg.setColor(Color.gray);
                int i = 0;
                while (i < 256) {
                    if (this.hColors != null) {
                        this.osg.setColor(this.hColors[i]);
                    }
                    this.osg.drawLine(i, 48, i, 48 - 48 * this.histogram[i] / this.hmax);
                    ++i;
                }
                this.osg.dispose();
            }
            g.drawImage(this.os, 0, 0, this);
        } else {
            g.setColor(Color.white);
            g.fillRect(0, 0, 256, 48);
        }
        g.setColor(Color.black);
        g.drawRect(0, 0, 256, 48);
        if (this.mode == 0) {
            g.setColor(Color.red);
        } else if (this.mode == 2) {
            g.setColor(Color.blue);
            g.drawRect(1, 1, (int)this.minThreshold - 2, 48);
            g.drawRect(1, 0, (int)this.minThreshold - 2, 0);
            g.setColor(Color.green);
            g.drawRect((int)this.maxThreshold + 1, 1, 256 - (int)this.maxThreshold, 48);
            g.drawRect((int)this.maxThreshold + 1, 0, 256 - (int)this.maxThreshold, 0);
            return;
        }
        g.drawRect((int)this.minThreshold, 1, (int)(this.maxThreshold - this.minThreshold), 48);
        g.drawLine((int)this.minThreshold, 0, (int)this.maxThreshold, 0);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }
}

