/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.process.ByteProcessor;
import ij.process.ColorBlitter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class ColorProcessor
extends ImageProcessor {
    protected int[] pixels;
    protected int[] snapshotPixels = null;
    private int bgColor = -1;
    private int min = 0;
    private int max = 255;
    public final int RGB_NOISE = 0;
    public final int RGB_MEDIAN = 1;
    public final int RGB_FIND_EDGES = 2;
    public final int RGB_ERODE = 3;
    public final int RGB_DILATE = 4;
    public final int RGB_THRESHOLD = 5;

    public ColorProcessor(Image img) {
        this.width = img.getWidth(null);
        this.height = img.getHeight(null);
        this.pixels = new int[this.width * this.height];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, this.width, this.height, this.pixels, 0, this.width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.createColorModel();
        this.fgColor = -16777216;
        this.resetRoi();
    }

    public ColorProcessor(int width, int height) {
        this(width, height, new int[width * height]);
    }

    public ColorProcessor(int width, int height, int[] pixels) {
        if (pixels != null && width * height != pixels.length) {
            throw new IllegalArgumentException("(width*height) != pixels.length");
        }
        this.width = width;
        this.height = height;
        this.createColorModel();
        this.fgColor = -16777216;
        this.resetRoi();
        this.pixels = pixels;
    }

    void createColorModel() {
        this.cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
    }

    public Image createImage() {
        if (this.source == null || IJ.isMacintosh() && !IJ.isJava2()) {
            this.source = new MemoryImageSource(this.width, this.height, this.cm, this.pixels, 0, this.width);
            this.source.setAnimated(true);
            this.source.setFullBufferUpdates(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.source);
        } else if (this.newPixels) {
            this.source.newPixels(this.pixels, this.cm, 0, this.width);
            this.newPixels = false;
        } else {
            this.source.newPixels();
        }
        return this.img;
    }

    public ImageProcessor createProcessor(int width, int height) {
        int[] pixels = new int[width * height];
        int i = 0;
        while (i < width * height) {
            pixels[i] = -1;
            ++i;
        }
        return new ColorProcessor(width, height, pixels);
    }

    public Color getColor(int x, int y) {
        int c = this.pixels[y * this.width + x];
        int r = (c & 0xFF0000) >> 16;
        int g = (c & 0xFF00) >> 8;
        int b = c & 0xFF;
        return new Color(r, g, b);
    }

    public void setColor(Color color) {
        this.fgColor = color.getRGB();
        this.drawingColor = color;
    }

    public void setValue(double value) {
        this.fgColor = (int)value;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMinAndMax(double min, double max) {
        this.setMinAndMax(min, max, 7);
    }

    public void setMinAndMax(double min, double max, int channels) {
        if (max < min) {
            return;
        }
        this.min = (int)min;
        this.max = (int)max;
        int[] lut = new int[256];
        int i = 0;
        while (i < 256) {
            int v = i - this.min;
            if ((v = (int)(256.0 * (double)v / (max - min))) < 0) {
                v = 0;
            }
            if (v > 255) {
                v = 255;
            }
            lut[i] = v;
            ++i;
        }
        this.reset();
        if (channels == 7) {
            this.applyTable(lut);
        } else {
            this.applyTable(lut, channels);
        }
    }

    public void snapshot() {
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
        if (this.snapshotPixels == null || this.snapshotPixels != null && this.snapshotPixels.length != this.pixels.length) {
            this.snapshotPixels = new int[this.width * this.height];
        }
        System.arraycopy(this.pixels, 0, this.snapshotPixels, 0, this.width * this.height);
        this.newSnapshot = true;
    }

    public void reset() {
        if (this.snapshotPixels == null) {
            return;
        }
        System.arraycopy(this.snapshotPixels, 0, this.pixels, 0, this.width * this.height);
        this.newSnapshot = true;
    }

    public void reset(int[] mask) {
        if (mask == null || this.snapshotPixels == null || mask.length != this.roiWidth * this.roiHeight) {
            return;
        }
        int y = this.roiY;
        int my = 0;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int mi = my * this.roiWidth;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                if (mask[mi++] != -16777216) {
                    this.pixels[i] = this.snapshotPixels[i];
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
    }

    public void fill(int[] mask) {
        if (mask == null) {
            this.fill();
            return;
        }
        if (mask.length < this.roiWidth * this.roiHeight) {
            throw new IllegalArgumentException();
        }
        int y = this.roiY;
        int my = 0;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int mi = my * this.roiWidth;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                if (mask[mi++] == -16777216) {
                    this.pixels[i] = this.fgColor;
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
    }

    public Object getPixelsCopy() {
        if (this.newSnapshot) {
            return this.snapshotPixels;
        }
        int[] pixels2 = new int[this.width * this.height];
        System.arraycopy(this.pixels, 0, pixels2, 0, this.width * this.height);
        return pixels2;
    }

    public Object getSnapshotPixels() {
        return this.snapshotPixels;
    }

    public int getPixel(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return this.pixels[y * this.width + x];
        }
        return 0;
    }

    public int[] getPixel(int x, int y, int[] iArray) {
        if (iArray == null) {
            iArray = new int[3];
        }
        int c = this.getPixel(x, y);
        iArray[0] = (c & 0xFF0000) >> 16;
        iArray[1] = (c & 0xFF00) >> 8;
        iArray[2] = c & 0xFF;
        return iArray;
    }

    public void putPixel(int x, int y, int[] iArray) {
        int r = iArray[0];
        int g = iArray[1];
        int b = iArray[2];
        this.putPixel(x, y, -16777216 + (r << 16) + (g << 8) + b);
    }

    public double getInterpolatedPixel(double x, double y) {
        int ix = (int)(x + 0.5);
        int iy = (int)(y + 0.5);
        if (ix < 0) {
            ix = 0;
        }
        if (ix >= this.width) {
            ix = this.width - 1;
        }
        if (iy < 0) {
            iy = 0;
        }
        if (iy >= this.height) {
            iy = this.height - 1;
        }
        return this.getPixelValue(ix, iy);
    }

    public void putPixel(int x, int y, int value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.pixels[y * this.width + x] = value | 0xFF000000;
        }
    }

    public void putPixelValue(int x, int y, double value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            if (value > 255.0) {
                value = 255.0;
            } else if (value < 0.0) {
                value = 0.0;
            }
            int gray = (int)(value + 0.5);
            this.pixels[y * this.width + x] = -16777216 + (gray << 16) + (gray << 8) + gray;
        }
    }

    public float getPixelValue(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            int c = this.pixels[y * this.width + x];
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            return (float)((double)r * 0.299 + (double)g * 0.587 + (double)b * 0.114);
        }
        return 0.0f;
    }

    public void drawPixel(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.pixels[y * this.width + x] = this.fgColor;
        }
    }

    public Object getPixels() {
        return this.pixels;
    }

    public void setPixels(Object pixels) {
        this.pixels = (int[])pixels;
        this.resetPixels(pixels);
        this.snapshotPixels = null;
    }

    public void getHSB(byte[] H, byte[] S, byte[] B) {
        float[] hsb = new float[3];
        int i = 0;
        while (i < this.width * this.height) {
            int c = this.pixels[i];
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            hsb = Color.RGBtoHSB(r, g, b, hsb);
            H[i] = (byte)((double)hsb[0] * 255.0);
            S[i] = (byte)((double)hsb[1] * 255.0);
            B[i] = (byte)((double)hsb[2] * 255.0);
            ++i;
        }
    }

    public void getRGB(byte[] R, byte[] G, byte[] B) {
        int i = 0;
        while (i < this.width * this.height) {
            int c = this.pixels[i];
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            R[i] = (byte)r;
            G[i] = (byte)g;
            B[i] = (byte)b;
            ++i;
        }
    }

    public void setRGB(byte[] R, byte[] G, byte[] B) {
        int i = 0;
        while (i < this.width * this.height) {
            this.pixels[i] = 0xFF000000 | (R[i] & 0xFF) << 16 | (G[i] & 0xFF) << 8 | B[i] & 0xFF;
            ++i;
        }
    }

    public void setHSB(byte[] H, byte[] S, byte[] B) {
        int i = 0;
        while (i < this.width * this.height) {
            float hue = (float)((double)(H[i] & 0xFF) / 255.0);
            float saturation = (float)((double)(S[i] & 0xFF) / 255.0);
            float brightness = (float)((double)(B[i] & 0xFF) / 255.0);
            this.pixels[i] = Color.HSBtoRGB(hue, saturation, brightness);
            ++i;
        }
    }

    public void copyBits(ImageProcessor ip, int xloc, int yloc, int mode) {
        if (!(ip instanceof ColorProcessor | ip instanceof ByteProcessor)) {
            throw new IllegalArgumentException("8-bit or RGB image required");
        }
        new ColorBlitter(this).copyBits(ip, xloc, yloc, mode);
    }

    public void applyTable(int[] lut) {
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                int c = this.pixels[i];
                int r = lut[(c & 0xFF0000) >> 16];
                int g = lut[(c & 0xFF00) >> 8];
                int b = lut[c & 0xFF];
                this.pixels[i] = -16777216 + (r << 16) + (g << 8) + b;
                ++i;
                ++x;
            }
            ++y;
        }
        this.hideProgress();
    }

    public void applyTable(int[] lut, int channels) {
        int r = 0;
        int g = 0;
        int b = 0;
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                int c = this.pixels[i];
                if (channels == 4) {
                    r = lut[(c & 0xFF0000) >> 16];
                    g = (c & 0xFF00) >> 8;
                    b = c & 0xFF;
                } else if (channels == 2) {
                    r = (c & 0xFF0000) >> 16;
                    g = lut[(c & 0xFF00) >> 8];
                    b = c & 0xFF;
                } else if (channels == 1) {
                    r = (c & 0xFF0000) >> 16;
                    g = (c & 0xFF00) >> 8;
                    b = lut[c & 0xFF];
                } else if ((channels & 6) == 6) {
                    r = lut[(c & 0xFF0000) >> 16];
                    g = lut[(c & 0xFF00) >> 8];
                    b = c & 0xFF;
                } else if ((channels & 5) == 5) {
                    r = lut[(c & 0xFF0000) >> 16];
                    g = (c & 0xFF00) >> 8;
                    b = lut[c & 0xFF];
                } else if ((channels & 3) == 3) {
                    r = (c & 0xFF0000) >> 16;
                    g = lut[(c & 0xFF00) >> 8];
                    b = lut[c & 0xFF];
                }
                this.pixels[i] = -16777216 + (r << 16) + (g << 8) + b;
                ++i;
                ++x;
            }
            ++y;
        }
        this.hideProgress();
    }

    public void fill() {
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                this.pixels[i++] = this.fgColor;
                ++x;
            }
            if (y % 20 == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        this.hideProgress();
    }

    public void filterRGB(int type, double arg) {
        this.showProgress(0.01);
        byte[] R = new byte[this.width * this.height];
        byte[] G = new byte[this.width * this.height];
        byte[] B = new byte[this.width * this.height];
        this.getRGB(R, G, B);
        Rectangle roi = new Rectangle(this.roiX, this.roiY, this.roiWidth, this.roiHeight);
        ByteProcessor r = new ByteProcessor(this.width, this.height, R, null);
        r.setRoi(roi);
        ByteProcessor g = new ByteProcessor(this.width, this.height, G, null);
        g.setRoi(roi);
        ByteProcessor b = new ByteProcessor(this.width, this.height, B, null);
        b.setRoi(roi);
        this.showProgress(0.15);
        switch (type) {
            case 0: {
                r.noise(arg);
                this.showProgress(0.4);
                g.noise(arg);
                this.showProgress(0.65);
                b.noise(arg);
                this.showProgress(0.9);
                break;
            }
            case 1: {
                r.medianFilter();
                this.showProgress(0.4);
                g.medianFilter();
                this.showProgress(0.65);
                b.medianFilter();
                this.showProgress(0.9);
                break;
            }
            case 2: {
                r.findEdges();
                this.showProgress(0.4);
                g.findEdges();
                this.showProgress(0.65);
                b.findEdges();
                this.showProgress(0.9);
                break;
            }
            case 3: {
                r.erode();
                this.showProgress(0.4);
                g.erode();
                this.showProgress(0.65);
                b.erode();
                this.showProgress(0.9);
                break;
            }
            case 4: {
                r.dilate();
                this.showProgress(0.4);
                g.dilate();
                this.showProgress(0.65);
                b.dilate();
                this.showProgress(0.9);
                break;
            }
            case 5: {
                r.autoThreshold();
                this.showProgress(0.4);
                g.autoThreshold();
                this.showProgress(0.65);
                b.autoThreshold();
                this.showProgress(0.9);
            }
        }
        R = (byte[])r.getPixels();
        G = (byte[])g.getPixels();
        B = (byte[])b.getPixels();
        this.setRGB(R, G, B);
        this.hideProgress();
    }

    public void noise(double range) {
        this.filterRGB(0, range);
    }

    public void medianFilter() {
        this.filterRGB(1, 0.0);
    }

    public void findEdges() {
        this.filterRGB(2, 0.0);
    }

    public void erode() {
        this.filterRGB(3, 0.0);
    }

    public void dilate() {
        this.filterRGB(4, 0.0);
    }

    public void autoThreshold() {
        this.filterRGB(5, 0.0);
    }

    public void scale(double xScale, double yScale) {
        int ymax;
        int ymin;
        int xmax;
        int xmin;
        double xCenter = (double)this.roiX + (double)this.roiWidth / 2.0;
        double yCenter = (double)this.roiY + (double)this.roiHeight / 2.0;
        if (xScale > 1.0 && yScale > 1.0) {
            xmin = (int)(xCenter - (xCenter - (double)this.roiX) * xScale);
            if (xmin < 0) {
                xmin = 0;
            }
            if ((xmax = xmin + (int)((double)this.roiWidth * xScale) - 1) >= this.width) {
                xmax = this.width - 1;
            }
            if ((ymin = (int)(yCenter - (yCenter - (double)this.roiY) * yScale)) < 0) {
                ymin = 0;
            }
            if ((ymax = ymin + (int)((double)this.roiHeight * yScale) - 1) >= this.height) {
                ymax = this.height - 1;
            }
        } else {
            xmin = this.roiX;
            xmax = this.roiX + this.roiWidth - 1;
            ymin = this.roiY;
            ymax = this.roiY + this.roiHeight - 1;
        }
        int[] pixels2 = (int[])this.getPixelsCopy();
        boolean checkCoordinates = xScale < 1.0 || yScale < 1.0;
        double xlimit = (double)this.width - 1.0;
        double xlimit2 = (double)this.width - 1.001;
        double ylimit = (double)this.height - 1.0;
        double ylimit2 = (double)this.height - 1.001;
        int y = ymin;
        while (y <= ymax) {
            double ys = ((double)y - yCenter) / yScale + yCenter;
            int ysi = (int)ys;
            if (ys < 0.0) {
                ys = 0.0;
            }
            if (ys >= ylimit) {
                ys = ylimit2;
            }
            int index1 = y * this.width + xmin;
            int index2 = this.width * (int)ys;
            int x = xmin;
            while (x <= xmax) {
                double xs = ((double)x - xCenter) / xScale + xCenter;
                int xsi = (int)xs;
                if (checkCoordinates && (xsi < xmin || xsi > xmax || ysi < ymin || ysi > ymax)) {
                    this.pixels[index1++] = (byte)this.bgColor;
                } else if (this.interpolate) {
                    if (xs < 0.0) {
                        xs = 0.0;
                    }
                    if (xs >= xlimit) {
                        xs = xlimit2;
                    }
                    this.pixels[index1++] = this.getInterpolatedPixel(xs, ys, pixels2);
                } else {
                    this.pixels[index1++] = pixels2[index2 + xsi];
                }
                ++x;
            }
            if (y % 20 == 0) {
                this.showProgress((double)(y - ymin) / (double)this.height);
            }
            ++y;
        }
        this.hideProgress();
    }

    public ImageProcessor crop() {
        int[] pixels2 = new int[this.roiWidth * this.roiHeight];
        int ys = this.roiY;
        while (ys < this.roiY + this.roiHeight) {
            int offset1 = (ys - this.roiY) * this.roiWidth;
            int offset2 = ys * this.width + this.roiX;
            int xs = 0;
            while (xs < this.roiWidth) {
                pixels2[offset1++] = this.pixels[offset2++];
                ++xs;
            }
            ++ys;
        }
        return new ColorProcessor(this.roiWidth, this.roiHeight, pixels2);
    }

    private final int getInterpolatedPixel(double x, double y, int[] pixels) {
        int xbase = (int)x;
        int ybase = (int)y;
        double xFraction = x - (double)xbase;
        double yFraction = y - (double)ybase;
        int offset = ybase * this.width + xbase;
        int lowerLeft = pixels[offset];
        int rll = (lowerLeft & 0xFF0000) >> 16;
        int gll = (lowerLeft & 0xFF00) >> 8;
        int bll = lowerLeft & 0xFF;
        int lowerRight = pixels[offset + 1];
        int rlr = (lowerRight & 0xFF0000) >> 16;
        int glr = (lowerRight & 0xFF00) >> 8;
        int blr = lowerRight & 0xFF;
        int upperRight = pixels[offset + this.width + 1];
        int rur = (upperRight & 0xFF0000) >> 16;
        int gur = (upperRight & 0xFF00) >> 8;
        int bur = upperRight & 0xFF;
        int upperLeft = pixels[offset + this.width];
        int rul = (upperLeft & 0xFF0000) >> 16;
        int gul = (upperLeft & 0xFF00) >> 8;
        int bul = upperLeft & 0xFF;
        double upperAverage = (double)rul + xFraction * (double)(rur - rul);
        double lowerAverage = (double)rll + xFraction * (double)(rlr - rll);
        int r = (int)(lowerAverage + yFraction * (upperAverage - lowerAverage) + 0.5);
        upperAverage = (double)gul + xFraction * (double)(gur - gul);
        lowerAverage = (double)gll + xFraction * (double)(glr - gll);
        int g = (int)(lowerAverage + yFraction * (upperAverage - lowerAverage) + 0.5);
        upperAverage = (double)bul + xFraction * (double)(bur - bul);
        lowerAverage = (double)bll + xFraction * (double)(blr - bll);
        int b = (int)(lowerAverage + yFraction * (upperAverage - lowerAverage) + 0.5);
        return 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public ImageProcessor resize(int dstWidth, int dstHeight) {
        double srcCenterX = (double)this.roiX + (double)this.roiWidth / 2.0;
        double srcCenterY = (double)this.roiY + (double)this.roiHeight / 2.0;
        double dstCenterX = (double)dstWidth / 2.0;
        double dstCenterY = (double)dstHeight / 2.0;
        double xScale = (double)dstWidth / (double)this.roiWidth;
        double yScale = (double)dstHeight / (double)this.roiHeight;
        double xlimit = (double)this.width - 1.0;
        double xlimit2 = (double)this.width - 1.001;
        double ylimit = (double)this.height - 1.0;
        double ylimit2 = (double)this.height - 1.001;
        if (this.interpolate) {
            dstCenterX += xScale / 2.0;
            dstCenterY += yScale / 2.0;
        }
        ImageProcessor ip2 = this.createProcessor(dstWidth, dstHeight);
        int[] pixels2 = (int[])ip2.getPixels();
        int y = 0;
        while (y <= dstHeight - 1) {
            double ys = ((double)y - dstCenterY) / yScale + srcCenterY;
            if (this.interpolate) {
                if (ys < 0.0) {
                    ys = 0.0;
                }
                if (ys >= ylimit) {
                    ys = ylimit2;
                }
            }
            int index1 = this.width * (int)ys;
            int index2 = y * dstWidth;
            int x = 0;
            while (x <= dstWidth - 1) {
                double xs = ((double)x - dstCenterX) / xScale + srcCenterX;
                if (this.interpolate) {
                    if (xs < 0.0) {
                        xs = 0.0;
                    }
                    if (xs >= xlimit) {
                        xs = xlimit2;
                    }
                    pixels2[index2++] = this.getInterpolatedPixel(xs, ys, this.pixels);
                } else {
                    pixels2[index2++] = this.pixels[index1 + (int)xs];
                }
                ++x;
            }
            if (y % 20 == 0) {
                this.showProgress((double)y / (double)dstHeight);
            }
            ++y;
        }
        this.hideProgress();
        return ip2;
    }

    public void rotate(double angle) {
        if (angle % 360.0 == 0.0) {
            return;
        }
        int[] pixels2 = (int[])this.getPixelsCopy();
        double centerX = (double)this.roiX + (double)(this.roiWidth - 1) / 2.0;
        double centerY = (double)this.roiY + (double)(this.roiHeight - 1) / 2.0;
        int xMax = this.roiX + this.roiWidth - 1;
        double angleRadians = -angle / 57.29577951308232;
        double ca = Math.cos(angleRadians);
        double sa = Math.sin(angleRadians);
        double tmp1 = centerY * sa - centerX * ca;
        double tmp2 = -centerX * sa - centerY * ca;
        double dwidth = this.width;
        double dheight = this.height;
        double xlimit = (double)this.width - 1.0;
        double xlimit2 = (double)this.width - 1.001;
        double ylimit = (double)this.height - 1.0;
        double ylimit2 = (double)this.height - 1.001;
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int index = y * this.width + this.roiX;
            double tmp3 = tmp1 - (double)y * sa + centerX;
            double tmp4 = tmp2 + (double)y * ca + centerY;
            int x = this.roiX;
            while (x <= xMax) {
                double xs = (double)x * ca + tmp3;
                double ys = (double)x * sa + tmp4;
                if (xs >= -0.01 && xs < dwidth && ys >= -0.01 && ys < dheight) {
                    if (this.interpolate) {
                        if (xs < 0.0) {
                            xs = 0.0;
                        }
                        if (xs >= xlimit) {
                            xs = xlimit2;
                        }
                        if (ys < 0.0) {
                            ys = 0.0;
                        }
                        if (ys >= ylimit) {
                            ys = ylimit2;
                        }
                        this.pixels[index++] = this.getInterpolatedPixel(xs, ys, pixels2);
                    } else {
                        int ixs = (int)(xs + 0.5);
                        int iys = (int)(ys + 0.5);
                        if (ixs >= this.width) {
                            ixs = this.width - 1;
                        }
                        if (iys >= this.height) {
                            iys = this.height - 1;
                        }
                        this.pixels[index++] = pixels2[this.width * iys + ixs];
                    }
                } else {
                    this.pixels[index++] = this.bgColor;
                }
                ++x;
            }
            if (y % 30 == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        this.hideProgress();
    }

    public void flipVertical() {
        int y = 0;
        while (y < this.roiHeight / 2) {
            int index1 = (this.roiY + y) * this.width + this.roiX;
            int index2 = (this.roiY + this.roiHeight - 1 - y) * this.width + this.roiX;
            int i = 0;
            while (i < this.roiWidth) {
                int tmp = this.pixels[index1];
                this.pixels[index1++] = this.pixels[index2];
                this.pixels[index2++] = tmp;
                ++i;
            }
            ++y;
        }
        this.newSnapshot = false;
    }

    public void convolve3x3(int[] kernel) {
        int inc;
        int k1 = kernel[0];
        int k2 = kernel[1];
        int k3 = kernel[2];
        int k4 = kernel[3];
        int k5 = kernel[4];
        int k6 = kernel[5];
        int k7 = kernel[6];
        int k8 = kernel[7];
        int k9 = kernel[8];
        int scale = 0;
        int i = 0;
        while (i < kernel.length) {
            scale += kernel[i];
            ++i;
        }
        if (scale == 0) {
            scale = 1;
        }
        if ((inc = this.roiHeight / 25) < 1) {
            inc = 1;
        }
        int[] pixels2 = (int[])this.getPixelsCopy();
        int rsum = 0;
        int gsum = 0;
        int bsum = 0;
        int rowOffset = this.width;
        int y = this.yMin;
        while (y <= this.yMax) {
            int offset = this.xMin + y * this.width;
            int p1 = 0;
            int p2 = pixels2[offset - rowOffset - 1];
            int p3 = pixels2[offset - rowOffset];
            int p4 = 0;
            int p5 = pixels2[offset - 1];
            int p6 = pixels2[offset];
            int p7 = 0;
            int p8 = pixels2[offset + rowOffset - 1];
            int p9 = pixels2[offset + rowOffset];
            int x = this.xMin;
            while (x <= this.xMax) {
                p1 = p2;
                p2 = p3;
                p3 = pixels2[offset - rowOffset + 1];
                p4 = p5;
                p5 = p6;
                p6 = pixels2[offset + 1];
                p7 = p8;
                p8 = p9;
                p9 = pixels2[offset + rowOffset + 1];
                rsum = k1 * ((p1 & 0xFF0000) >> 16) + k2 * ((p2 & 0xFF0000) >> 16) + k3 * ((p3 & 0xFF0000) >> 16) + k4 * ((p4 & 0xFF0000) >> 16) + k5 * ((p5 & 0xFF0000) >> 16) + k6 * ((p6 & 0xFF0000) >> 16) + k7 * ((p7 & 0xFF0000) >> 16) + k8 * ((p8 & 0xFF0000) >> 16) + k9 * ((p9 & 0xFF0000) >> 16);
                if ((rsum /= scale) > 255) {
                    rsum = 255;
                }
                if (rsum < 0) {
                    rsum = 0;
                }
                gsum = k1 * ((p1 & 0xFF00) >> 8) + k2 * ((p2 & 0xFF00) >> 8) + k3 * ((p3 & 0xFF00) >> 8) + k4 * ((p4 & 0xFF00) >> 8) + k5 * ((p5 & 0xFF00) >> 8) + k6 * ((p6 & 0xFF00) >> 8) + k7 * ((p7 & 0xFF00) >> 8) + k8 * ((p8 & 0xFF00) >> 8) + k9 * ((p9 & 0xFF00) >> 8);
                if ((gsum /= scale) > 255) {
                    gsum = 255;
                } else if (gsum < 0) {
                    gsum = 0;
                }
                bsum = k1 * (p1 & 0xFF) + k2 * (p2 & 0xFF) + k3 * (p3 & 0xFF) + k4 * (p4 & 0xFF) + k5 * (p5 & 0xFF) + k6 * (p6 & 0xFF) + k7 * (p7 & 0xFF) + k8 * (p8 & 0xFF) + k9 * (p9 & 0xFF);
                if ((bsum /= scale) > 255) {
                    bsum = 255;
                }
                if (bsum < 0) {
                    bsum = 0;
                }
                this.pixels[offset++] = 0xFF000000 | rsum << 16 & 0xFF0000 | gsum << 8 & 0xFF00 | bsum & 0xFF;
                ++x;
            }
            if (y % inc == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        this.hideProgress();
    }

    public void filter(int type) {
        int inc = this.roiHeight / 25;
        if (inc < 1) {
            inc = 1;
        }
        int[] pixels2 = (int[])this.getPixelsCopy();
        int rsum = 0;
        int gsum = 0;
        int bsum = 0;
        int rowOffset = this.width;
        int y = this.yMin;
        while (y <= this.yMax) {
            int offset = this.xMin + y * this.width;
            int p1 = 0;
            int p2 = pixels2[offset - rowOffset - 1];
            int p3 = pixels2[offset - rowOffset];
            int p4 = 0;
            int p5 = pixels2[offset - 1];
            int p6 = pixels2[offset];
            int p7 = 0;
            int p8 = pixels2[offset + rowOffset - 1];
            int p9 = pixels2[offset + rowOffset];
            int x = this.xMin;
            while (x <= this.xMax) {
                p1 = p2;
                p2 = p3;
                p3 = pixels2[offset - rowOffset + 1];
                p4 = p5;
                p5 = p6;
                p6 = pixels2[offset + 1];
                p7 = p8;
                p8 = p9;
                p9 = pixels2[offset + rowOffset + 1];
                rsum = (p1 & 0xFF0000) + (p2 & 0xFF0000) + (p3 & 0xFF0000) + (p4 & 0xFF0000) + (p5 & 0xFF0000) + (p6 & 0xFF0000) + (p7 & 0xFF0000) + (p8 & 0xFF0000) + (p9 & 0xFF0000);
                gsum = (p1 & 0xFF00) + (p2 & 0xFF00) + (p3 & 0xFF00) + (p4 & 0xFF00) + (p5 & 0xFF00) + (p6 & 0xFF00) + (p7 & 0xFF00) + (p8 & 0xFF00) + (p9 & 0xFF00);
                bsum = (p1 & 0xFF) + (p2 & 0xFF) + (p3 & 0xFF) + (p4 & 0xFF) + (p5 & 0xFF) + (p6 & 0xFF) + (p7 & 0xFF) + (p8 & 0xFF) + (p9 & 0xFF);
                this.pixels[offset++] = 0xFF000000 | rsum / 9 & 0xFF0000 | gsum / 9 & 0xFF00 | bsum / 9;
                ++x;
            }
            if (y % inc == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        this.hideProgress();
    }

    public int[] getHistogram() {
        if (this.mask != null) {
            return this.getHistogram(this.mask);
        }
        int[] histogram = new int[256];
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                int v;
                int c = this.pixels[i++];
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                int n = v = (int)((double)r * 0.299 + (double)g * 0.587 + (double)b * 0.114 + 0.5);
                histogram[n] = histogram[n] + 1;
                ++x;
            }
            if (y % 20 == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        this.hideProgress();
        return histogram;
    }

    public int[] getHistogram(int[] mask) {
        int[] histogram = new int[256];
        int y = this.roiY;
        int my = 0;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int mi = my * this.roiWidth;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                if (mask[mi++] == -16777216) {
                    int v;
                    int c = this.pixels[i];
                    int r = (c & 0xFF0000) >> 16;
                    int g = (c & 0xFF00) >> 8;
                    int b = c & 0xFF;
                    int n = v = (int)((double)r * 0.299 + (double)g * 0.587 + (double)b * 0.114 + 0.5);
                    histogram[n] = histogram[n] + 1;
                }
                ++i;
                ++x;
            }
            if (y % 20 == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
            ++my;
        }
        this.hideProgress();
        return histogram;
    }

    public void convolve(float[] kernel, int kernelWidth, int kernelHeight) {
        int size = this.width * this.height;
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        this.getRGB(r, g, b);
        ByteProcessor rip = new ByteProcessor(this.width, this.height, r, null);
        ByteProcessor gip = new ByteProcessor(this.width, this.height, g, null);
        ByteProcessor bip = new ByteProcessor(this.width, this.height, b, null);
        ImageProcessor ip2 = rip.convertToFloat();
        Rectangle roi = this.getRoi();
        ip2.setRoi(roi);
        ip2.convolve(kernel, kernelWidth, kernelHeight);
        ImageProcessor r2 = ip2.convertToByte(false);
        ip2 = gip.convertToFloat();
        ip2.setRoi(roi);
        ip2.convolve(kernel, kernelWidth, kernelHeight);
        ImageProcessor g2 = ip2.convertToByte(false);
        ip2 = bip.convertToFloat();
        ip2.setRoi(roi);
        ip2.convolve(kernel, kernelWidth, kernelHeight);
        ImageProcessor b2 = ip2.convertToByte(false);
        this.setRGB((byte[])r2.getPixels(), (byte[])g2.getPixels(), (byte[])b2.getPixels());
    }

    public boolean isInvertedLut() {
        return false;
    }

    public int getBestIndex(Color c) {
        return 0;
    }

    public void invertLut() {
    }

    public void threshold(int level) {
    }
}

