/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.IJ;
import ij.ImageJ;
import ij.WindowManager;
import ij.gui.GUI;
import ij.io.OpenDialog;
import ij.plugin.filter.Analyzer;
import ij.text.TextPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class TextWindow
extends Frame
implements ActionListener,
FocusListener {
    private TextPanel textPanel;

    public TextWindow(String title, String data, int width, int height) {
        this(title, "", data, width, height);
    }

    public TextWindow(String title, String headings, String data, int width, int height) {
        super(title);
        Image img;
        this.enableEvents(64L);
        this.textPanel = new TextPanel(title);
        this.textPanel.setTitle(title);
        this.add("Center", this.textPanel);
        this.textPanel.setColumnHeadings(headings);
        this.textPanel.append(data);
        ImageJ ij = IJ.getInstance();
        if (ij != null && (img = ij.getIconImage()) != null) {
            this.setIconImage(img);
        }
        this.addFocusListener(this);
        this.addMenuBar();
        WindowManager.addWindow(this);
        ((Component)this).setSize(width, height);
        GUI.center(this);
        this.show();
    }

    public TextWindow(String path, int width, int height) {
        super("");
        this.enableEvents(64L);
        this.textPanel = new TextPanel();
        this.add("Center", this.textPanel);
        if (this.openFile(path)) {
            WindowManager.addWindow(this);
            ((Component)this).setSize(width, height);
            this.show();
        } else {
            this.dispose();
        }
    }

    void addMenuBar() {
        MenuBar mb = new MenuBar();
        Menu m = new Menu("File");
        m.add(new MenuItem("Save As..."));
        m.addActionListener(this);
        mb.add(m);
        m = new Menu("Edit");
        m.add(new MenuItem("Cut"));
        m.add(new MenuItem("Copy"));
        m.add(new MenuItem("Copy All"));
        m.add(new MenuItem("Clear"));
        m.add(new MenuItem("Select All"));
        if (this.getTitle().equals("Results")) {
            m.addSeparator();
            m.add(new MenuItem("Clear Results"));
            m.add(new MenuItem("Summarize"));
            m.add(new MenuItem("Set Measurements..."));
        }
        m.addActionListener(this);
        mb.add(m);
        this.setMenuBar(mb);
    }

    public void append(String text) {
        this.textPanel.append(text);
    }

    public void setFont(Font font) {
        this.textPanel.setFont(font);
    }

    boolean openFile(String path) {
        OpenDialog od = new OpenDialog("Open Text File...", path);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return false;
        }
        path = directory + name;
        IJ.showStatus("Opening: " + path);
        try {
            BufferedReader r = new BufferedReader(new FileReader(directory + name));
            this.load(r);
            r.close();
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return true;
        }
        this.textPanel.setTitle(name);
        this.setTitle(name);
        IJ.showStatus("");
        return true;
    }

    public TextPanel getTextPanel() {
        return this.textPanel;
    }

    public void load(BufferedReader in) throws IOException {
        String s;
        boolean count = false;
        while ((s = in.readLine()) != null) {
            this.textPanel.appendLine(s);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        this.textPanel.doCommand(cmd);
    }

    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        int id = e.getID();
        if (id == 201) {
            this.close();
        } else if (id == 205) {
            WindowManager.setWindow(this);
        }
    }

    public void close() {
        if (this.getTitle().equals("Results")) {
            if (!Analyzer.resetCounter()) {
                return;
            }
            IJ.setTextPanel(null);
        }
        if (this.getTitle().equals("Log")) {
            IJ.debugMode = false;
            IJ.log("$Closed");
        }
        ((Component)this).setVisible(false);
        this.dispose();
        WindowManager.removeWindow(this);
        this.textPanel.flush();
    }

    public void focusGained(FocusEvent e) {
        WindowManager.setWindow(this);
    }

    public void focusLost(FocusEvent e) {
    }
}

