/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Executer;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.io.Opener;
import ij.macro.Interpreter;
import ij.macro.MacroRunner;
import ij.plugin.MacroInstaller;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageProducer;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ImageJ
extends Frame
implements ActionListener,
MouseListener,
KeyListener,
WindowListener,
ItemListener {
    public static final String VERSION = "1.31r";
    public static Color backgroundColor = new Color(220, 220, 220);
    private static final String IJ_X = "ij.x";
    private static final String IJ_Y = "ij.y";
    private static final String RESULTS_X = "results.x";
    private static final String RESULTS_Y = "results.y";
    private static final String RESULTS_WIDTH = "results.width";
    private static final String RESULTS_HEIGHT = "results.height";
    private Toolbar toolbar;
    private Panel statusBar;
    private ProgressBar progressBar;
    private Label statusLine;
    private boolean firstTime = true;
    private Applet applet;
    private Vector classes = new Vector();
    private boolean exitWhenQuiting;
    private boolean quitting;
    boolean hotkey;

    public ImageJ() {
        this((Applet)null);
    }

    public ImageJ(Applet applet) {
        super("ImageJ");
        int nMacros;
        this.applet = applet;
        String err1 = Prefs.load(this, applet);
        Menus m = new Menus(this, applet);
        String err2 = m.addMenuBar();
        m.installPopupMenu(this);
        this.setLayout(new GridLayout(2, 1));
        this.toolbar = new Toolbar();
        this.toolbar.addKeyListener(this);
        this.add(this.toolbar);
        this.statusBar = new Panel();
        this.statusBar.setLayout(new BorderLayout());
        this.statusBar.setForeground(Color.black);
        this.statusBar.setBackground(backgroundColor);
        this.statusLine = new Label();
        this.statusLine.addKeyListener(this);
        this.statusLine.addMouseListener(this);
        this.statusBar.add("Center", this.statusLine);
        this.progressBar = new ProgressBar(100, 18);
        this.progressBar.addKeyListener(this);
        this.progressBar.addMouseListener(this);
        this.statusBar.add("East", this.progressBar);
        this.statusBar.setSize(this.toolbar.getPreferredSize());
        this.add(this.statusBar);
        IJ.init(this, applet);
        this.addKeyListener(this);
        this.addWindowListener(this);
        Point loc = this.getPreferredLocation();
        Dimension tbSize = this.toolbar.getPreferredSize();
        int ijWidth = tbSize.width + 10;
        int ijHeight = 100;
        this.setCursor(Cursor.getDefaultCursor());
        this.setIcon();
        ((Component)this).setBounds(loc.x, loc.y, ijWidth, ijHeight);
        ((Component)this).setLocation(loc.x, loc.y);
        this.pack();
        this.setResizable(!IJ.isMacintosh() && !IJ.isWindows());
        this.show();
        if (err1 != null) {
            IJ.error(err1);
        }
        if (err2 != null) {
            IJ.error(err2);
        }
        if (IJ.isMacintosh()) {
            IJ.runPlugIn("QuitHandler", "");
        }
        if (IJ.isJava2() && applet == null) {
            IJ.runPlugIn("ij.plugin.DragAndDrop", "");
        }
        String str = (nMacros = m.installMacros()) == 1 ? " macro)" : " macros)";
        IJ.showStatus("Version 1.31r (" + Menus.nPlugins + " commands, " + nMacros + str);
    }

    void showResults() {
        TextWindow resultsWindow = new TextWindow("Results", "", 300, 200);
        TextPanel textPanel = resultsWindow.getTextPanel();
        textPanel.addKeyListener(this);
        IJ.setTextPanel(textPanel);
    }

    void setIcon() {
        URL url = this.getClass().getResource("/microscope.gif");
        if (url == null) {
            return;
        }
        Image img = null;
        try {
            img = this.createImage((ImageProducer)url.getContent());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (img != null) {
            this.setIconImage(img);
        }
    }

    public Point getPreferredLocation() {
        int windowWidth;
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int ijX = Prefs.getInt(IJ_X, -99);
        int ijY = Prefs.getInt(IJ_Y, -99);
        if (ijX != -99 && ijY != -99 && ijX < screenWidth - 75) {
            return new Point(ijX, ijY);
        }
        Dimension tbsize = this.toolbar.getPreferredSize();
        double percent = screenWidth > 832 ? 0.8 : 0.9;
        int windowX = (int)(percent * (double)(screenWidth - (windowWidth = tbsize.width + 10)));
        if (windowX < 10) {
            windowX = 10;
        }
        int windowY = 32;
        return new Point(windowX, windowY);
    }

    void showStatus(String s) {
        this.statusLine.setText(s);
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    void doCommand(String name) {
        new Executer(name, WindowManager.getCurrentImage());
    }

    public void runFilterPlugIn(Object theFilter, String cmd, String arg) {
        IJ.runFilterPlugIn(theFilter, cmd, arg);
    }

    public Object runUserPlugIn(String commandName, String className, String arg, boolean createNewLoader) {
        return IJ.runUserPlugIn(commandName, className, arg, createNewLoader);
    }

    public static String modifiers(int flags) {
        String s = " [ ";
        if (flags == 0) {
            return "";
        }
        if ((flags & 1) != 0) {
            s = s + "Shift ";
        }
        if ((flags & 2) != 0) {
            s = s + "Control ";
        }
        if ((flags & 4) != 0) {
            s = s + "Meta ";
        }
        if ((flags & 8) != 0) {
            s = s + "Alt ";
        }
        s = s + "] ";
        return s;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof MenuItem) {
            MenuItem item = (MenuItem)e.getSource();
            String cmd = e.getActionCommand();
            this.hotkey = false;
            if (cmd != null) {
                this.doCommand(cmd);
            }
            if (IJ.debugMode) {
                IJ.log("actionPerformed: " + e);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        MenuItem item = (MenuItem)e.getSource();
        MenuComponent parent = (MenuComponent)((Object)item.getParent());
        String cmd = e.getItem().toString();
        if ((Menu)parent == Menus.window) {
            WindowManager.activateWindow(cmd, item);
        } else {
            this.doCommand(cmd);
        }
    }

    public void mousePressed(MouseEvent e) {
        Undo.reset();
        IJ.showStatus(IJ.freeMemory());
        if (IJ.debugMode) {
            IJ.log("Windows: " + WindowManager.getWindowCount());
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        Roi roi;
        boolean isStack;
        int keyCode = e.getKeyCode();
        IJ.setKeyDown(keyCode);
        this.hotkey = false;
        if (keyCode == 17 || keyCode == 16) {
            return;
        }
        char keyChar = e.getKeyChar();
        int flags = e.getModifiers();
        if (IJ.debugMode) {
            IJ.log("keyCode=" + keyCode + " (" + KeyEvent.getKeyText(keyCode) + ") keyChar=\"" + keyChar + "\" (" + keyChar + ") " + KeyEvent.getKeyModifiersText(flags));
        }
        boolean shift = (flags & 1) != 0;
        boolean control = (flags & 2) != 0;
        boolean alt = (flags & 8) != 0;
        String c = "";
        ImagePlus imp = WindowManager.getCurrentImage();
        boolean bl = isStack = imp != null && imp.getStackSize() > 1;
        if (imp != null && !control && (keyChar >= ' ' && keyChar <= '\u00ff' || keyChar == '\b' || keyChar == '\n') && (roi = imp.getRoi()) instanceof TextRoi) {
            if (alt) {
                switch (keyChar) {
                    case 'm': 
                    case 'u': {
                        keyChar = '\u00b5';
                        break;
                    }
                    case 'A': {
                        keyChar = '\u00c5';
                        break;
                    }
                }
            }
            ((TextRoi)roi).addChar(keyChar);
            return;
        }
        Hashtable shortcuts = Menus.getShortcuts();
        c = shift ? (String)shortcuts.get(new Integer(keyCode + 200)) : (String)shortcuts.get(new Integer(keyCode));
        if (c == null) {
            switch (keyCode) {
                case 9: {
                    WindowManager.putBehind();
                    return;
                }
                case 8: {
                    c = "Clear";
                    this.hotkey = true;
                    break;
                }
                case 61: 
                case 187: {
                    c = "Start Animation [=]";
                    break;
                }
                case 47: 
                case 191: {
                    c = "Reslice [/]...";
                    break;
                }
                case 44: 
                case 188: {
                    c = "Previous Slice [<]";
                    break;
                }
                case 46: 
                case 190: {
                    c = "Next Slice [>]";
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    Roi roi2 = null;
                    if (imp != null) {
                        roi2 = imp.getRoi();
                    }
                    if (roi2 == null) {
                        return;
                    }
                    if ((flags & 8) != 0) {
                        roi2.nudgeCorner(keyCode);
                    } else {
                        roi2.nudge(keyCode);
                    }
                    return;
                }
                case 27: {
                    if (imp != null) {
                        imp.getWindow().running = false;
                    }
                    Macro.abort();
                    Interpreter.abort();
                    if (Interpreter.getInstance() != null) {
                        IJ.beep();
                    }
                    return;
                }
                case 10: {
                    this.toFront();
                    return;
                }
            }
        }
        if (c != null && !c.equals("")) {
            if (c.equals("Fill")) {
                this.hotkey = true;
            }
            if (c.charAt(0) == '^') {
                MacroInstaller.doShortcut(c);
            } else {
                this.doCommand(c);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        IJ.setKeyUp(e.getKeyCode());
    }

    public void keyTyped(KeyEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        boolean quit = true;
        if (Menus.window.getItemCount() > 5) {
            GenericDialog gd = new GenericDialog("ImageJ", this);
            gd.addMessage("Are you sure you want to quit ImageJ?");
            gd.showDialog();
            boolean bl = quit = !gd.wasCanceled();
        }
        if (quit) {
            this.doCommand("Quit");
        }
    }

    public void windowActivated(WindowEvent e) {
        if (IJ.isMacintosh()) {
            IJ.wait(1);
            this.setMenuBar(Menus.getMenuBar());
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void register(Class c) {
        if (!this.classes.contains(c)) {
            this.classes.addElement(c);
        }
    }

    public void quit() {
        this.quitting = true;
        if (!WindowManager.closeAllWindows()) {
            this.quitting = false;
            return;
        }
        if (this.applet == null) {
            Prefs.savePreferences();
        }
        ((Component)this).setVisible(false);
        this.dispose();
        if (this.exitWhenQuiting) {
            System.exit(0);
        }
    }

    public boolean quitting() {
        return this.quitting;
    }

    public void savePreferences(Properties prefs) {
        Point loc = this.getLocation();
        ((Hashtable)prefs).put(IJ_X, Integer.toString(loc.x));
        ((Hashtable)prefs).put(IJ_Y, Integer.toString(loc.y));
    }

    public static void main(String[] args) {
        ImageJ ij = IJ.getInstance();
        if (ij == null || ij != null && !ij.isShowing()) {
            if (IJ.isMacOSX()) {
                System.setProperty("com.apple.mrj.application.growbox.intrudes", "true");
                ij = new ImageJ(null);
                System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            } else {
                ij = new ImageJ(null);
            }
            ij.exitWhenQuiting = true;
        }
        boolean macroStarted = false;
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i].endsWith(".txt")) {
                    if (macroStarted) {
                        new Opener().open(args[i]);
                    } else {
                        new MacroRunner(new File(args[i]));
                        macroStarted = true;
                    }
                } else {
                    Opener opener = new Opener();
                    ImagePlus imp = opener.openImage(args[i]);
                    if (imp != null) {
                        imp.show();
                    }
                }
                ++i;
            }
        }
    }
}

