/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImageJ;
import ij.Macro;
import ij.Prefs;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.frame.Recorder;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;

public class SaveDialog {
    private String dir;
    private String name;
    private String title;

    public SaveDialog(String title, String defaultName, String extension) {
        String macroOptions = Macro.getOptions();
        this.title = title;
        if (macroOptions != null) {
            String path = Macro.getValue(macroOptions, title, null);
            if (path == null) {
                path = Macro.getValue(macroOptions, "path", null);
            }
            if (path != null) {
                Opener o = new Opener();
                this.dir = o.getDir(path);
                this.name = o.getName(path);
                return;
            }
        }
        if (defaultName != null) {
            int dotIndex = defaultName.lastIndexOf(".");
            defaultName = dotIndex >= 0 ? defaultName.substring(0, dotIndex) + extension : defaultName + extension;
        }
        if (Prefs.useJFileChooser) {
            this.jsave(title, defaultName);
        } else {
            this.save(title, defaultName);
        }
        IJ.showStatus(title + ": " + this.dir + this.name);
    }

    void jsave(String title, String defaultName) {
        int returnVal;
        File f;
        JFileChooser fc = new JFileChooser();
        String defaultDir = OpenDialog.getDefaultDirectory();
        if (defaultDir != null && (f = new File(defaultDir)) != null) {
            fc.setCurrentDirectory(f);
        }
        if (defaultName != null) {
            fc.setSelectedFile(new File(defaultName));
        }
        if ((returnVal = fc.showSaveDialog(IJ.getInstance())) != 0) {
            Macro.abort();
            return;
        }
        this.dir = fc.getCurrentDirectory().getPath() + File.separator;
        this.name = fc.getName(fc.getSelectedFile());
        if (this.dir != null) {
            OpenDialog.setDefaultDirectory(this.dir);
        }
    }

    void save(String title, String defaultName) {
        String defaultDir;
        ImageJ ij = IJ.getInstance();
        Frame parent = ij != null ? ij : new Frame();
        FileDialog fd = new FileDialog(parent, title, 1);
        if (defaultName != null) {
            fd.setFile(defaultName);
        }
        if ((defaultDir = OpenDialog.getDefaultDirectory()) != null) {
            fd.setDirectory(defaultDir);
        }
        fd.show();
        this.name = fd.getFile();
        this.dir = fd.getDirectory();
        if (this.name == null) {
            Macro.abort();
        }
        if (this.name != null && this.dir != null) {
            OpenDialog.setDefaultDirectory(this.dir);
        }
        fd.dispose();
        if (ij == null) {
            parent.dispose();
        }
    }

    public String getDirectory() {
        return this.dir;
    }

    public String getFileName() {
        if (Recorder.record) {
            Recorder.recordPath(this.title, this.dir + this.name);
        }
        return this.name;
    }
}

