/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.EllipseFitter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Frame;
import java.awt.Rectangle;

public class Selection
implements PlugIn {
    ImagePlus imp;
    float[] kernel = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    float[] kernel3 = new float[]{1.0f, 1.0f, 1.0f};

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (arg.equals("all")) {
            this.imp.setRoi(0, 0, this.imp.getWidth(), this.imp.getHeight());
        } else if (arg.equals("none")) {
            this.imp.killRoi();
        } else if (arg.equals("restore")) {
            this.imp.restoreRoi();
        } else if (arg.equals("spline")) {
            this.fitSpline();
        } else if (arg.equals("ellipse")) {
            this.drawEllipse(this.imp);
        } else if (arg.equals("hull")) {
            this.convexHull(this.imp);
        } else if (arg.equals("mask")) {
            this.createMask(this.imp);
        }
    }

    void fitSpline() {
        double mag;
        boolean segmentedSelection;
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            IJ.showMessage("Spline", "Selection required");
            return;
        }
        int type = roi.getType();
        boolean bl = segmentedSelection = type == 2 || type == 6;
        if (!segmentedSelection && type != 3 && type != 4 && type != 7) {
            IJ.showMessage("Spline", "Polygon or polyline selection required");
            return;
        }
        PolygonRoi p = (PolygonRoi)roi;
        double length = this.getLength(p);
        if (!segmentedSelection) {
            p = this.trimPolygon(p, length);
        }
        int evaluationPoints = (int)(length / 2.0);
        ImageWindow win = this.imp.getWindow();
        if (win != null && (mag = win.getCanvas().getMagnification()) < 1.0) {
            evaluationPoints = (int)((double)evaluationPoints * mag);
        }
        if (evaluationPoints < 100) {
            evaluationPoints = 100;
        }
        p.fitSpline(evaluationPoints);
        this.imp.draw();
    }

    double getLength(PolygonRoi roi) {
        Calibration cal = this.imp.getCalibration();
        double spw = cal.pixelWidth;
        double sph = cal.pixelHeight;
        cal.pixelWidth = 1.0;
        cal.pixelHeight = 1.0;
        double length = roi.getLength();
        cal.pixelWidth = spw;
        cal.pixelHeight = sph;
        return length;
    }

    PolygonRoi trimPolygon(PolygonRoi roi, double length) {
        int type;
        int[] x = roi.getXCoordinates();
        int[] y = roi.getYCoordinates();
        int n = roi.getNCoordinates();
        float[] curvature = this.getCurvature(x, y, n);
        Rectangle r = roi.getBoundingRect();
        double threshold = this.rodbard(length);
        double distance = Math.sqrt((x[1] - x[0]) * (x[1] - x[0]) + (y[1] - y[0]) * (y[1] - y[0]));
        x[0] = x[0] + r.x;
        y[0] = y[0] + r.y;
        int i2 = 1;
        int x2 = 0;
        int y2 = 0;
        int i = 1;
        while (i < n - 1) {
            int x1 = x[i];
            int y1 = y[i];
            x2 = x[i + 1];
            y2 = y[i + 1];
            distance += Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) + 1.0;
            if ((distance += (double)(curvature[i] * 2.0f)) >= threshold) {
                x[i2] = x2 + r.x;
                y[i2] = y2 + r.y;
                ++i2;
                distance = 0.0;
            }
            ++i;
        }
        int n2 = type = roi.getType() == 7 ? 6 : 2;
        if (type == 6 && distance > 0.0) {
            x[i2] = x2 + r.x;
            y[i2] = y2 + r.y;
            ++i2;
        }
        PolygonRoi p = new PolygonRoi(x, y, i2, type);
        this.imp.setRoi(p);
        return p;
    }

    double rodbard(double x) {
        double ex = x == 0.0 ? 5.0 : Math.exp(Math.log(x / 700.0) * 0.88);
        double y = -40.1;
        return (y /= 1.0 + ex) + 44.0;
    }

    float[] getCurvature(int[] x, int[] y, int n) {
        float[] x2 = new float[n];
        float[] y2 = new float[n];
        int i = 0;
        while (i < n) {
            x2[i] = x[i];
            y2[i] = y[i];
            ++i;
        }
        FloatProcessor ipx = new FloatProcessor(n, 1, x2, null);
        FloatProcessor ipy = new FloatProcessor(n, 1, y2, null);
        ((ImageProcessor)ipx).convolve(this.kernel, this.kernel.length, 1);
        ((ImageProcessor)ipy).convolve(this.kernel, this.kernel.length, 1);
        float[] indexes = new float[n];
        float[] curvature = new float[n];
        int i2 = 0;
        while (i2 < n) {
            indexes[i2] = i2;
            curvature[i2] = (float)Math.sqrt((x2[i2] - (float)x[i2]) * (x2[i2] - (float)x[i2]) + (y2[i2] - (float)y[i2]) * (y2[i2] - (float)y[i2]));
            ++i2;
        }
        return curvature;
    }

    void drawEllipse(ImagePlus imp) {
        IJ.showStatus("Fitting ellipse");
        Roi roi = imp.getRoi();
        ImageProcessor ip = imp.getProcessor();
        ImageStatistics stats = imp.getStatistics();
        EllipseFitter ef = new EllipseFitter();
        ef.fit(ip, stats);
        ef.makeRoi(ip);
        imp.setRoi(new PolygonRoi(ef.xCoordinates, ef.yCoordinates, ef.nCoordinates, 3));
        IJ.showStatus("");
    }

    void convexHull(ImagePlus imp) {
        int type;
        Roi roi = imp.getRoi();
        int n = type = roi != null ? roi.getType() : -1;
        if (type != 3 && type != 4 && type != 2) {
            IJ.showMessage("Convex Hull", "Polygonal selection required");
            return;
        }
        imp.setRoi(this.makeConvexHull(imp, (PolygonRoi)roi));
    }

    Roi makeConvexHull(ImagePlus imp, PolygonRoi roi) {
        int p2;
        int p1;
        int n = roi.getNCoordinates();
        int[] xCoordinates = roi.getXCoordinates();
        int[] yCoordinates = roi.getYCoordinates();
        Rectangle r = roi.getBoundingRect();
        int xbase = r.x;
        int ybase = r.y;
        int[] xx = new int[n];
        int[] yy = new int[n];
        int n2 = 0;
        int pstart = p1 = this.findFirstPoint(xCoordinates, yCoordinates, n, imp);
        do {
            int x1 = xCoordinates[p1];
            int y1 = yCoordinates[p1];
            p2 = p1 + 1;
            if (p2 == n) {
                p2 = 0;
            }
            int x2 = xCoordinates[p2];
            int y2 = yCoordinates[p2];
            int p3 = p2 + 1;
            if (p3 == n) {
                p3 = 0;
            }
            do {
                int x3;
                int y3;
                int determinate;
                if ((determinate = x1 * (y2 - (y3 = yCoordinates[p3])) - y1 * (x2 - (x3 = xCoordinates[p3])) + (y3 * x2 - y2 * x3)) > 0) {
                    x2 = x3;
                    y2 = y3;
                    p2 = p3;
                }
                if (++p3 != n) continue;
                p3 = 0;
            } while (p3 != p1);
            if (n2 >= n) continue;
            xx[n2] = xbase + x1;
            yy[n2] = ybase + y1;
            ++n2;
        } while ((p1 = p2) != pstart);
        return new PolygonRoi(xx, yy, n2, 2);
    }

    int findFirstPoint(int[] xCoordinates, int[] yCoordinates, int n, ImagePlus imp) {
        int y;
        int smallestY = imp.getHeight();
        int i = 0;
        while (i < n) {
            y = yCoordinates[i];
            if (y < smallestY) {
                smallestY = y;
            }
            ++i;
        }
        int smallestX = imp.getWidth();
        int p1 = 0;
        int i2 = 0;
        while (i2 < n) {
            int x = xCoordinates[i2];
            y = yCoordinates[i2];
            if (y == smallestY && x < smallestX) {
                smallestX = x;
                p1 = i2;
            }
            ++i2;
        }
        return p1;
    }

    void createMask(ImagePlus imp) {
        Roi roi = imp.getRoi();
        if (roi == null || roi.getType() > 4) {
            IJ.showMessage("Create Mask", "Area selection required");
            return;
        }
        ImagePlus maskImp = null;
        Frame frame = WindowManager.getFrame("Mask");
        if (frame != null && frame instanceof ImageWindow) {
            maskImp = ((ImageWindow)frame).getImagePlus();
        }
        if (maskImp == null) {
            ByteProcessor ip = new ByteProcessor(imp.getWidth(), imp.getHeight());
            ip.invertLut();
            maskImp = new ImagePlus("Mask", ip);
            maskImp.show();
        }
        maskImp.setRoi((Roi)roi.clone());
        int[] mask = maskImp.getMask();
        ImageProcessor ip = maskImp.getProcessor();
        ip.setValue(255.0);
        Rectangle r = ip.getRoi();
        if (mask != null && mask.length == r.width * r.height || mask == null) {
            ip.fill(mask);
        }
        maskImp.killRoi();
        maskImp.updateAndDraw();
    }
}

