/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Properties;

public class Printer
implements PlugInFilter {
    private ImagePlus imp;
    private static double scaling = 100.0;
    private static boolean drawBorder;
    private static boolean center;
    private static boolean label;
    private static boolean printSelection;
    private static Properties printPrefs;
    static /* synthetic */ Class class$ij$plugin$filter$Printer;

    public int setup(String arg, ImagePlus imp) {
        if (arg.equals("setup")) {
            this.pageSetup();
            return 4096;
        }
        this.imp = imp;
        IJ.register(class$ij$plugin$filter$Printer == null ? (class$ij$plugin$filter$Printer = Printer.class$("ij.plugin.filter.Printer")) : class$ij$plugin$filter$Printer);
        return 159;
    }

    public void run(ImageProcessor ip) {
        this.print(this.imp);
    }

    void pageSetup() {
        GenericDialog gd = new GenericDialog("Page Setup");
        gd.addNumericField("Scaling (5-500%):", scaling, 0);
        gd.addCheckbox("Draw Border", drawBorder);
        gd.addCheckbox("Center on Page", center);
        gd.addCheckbox("Print Title", label);
        gd.addCheckbox("Selection Only", printSelection);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        scaling = gd.getNextNumber();
        if (scaling < 5.0) {
            scaling = 5.0;
        }
        drawBorder = gd.getNextBoolean();
        center = gd.getNextBoolean();
        label = gd.getNextBoolean();
        printSelection = gd.getNextBoolean();
    }

    void print(ImagePlus imp) {
        ImageWindow win = imp.getWindow();
        if (win == null) {
            return;
        }
        ImageCanvas ic = win.getCanvas();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        PrintJob job = toolkit.getPrintJob(win, imp.getTitle(), printPrefs);
        if (job == null) {
            return;
        }
        imp.startTiming();
        Graphics g = job.getGraphics();
        if (g == null) {
            return;
        }
        Dimension pageSize = job.getPageDimension();
        if (IJ.debugMode) {
            IJ.log("pageSize: " + pageSize);
        }
        double scale = scaling / 100.0;
        int width = imp.getWidth();
        int height = imp.getHeight();
        Roi roi = imp.getRoi();
        boolean crop = false;
        if (printSelection && roi != null && roi.getType() <= 4) {
            Rectangle r = roi.getBoundingRect();
            width = r.width;
            height = r.height;
            crop = true;
        }
        int printWidth = (int)((double)width * scale);
        int printHeight = (int)((double)height * scale);
        int margin = 20;
        int labelHeight = 0;
        int maxWidth = pageSize.width - margin * 2;
        int maxHeight = pageSize.height - (margin + labelHeight) * 2;
        g.setColor(Color.black);
        if (label) {
            labelHeight = 15;
            g.setFont(new Font("SanSerif", 0, 12));
            g.drawString(imp.getTitle(), margin + 5, margin + labelHeight - 3);
        }
        ImageProcessor ip = imp.getProcessor();
        if (crop) {
            ip = ip.crop();
        }
        if (width > maxWidth || height > maxHeight) {
            double hscale = (double)maxWidth / (double)width;
            double vscale = (double)maxHeight / (double)height;
            scale = hscale <= vscale ? hscale : vscale;
            printWidth = (int)((double)width * scale);
            printHeight = (int)((double)height * scale);
            if (System.getProperty("os.name").startsWith("Windows") && System.getProperty("java.version").startsWith("1.3.1")) {
                ip.setInterpolate(true);
                ip = ip.resize(printWidth, printHeight);
            }
        }
        Image img = ip.createImage();
        if (center && width < maxWidth && height < maxHeight) {
            g.translate((pageSize.width - width) / 2, labelHeight + (pageSize.height - height) / 2);
        } else {
            g.translate(margin, margin + labelHeight);
        }
        if (drawBorder) {
            g.drawRect(-1, -1, printWidth + 1, printHeight + 1);
        }
        g.drawImage(img, 0, 0, printWidth, printHeight, null);
        g.dispose();
        job.end();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        center = true;
        printPrefs = new Properties();
    }
}

