/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Undo;
import ij.gui.ImageWindow;
import ij.macro.Interpreter;
import ij.plugin.Converter;
import ij.plugin.frame.Recorder;
import java.awt.CheckboxMenuItem;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuItem;
import java.util.Vector;

public class WindowManager {
    private static Vector imageList = new Vector();
    private static Vector nonImageList = new Vector();
    private static ImageWindow currentWindow;
    private static Frame frontWindow;
    private static ImagePlus tempCurrentImage;

    private WindowManager() {
    }

    public static synchronized void setCurrentWindow(ImageWindow win) {
        ImagePlus imp;
        if (win == null || win.isClosed() || win.getImagePlus() == null) {
            return;
        }
        WindowManager.setWindow(win);
        tempCurrentImage = null;
        if (win == currentWindow || imageList.size() == 0) {
            return;
        }
        if (currentWindow != null && (imp = currentWindow.getImagePlus()) != null && imp.lockSilently()) {
            imp.trimProcessor();
            Image img = imp.getImage();
            if (!Converter.newWindowCreated) {
                imp.saveRoi();
            }
            Converter.newWindowCreated = false;
            imp.unlock();
        }
        Undo.reset();
        currentWindow = win;
        Menus.updateMenus();
    }

    public static ImageWindow getCurrentWindow() {
        return currentWindow;
    }

    static int getCurrentIndex() {
        return imageList.indexOf(currentWindow);
    }

    public static synchronized ImagePlus getCurrentImage() {
        if (tempCurrentImage != null) {
            return tempCurrentImage;
        }
        if (currentWindow != null) {
            return currentWindow.getImagePlus();
        }
        if (frontWindow != null && frontWindow instanceof ImageWindow) {
            return ((ImageWindow)frontWindow).getImagePlus();
        }
        if (imageList.size() > 0) {
            ImageWindow win = (ImageWindow)imageList.elementAt(imageList.size() - 1);
            return win.getImagePlus();
        }
        return null;
    }

    public static int getWindowCount() {
        int count = imageList.size();
        if (count == 0 && tempCurrentImage != null) {
            count = 1;
        }
        return count;
    }

    public static int getImageCount() {
        int count = imageList.size();
        if ((count += Interpreter.getBatchModeImageCount()) == 0 && tempCurrentImage != null) {
            count = 1;
        }
        return count;
    }

    public static Frame getFrontWindow() {
        return frontWindow;
    }

    public static synchronized int[] getIDList() {
        int[] batchModeImages;
        int nBatchImages;
        int nWindows = imageList.size();
        if (nWindows + (nBatchImages = (batchModeImages = Interpreter.getBatchModeImageIDs()).length) == 0) {
            return null;
        }
        int[] list = new int[nWindows + nBatchImages];
        int i = 0;
        while (i < nBatchImages) {
            list[i] = batchModeImages[i];
            ++i;
        }
        int index = 0;
        int i2 = nBatchImages;
        while (i2 < nBatchImages + nWindows) {
            ImageWindow win = (ImageWindow)imageList.elementAt(index++);
            list[i2] = win.getImagePlus().getID();
            ++i2;
        }
        return list;
    }

    public static synchronized ImagePlus getImage(int imageID) {
        ImagePlus imp2;
        if (imageID == 0) {
            return null;
        }
        if (imageID < 0 && (imp2 = Interpreter.getBatchModeImage(imageID)) != null) {
            return imp2;
        }
        int nImages = imageList.size();
        if (nImages == 0) {
            return null;
        }
        if (imageID > 0) {
            if (imageID > nImages) {
                return null;
            }
            ImageWindow win = (ImageWindow)imageList.elementAt(imageID - 1);
            if (win != null) {
                return win.getImagePlus();
            }
            return null;
        }
        ImagePlus imp = null;
        int i = 0;
        while (i < imageList.size()) {
            ImageWindow win = (ImageWindow)imageList.elementAt(i);
            ImagePlus imp22 = win.getImagePlus();
            if (imageID == imp22.getID()) {
                imp = imp22;
                break;
            }
            ++i;
        }
        return imp;
    }

    public static synchronized void addWindow(Frame win) {
        if (win == null) {
            return;
        }
        if (win instanceof ImageWindow) {
            WindowManager.addImageWindow((ImageWindow)win);
        } else {
            Menus.insertWindowMenuItem(win);
            nonImageList.addElement(win);
        }
    }

    private static void addImageWindow(ImageWindow win) {
        imageList.addElement(win);
        Menus.addWindowMenuItem(win.getImagePlus());
        WindowManager.setCurrentWindow(win);
    }

    public static synchronized void removeWindow(Frame win) {
        if (win instanceof ImageWindow) {
            WindowManager.removeImageWindow((ImageWindow)win);
        } else {
            int index = nonImageList.indexOf(win);
            if (index >= 0) {
                Menus.removeWindowMenuItem(index);
                nonImageList.removeElement(win);
            }
        }
        WindowManager.setWindow(null);
    }

    private static void removeImageWindow(ImageWindow win) {
        int index = imageList.indexOf(win);
        if (index == -1) {
            return;
        }
        if (imageList.size() > 1) {
            int newIndex = index - 1;
            if (newIndex < 0) {
                newIndex = imageList.size() - 1;
            }
            WindowManager.setCurrentWindow((ImageWindow)imageList.elementAt(newIndex));
        } else {
            currentWindow = null;
        }
        imageList.removeElementAt(index);
        int nonImageCount = nonImageList.size();
        if (nonImageCount > 0) {
            ++nonImageCount;
        }
        Menus.removeWindowMenuItem(nonImageCount + index);
        Menus.updateMenus();
        Undo.reset();
    }

    public static void setWindow(Frame win) {
        frontWindow = win;
    }

    public static synchronized boolean closeAllWindows() {
        while (imageList.size() > 0) {
            if (!((ImageWindow)imageList.elementAt(0)).close()) {
                return false;
            }
            IJ.wait(100);
        }
        return true;
    }

    public static void putBehind() {
        if (IJ.debugMode) {
            IJ.log("putBehind");
        }
        if (imageList.size() < 1 || currentWindow == null) {
            return;
        }
        int index = imageList.indexOf(currentWindow);
        if (--index < 0) {
            index = imageList.size() - 1;
        }
        ImageWindow win = (ImageWindow)imageList.elementAt(index);
        WindowManager.setCurrentWindow(win);
        win.toFront();
        Menus.updateMenus();
    }

    public static void setTempCurrentImage(ImagePlus imp) {
        tempCurrentImage = imp;
    }

    public static Frame getFrame(String title) {
        int i = 0;
        while (i < nonImageList.size()) {
            Frame frame = (Frame)nonImageList.elementAt(i);
            if (title.equals(frame.getTitle())) {
                return frame;
            }
            ++i;
        }
        int[] wList = WindowManager.getIDList();
        int len = wList != null ? wList.length : 0;
        int i2 = 0;
        while (i2 < len) {
            ImagePlus imp = WindowManager.getImage(wList[i2]);
            if (imp != null && imp.getTitle().equals(title)) {
                return imp.getWindow();
            }
            ++i2;
        }
        return null;
    }

    static synchronized void activateWindow(String menuItemLabel, MenuItem item) {
        int i = 0;
        while (i < nonImageList.size()) {
            Frame win = (Frame)nonImageList.elementAt(i);
            String title = win.getTitle();
            if (menuItemLabel.equals(title)) {
                win.toFront();
                ((CheckboxMenuItem)item).setState(false);
                if (Recorder.record) {
                    Recorder.record("selectWindow", title);
                }
                return;
            }
            ++i;
        }
        int lastSpace = menuItemLabel.lastIndexOf(32);
        if (lastSpace > 0) {
            menuItemLabel = menuItemLabel.substring(0, lastSpace);
        }
        int i2 = 0;
        while (i2 < imageList.size()) {
            ImageWindow win = (ImageWindow)imageList.elementAt(i2);
            String title = win.getImagePlus().getTitle();
            if (menuItemLabel.equals(title)) {
                int start;
                WindowManager.setCurrentWindow(win);
                win.toFront();
                int index = imageList.indexOf(win);
                int n = Menus.window.getItemCount();
                int j = start = 5 + Menus.windowMenuItems2;
                while (j < n) {
                    MenuItem mi = Menus.window.getItem(j);
                    ((CheckboxMenuItem)mi).setState(j - start == index);
                    ++j;
                }
                if (!Recorder.record) break;
                Recorder.record("selectWindow", title);
                break;
            }
            ++i2;
        }
    }

    static void showList() {
        if (IJ.debugMode) {
            int i = 0;
            while (i < imageList.size()) {
                ImageWindow win = (ImageWindow)imageList.elementAt(i);
                ImagePlus imp = win.getImagePlus();
                IJ.log(i + " " + imp.getTitle() + (win == currentWindow ? "*" : ""));
                ++i;
            }
            IJ.log(" ");
        }
    }
}

