/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.gui.PolygonRoi;
import ij.gui.Toolbar;

public class FreehandRoi
extends PolygonRoi {
    public FreehandRoi(int x, int y, ImagePlus imp) {
        super(x, y, imp);
        this.type = Toolbar.getToolId() == 3 ? 3 : 7;
        if (this.nPoints == 2) {
            --this.nPoints;
        }
    }

    protected void grow(int ox, int oy) {
        if (ox < 0) {
            ox = 0;
        }
        if (oy < 0) {
            oy = 0;
        }
        if (ox > this.xMax) {
            ox = this.xMax;
        }
        if (oy > this.yMax) {
            oy = this.yMax;
        }
        if (ox != this.xp[this.nPoints - 1] + this.x || oy != this.yp[this.nPoints - 1] + this.y) {
            this.xp[this.nPoints] = ox - this.x;
            this.yp[this.nPoints] = oy - this.y;
            ++this.nPoints;
            if (this.nPoints == this.xp.length) {
                this.enlargeArrays();
            }
            this.drawLine();
        }
    }

    void drawLine() {
        double mag;
        int x1 = this.xp[this.nPoints - 2] + this.x;
        int y1 = this.yp[this.nPoints - 2] + this.y;
        int x2 = this.xp[this.nPoints - 1] + this.x;
        int y2 = this.yp[this.nPoints - 1] + this.y;
        int xmin = Math.min(x1, x2);
        int xmax = Math.max(x1, x2);
        int ymin = Math.min(y1, y2);
        int ymax = Math.max(y1, y2);
        int margin = 4;
        if (this.ic != null && (mag = this.ic.getMagnification()) < 1.0) {
            margin = (int)((double)margin / mag);
        }
        this.imp.draw(xmin - margin, ymin - margin, xmax - xmin + margin * 2, ymax - ymin + margin * 2);
    }

    protected void handleMouseUp(int screenX, int screenY) {
        if (this.state == 0) {
            this.addOffset();
            this.finishPolygon();
        }
        this.state = 3;
    }
}

