/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Polygon;

public class Line
extends Roi {
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    private int x1R = 0;
    private int y1R = 0;
    private int x2R;
    private int y2R;
    private static int lineWidth = 1;
    private int xHandleOffset;
    private int yHandleOffset;

    public Line(int ox1, int oy1, int ox2, int oy2) {
        this(ox1, oy1, null);
        this.grow(ox2, oy2);
        this.x1 = this.x + this.x1R;
        this.y1 = this.y + this.y1R;
        this.x2 = this.x + this.x2R;
        this.y2 = this.y + this.y2R;
        this.state = 3;
    }

    public Line(int ox, int oy, ImagePlus imp) {
        super(ox, oy, imp);
        this.type = 5;
    }

    public Line(int ox1, int oy1, int ox2, int oy2, ImagePlus imp) {
        this(ox1, oy1, ox2, oy2);
        this.setImage(imp);
    }

    protected void grow(int xend, int yend) {
        if (xend < 0) {
            xend = 0;
        }
        if (yend < 0) {
            yend = 0;
        }
        if (xend > this.xMax) {
            xend = this.xMax;
        }
        if (yend > this.yMax) {
            yend = this.yMax;
        }
        int xstart = this.x + this.x1R;
        int ystart = this.y + this.y1R;
        if (this.constrain) {
            int dy;
            int dx = Math.abs(xend - xstart);
            if (dx >= (dy = Math.abs(yend - ystart))) {
                yend = ystart;
            } else {
                xend = xstart;
            }
        }
        this.x = Math.min(this.x + this.x1R, xend);
        this.y = Math.min(this.y + this.y1R, yend);
        this.x1R = xstart - this.x;
        this.y1R = ystart - this.y;
        this.x2R = xend - this.x;
        this.y2R = yend - this.y;
        this.width = Math.abs(this.x2R - this.x1R);
        this.height = Math.abs(this.y2R - this.y1R);
        if (this.width < 1) {
            this.width = 1;
        }
        if (this.height < 1) {
            this.height = 1;
        }
        this.updateClipRect();
        if (this.imp != null) {
            if (lineWidth == 1) {
                this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            } else {
                this.imp.draw();
            }
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    void move(int xNew, int yNew) {
        this.x += xNew - this.startX;
        this.y += yNew - this.startY;
        this.clipboard = null;
        this.startX = xNew;
        this.startY = yNew;
        if (lineWidth == 1) {
            this.updateClipRect();
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        } else {
            this.imp.draw();
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    protected void moveHandle(int ox, int oy) {
        this.x1 = this.x + this.x1R;
        this.y1 = this.y + this.y1R;
        this.x2 = this.x + this.x2R;
        this.y2 = this.y + this.y2R;
        switch (this.activeHandle) {
            case 0: {
                this.x1 = ox;
                this.y1 = oy;
                break;
            }
            case 1: {
                this.x2 = ox;
                this.y2 = oy;
                break;
            }
            case 2: {
                int dx = ox - (this.x1 + (this.x2 - this.x1) / 2);
                int dy = oy - (this.y1 + (this.y2 - this.y1) / 2);
                this.x1 += dx;
                this.y1 += dy;
                this.x2 += dx;
                this.y2 += dy;
                if (lineWidth <= 1) break;
                this.x1 += this.xHandleOffset;
                this.y1 += this.yHandleOffset;
                this.x2 += this.xHandleOffset;
                this.y2 += this.yHandleOffset;
            }
        }
        if (this.constrain) {
            int dx = Math.abs(this.x1 - this.x2);
            int dy = Math.abs(this.y1 - this.y2);
            if (this.activeHandle == 0) {
                if (dx >= dy) {
                    this.y1 = this.y2;
                } else {
                    this.x1 = this.x2;
                }
            } else if (this.activeHandle == 1) {
                if (dx >= dy) {
                    this.y2 = this.y1;
                } else {
                    this.x2 = this.x1;
                }
            }
        }
        this.x = Math.min(this.x1, this.x2);
        this.y = Math.min(this.y1, this.y2);
        this.x1R = this.x1 - this.x;
        this.y1R = this.y1 - this.y;
        this.x2R = this.x2 - this.x;
        this.y2R = this.y2 - this.y;
        this.width = Math.abs(this.x2R - this.x1R);
        this.height = Math.abs(this.y2R - this.y1R);
        this.updateClipRect();
        if (lineWidth == 1) {
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        } else {
            this.imp.draw();
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    protected void mouseDownInHandle(int handle, int sx, int sy) {
        this.state = 4;
        this.activeHandle = handle;
        if (lineWidth <= 3) {
            this.ic.setCursor(new Cursor(1));
        }
    }

    public void draw(Graphics g) {
        g.setColor(Roi.ROIColor);
        this.x1 = this.x + this.x1R;
        this.y1 = this.y + this.y1R;
        this.x2 = this.x + this.x2R;
        this.y2 = this.y + this.y2R;
        int sx1 = this.ic.screenX(this.x1);
        int sy1 = this.ic.screenY(this.y1);
        int sx2 = this.ic.screenX(this.x2);
        int sy2 = this.ic.screenY(this.y2);
        int sx3 = sx1 + (sx2 - sx1) / 2;
        int sy3 = sy1 + (sy2 - sy1) / 2;
        if (lineWidth == 1) {
            g.drawLine(sx1, sy1, sx2, sy2);
        } else {
            Polygon p = this.getPolygon();
            g.drawLine(this.ic.screenX(p.xpoints[0]), this.ic.screenY(p.ypoints[0]), this.ic.screenX(p.xpoints[1]), this.ic.screenY(p.ypoints[1]));
            g.drawLine(this.ic.screenX(p.xpoints[1]), this.ic.screenY(p.ypoints[1]), this.ic.screenX(p.xpoints[2]), this.ic.screenY(p.ypoints[2]));
            g.drawLine(this.ic.screenX(p.xpoints[2]), this.ic.screenY(p.ypoints[2]), this.ic.screenX(p.xpoints[3]), this.ic.screenY(p.ypoints[3]));
            g.drawLine(this.ic.screenX(p.xpoints[3]), this.ic.screenY(p.ypoints[3]), this.ic.screenX(p.xpoints[0]), this.ic.screenY(p.ypoints[0]));
        }
        if (this.state != 0) {
            int size2 = 2;
            if (this.ic != null) {
                this.mag = this.ic.getMagnification();
            }
            this.drawHandle(g, sx1 - size2, sy1 - size2);
            this.drawHandle(g, sx2 - size2, sy2 - size2);
            this.drawHandle(g, sx3 - size2, sy3 - size2);
        }
        if (this.state != 3) {
            IJ.showStatus(this.imp.getLocationAsString(this.x2, this.y2) + ", angle=" + IJ.d2s(this.getAngle(this.x1, this.y1, this.x2, this.y2)) + ", length=" + IJ.d2s(this.getLength()));
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    public double getLength() {
        Calibration cal = this.imp.getCalibration();
        return Math.sqrt((double)(this.x2 - this.x1) * cal.pixelWidth * (double)(this.x2 - this.x1) * cal.pixelWidth + (double)(this.y2 - this.y1) * cal.pixelHeight * (double)(this.y2 - this.y1) * cal.pixelHeight);
    }

    public double getRawLength() {
        return Math.sqrt((this.x2 - this.x1) * (this.x2 - this.x1) + (this.y2 - this.y1) * (this.y2 - this.y1));
    }

    public double[] getPixels() {
        double[] profile;
        ImageProcessor ip = this.imp.getProcessor();
        if (lineWidth == 1) {
            profile = ip.getLine(this.x1, this.y1, this.x2, this.y2);
        } else {
            int i;
            ImageProcessor ip2 = this.rotateWideLine(ip);
            int width = ip2.getWidth();
            int height = ip2.getHeight();
            profile = new double[width];
            ip2.setInterpolate(false);
            int y = 0;
            while (y < height) {
                double[] aLine = ip2.getLine(0.0, y, width - 1, y);
                i = 0;
                while (i < width) {
                    int n = i;
                    profile[n] = profile[n] + aLine[i];
                    ++i;
                }
                ++y;
            }
            i = 0;
            while (i < width) {
                int n = i++;
                profile[n] = profile[n] / (double)height;
            }
        }
        return profile;
    }

    ImageProcessor rotateWideLine(ImageProcessor ip) {
        int width = (int)Math.round(this.getRawLength());
        int height = lineWidth;
        FloatProcessor ip2 = new FloatProcessor(width, height);
        double angle = Math.atan2(this.y1 - this.y2, this.x2 - this.x1);
        double srcWidth = ip.getWidth();
        double srcHeight = ip.getHeight();
        Polygon p = this.getPolygon();
        int sxbase = p.xpoints[1];
        int sybase = p.ypoints[1];
        int dy = 0;
        while (dy < height) {
            int dx = 0;
            while (dx < width) {
                double r = Math.sqrt(dx * dx + dy * dy);
                double theta = Math.atan2(dy, dx);
                double sx = (double)sxbase + r * Math.cos(theta += angle);
                double sy = (double)sybase - r * Math.sin(theta);
                if (sx > srcWidth || sy > srcHeight || sy < 0.0 || sx < 0.0) {
                    ((ImageProcessor)ip2).putPixelValue(dx, dy, 0.0);
                } else {
                    ((ImageProcessor)ip2).putPixelValue(dx, dy, ip.getInterpolatedPixel(sx, sy));
                }
                ++dx;
            }
            ++dy;
        }
        if (IJ.altKeyDown()) {
            ((ImageProcessor)ip2).resetMinAndMax();
            new ImagePlus("Rotated Line", ip2).show();
        }
        return ip2;
    }

    public Polygon getPolygon() {
        Polygon p = new Polygon();
        if (lineWidth == 1) {
            p.addPoint(this.x1, this.y1);
            p.addPoint(this.x2, this.y2);
        } else {
            double angle = Math.atan2(this.y1 - this.y2, this.x2 - this.x1);
            double width2 = (double)lineWidth / 2.0;
            double p1x = (double)this.x1 + Math.cos(angle + 1.5707963267948966) * width2;
            double p1y = (double)this.y1 - Math.sin(angle + 1.5707963267948966) * width2;
            double p2x = (double)this.x1 + Math.cos(angle - 1.5707963267948966) * width2;
            double p2y = (double)this.y1 - Math.sin(angle - 1.5707963267948966) * width2;
            double p3x = (double)this.x2 + Math.cos(angle - 1.5707963267948966) * width2;
            double p3y = (double)this.y2 - Math.sin(angle - 1.5707963267948966) * width2;
            double p4x = (double)this.x2 + Math.cos(angle + 1.5707963267948966) * width2;
            double p4y = (double)this.y2 - Math.sin(angle + 1.5707963267948966) * width2;
            p.addPoint((int)Math.round(p1x), (int)Math.round(p1y));
            p.addPoint((int)Math.round(p2x), (int)Math.round(p2y));
            p.addPoint((int)Math.round(p3x), (int)Math.round(p3y));
            p.addPoint((int)Math.round(p4x), (int)Math.round(p4y));
        }
        return p;
    }

    public void drawPixels(ImageProcessor ip) {
        ip.setLineWidth(1);
        if (lineWidth == 1) {
            ip.moveTo(this.x1, this.y1);
            ip.lineTo(this.x2, this.y2);
        } else {
            ip.drawPolygon(this.getPolygon());
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int x, int y) {
        if (lineWidth > 1) {
            return this.getPolygon().contains(x, y);
        }
        return false;
    }

    public int isHandle(int sx, int sy) {
        int size = 10;
        if (lineWidth > 1) {
            size += (int)Math.log(lineWidth);
        }
        int halfSize = size / 2;
        int sx1 = this.ic.screenX(this.x + this.x1R) - halfSize;
        int sy1 = this.ic.screenY(this.y + this.y1R) - halfSize;
        int sx2 = this.ic.screenX(this.x + this.x2R) - halfSize;
        int sy2 = this.ic.screenY(this.y + this.y2R) - halfSize;
        int sx3 = sx1 + (sx2 - sx1) / 2 - 1;
        int sy3 = sy1 + (sy2 - sy1) / 2 - 1;
        if (sx >= sx1 && sx <= sx1 + size && sy >= sy1 && sy <= sy1 + size) {
            return 0;
        }
        if (sx >= sx2 && sx <= sx2 + size && sy >= sy2 && sy <= sy2 + size) {
            return 1;
        }
        if (sx >= sx3 && sx <= sx3 + size + 2 && sy >= sy3 && sy <= sy3 + size + 2) {
            return 2;
        }
        return -1;
    }

    public static int getWidth() {
        return lineWidth;
    }

    public static void setWidth(int w) {
        if (w < 1) {
            w = 1;
        }
        if (w > 200) {
            w = 200;
        }
        lineWidth = w;
    }

    public void nudgeCorner(int key) {
        switch (key) {
            case 38: {
                --this.y2R;
                break;
            }
            case 40: {
                ++this.y2R;
                break;
            }
            case 37: {
                --this.x2R;
                break;
            }
            case 39: {
                ++this.x2R;
            }
        }
        this.grow(this.x + this.x2R, this.y + this.y2R);
    }
}

