/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.PointRoi;
import ij.gui.ShapeRoi;
import ij.measure.Calibration;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;

public class Roi
implements Cloneable,
Serializable {
    public static final int CONSTRUCTING = 0;
    public static final int MOVING = 1;
    public static final int RESIZING = 2;
    public static final int NORMAL = 3;
    public static final int MOVING_HANDLE = 4;
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int POLYGON = 2;
    public static final int FREEROI = 3;
    public static final int TRACED_ROI = 4;
    public static final int LINE = 5;
    public static final int POLYLINE = 6;
    public static final int FREELINE = 7;
    public static final int ANGLE = 8;
    public static final int COMPOSITE = 9;
    public static final int POINT = 10;
    public static final int HANDLE_SIZE = 5;
    public static final int NOT_PASTING = -1;
    static final int NO_MODS = 0;
    static final int ADD_TO_ROI = 1;
    static final int SUBTRACT_FROM_ROI = 2;
    int startX;
    int startY;
    int x;
    int y;
    int width;
    int height;
    int activeHandle;
    int state;
    int modState = 0;
    public static Roi previousRoi;
    protected static Color ROIColor;
    protected static int pasteMode;
    protected int type;
    protected int xMax;
    protected int yMax;
    protected ImagePlus imp;
    protected ImageCanvas ic;
    protected int oldX;
    protected int oldY;
    protected int oldWidth;
    protected int oldHeight;
    protected int clipX;
    protected int clipY;
    protected int clipWidth;
    protected int clipHeight;
    protected ImagePlus clipboard;
    protected boolean constrain;
    protected boolean center;
    protected boolean updateFullWindow;
    protected double mag = 1.0;
    protected String name;
    protected ImageProcessor cachedMask;

    public Roi(int x, int y, int width, int height) {
        this.setImage(null);
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        if (width > this.xMax) {
            width = this.xMax;
        }
        if (height > this.yMax) {
            height = this.yMax;
        }
        this.x = x;
        this.y = y;
        this.startX = x;
        this.startY = y;
        this.oldX = x;
        this.oldY = y;
        this.oldWidth = 0;
        this.oldHeight = 0;
        this.width = width;
        this.height = height;
        this.oldWidth = width;
        this.oldHeight = height;
        this.clipX = x;
        this.clipY = y;
        this.clipWidth = width;
        this.clipHeight = height;
        this.state = 3;
        this.type = 0;
        if (this.ic != null) {
            Graphics g = this.ic.getGraphics();
            this.draw(g);
            g.dispose();
        }
    }

    public Roi(Rectangle r) {
        this(r.x, r.y, r.width, r.height);
    }

    public Roi(int x, int y, ImagePlus imp) {
        this.setImage(imp);
        this.setLocation(x, y);
        this.width = 0;
        this.height = 0;
        this.state = 0;
        this.type = 0;
    }

    public Roi(int x, int y, int width, int height, ImagePlus imp) {
        this(x, y, width, height);
        this.setImage(imp);
    }

    public void setLocation(int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x + this.width > this.xMax) {
            x = this.xMax - this.width;
        }
        if (y + this.height > this.yMax) {
            y = this.yMax - this.height;
        }
        this.x = x;
        this.y = y;
        this.startX = x;
        this.startY = y;
        this.oldX = x;
        this.oldY = y;
        this.oldWidth = 0;
        this.oldHeight = 0;
    }

    public void setImage(ImagePlus imp) {
        this.imp = imp;
        this.cachedMask = null;
        if (imp == null) {
            this.ic = null;
            this.clipboard = null;
            this.xMax = 99999;
            this.yMax = 99999;
        } else {
            ImageWindow win = imp.getWindow();
            if (win != null) {
                this.ic = win.getCanvas();
            }
            this.xMax = imp.getWidth();
            this.yMax = imp.getHeight();
        }
    }

    public int getType() {
        return this.type;
    }

    public int getState() {
        return this.state;
    }

    public double getLength() {
        double pw = 1.0;
        double ph = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            pw = cal.pixelWidth;
            ph = cal.pixelHeight;
        }
        return 2.0 * (double)this.width * pw + 2.0 * (double)this.height * ph;
    }

    public double getFeretsDiameter() {
        double pw = 1.0;
        double ph = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            pw = cal.pixelWidth;
            ph = cal.pixelHeight;
        }
        return Math.sqrt((double)(this.width * this.width) * pw * pw + (double)(this.height * this.height) * ph * ph);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle getBoundingRect() {
        return this.getBounds();
    }

    public Polygon getPolygon() {
        int[] xpoints = new int[4];
        int[] ypoints = new int[4];
        xpoints[0] = this.x;
        ypoints[0] = this.y;
        xpoints[1] = this.x + this.width;
        ypoints[1] = this.y;
        xpoints[2] = this.x + this.width;
        ypoints[2] = this.y + this.height;
        xpoints[3] = this.x;
        ypoints[3] = this.y + this.height;
        return new Polygon(xpoints, ypoints, 4);
    }

    public synchronized Object clone() {
        try {
            Roi r = (Roi)super.clone();
            r.setImage(null);
            return r;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    protected void grow(int xNew, int yNew) {
        if (this.clipboard != null) {
            return;
        }
        if (xNew < 0) {
            xNew = 0;
        }
        if (yNew < 0) {
            yNew = 0;
        }
        if (this.constrain) {
            int dx = xNew - this.x;
            int dy = yNew - this.y;
            int d = dx < dy ? dx : dy;
            xNew = this.x + d;
            yNew = this.y + d;
        }
        if (this.center) {
            this.width = Math.abs(xNew - this.startX) * 2;
            this.height = Math.abs(yNew - this.startY) * 2;
            this.x = this.startX - this.width / 2;
            this.y = this.startY - this.height / 2;
        } else {
            this.width = Math.abs(xNew - this.startX);
            this.height = Math.abs(yNew - this.startY);
            this.x = xNew >= this.startX ? this.startX : this.startX - this.width;
            int n = this.y = yNew >= this.startY ? this.startY : this.startY - this.height;
            if (this.x + this.width > this.xMax) {
                this.width = this.xMax - this.x;
            }
            if (this.y + this.height > this.yMax) {
                this.height = this.yMax - this.y;
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    protected void moveHandle(int ox, int oy) {
        if (this.clipboard != null) {
            return;
        }
        if (ox < 0) {
            ox = 0;
        }
        if (oy < 0) {
            oy = 0;
        }
        if (ox > this.xMax) {
            ox = this.xMax;
        }
        if (oy > this.yMax) {
            oy = this.yMax;
        }
        int x1 = this.x;
        int y1 = this.y;
        int x2 = x1 + this.width;
        int y2 = this.y + this.height;
        switch (this.activeHandle) {
            case 0: {
                this.x = ox;
                this.y = oy;
                break;
            }
            case 1: {
                this.y = oy;
                break;
            }
            case 2: {
                x2 = ox;
                this.y = oy;
                break;
            }
            case 3: {
                x2 = ox;
                break;
            }
            case 4: {
                x2 = ox;
                y2 = oy;
                break;
            }
            case 5: {
                y2 = oy;
                break;
            }
            case 6: {
                this.x = ox;
                y2 = oy;
                break;
            }
            case 7: {
                this.x = ox;
            }
        }
        if (this.x < x2) {
            this.width = x2 - this.x;
        } else {
            this.width = 1;
            this.x = x2;
        }
        if (this.y < y2) {
            this.height = y2 - this.y;
        } else {
            this.height = 1;
            this.y = y2;
        }
        if (this.constrain) {
            this.height = this.width;
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    void move(int xNew, int yNew) {
        this.x += xNew - this.startX;
        this.y += yNew - this.startY;
        if (this.clipboard == null) {
            if (this.x < 0) {
                this.x = 0;
            }
            if (this.y < 0) {
                this.y = 0;
            }
            if (this.x + this.width > this.xMax) {
                this.x = this.xMax - this.width;
            }
            if (this.y + this.height > this.yMax) {
                this.y = this.yMax - this.height;
            }
        }
        this.startX = xNew;
        this.startY = yNew;
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    public void nudge(int key) {
        switch (key) {
            case 38: {
                --this.y;
                if (this.y >= 0 || this.type == 0 && this.clipboard != null) break;
                this.y = 0;
                break;
            }
            case 40: {
                ++this.y;
                if (this.y + this.height < this.yMax || this.type == 0 && this.clipboard != null) break;
                this.y = this.yMax - this.height;
                break;
            }
            case 37: {
                --this.x;
                if (this.x >= 0 || this.type == 0 && this.clipboard != null) break;
                this.x = 0;
                break;
            }
            case 39: {
                ++this.x;
                if (this.x + this.width < this.xMax || this.type == 0 && this.clipboard != null) break;
                this.x = this.xMax - this.width;
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.showStatus();
    }

    public void nudgeCorner(int key) {
        if (this.type > 1 || this.clipboard != null) {
            return;
        }
        switch (key) {
            case 38: {
                --this.height;
                if (this.height >= 1) break;
                this.height = 1;
                break;
            }
            case 40: {
                ++this.height;
                if (this.y + this.height <= this.yMax) break;
                this.height = this.yMax - this.y;
                break;
            }
            case 37: {
                --this.width;
                if (this.width >= 1) break;
                this.width = 1;
                break;
            }
            case 39: {
                ++this.width;
                if (this.x + this.width <= this.xMax) break;
                this.width = this.xMax - this.x;
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.cachedMask = null;
        this.showStatus();
    }

    protected void updateClipRect() {
        double mag;
        this.clipX = this.x <= this.oldX ? this.x : this.oldX;
        this.clipY = this.y <= this.oldY ? this.y : this.oldY;
        this.clipWidth = (this.x + this.width >= this.oldX + this.oldWidth ? this.x + this.width : this.oldX + this.oldWidth) - this.clipX + 1;
        this.clipHeight = (this.y + this.height >= this.oldY + this.oldHeight ? this.y + this.height : this.oldY + this.oldHeight) - this.clipY + 1;
        int m = 3;
        if (this.ic != null && (mag = this.ic.getMagnification()) < 1.0) {
            m = (int)(3.0 / mag);
        }
        this.clipX -= m;
        this.clipY -= m;
        this.clipWidth += m * 2;
        this.clipHeight += m * 2;
    }

    protected void handleMouseDrag(int sx, int sy, int flags) {
        if (this.ic == null) {
            return;
        }
        this.constrain = (flags & 1) != 0;
        this.center = (flags & 2) != 0 || IJ.isMacintosh() && (flags & 4) != 0;
        int ox = this.ic.offScreenX(sx);
        int oy = this.ic.offScreenY(sy);
        switch (this.state) {
            case 0: {
                this.grow(ox, oy);
                break;
            }
            case 1: {
                this.move(ox, oy);
                break;
            }
            case 4: {
                this.moveHandle(ox, oy);
                break;
            }
        }
    }

    int getHandleSize() {
        double mag = this.ic != null ? this.ic.getMagnification() : 1.0;
        double size = 5.0 / mag;
        return (int)(size * mag);
    }

    public void draw(Graphics g) {
        if (this.ic == null) {
            return;
        }
        g.setColor(ROIColor);
        this.mag = this.ic.getMagnification();
        int sw = (int)((double)this.width * this.mag);
        int sh = (int)((double)this.height * this.mag);
        int sx1 = this.ic.screenX(this.x);
        int sy1 = this.ic.screenY(this.y);
        int sx2 = sx1 + sw / 2;
        int sy2 = sy1 + sh / 2;
        int sx3 = sx1 + sw;
        int sy3 = sy1 + sh;
        g.drawRect(sx1, sy1, sw, sh);
        if (this.state != 0 && this.clipboard == null) {
            int size2 = 2;
            this.drawHandle(g, sx1 - size2, sy1 - size2);
            this.drawHandle(g, sx2 - size2, sy1 - size2);
            this.drawHandle(g, sx3 - size2, sy1 - size2);
            this.drawHandle(g, sx3 - size2, sy2 - size2);
            this.drawHandle(g, sx3 - size2, sy3 - size2);
            this.drawHandle(g, sx2 - size2, sy3 - size2);
            this.drawHandle(g, sx1 - size2, sy3 - size2);
            this.drawHandle(g, sx1 - size2, sy2 - size2);
        }
        this.drawPreviousRoi(g);
        if (this.state != 3) {
            this.showStatus();
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    void drawPreviousRoi(Graphics g) {
        if (previousRoi != null && previousRoi != this && Roi.previousRoi.modState != 0) {
            if (this.type != 10 && previousRoi.getType() == 10 && Roi.previousRoi.modState != 2) {
                return;
            }
            previousRoi.setImage(this.imp);
            previousRoi.draw(g);
        }
    }

    void drawHandle(Graphics g, int x, int y) {
        double size = (double)(this.width * this.height) * this.mag;
        if (this.type == 5) {
            size = Math.sqrt(this.width * this.width + this.height * this.height);
            size *= size * this.mag;
        }
        if (size > 6000.0) {
            g.setColor(Color.black);
            g.fillRect(x, y, 5, 5);
            g.setColor(Color.white);
            g.fillRect(x + 1, y + 1, 3, 3);
        } else if (size > 1500.0) {
            g.setColor(Color.black);
            g.fillRect(x + 1, y + 1, 4, 4);
            g.setColor(Color.white);
            g.fillRect(x + 2, y + 2, 2, 2);
        } else {
            g.setColor(Color.black);
            g.fillRect(x + 1, y + 1, 3, 3);
            g.setColor(Color.white);
            g.fillRect(x + 2, y + 2, 1, 1);
        }
    }

    public void drawPixels() {
        if (this.imp != null) {
            this.drawPixels(this.imp.getProcessor());
        }
    }

    public void drawPixels(ImageProcessor ip) {
        this.endPaste();
        ip.drawRect(this.x, this.y, this.width, this.height);
        if (Line.getWidth() > 1) {
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int x, int y) {
        Rectangle r = new Rectangle(this.x, this.y, this.width, this.height);
        return r.contains(x, y);
    }

    public int isHandle(int sx, int sy) {
        if (this.clipboard != null) {
            return -1;
        }
        double mag = this.ic.getMagnification();
        int size = 8;
        int halfSize = size / 2;
        int sx1 = this.ic.screenX(this.x) - halfSize;
        int sy1 = this.ic.screenY(this.y) - halfSize;
        int sx3 = this.ic.screenX(this.x + this.width) - halfSize;
        int sy3 = this.ic.screenY(this.y + this.height) - halfSize;
        int sx2 = sx1 + (sx3 - sx1) / 2;
        int sy2 = sy1 + (sy3 - sy1) / 2;
        if (sx >= sx1 && sx <= sx1 + size && sy >= sy1 && sy <= sy1 + size) {
            return 0;
        }
        if (sx >= sx2 && sx <= sx2 + size && sy >= sy1 && sy <= sy1 + size) {
            return 1;
        }
        if (sx >= sx3 && sx <= sx3 + size && sy >= sy1 && sy <= sy1 + size) {
            return 2;
        }
        if (sx >= sx3 && sx <= sx3 + size && sy >= sy2 && sy <= sy2 + size) {
            return 3;
        }
        if (sx >= sx3 && sx <= sx3 + size && sy >= sy3 && sy <= sy3 + size) {
            return 4;
        }
        if (sx >= sx2 && sx <= sx2 + size && sy >= sy3 && sy <= sy3 + size) {
            return 5;
        }
        if (sx >= sx1 && sx <= sx1 + size && sy >= sy3 && sy <= sy3 + size) {
            return 6;
        }
        if (sx >= sx1 && sx <= sx1 + size && sy >= sy2 && sy <= sy2 + size) {
            return 7;
        }
        return -1;
    }

    protected void mouseDownInHandle(int handle, int sx, int sy) {
        this.state = 4;
        this.activeHandle = handle;
    }

    protected void handleMouseDown(int sx, int sy) {
        if (this.state == 3) {
            this.state = 1;
            this.startX = this.ic.offScreenX(sx);
            this.startY = this.ic.offScreenY(sy);
            this.showStatus();
        }
    }

    protected void handleMouseUp(int screenX, int screenY) {
        this.state = 3;
        this.imp.draw(this.clipX - 5, this.clipY - 5, this.clipWidth + 10, this.clipHeight + 10);
        if (Recorder.record) {
            if (this.type == 5) {
                if (this.imp == null) {
                    return;
                }
                Line line = (Line)this.imp.getRoi();
                Recorder.record("makeLine", line.x1, line.y1, line.x2, line.y2);
            } else if (this.type == 1) {
                Recorder.record("makeOval", this.x, this.y, this.width, this.height);
            } else {
                Recorder.record("makeRectangle", this.x, this.y, this.width, this.height);
            }
        }
        this.modifyRoi();
    }

    void modifyRoi() {
        if (previousRoi == null || Roi.previousRoi.modState == 0) {
            return;
        }
        if (this.type == 10 || previousRoi.getType() == 10) {
            if (this.type == 10 && previousRoi.getType() == 10) {
                this.addPoint();
            } else if (this.isArea() && previousRoi.getType() == 10 && Roi.previousRoi.modState == 2) {
                this.subtractPoints();
            }
            return;
        }
        ShapeRoi s1 = null;
        ShapeRoi s2 = null;
        s1 = previousRoi instanceof ShapeRoi ? (ShapeRoi)previousRoi : new ShapeRoi(previousRoi);
        s2 = this instanceof ShapeRoi ? (ShapeRoi)this : new ShapeRoi(this);
        if (Roi.previousRoi.modState == 1) {
            s1.or(s2);
        } else {
            s1.not(s2);
        }
        Roi.previousRoi.modState = 0;
        Roi[] rois = s1.getRois();
        if (rois.length == 0) {
            return;
        }
        int type2 = rois[0].getType();
        if (rois.length == 1 && (type2 == 2 || type2 == 3)) {
            this.imp.setRoi(rois[0]);
        } else {
            this.imp.setRoi(s1);
        }
    }

    void addPoint() {
        if (this.type != 10 || previousRoi.getType() != 10) {
            this.modState = 0;
            this.imp.draw();
            return;
        }
        Roi.previousRoi.modState = 0;
        PointRoi p1 = (PointRoi)previousRoi;
        Rectangle r = this.getBounds();
        this.imp.setRoi(p1.addPoint(r.x, r.y));
    }

    void subtractPoints() {
        Roi.previousRoi.modState = 0;
        PointRoi p1 = (PointRoi)previousRoi;
        PointRoi p2 = p1.subtractPoints(this);
        if (p2 != null) {
            this.imp.setRoi(p1.subtractPoints(this));
        } else {
            this.imp.killRoi();
        }
    }

    public void addOrSubtract() {
        if (!IJ.isJava2() || previousRoi == null) {
            return;
        }
        Roi.previousRoi.modState = IJ.shiftKeyDown() ? 1 : (IJ.altKeyDown() ? 2 : 0);
        this.modifyRoi();
    }

    protected void showStatus() {
        String value;
        if (this.state != 0 && (this.type == 0 || this.type == 10) && this.width <= 25 && this.height <= 25) {
            ImageProcessor ip = this.imp.getProcessor();
            double v = ip.getPixelValue(this.x, this.y);
            int digits = this.imp.getType() == 0 || this.imp.getType() == 1 ? 0 : 2;
            value = ", value=" + IJ.d2s(v, digits);
        } else {
            value = "";
        }
        Calibration cal = this.imp.getCalibration();
        String size = cal.scaled() && !IJ.altKeyDown() ? ", w=" + IJ.d2s((double)this.width * cal.pixelWidth) + ", h=" + IJ.d2s((double)this.height * cal.pixelHeight) : ", w=" + this.width + ", h=" + this.height;
        IJ.showStatus(this.imp.getLocationAsString(this.x, this.y) + size + value);
    }

    public ImageProcessor getMask() {
        return null;
    }

    public void startPaste(ImagePlus clipboard) {
        IJ.showStatus("Pasting...");
        this.clipboard = clipboard;
        this.imp.getProcessor().snapshot();
        this.updateClipRect();
        if (IJ.debugMode) {
            IJ.log("startPaste: " + this.clipX + " " + this.clipY + " " + this.clipWidth + " " + this.clipHeight);
        }
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
    }

    void updatePaste() {
        if (this.clipboard != null) {
            this.imp.getMask();
            ImageProcessor ip = this.imp.getProcessor();
            ip.reset();
            ip.copyBits(this.clipboard.getProcessor(), this.x, this.y, pasteMode);
            if (this.type != 0) {
                ip.reset(ip.getMask());
            }
            this.ic.setImageUpdated();
        }
    }

    public void endPaste() {
        if (this.clipboard != null) {
            this.imp.getMask();
            ImageProcessor ip = this.imp.getProcessor();
            if (pasteMode != 0) {
                ip.reset();
            }
            ip.copyBits(this.clipboard.getProcessor(), this.x, this.y, pasteMode);
            if (this.type != 0) {
                ip.reset(ip.getMask());
            }
            ip.snapshot();
            this.clipboard = null;
            this.imp.updateAndDraw();
            Undo.setup(1, this.imp);
        }
    }

    public void abortPaste() {
        this.clipboard = null;
        this.imp.getProcessor().reset();
        this.imp.updateAndDraw();
    }

    public double getAngle(int x1, int y1, int x2, int y2) {
        boolean q1 = false;
        int q2orq3 = 2;
        int q4 = 3;
        double dx = x2 - x1;
        double dy = y1 - y2;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            dx *= cal.pixelWidth;
            dy *= cal.pixelHeight;
        }
        double angle = dx != 0.0 ? Math.atan(dy / dx) : (dy >= 0.0 ? 1.5707963267948966 : -1.5707963267948966);
        angle = 57.29577951308232 * angle;
        int quadrant = dx >= 0.0 && dy >= 0.0 ? 0 : (dx < 0.0 ? 2 : 3);
        switch (quadrant) {
            case 0: {
                break;
            }
            case 2: {
                angle += 180.0;
                break;
            }
            case 3: {
                angle += 360.0;
            }
        }
        return angle;
    }

    public static Color getColor() {
        return ROIColor;
    }

    public static void setColor(Color c) {
        ROIColor = c;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static void setPasteMode(int transferMode) {
        int previousMode = pasteMode;
        pasteMode = transferMode;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        if (previousMode != 0) {
            ImageProcessor ip = imp.getProcessor();
            ip.reset();
            if (pasteMode != 0) {
                // empty if block
            }
        }
        imp.updateAndDraw();
    }

    public int getPasteMode() {
        if (this.clipboard == null) {
            return -1;
        }
        return pasteMode;
    }

    public static int getCurrentPasteMode() {
        return pasteMode;
    }

    public boolean isArea() {
        return this.type >= 0 && this.type <= 4 || this.type == 9;
    }

    public boolean isLine() {
        return this.type >= 5 && this.type <= 7;
    }

    public String getTypeAsString() {
        String s = "";
        switch (this.type) {
            case 2: {
                s = "Polygon";
                break;
            }
            case 3: {
                s = "Freehand";
                break;
            }
            case 4: {
                s = "Traced";
                break;
            }
            case 6: {
                s = "Polyline";
                break;
            }
            case 7: {
                s = "Freeline";
                break;
            }
            case 8: {
                s = "Angle";
                break;
            }
            case 5: {
                s = "Straight Line";
                break;
            }
            case 1: {
                s = "Oval";
                break;
            }
            case 9: {
                s = "Composite";
                break;
            }
            case 10: {
                s = "Point";
                break;
            }
            default: {
                s = "Rectangle";
            }
        }
        return s;
    }

    public String toString() {
        return "Roi[" + this.getTypeAsString() + ", x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }

    static {
        ROIColor = Prefs.getColor("roicolor", Color.yellow);
        pasteMode = 0;
    }
}

