/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.io.FileInfo;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageReader {
    private FileInfo fi;
    private int width;
    private int height;
    private long skipCount;
    private int bytesPerPixel;
    private int bufferSize;
    private int byteCount;
    private int nPixels;
    private boolean showProgressBar = true;
    private int eofErrorCount;

    public ImageReader(FileInfo fi) {
        this.fi = fi;
        this.width = fi.width;
        this.height = fi.height;
        this.skipCount = fi.longOffset > 0L ? fi.longOffset : (long)fi.offset;
    }

    void eofError() {
        ++this.eofErrorCount;
    }

    byte[] read8bitImage(InputStream in) throws IOException {
        int totalRead = 0;
        byte[] pixels = new byte[this.nPixels];
        while (totalRead < this.byteCount) {
            int count = totalRead + this.bufferSize > this.byteCount ? this.byteCount - totalRead : this.bufferSize;
            int actuallyRead = in.read(pixels, totalRead, count);
            if (actuallyRead == -1) {
                this.eofError();
                break;
            }
            this.showProgress((double)(totalRead += actuallyRead) / (double)this.byteCount);
        }
        return pixels;
    }

    private void showProgress(double progress) {
        if (this.showProgressBar) {
            IJ.showProgress(progress);
        }
    }

    short[] read16bitImage(InputStream in) throws IOException {
        byte[] buffer = new byte[this.bufferSize];
        short[] pixels = new short[this.nPixels];
        int totalRead = 0;
        int base = 0;
        while (totalRead < this.byteCount) {
            int j;
            int i;
            int j2;
            int i2;
            if (totalRead + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - totalRead;
            }
            int bufferCount = 0;
            while (bufferCount < this.bufferSize) {
                int count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count == -1) {
                    this.eofError();
                    if (this.fi.fileType == 1) {
                        i2 = base;
                        while (i2 < pixels.length) {
                            pixels[i2] = Short.MIN_VALUE;
                            ++i2;
                        }
                    }
                    return pixels;
                }
                bufferCount += count;
            }
            this.showProgress((double)(totalRead += this.bufferSize) / (double)this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            if (this.fi.intelByteOrder) {
                if (this.fi.fileType == 1) {
                    i2 = base;
                    j2 = 0;
                    while (i2 < base + pixelsRead) {
                        pixels[i2] = (short)(((buffer[j2 + 1] & 0xFF) << 8 | buffer[j2] & 0xFF) + 32768);
                        ++i2;
                        j2 += 2;
                    }
                } else {
                    i = base;
                    j = 0;
                    while (i < base + pixelsRead) {
                        pixels[i] = (short)((buffer[j + 1] & 0xFF) << 8 | buffer[j] & 0xFF);
                        ++i;
                        j += 2;
                    }
                }
            } else if (this.fi.fileType == 1) {
                i2 = base;
                j2 = 0;
                while (i2 < base + pixelsRead) {
                    pixels[i2] = (short)(((buffer[j2] & 0xFF) << 8 | buffer[j2 + 1] & 0xFF) + 32768);
                    ++i2;
                    j2 += 2;
                }
            } else {
                i = base;
                j = 0;
                while (i < base + pixelsRead) {
                    pixels[i] = (short)((buffer[j] & 0xFF) << 8 | buffer[j + 1] & 0xFF);
                    ++i;
                    j += 2;
                }
            }
            base += pixelsRead;
        }
        return pixels;
    }

    float[] read32bitImage(InputStream in) throws IOException {
        byte[] buffer = new byte[this.bufferSize];
        float[] pixels = new float[this.nPixels];
        int totalRead = 0;
        int base = 0;
        while (totalRead < this.byteCount) {
            int tmp;
            if (totalRead + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - totalRead;
            }
            int bufferCount = 0;
            while (bufferCount < this.bufferSize) {
                int count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count == -1) {
                    this.eofError();
                    return pixels;
                }
                bufferCount += count;
            }
            this.showProgress((double)(totalRead += this.bufferSize) / (double)this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            int j = 0;
            if (this.fi.intelByteOrder) {
                int i = base;
                while (i < base + pixelsRead) {
                    tmp = (buffer[j + 3] & 0xFF) << 24 | (buffer[j + 2] & 0xFF) << 16 | (buffer[j + 1] & 0xFF) << 8 | buffer[j] & 0xFF;
                    pixels[i] = this.fi.fileType == 4 ? Float.intBitsToFloat(tmp) : (this.fi.fileType == 11 ? (float)((long)tmp & 0xFFFFFFFFL) : (float)tmp);
                    j += 4;
                    ++i;
                }
            } else {
                int i = base;
                while (i < base + pixelsRead) {
                    tmp = (buffer[j] & 0xFF) << 24 | (buffer[j + 1] & 0xFF) << 16 | (buffer[j + 2] & 0xFF) << 8 | buffer[j + 3] & 0xFF;
                    pixels[i] = this.fi.fileType == 4 ? Float.intBitsToFloat(tmp) : (this.fi.fileType == 11 ? (float)((long)tmp & 0xFFFFFFFFL) : (float)tmp);
                    j += 4;
                    ++i;
                }
            }
            base += pixelsRead;
        }
        return pixels;
    }

    int[] readChunkyRGB(InputStream in) throws IOException {
        this.bufferSize = 24 * this.width;
        byte[] buffer = new byte[this.bufferSize];
        int[] pixels = new int[this.nPixels];
        int totalRead = 0;
        int base = 0;
        while (totalRead < this.byteCount) {
            if (totalRead + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - totalRead;
            }
            int bufferCount = 0;
            while (bufferCount < this.bufferSize) {
                int count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count == -1) {
                    this.eofError();
                    return pixels;
                }
                bufferCount += count;
            }
            this.showProgress((double)(totalRead += this.bufferSize) / (double)this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            boolean bgr = this.fi.fileType == 10;
            int j = 0;
            int i = base;
            while (i < base + pixelsRead) {
                if (this.bytesPerPixel == 4) {
                    // empty if block
                }
                int n = ++j;
                int r = buffer[n] & 0xFF;
                int n2 = ++j;
                int g = buffer[n2] & 0xFF;
                int n3 = ++j;
                ++j;
                int b = buffer[n3] & 0xFF;
                pixels[i] = bgr ? 0xFF000000 | b << 16 | g << 8 | r : 0xFF000000 | r << 16 | g << 8 | b;
                ++i;
            }
            base += pixelsRead;
        }
        return pixels;
    }

    int[] readPlanarRGB(InputStream in) throws IOException {
        int planeSize = this.nPixels;
        byte[] buffer = new byte[planeSize];
        int[] pixels = new int[this.nPixels];
        int totalRead = 0;
        this.showProgress(0.12);
        int bytesRead = in.read(buffer, 0, planeSize);
        if (bytesRead == -1) {
            this.eofError();
            return pixels;
        }
        totalRead += bytesRead;
        int i = 0;
        while (i < planeSize) {
            int r = buffer[i] & 0xFF;
            pixels[i] = 0xFF000000 | r << 16;
            ++i;
        }
        this.showProgress(0.37);
        bytesRead = in.read(buffer, 0, planeSize);
        if (bytesRead == -1) {
            this.eofError();
            return pixels;
        }
        totalRead += bytesRead;
        int i2 = 0;
        while (i2 < planeSize) {
            int g = buffer[i2] & 0xFF;
            int n = i2++;
            pixels[n] = pixels[n] | g << 8;
        }
        this.showProgress(0.62);
        bytesRead = in.read(buffer, 0, planeSize);
        if (bytesRead == -1) {
            this.eofError();
            return pixels;
        }
        totalRead += bytesRead;
        int i3 = 0;
        while (i3 < planeSize) {
            int b = buffer[i3] & 0xFF;
            int n = i3++;
            pixels[n] = pixels[n] | b;
        }
        this.showProgress(0.87);
        return pixels;
    }

    Object readRGB48(InputStream in) throws IOException {
        this.bufferSize = 24 * this.width;
        byte[] buffer = new byte[this.bufferSize];
        short[] red = new short[this.nPixels];
        short[] green = new short[this.nPixels];
        short[] blue = new short[this.nPixels];
        int totalRead = 0;
        int base = 0;
        Object[] stack = new Object[]{red, green, blue};
        while (totalRead < this.byteCount) {
            int j;
            int i;
            if (totalRead + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - totalRead;
            }
            int bufferCount = 0;
            while (bufferCount < this.bufferSize) {
                int count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count == -1) {
                    this.eofError();
                    return stack;
                }
                bufferCount += count;
            }
            this.showProgress((double)(totalRead += this.bufferSize) / (double)this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            if (this.fi.intelByteOrder) {
                i = base;
                j = 0;
                while (i < base + pixelsRead) {
                    red[i] = (short)((buffer[j + 1] & 0xFF) << 8 | buffer[j] & 0xFF);
                    green[i] = (short)((buffer[(j += 2) + 1] & 0xFF) << 8 | buffer[j] & 0xFF);
                    blue[i] = (short)((buffer[(j += 2) + 1] & 0xFF) << 8 | buffer[j] & 0xFF);
                    j += 2;
                    ++i;
                }
            } else {
                i = base;
                j = 0;
                while (i < base + pixelsRead) {
                    red[i] = (short)((buffer[j] & 0xFF) << 8 | buffer[j + 1] & 0xFF);
                    green[i] = (short)((buffer[j += 2] & 0xFF) << 8 | buffer[j + 1] & 0xFF);
                    blue[i] = (short)((buffer[j += 2] & 0xFF) << 8 | buffer[j + 1] & 0xFF);
                    j += 2;
                    ++i;
                }
            }
            base += pixelsRead;
        }
        return stack;
    }

    short[] read12bitImage(InputStream in) throws IOException {
        int nBytes = (int)((double)this.nPixels * 1.5);
        if ((this.nPixels & 1) == 1) {
            ++nBytes;
        }
        byte[] buffer = new byte[nBytes];
        short[] pixels = new short[this.nPixels];
        boolean totalRead = false;
        DataInputStream dis = new DataInputStream(in);
        dis.readFully(buffer);
        int i = 0;
        int j = 0;
        int index = 0;
        while (index < buffer.length / 3) {
            pixels[j++] = (short)((buffer[i] & 0xFF) * 16 + (buffer[i + 1] >> 4 & 0xF));
            pixels[j++] = (short)((buffer[i + 1] & 0xF) * 256 + (buffer[i + 2] & 0xFF));
            i += 3;
            ++index;
        }
        return pixels;
    }

    void skip(InputStream in) throws IOException {
        if (this.skipCount > 0L) {
            long bytesRead = 0L;
            int skipAttempts = 0;
            while (bytesRead < this.skipCount) {
                long count = in.skip(this.skipCount - bytesRead);
                if (count == -1L || ++skipAttempts > 5) break;
                bytesRead += count;
            }
        }
        this.byteCount = this.width * this.height * this.bytesPerPixel;
        if (this.fi.fileType == 8) {
            int scan = this.width / 8;
            int pad = this.width % 8;
            if (pad > 0) {
                ++scan;
            }
            this.byteCount = scan * this.height;
        }
        this.nPixels = this.width * this.height;
        this.bufferSize = this.byteCount / 25;
        this.bufferSize = this.bufferSize < 8192 ? 8192 : this.bufferSize / 8192 * 8192;
    }

    public Object readPixels(InputStream in) {
        try {
            switch (this.fi.fileType) {
                case 0: 
                case 5: {
                    this.bytesPerPixel = 1;
                    this.skip(in);
                    return this.read8bitImage(in);
                }
                case 1: 
                case 2: {
                    this.bytesPerPixel = 2;
                    this.skip(in);
                    return this.read16bitImage(in);
                }
                case 3: 
                case 4: 
                case 11: {
                    this.bytesPerPixel = 4;
                    this.skip(in);
                    return this.read32bitImage(in);
                }
                case 6: 
                case 9: 
                case 10: {
                    this.bytesPerPixel = this.fi.fileType == 9 ? 4 : 3;
                    this.skip(in);
                    return this.readChunkyRGB(in);
                }
                case 7: {
                    this.bytesPerPixel = 3;
                    this.skip(in);
                    return this.readPlanarRGB(in);
                }
                case 8: {
                    this.bytesPerPixel = 1;
                    this.skip(in);
                    byte[] bitmap = this.read8bitImage(in);
                    this.expandBitmap(bitmap);
                    return bitmap;
                }
                case 12: {
                    this.bytesPerPixel = 6;
                    this.skip(in);
                    return this.readRGB48(in);
                }
                case 13: {
                    this.skip(in);
                    short[] data = this.read12bitImage(in);
                    return data;
                }
            }
            return null;
        }
        catch (IOException e) {
            IJ.write("" + e);
            return null;
        }
    }

    public Object readPixels(InputStream in, long skipCount) {
        this.skipCount = skipCount;
        this.showProgressBar = false;
        Object pixels = this.readPixels(in);
        if (this.eofErrorCount > 0) {
            return null;
        }
        return pixels;
    }

    public Object readPixels(String url) {
        InputStream is;
        URL theURL;
        try {
            theURL = new URL(url);
        }
        catch (MalformedURLException e) {
            IJ.write("" + e);
            return null;
        }
        try {
            is = theURL.openStream();
        }
        catch (IOException e) {
            IJ.write("" + e);
            return null;
        }
        return this.readPixels(is);
    }

    void expandBitmap(byte[] pixels) {
        int scan = this.width / 8;
        int pad = this.width % 8;
        if (pad > 0) {
            ++scan;
        }
        int len = scan * this.height;
        byte[] bitmap = new byte[len];
        System.arraycopy(pixels, 0, bitmap, 0, len);
        int y = 0;
        while (y < this.height) {
            int offset = y * scan;
            int index = y * this.width;
            int x = 0;
            while (x < scan) {
                int value1 = bitmap[offset + x] & 0xFF;
                int i = 7;
                while (i >= 0) {
                    int value2;
                    int n = value2 = (value1 & 1 << i) != 0 ? 255 : 0;
                    if (index < pixels.length) {
                        pixels[index++] = (byte)value2;
                    }
                    --i;
                }
                ++x;
            }
            ++y;
        }
    }
}

