/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.io.File;
import java.util.Hashtable;
import java.util.Properties;

public class ImportDialog {
    private String fileName;
    private String directory;
    static final String TYPE = "raw.type";
    static final String WIDTH = "raw.width";
    static final String HEIGHT = "raw.height";
    static final String OFFSET = "raw.offset";
    static final String N = "raw.n";
    static final String GAP = "raw.gap";
    static final String OPTIONS = "raw.options";
    static final int WHITE_IS_ZERO = 1;
    static final int INTEL_BYTE_ORDER = 2;
    static final int OPEN_ALL = 4;
    private static int choiceSelection = Prefs.getInt("raw.type", 0);
    private static int width = Prefs.getInt("raw.width", 512);
    private static int height = Prefs.getInt("raw.height", 512);
    private static long offset = Prefs.getInt("raw.offset", 0);
    private static int nImages = Prefs.getInt("raw.n", 1);
    private static int gapBetweenImages = Prefs.getInt("raw.gap", 0);
    private static int options;
    private static boolean whiteIsZero;
    private static boolean intelByteOrder;
    private boolean openAll;
    private static String[] types;
    static /* synthetic */ Class class$ij$io$ImportDialog;

    public ImportDialog(String fileName, String directory) {
        this.fileName = fileName;
        this.directory = directory;
        IJ.showStatus("Importing: " + fileName);
    }

    public ImportDialog() {
    }

    boolean showDialog() {
        if (choiceSelection >= types.length) {
            choiceSelection = 0;
        }
        GenericDialog gd = new GenericDialog("Import...", IJ.getInstance());
        gd.addChoice("Image Type:", types, types[choiceSelection]);
        gd.addNumericField("Width:", width, 0, 6, "pixels");
        gd.addNumericField("Height:", height, 0, 6, "pixels");
        gd.addNumericField("Offset to First Image:", offset, 0, 6, "bytes");
        gd.addNumericField("Number of Images:", nImages, 0, 6, null);
        gd.addNumericField("Gap Between Images:", gapBetweenImages, 0, 6, "bytes");
        gd.addCheckbox("White is Zero", whiteIsZero);
        gd.addCheckbox("Little-Endian Byte Order", intelByteOrder);
        gd.addCheckbox("Open All Files in Folder", this.openAll);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        choiceSelection = gd.getNextChoiceIndex();
        width = (int)gd.getNextNumber();
        height = (int)gd.getNextNumber();
        offset = (long)gd.getNextNumber();
        nImages = (int)gd.getNextNumber();
        gapBetweenImages = (int)gd.getNextNumber();
        whiteIsZero = gd.getNextBoolean();
        intelByteOrder = gd.getNextBoolean();
        this.openAll = gd.getNextBoolean();
        IJ.register(class$ij$io$ImportDialog == null ? (class$ij$io$ImportDialog = ImportDialog.class$("ij.io.ImportDialog")) : class$ij$io$ImportDialog);
        return true;
    }

    void openAll(String[] list, FileInfo fi) {
        StringSorter.sort(list);
        ImageStack stack = null;
        ImagePlus imp = null;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < list.length) {
            if (!list[i].startsWith(".")) {
                fi.fileName = list[i];
                imp = new FileOpener(fi).open(false);
                if (imp == null) {
                    IJ.log(list[i] + ": unable to open");
                } else {
                    if (stack == null) {
                        stack = imp.createEmptyStack();
                    }
                    try {
                        ImageProcessor ip = imp.getProcessor();
                        if (ip.getMin() < min) {
                            min = ip.getMin();
                        }
                        if (ip.getMax() > max) {
                            max = ip.getMax();
                        }
                        stack.addSlice(list[i], ip);
                    }
                    catch (OutOfMemoryError e) {
                        IJ.outOfMemory("OpenAll");
                        stack.trim();
                        break;
                    }
                    IJ.showStatus(stack.getSize() + 1 + ": " + list[i]);
                }
            }
            ++i;
        }
        if (stack != null) {
            imp = new ImagePlus("Imported Stack", stack);
            if (imp.getBitDepth() == 16 || imp.getBitDepth() == 32) {
                imp.getProcessor().setMinAndMax(min, max);
            }
            Calibration cal = imp.getCalibration();
            if (fi.fileType == 1) {
                double[] coeff = new double[]{-32768.0, 1.0};
                cal.setFunction(0, coeff, "gray value");
            }
            imp.show();
        }
    }

    public void openImage() {
        FileInfo fi = this.getFileInfo();
        if (fi == null) {
            return;
        }
        if (this.openAll) {
            String[] list = new File(this.directory).list();
            if (list == null) {
                return;
            }
            this.openAll(list, fi);
        } else {
            FileOpener fo = new FileOpener(fi);
            fo.open();
        }
    }

    public FileInfo getFileInfo() {
        if (!this.showDialog()) {
            return null;
        }
        String imageType = types[choiceSelection];
        FileInfo fi = new FileInfo();
        fi.fileFormat = 1;
        fi.fileName = this.fileName;
        fi.directory = this.directory;
        fi.width = width;
        fi.height = height;
        if (offset > Integer.MAX_VALUE) {
            fi.longOffset = offset;
        } else {
            fi.offset = (int)offset;
        }
        fi.nImages = nImages;
        fi.gapBetweenImages = gapBetweenImages;
        fi.intelByteOrder = intelByteOrder;
        fi.whiteIsZero = whiteIsZero;
        fi.fileType = imageType.equals("8-bit") ? 0 : (imageType.equals("16-bit Signed") ? 1 : (imageType.equals("16-bit Unsigned") ? 2 : (imageType.equals("32-bit Signed") ? 3 : (imageType.equals("32-bit Unsigned") ? 11 : (imageType.equals("32-bit Real") ? 4 : (imageType.equals("24-bit RGB") ? 6 : (imageType.equals("24-bit RGB Planar") ? 7 : (imageType.equals("24-bit BGR") ? 10 : (imageType.equals("32-bit ARGB") ? 9 : (imageType.equals("1-bit Bitmap") ? 8 : 0))))))))));
        if (IJ.debugMode) {
            IJ.log("ImportDialog: " + fi);
        }
        return fi;
    }

    public static void savePreferences(Properties prefs) {
        ((Hashtable)prefs).put(TYPE, Integer.toString(choiceSelection));
        ((Hashtable)prefs).put(WIDTH, Integer.toString(width));
        ((Hashtable)prefs).put(HEIGHT, Integer.toString(height));
        ((Hashtable)prefs).put(OFFSET, Integer.toString(offset > Integer.MAX_VALUE ? 0 : (int)offset));
        ((Hashtable)prefs).put(N, Integer.toString(nImages));
        ((Hashtable)prefs).put(GAP, Integer.toString(gapBetweenImages));
        int options = 0;
        if (whiteIsZero) {
            options |= 1;
        }
        if (intelByteOrder) {
            options |= 2;
        }
        ((Hashtable)prefs).put(OPTIONS, Integer.toString(options));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        types = new String[]{"8-bit", "16-bit Signed", "16-bit Unsigned", "32-bit Signed", "32-bit Unsigned", "32-bit Real", "24-bit RGB", "24-bit RGB Planar", "24-bit BGR", "32-bit ARGB", "1-bit Bitmap"};
        options = Prefs.getInt(OPTIONS, 0);
        whiteIsZero = (options & 1) != 0;
        intelByteOrder = (options & 2) != 0;
    }
}

