/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipFile;

public class PluginClassLoader
extends ClassLoader {
    protected String path;
    protected Hashtable cache = new Hashtable();
    protected Vector jarFiles;

    public PluginClassLoader(String path) {
        this.path = path;
        this.jarFiles = new Vector();
        File f = new File(path);
        String[] list = f.list();
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            f = new File(path, list[i]);
            if (f.isDirectory()) {
                String[] innerlist = f.list();
                if (innerlist != null) {
                    int j = 0;
                    while (j < innerlist.length) {
                        File g = new File(f, innerlist[j]);
                        if (g.isFile()) {
                            this.addJAR(g);
                        }
                        ++j;
                    }
                }
            } else {
                this.addJAR(f);
            }
            ++i;
        }
    }

    private void addJAR(File f) {
        if (f.getName().endsWith(".jar") || f.getName().endsWith(".zip")) {
            this.jarFiles.addElement(f);
        }
    }

    public URL getResource(String name) {
        File resFile;
        URL res = ClassLoader.getSystemResource(name);
        if (res != null) {
            return res;
        }
        try {
            resFile = new File(this.path, name);
            if (resFile.exists()) {
                res = this.makeURL(resFile);
                return res;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        resFile = new File(this.path);
        String[] list = resFile.list();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                resFile = new File(this.path, list[i]);
                if (resFile.isDirectory()) {
                    try {
                        File f = new File(this.path + list[i], name);
                        if (f.exists()) {
                            res = this.makeURL(f);
                            return res;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.jarFiles.size()) {
            try {
                File jf = (File)this.jarFiles.elementAt(i);
                byte[] resourceBytes = this.loadFromJar(jf.getPath(), name);
                if (resourceBytes != null) {
                    res = this.makeURL(name, jf);
                    return res;
                }
            }
            catch (MalformedURLException e) {
                IJ.error(e.toString());
            }
            catch (IOException e) {
                IJ.error(e.toString());
            }
            ++i;
        }
        return null;
    }

    private URL makeURL(File fil) throws MalformedURLException {
        URL url = new URL("file", "", fil.toString());
        return url;
    }

    private URL makeURL(String name, File jar) throws MalformedURLException {
        StringBuffer filename = new StringBuffer("file:///");
        filename.append(jar.toString());
        filename.append("!/");
        filename.append(name);
        String sf = filename.toString();
        String sfu = sf.replace('\\', '/');
        URL url = new URL("jar", "", sfu);
        return url;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is = ClassLoader.getSystemResourceAsStream(name);
        if (is != null) {
            return is;
        }
        File resFile = new File(this.path, name);
        try {
            is = new FileInputStream(resFile);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (is != null) {
            return is;
        }
        resFile = new File(this.path);
        String[] list = resFile.list();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                resFile = new File(this.path, list[i]);
                if (resFile.isDirectory()) {
                    try {
                        File f = new File(this.path + list[i], name);
                        is = new FileInputStream(f);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (is != null) {
                        return is;
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.jarFiles.size()) {
            try {
                File jf = (File)this.jarFiles.elementAt(i);
                byte[] resourceBytes = this.loadFromJar(jf.getPath(), name);
                if (resourceBytes != null) {
                    is = new ByteArrayInputStream(resourceBytes);
                    return is;
                }
            }
            catch (Exception e) {
                IJ.error(e.toString());
            }
            ++i;
        }
        return null;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    public synchronized Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        Class<?> result = (Class<?>)this.cache.get(className);
        if (result != null) {
            return result;
        }
        try {
            result = super.findSystemClass(className);
            return result;
        }
        catch (Exception e) {
            byte[] classBytes = this.loadClassBytes(className);
            if (classBytes == null) {
                throw new ClassNotFoundException(className);
            }
            result = this.defineClass(className, classBytes, 0, classBytes.length);
            if (result == null) {
                throw new ClassFormatError();
            }
            if (resolveIt) {
                this.resolveClass(result);
            }
            this.cache.put(className, result);
            return result;
        }
    }

    protected byte[] loadClassBytes(String name) {
        byte[] classBytes = null;
        classBytes = this.loadIt(this.path, name);
        if (classBytes == null && (classBytes = this.loadFromSubdirectory(this.path, name)) == null) {
            int i = 0;
            while (i < this.jarFiles.size()) {
                try {
                    File jf = (File)this.jarFiles.elementAt(i);
                    classBytes = this.loadClassFromJar(jf.getPath(), name);
                    if (classBytes != null) {
                        return classBytes;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
        }
        return classBytes;
    }

    private byte[] loadIt(String path, String classname) {
        String filename = classname.replace('.', '/');
        filename = filename + ".class";
        File fullname = new File(path, filename);
        try {
            FileInputStream is = new FileInputStream(fullname);
            int bufsize = (int)fullname.length();
            byte[] buf = new byte[bufsize];
            ((InputStream)is).read(buf, 0, bufsize);
            ((InputStream)is).close();
            return buf;
        }
        catch (Exception e) {
            return null;
        }
    }

    private byte[] loadFromSubdirectory(String path, String name) {
        File f = new File(path);
        String[] list = f.list();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                byte[] buf;
                f = new File(path, list[i]);
                if (f.isDirectory() && (buf = this.loadIt(path + list[i], name)) != null) {
                    return buf;
                }
                ++i;
            }
        }
        return null;
    }

    byte[] loadClassFromJar(String jar, String className) {
        String name = className.replace('.', '/');
        name = name + ".class";
        return this.loadFromJar(jar, name);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] loadFromJar(String jar, String name) {
        block13: {
            block12: {
                bis = null;
                try {
                    try {
                        jarFile = new ZipFile(jar);
                        entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            entry = entries.nextElement();
                            if (!entry.getName().equals(name)) continue;
                            bis = new BufferedInputStream(jarFile.getInputStream(entry));
                            size = (int)entry.getSize();
                            data = new byte[size];
                            b = 0;
                            eofFlag = 0;
                            while (size - b > 0 && (eofFlag = bis.read(data, b, size - b)) != -1) {
                                b += eofFlag;
                            }
                            var11_12 = data;
                            var13_13 = null;
                            break block12;
                        }
                        break block13;
                    }
                    catch (Exception e) {
                        var13_15 = null;
                        try {
                            if (bis == null) return null;
                            bis.close();
                            return null;
                        }
                        catch (IOException e) {
                            return null;
                        }
                    }
                }
                catch (Throwable var12_21) {
                    var13_16 = null;
                    ** try [egrp 2[TRYBLOCK] [2 : 167->178)] { 
lbl35:
                    // 1 sources

                    if (bis == null) throw var12_21;
                    bis.close();
                    throw var12_21;
lbl38:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var12_21;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 167->178)] { 
lbl43:
            // 1 sources

            if (bis == null) return var11_12;
            bis.close();
            return var11_12;
lbl46:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var11_12;
        }
        var13_14 = null;
        try {}
        catch (IOException e) {}
        if (bis == null) return null;
        bis.close();
        return null;
        return null;
    }
}

