/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Plot;
import ij.gui.PlotWindow;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.gui.YesNoCancelDialog;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.Program;
import ij.macro.Symbol;
import ij.macro.Variable;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.JpegWriter;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.Info;
import ij.plugin.frame.Editor;
import ij.plugin.frame.RoiManager;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatBlitter;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.text.TextPanel;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class Functions
implements MacroConstants,
Measurements {
    Interpreter interp;
    Program pgm;
    boolean updateNeeded;
    boolean autoUpdate = true;
    ImagePlus imp;
    ImageProcessor ip;
    int imageType;
    boolean colorSet;
    Plot plot;
    static int plotID;
    int justification = 0;
    boolean saveSettingsCalled;
    boolean usePointerCursor;
    boolean hideProcessStackDialog;
    float divideByZeroValue;
    int jpegQuality;
    int lineWidth;
    boolean doScaling;
    boolean weightedColor;
    double[] weights;
    boolean interpolateScaledImages;
    boolean open100Percent;
    boolean blackCanvas;
    boolean antialiasedText;
    boolean useJFileChooser;
    boolean debugMode;
    Color foregroundColor;
    Color backgroundColor;
    Color roiColor;
    boolean pointAutoMeasure;
    boolean requireControlKey;
    boolean useInvertingLut;
    Random ran;

    Functions(Interpreter interp, Program pgm) {
        this.interp = interp;
        this.pgm = pgm;
    }

    void doFunction(int type) {
        switch (type) {
            case 300: {
                this.doRun();
                break;
            }
            case 302: {
                IJ.selectWindow(this.getStringArg());
                this.resetImage();
                break;
            }
            case 303: {
                IJ.wait((int)this.getArg());
                break;
            }
            case 304: {
                this.interp.getParens();
                IJ.beep();
                break;
            }
            case 305: {
                this.interp.getParens();
                IJ.resetMinAndMax();
                this.resetImage();
                break;
            }
            case 306: {
                this.interp.getParens();
                IJ.resetThreshold();
                this.resetImage();
                break;
            }
            case 307: {
                IJ.log(this.getStringArg());
                break;
            }
            case 308: {
                IJ.write(this.getStringArg());
                break;
            }
            case 309: {
                IJ.doWand((int)this.getFirstArg(), (int)this.getLastArg());
                this.resetImage();
                break;
            }
            case 310: {
                IJ.setMinAndMax(this.getFirstArg(), this.getLastArg());
                this.resetImage();
                break;
            }
            case 311: {
                IJ.setThreshold(this.getFirstArg(), this.getLastArg());
                this.resetImage();
                break;
            }
            case 312: {
                IJ.setTool((int)this.getArg());
                break;
            }
            case 313: {
                this.setForegroundColor();
                break;
            }
            case 314: {
                this.setBackgroundColor();
                break;
            }
            case 336: {
                this.setColor();
                break;
            }
            case 315: {
                this.makeLine();
                break;
            }
            case 316: {
                this.makeOval();
                break;
            }
            case 317: {
                this.makeRectangle();
                break;
            }
            case 318: {
                this.interp.dump();
                break;
            }
            case 320: {
                this.lineTo();
                break;
            }
            case 319: {
                this.moveTo();
                break;
            }
            case 321: {
                this.drawLine();
                break;
            }
            case 322: {
                this.requires();
                break;
            }
            case 323: {
                this.autoUpdate = this.getBooleanArg();
                break;
            }
            case 324: {
                this.interp.getParens();
                this.updateDisplay();
                break;
            }
            case 325: {
                this.drawString();
                break;
            }
            case 326: {
                IJ.setPasteMode(this.getStringArg());
                break;
            }
            case 327: {
                IJ.doCommand(this.getStringArg());
                break;
            }
            case 328: {
                IJ.showStatus(this.getStringArg());
                this.interp.statusUpdated = true;
                break;
            }
            case 329: {
                this.showProgress();
                break;
            }
            case 330: {
                this.showMessage(false);
                break;
            }
            case 351: {
                this.showMessage(true);
                break;
            }
            case 331: 
            case 332: {
                this.setPixel();
                break;
            }
            case 333: 
            case 334: 
            case 335: {
                this.doIPMethod(type);
                break;
            }
            case 337: {
                this.getProcessor().setLineWidth((int)this.getArg());
                break;
            }
            case 338: {
                this.changeValues();
                break;
            }
            case 339: {
                this.selectImage();
                break;
            }
            case 340: {
                this.exit();
                break;
            }
            case 341: {
                this.setLocation();
                break;
            }
            case 342: {
                this.getCursorLoc();
                break;
            }
            case 343: {
                this.getLine();
                break;
            }
            case 344: {
                this.getVoxelSize();
                break;
            }
            case 345: {
                this.getHistogram();
                break;
            }
            case 346: {
                this.getStatistics();
                break;
            }
            case 347: {
                this.getBounds();
                break;
            }
            case 348: {
                this.getLut();
                break;
            }
            case 349: {
                this.setLut();
                break;
            }
            case 350: {
                this.getCoordinates();
                break;
            }
            case 352: {
                this.makeSelection();
                break;
            }
            case 353: {
                this.setResult();
                break;
            }
            case 354: {
                this.updateResults();
                break;
            }
            case 355: {
                this.setBatchMode();
                break;
            }
            case 356: {
                this.doPlot();
                break;
            }
            case 357: {
                this.setJustification();
                break;
            }
            case 358: {
                this.setZCoordinate();
                break;
            }
            case 359: {
                this.getThreshold();
                break;
            }
            case 360: {
                this.getPixelSize();
                break;
            }
            case 361: {
                this.interp.getParens();
                Undo.setup(6, this.getImage());
                break;
            }
            case 362: {
                this.saveSettings();
                break;
            }
            case 363: {
                this.restoreSettings();
                break;
            }
            case 364: {
                this.setKeyDown();
                break;
            }
            case 365: {
                this.open();
                break;
            }
            case 366: {
                this.roiManager();
                break;
            }
            case 367: {
                this.setFont();
                break;
            }
            case 368: {
                this.getMinAndMax();
                break;
            }
            case 369: {
                this.close();
                break;
            }
            case 370: {
                this.setSlice();
                break;
            }
            case 371: {
                this.newImage();
                break;
            }
            case 373: {
                IJ.save(this.getStringArg());
                break;
            }
            case 372: {
                this.saveAs();
                break;
            }
            case 374: {
                this.setAutoThreshold();
                break;
            }
            case 375: {
                IJ.run("Rename...", "title=[" + this.getStringArg() + "]");
            }
        }
    }

    final double getFunctionValue(int type) {
        double value = 0.0;
        switch (type) {
            case 1000: {
                value = this.getPixel();
                break;
            }
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1027: {
                value = this.math(type);
                break;
            }
            case 1006: 
            case 1007: 
            case 1008: 
            case 1036: {
                value = this.math2(type);
                break;
            }
            case 1013: {
                this.interp.getParens();
                value = System.currentTimeMillis();
                break;
            }
            case 1014: {
                this.interp.getParens();
                value = this.getImage().getWidth();
                break;
            }
            case 1015: {
                this.interp.getParens();
                value = this.getImage().getHeight();
                break;
            }
            case 1016: {
                value = this.random();
                break;
            }
            case 1018: 
            case 1023: {
                value = this.getResultsCount();
                break;
            }
            case 1017: {
                value = this.getResult();
                break;
            }
            case 1019: {
                value = this.getNumber();
                break;
            }
            case 1020: {
                value = this.getImageCount();
                break;
            }
            case 1021: {
                value = this.getStackSize();
                break;
            }
            case 1022: {
                value = this.lengthOf();
                break;
            }
            case 1024: {
                this.interp.getParens();
                value = this.getImage().getID();
                break;
            }
            case 1025: {
                this.interp.getParens();
                value = this.getImage().getBitDepth();
                break;
            }
            case 1026: {
                value = this.getSelectionType();
                break;
            }
            case 1028: {
                value = this.isOpen();
                break;
            }
            case 1029: {
                value = this.isActive();
                break;
            }
            case 1030: {
                value = this.indexOf();
                break;
            }
            case 1031: {
                value = this.getFirstString().lastIndexOf(this.getLastString());
                break;
            }
            case 1032: {
                value = this.getFirstString().charAt((int)this.getLastArg());
                break;
            }
            case 1033: {
                value = this.getBoolean();
                break;
            }
            case 1034: 
            case 1035: {
                value = this.startsWithEndsWith(type);
                break;
            }
            case 1037: {
                value = Double.isNaN(this.getArg()) ? 1.0 : 0.0;
                break;
            }
            case 1038: {
                value = this.getZoom();
                break;
            }
            case 1040: {
                value = this.parseDouble(this.getStringArg());
                break;
            }
            case 1039: {
                value = this.parseInt();
                break;
            }
            default: {
                this.interp.error("Numeric function expected");
            }
        }
        return value;
    }

    String getStringFunction(int type) {
        String str;
        switch (type) {
            case 2000: {
                str = this.d2s();
                break;
            }
            case 2001: {
                str = this.toString(16);
                break;
            }
            case 2002: {
                str = this.toString(2);
                break;
            }
            case 2003: {
                this.interp.getParens();
                str = this.getImage().getTitle();
                break;
            }
            case 2004: {
                str = this.getStringDialog();
                break;
            }
            case 2005: {
                str = this.substring();
                break;
            }
            case 2006: {
                str = this.fromCharCode();
                break;
            }
            case 2007: {
                str = this.getInfo(true);
                break;
            }
            case 2010: {
                str = this.getInfo(false);
                break;
            }
            case 2008: {
                str = this.getDirectory();
                break;
            }
            case 2009: {
                this.interp.getParens();
                str = this.interp.argument != null ? this.interp.argument : "";
                break;
            }
            default: {
                str = "";
                this.interp.error("String function expected");
            }
        }
        return str;
    }

    Variable[] getArrayFunction(int type) {
        Variable[] array;
        switch (type) {
            case 3000: {
                array = this.getProfile();
                break;
            }
            case 3001: {
                array = this.newArray();
                break;
            }
            case 3002: {
                array = this.split();
                break;
            }
            case 3003: {
                array = this.getFileList();
                break;
            }
            default: {
                array = null;
                this.interp.error("Array function expected");
            }
        }
        return array;
    }

    final double math(int type) {
        double arg = this.getArg();
        switch (type) {
            case 1001: {
                return Math.abs(arg);
            }
            case 1002: {
                return Math.cos(arg);
            }
            case 1003: {
                return Math.exp(arg);
            }
            case 1004: {
                return Math.floor(arg);
            }
            case 1005: {
                return Math.log(arg);
            }
            case 1009: {
                return Math.round(arg);
            }
            case 1010: {
                return Math.sin(arg);
            }
            case 1011: {
                return Math.sqrt(arg);
            }
            case 1012: {
                return Math.tan(arg);
            }
            case 1027: {
                return Math.atan(arg);
            }
        }
        return 0.0;
    }

    final double math2(int type) {
        double a1 = this.getFirstArg();
        double a2 = this.getLastArg();
        switch (type) {
            case 1007: {
                return Math.min(a1, a2);
            }
            case 1006: {
                return Math.max(a1, a2);
            }
            case 1008: {
                return Math.pow(a1, a2);
            }
            case 1036: {
                return Math.atan2(a1, a2);
            }
        }
        return 0.0;
    }

    final String getString() {
        String str = this.interp.getStringTerm();
        while (true) {
            this.interp.getToken();
            if (this.interp.token != 43) break;
            str = str + this.interp.getStringTerm();
        }
        this.interp.putTokenBack();
        return str;
    }

    final boolean isStringFunction() {
        Symbol symbol = this.pgm.table[this.interp.tokenAddress];
        return symbol.type == 2000;
    }

    final double getArg() {
        this.interp.getLeftParen();
        double arg = this.interp.getExpression();
        this.interp.getRightParen();
        return arg;
    }

    final double getFirstArg() {
        this.interp.getLeftParen();
        return this.interp.getExpression();
    }

    final double getNextArg() {
        this.interp.getComma();
        return this.interp.getExpression();
    }

    final double getLastArg() {
        this.interp.getComma();
        double arg = this.interp.getExpression();
        this.interp.getRightParen();
        return arg;
    }

    String getStringArg() {
        this.interp.getLeftParen();
        String arg = this.getString();
        this.interp.getRightParen();
        return arg;
    }

    final String getFirstString() {
        this.interp.getLeftParen();
        return this.getString();
    }

    final String getNextString() {
        this.interp.getComma();
        return this.getString();
    }

    final String getLastString() {
        this.interp.getComma();
        String arg = this.getString();
        this.interp.getRightParen();
        return arg;
    }

    boolean getBooleanArg() {
        this.interp.getLeftParen();
        double arg = this.interp.getBooleanExpression();
        this.interp.checkBoolean(arg);
        this.interp.getRightParen();
        return arg != 0.0;
    }

    final Variable getFirstVariable() {
        this.interp.getLeftParen();
        return this.getVariable();
    }

    final Variable getNextVariable() {
        this.interp.getComma();
        return this.getVariable();
    }

    final Variable getLastVariable() {
        this.interp.getComma();
        Variable v = this.getVariable();
        this.interp.getRightParen();
        return v;
    }

    final Variable getVariable() {
        Variable[] array;
        Variable v;
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Variable expected");
        }
        if ((v = this.interp.lookupVariable(this.interp.tokenAddress)) == null) {
            v = this.interp.push(this.interp.tokenAddress, 0.0, null, this.interp);
        }
        if ((array = v.getArray()) != null) {
            int index = this.interp.getIndex();
            this.checkIndex(index, 0, array.length - 1);
            v = array[index];
        }
        return v;
    }

    final Variable getFirstArrayVariable() {
        this.interp.getLeftParen();
        return this.getArrayVariable();
    }

    final Variable getNextArrayVariable() {
        this.interp.getComma();
        return this.getArrayVariable();
    }

    final Variable getLastArrayVariable() {
        this.interp.getComma();
        Variable v = this.getArrayVariable();
        this.interp.getRightParen();
        return v;
    }

    final Variable getArrayVariable() {
        Variable v;
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Variable expected");
        }
        if ((v = this.interp.lookupVariable(this.interp.tokenAddress)) == null) {
            v = this.interp.push(this.interp.tokenAddress, 0.0, null, this.interp);
        }
        return v;
    }

    final double[] getFirstArray() {
        this.interp.getLeftParen();
        return this.getArray();
    }

    final double[] getNextArray() {
        this.interp.getComma();
        return this.getArray();
    }

    final double[] getLastArray() {
        this.interp.getComma();
        double[] a = this.getArray();
        this.interp.getRightParen();
        return a;
    }

    double[] getArray() {
        Variable[] a1;
        boolean newArray;
        this.interp.getToken();
        boolean bl = newArray = this.interp.token == 137 && this.pgm.table[this.interp.tokenAddress].type == 3001;
        if (this.interp.token != 129 && !newArray) {
            this.interp.error("Array expected");
        }
        if (newArray) {
            a1 = this.getArrayFunction(3001);
        } else {
            Variable v = this.interp.lookupVariable(this.interp.tokenAddress);
            if (v == null) {
                this.interp.error("Undefined variable");
            }
            a1 = v.getArray();
        }
        if (a1 == null) {
            this.interp.error("Array expected");
        }
        double[] a2 = new double[a1.length];
        int i = 0;
        while (i < a1.length) {
            a2[i] = a1[i].getValue();
            ++i;
        }
        return a2;
    }

    Color getColor() {
        String color = this.getString();
        if ((color = color.toLowerCase(Locale.US)).equals("black")) {
            return Color.black;
        }
        if (color.equals("white")) {
            return Color.white;
        }
        if (color.equals("red")) {
            return Color.red;
        }
        if (color.equals("green")) {
            return Color.green;
        }
        if (color.equals("blue")) {
            return Color.blue;
        }
        if (color.equals("cyan")) {
            return Color.cyan;
        }
        if (color.equals("darkgray")) {
            return Color.darkGray;
        }
        if (color.equals("gray")) {
            return Color.gray;
        }
        if (color.equals("lightgray")) {
            return Color.lightGray;
        }
        if (color.equals("magenta")) {
            return Color.magenta;
        }
        if (color.equals("orange")) {
            return Color.orange;
        }
        if (color.equals("yellow")) {
            return Color.yellow;
        }
        if (color.equals("pink")) {
            return Color.pink;
        }
        this.interp.error("'red', 'green', etc. expected");
        return null;
    }

    void checkIndex(int index, int lower, int upper) {
        if (index < lower || index > upper) {
            this.interp.error("Index (" + index + ") is outside of the " + lower + "-" + upper + " range");
        }
    }

    void doRun() {
        this.interp.getLeftParen();
        String arg1 = this.getString();
        this.interp.getToken();
        if (this.interp.token != 41 && this.interp.token != 44) {
            this.interp.error("',' or ')'  expected");
        }
        String arg2 = null;
        if (this.interp.token == 44) {
            arg2 = this.getString();
            this.interp.getRightParen();
        }
        if (arg2 != null) {
            IJ.run(arg1, arg2);
        } else {
            IJ.run(arg1);
        }
        this.resetImage();
    }

    void setForegroundColor() {
        IJ.setForegroundColor((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void setBackgroundColor() {
        IJ.setBackgroundColor((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void setColor() {
        double color = this.getFirstArg();
        this.colorSet = true;
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
            this.setColor(color);
            return;
        }
        int red = (int)color;
        int green = (int)this.getNextArg();
        int blue = (int)this.getLastArg();
        if (red < 0) {
            red = 0;
        }
        if (green < 0) {
            green = 0;
        }
        if (blue < 0) {
            blue = 0;
        }
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        Color c = new Color(red, green, blue);
        this.getProcessor().setColor(c);
    }

    void setColor(double color) {
        ImageProcessor ip = this.getProcessor();
        switch (this.imp.getBitDepth()) {
            case 8: {
                if (color < 0.0 || color > 255.0) {
                    this.interp.error("Argument out of 8-bit range (0-255)");
                }
                ip.setValue(color);
                break;
            }
            case 16: {
                if (color < 0.0 || color > 65535.0) {
                    this.interp.error("Argument out of 16-bit range (0-65535)");
                }
                ip.setValue(color);
                break;
            }
            default: {
                ip.setValue(color);
            }
        }
    }

    void makeLine() {
        IJ.makeLine((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void makeOval() {
        IJ.makeOval((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void makeRectangle() {
        IJ.makeRectangle((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    ImagePlus getImage() {
        if (this.imp == null) {
            this.imp = IJ.getImage();
        }
        if (this.imp.getWindow() == null && IJ.getInstance() != null) {
            if (!Interpreter.isBatchMode()) {
                throw new RuntimeException("Macro canceled");
            }
        }
        return this.imp;
    }

    void resetImage() {
        this.imp = null;
        this.ip = null;
    }

    ImageProcessor getProcessor() {
        if (this.ip == null) {
            this.ip = this.getImage().getProcessor();
        }
        return this.ip;
    }

    int getType() {
        if (this.imp == null) {
            this.imp = IJ.getImage();
        }
        this.imageType = this.imp.getType();
        return this.imageType;
    }

    double getPixel() {
        this.interp.getLeftParen();
        int a1 = (int)this.interp.getExpression();
        this.interp.getComma();
        int a2 = (int)this.interp.getExpression();
        this.interp.getRightParen();
        double value = 0.0;
        ImageProcessor ip = this.getProcessor();
        value = this.getType() == 2 ? (double)ip.getPixelValue(a1, a2) : (double)ip.getPixel(a1, a2);
        return value;
    }

    void setZCoordinate() {
        int z = (int)this.getArg();
        ImagePlus imp = this.getImage();
        ImageStack stack = imp.getStack();
        int size = stack.getSize();
        if (z < 0 || z >= size) {
            this.interp.error("Z coordinate (" + z + ") is out of 0-" + (size - 1) + " range");
        }
        this.ip = stack.getProcessor(z + 1);
    }

    void setPixel() {
        this.interp.getLeftParen();
        int a1 = (int)this.interp.getExpression();
        this.interp.getComma();
        int a2 = (int)this.interp.getExpression();
        this.interp.getComma();
        double a3 = this.interp.getExpression();
        this.interp.getRightParen();
        if (this.getType() == 2) {
            this.getProcessor().putPixelValue(a1, a2, a3);
        } else {
            this.getProcessor().putPixel(a1, a2, (int)a3);
        }
        this.updateNeeded = true;
    }

    void moveTo() {
        this.interp.getLeftParen();
        int a1 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int a2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        this.getProcessor().moveTo(a1, a2);
    }

    void lineTo() {
        this.interp.getLeftParen();
        int a1 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int a2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        ImageProcessor ip = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(ip);
        }
        ip.lineTo(a1, a2);
        this.updateAndDraw(this.imp);
    }

    void drawLine() {
        this.interp.getLeftParen();
        int a1 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int a2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int a3 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int a4 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        ImageProcessor ip = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(ip);
        }
        ip.drawLine(a1, a2, a3, a4);
        this.updateAndDraw(this.imp);
    }

    void setForegroundColor(ImageProcessor ip) {
        ip.setColor(Toolbar.getForegroundColor());
        this.colorSet = true;
    }

    void doIPMethod(int type) {
        this.interp.getParens();
        ImageProcessor ip = this.getProcessor();
        switch (type) {
            case 333: {
                ip.snapshot();
                break;
            }
            case 334: {
                ip.reset();
                break;
            }
            case 335: {
                ImagePlus imp = this.getImage();
                Roi roi = imp.getRoi();
                if (!this.colorSet) {
                    this.setForegroundColor(ip);
                }
                if (roi == null) {
                    ip.resetRoi();
                    ip.fill();
                } else {
                    ip.setRoi(roi.getBounds());
                    ip.fill(imp.getMask());
                }
                this.updateAndDraw(imp);
            }
        }
    }

    void updateAndDraw(ImagePlus imp) {
        if (this.autoUpdate) {
            imp.updateAndDraw();
        } else {
            this.updateNeeded = true;
        }
    }

    void updateDisplay() {
        if (this.updateNeeded) {
            ImagePlus imp = this.getImage();
            imp.updateAndDraw();
            this.updateNeeded = false;
        }
    }

    void drawString() {
        this.interp.getLeftParen();
        String str = this.getString();
        this.interp.getComma();
        int x = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int y = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        ImageProcessor ip = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(ip);
        }
        ip.setJustification(this.justification);
        ip.drawString(str, x, y);
        this.updateAndDraw(this.imp);
    }

    void setJustification() {
        String str = this.getStringArg().toLowerCase(Locale.US);
        int just = 0;
        if (str.equals("center")) {
            just = 1;
        } else if (str.equals("right")) {
            just = 2;
        }
        this.justification = just;
    }

    void changeValues() {
        double darg1 = this.getFirstArg();
        double darg2 = this.getNextArg();
        double darg3 = this.getLastArg();
        ImagePlus imp = this.getImage();
        ImageProcessor ip = this.getProcessor();
        Roi roi = imp.getRoi();
        ImageProcessor mask = null;
        if (roi == null || !roi.isArea()) {
            ip.resetRoi();
            roi = null;
        } else {
            ip.setRoi(roi);
            mask = ip.getMask();
            if (mask != null) {
                ip.snapshot();
            }
        }
        int xmin = 0;
        int ymin = 0;
        int xmax = imp.getWidth();
        int ymax = imp.getHeight();
        if (roi != null) {
            Rectangle r = roi.getBounds();
            xmin = r.x;
            ymin = r.y;
            xmax = r.x + r.width;
            ymax = r.y + r.height;
        }
        boolean isFloat = this.getType() == 2;
        int y = ymin;
        while (y < ymax) {
            int x = xmin;
            while (x < xmax) {
                double v;
                double d = v = isFloat ? (double)ip.getPixelValue(x, y) : (double)(ip.getPixel(x, y) & 0xFFFFFF);
                if (v >= darg1 && v <= darg2) {
                    if (isFloat) {
                        ip.putPixelValue(x, y, darg3);
                    } else {
                        ip.putPixel(x, y, (int)darg3);
                    }
                }
                ++x;
            }
            ++y;
        }
        if (mask != null) {
            ip.reset(mask);
        }
        if (imp.getType() == 1 || imp.getType() == 2) {
            ip.resetMinAndMax();
        }
        imp.updateAndDraw();
        this.updateNeeded = false;
    }

    void requires() {
        if (IJ.versionLessThan(this.getStringArg())) {
            this.interp.done = true;
        }
    }

    double random() {
        this.interp.getParens();
        if (this.ran == null) {
            this.ran = new Random();
        }
        return this.ran.nextDouble();
    }

    double getResult() {
        this.interp.getLeftParen();
        String column = this.getString();
        this.interp.getComma();
        int row = (int)this.interp.getExpression();
        this.interp.getRightParen();
        ResultsTable rt = Analyzer.getResultsTable();
        int col = rt.getColumnIndex(column);
        if (!rt.columnExists(col)) {
            this.interp.error("\"" + column + "\" column not found");
        }
        if (row < 0 || row >= rt.getCounter()) {
            this.interp.error("Row (" + row + ") out of range");
        }
        return rt.getValue(col, row);
    }

    void setResult() {
        this.interp.getLeftParen();
        String column = this.getString();
        this.interp.getComma();
        int row = (int)this.interp.getExpression();
        this.interp.getComma();
        double value = 0.0;
        String label = null;
        if (column.equals("Label")) {
            label = this.getString();
        } else {
            value = this.interp.getExpression();
        }
        this.interp.getRightParen();
        ResultsTable rt = Analyzer.getResultsTable();
        if (row < 0 || row > rt.getCounter()) {
            this.interp.error("Row (" + row + ") out of range");
        }
        if (row == rt.getCounter()) {
            rt.incrementCounter();
        }
        try {
            if (label != null) {
                rt.setLabel(label, row);
            } else {
                rt.setValue(column, row, value);
            }
        }
        catch (Exception e) {
            this.interp.error("" + e.getMessage());
        }
    }

    void updateResults() {
        this.interp.getParens();
        ResultsTable rt = Analyzer.getResultsTable();
        rt.show("Results");
    }

    double getNumber() {
        String title;
        String prompt = this.getFirstString();
        double defaultValue = this.getLastArg();
        String string = title = this.interp.macroName != null ? this.interp.macroName : "";
        if (title.endsWith(" Options")) {
            title = title.substring(0, title.length() - 8);
        }
        GenericDialog gd = new GenericDialog(title);
        int decimalPlaces = (double)((int)defaultValue) == defaultValue ? 0 : 2;
        gd.addNumericField(prompt, defaultValue, decimalPlaces);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.interp.done = true;
            return defaultValue;
        }
        double v = gd.getNextNumber();
        if (gd.invalidNumber()) {
            return defaultValue;
        }
        return v;
    }

    double getBoolean() {
        YesNoCancelDialog d;
        String title;
        String prompt = this.getStringArg();
        String string = title = this.interp.macroName != null ? this.interp.macroName : "";
        if (title.endsWith(" Options")) {
            title = title.substring(0, title.length() - 8);
        }
        if ((d = new YesNoCancelDialog((Frame)IJ.getInstance(), title, prompt)).cancelPressed()) {
            this.interp.done = true;
            return 0.0;
        }
        if (d.yesPressed()) {
            return 1.0;
        }
        return 0.0;
    }

    double getBoolean2() {
        String title;
        String prompt = this.getFirstString();
        this.interp.getComma();
        double defaultValue = this.interp.getBooleanExpression();
        this.interp.checkBoolean(defaultValue);
        this.interp.getRightParen();
        String string = title = this.interp.macroName != null ? this.interp.macroName : "";
        if (title.endsWith(" Options")) {
            title = title.substring(0, title.length() - 8);
        }
        GenericDialog gd = new GenericDialog(title);
        gd.addCheckbox(prompt, defaultValue == 1.0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.interp.done = true;
            return 0.0;
        }
        return gd.getNextBoolean() ? 1.0 : 0.0;
    }

    String getStringDialog() {
        String title;
        this.interp.getLeftParen();
        String prompt = this.getString();
        this.interp.getComma();
        String defaultStr = this.getString();
        this.interp.getRightParen();
        String string = title = this.interp.macroName != null ? this.interp.macroName : "";
        if (title.endsWith(" Options")) {
            title = title.substring(0, title.length() - 8);
        }
        GenericDialog gd = new GenericDialog(title);
        gd.addStringField(prompt, defaultStr, 20);
        gd.showDialog();
        String str = "";
        if (gd.wasCanceled()) {
            this.interp.done = true;
        } else {
            str = gd.getNextString();
        }
        return str;
    }

    String d2s() {
        return IJ.d2s(this.getFirstArg(), (int)this.getLastArg());
    }

    String toString(int base) {
        int arg = (int)this.getArg();
        if (base == 2) {
            return Integer.toBinaryString(arg);
        }
        return Integer.toHexString(arg);
    }

    double getStackSize() {
        this.interp.getParens();
        return this.getImage().getStackSize();
    }

    double getImageCount() {
        this.interp.getParens();
        return WindowManager.getImageCount();
    }

    double getResultsCount() {
        this.interp.getParens();
        return Analyzer.getResultsTable().getCounter();
    }

    void getCoordinates() {
        Variable xCoordinates = this.getFirstArrayVariable();
        Variable yCoordinates = this.getLastArrayVariable();
        this.resetImage();
        ImageProcessor ip = this.getProcessor();
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            this.interp.error("Selection required");
        }
        Polygon p = roi.getPolygon();
        Variable[] xa = new Variable[p.npoints];
        int i = 0;
        while (i < p.npoints) {
            xa[i] = new Variable(p.xpoints[i]);
            ++i;
        }
        xCoordinates.setArray(xa);
        Variable[] ya = new Variable[p.npoints];
        int i2 = 0;
        while (i2 < p.npoints) {
            ya[i2] = new Variable(p.ypoints[i2]);
            ++i2;
        }
        yCoordinates.setArray(ya);
    }

    Variable[] getProfile() {
        this.interp.getParens();
        ImagePlus imp = this.getImage();
        ProfilePlot pp = new ProfilePlot(imp, IJ.altKeyDown());
        double[] array = pp.getProfile();
        if (array == null) {
            this.interp.done = true;
            return null;
        }
        return new Variable(array).getArray();
    }

    Variable[] newArray() {
        this.interp.getLeftParen();
        int next = this.interp.nextNonEolToken();
        if (next == 133 || this.interp.nextNextNonEolToken() == 44 || next == 45 || next == 211) {
            return this.initNewArray();
        }
        int size = (int)this.interp.getExpression();
        this.interp.getRightParen();
        Variable[] array = new Variable[size];
        int i = 0;
        while (i < size) {
            array[i] = new Variable();
            ++i;
        }
        return array;
    }

    Variable[] split() {
        String[] strings;
        String s1 = this.getFirstString();
        String s2 = this.getLastString();
        StringTokenizer t = s2.equals("") ? new StringTokenizer(s1) : new StringTokenizer(s1, s2);
        int tokens = t.countTokens();
        if (tokens > 0) {
            strings = new String[tokens];
            int i = 0;
            while (i < tokens) {
                strings[i] = t.nextToken();
                ++i;
            }
        } else {
            strings = new String[]{s1};
            tokens = 1;
        }
        Variable[] array = new Variable[tokens];
        int i = 0;
        while (i < tokens) {
            array[i] = new Variable(0, 0.0, strings[i]);
            ++i;
        }
        return array;
    }

    Variable[] getFileList() {
        String dir = this.getStringArg();
        File f = new File(dir);
        if (!f.exists() || !f.isDirectory()) {
            return new Variable[0];
        }
        String[] list = f.list();
        if (list == null) {
            return new Variable[0];
        }
        int hidden = 0;
        int i = 0;
        while (i < list.length) {
            if (list[i].startsWith(".")) {
                list[i] = null;
                ++hidden;
            } else {
                File f2 = new File(dir, list[i]);
                if (f2.isDirectory()) {
                    list[i] = list[i] + "/";
                }
            }
            ++i;
        }
        int n = list.length - hidden;
        if (n <= 0) {
            return new Variable[0];
        }
        if (hidden > 0) {
            String[] list2 = new String[n];
            int j = 0;
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2] != null) {
                    list2[j++] = list[i2];
                }
                ++i2;
            }
            list = list2;
        }
        Variable[] array = new Variable[n];
        int i3 = 0;
        while (i3 < n) {
            array[i3] = new Variable(0, 0.0, list[i3]);
            ++i3;
        }
        return array;
    }

    Variable[] initNewArray() {
        Vector<Variable> vector = new Vector<Variable>();
        int size = 0;
        do {
            Variable v = new Variable();
            if (this.interp.nextNonEolToken() == 133) {
                v.setString(this.getString());
            } else {
                v.setValue(this.interp.getExpression());
            }
            vector.addElement(v);
            ++size;
            this.interp.getToken();
        } while (this.interp.token == 44);
        if (this.interp.token != 41) {
            this.interp.error("';' expected");
        }
        Object[] array = new Variable[size];
        vector.copyInto(array);
        return array;
    }

    String fromCharCode() {
        char[] chars = new char[100];
        int count = 0;
        this.interp.getLeftParen();
        while (this.interp.nextToken() != 41) {
            int value = (int)this.interp.getExpression();
            if (value < 0 || value > 65535) {
                this.interp.error("Value (" + value + ") out of 0-65535 range");
            }
            chars[count++] = (char)value;
            if (this.interp.nextToken() != 44) continue;
            this.interp.getToken();
        }
        this.interp.getRightParen();
        return new String(chars, 0, count);
    }

    public String getInfo(boolean frontWindow) {
        Frame frame;
        this.interp.getParens();
        Frame frame2 = frame = frontWindow ? WindowManager.getFrontWindow() : null;
        if (frame != null && frame instanceof TextWindow) {
            TextPanel tp = ((TextWindow)frame).getTextPanel();
            return tp.getText();
        }
        if (frame != null && frame instanceof Editor) {
            return ((Editor)frame).getText();
        }
        ImagePlus imp = this.getImage();
        Info infoPlugin = new Info();
        return infoPlugin.getImageInfo(imp, this.getProcessor());
    }

    public String getDirectory() {
        String dir = IJ.getDirectory(this.getStringArg());
        if (dir == null) {
            dir = "";
        }
        return dir;
    }

    double getSelectionType() {
        this.interp.getParens();
        double type = -1.0;
        ImagePlus imp = this.getImage();
        Roi roi = imp.getRoi();
        if (roi != null) {
            type = roi.getType();
        }
        return type;
    }

    void showMessage(boolean withCancel) {
        String message;
        this.interp.getLeftParen();
        String title = this.getString();
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            message = this.getString();
        } else {
            message = title;
            title = "";
        }
        this.interp.getRightParen();
        if (withCancel) {
            IJ.showMessageWithCancel(title, message);
        } else {
            IJ.showMessage(title, message);
        }
    }

    double lengthOf() {
        int length = 0;
        this.interp.getLeftParen();
        switch (this.interp.nextToken()) {
            case 133: 
            case 136: 
            case 138: {
                length = this.getString().length();
                break;
            }
            case 129: {
                this.interp.getToken();
                Variable v = this.interp.lookupNumericVariable();
                if (v == null) {
                    return 0.0;
                }
                String s = v.getString();
                if (s != null) {
                    length = s.length();
                    break;
                }
                Variable[] array = v.getArray();
                if (array != null) {
                    length = array.length;
                    break;
                }
                this.interp.error("String or array expected");
                break;
            }
            default: {
                this.interp.error("String or array expected");
            }
        }
        this.interp.getRightParen();
        return length;
    }

    void getCursorLoc() {
        Variable x = this.getFirstVariable();
        Variable y = this.getNextVariable();
        Variable z = this.getNextVariable();
        Variable flags = this.getLastVariable();
        ImagePlus imp = this.getImage();
        ImageWindow win = imp.getWindow();
        if (win == null) {
            return;
        }
        ImageCanvas ic = win.getCanvas();
        Point p = ic.getCursorLoc();
        x.setValue(p.x);
        y.setValue(p.y);
        z.setValue(imp.getCurrentSlice() - 1);
        flags.setValue(ic.getModifiers());
    }

    void getLine() {
        Variable vx1 = this.getFirstVariable();
        Variable vy1 = this.getNextVariable();
        Variable vx2 = this.getNextVariable();
        Variable vy2 = this.getNextVariable();
        Variable lineWidth = this.getLastVariable();
        this.resetImage();
        ImagePlus imp = this.getImage();
        int x1 = -1;
        int y1 = -1;
        int x2 = -1;
        int y2 = -1;
        Roi roi = imp.getRoi();
        if (roi != null && roi.getType() == 5) {
            Line line = (Line)roi;
            x1 = line.x1;
            y1 = line.y1;
            x2 = line.x2;
            y2 = line.y2;
        }
        vx1.setValue(x1);
        vy1.setValue(y1);
        vx2.setValue(x2);
        vy2.setValue(y2);
        lineWidth.setValue(Line.getWidth());
    }

    void getVoxelSize() {
        Variable width = this.getFirstVariable();
        Variable height = this.getNextVariable();
        Variable depth = this.getNextVariable();
        Variable unit = this.getLastVariable();
        this.resetImage();
        ImagePlus imp = this.getImage();
        Calibration cal = imp.getCalibration();
        width.setValue(cal.pixelWidth);
        height.setValue(cal.pixelHeight);
        depth.setValue(cal.pixelDepth);
        unit.setString(cal.getUnit());
    }

    void getHistogram() {
        Variable[] array;
        this.interp.getLeftParen();
        Variable values = null;
        if (this.interp.nextToken() == 130) {
            this.interp.getExpression();
        } else {
            values = this.getArrayVariable();
        }
        Variable counts = this.getNextArrayVariable();
        this.interp.getComma();
        int nBins = (int)this.interp.getExpression();
        ImagePlus imp = this.getImage();
        double histMin = 0.0;
        double histMax = 0.0;
        boolean setMinMax = false;
        if (this.interp.nextToken() == 44) {
            histMin = this.getNextArg();
            histMax = this.getLastArg();
            if (imp.getBitDepth() != 32) {
                this.interp.error("32-bit image required to set min and max");
            }
            setMinMax = true;
        } else {
            this.interp.getRightParen();
        }
        int bitDepth = imp.getBitDepth();
        if ((bitDepth == 8 || bitDepth == 24) && nBins != 256 || bitDepth == 16 && nBins != 256 && nBins != 65536) {
            this.interp.error("Bin count (" + nBins + ") must be 256 for byte and RGB images, \nor 256 or 65536 for 16-bit images");
        }
        if (nBins == 65536 && bitDepth == 16) {
            Variable[] array2 = counts.getArray();
            int[] hist = this.getProcessor().getHistogram();
            if (array2 != null && array2.length == nBins) {
                int i = 0;
                while (i < nBins) {
                    array2[i].setValue(hist[i]);
                    ++i;
                }
            } else {
                counts.setArray(new Variable(hist).getArray());
            }
            return;
        }
        ImageStatistics stats = setMinMax ? imp.getStatistics(27, nBins, histMin, histMax) : imp.getStatistics(27, nBins);
        if (values != null) {
            Calibration cal = imp.getCalibration();
            double[] array3 = new double[nBins];
            double value = cal.getCValue(stats.histMin);
            double inc = 1.0;
            if (bitDepth == 16 || bitDepth == 32 || cal.calibrated()) {
                inc = (cal.getCValue(stats.histMax) - cal.getCValue(stats.histMin)) / (double)stats.nBins;
            }
            int i = 0;
            while (i < nBins) {
                array3[i] = value;
                value += inc;
                ++i;
            }
            values.setArray(new Variable(array3).getArray());
        }
        if ((array = counts.getArray()) != null && array.length == nBins) {
            int i = 0;
            while (i < nBins) {
                array[i].setValue(stats.histogram[i]);
                ++i;
            }
        } else {
            counts.setArray(new Variable(stats.histogram).getArray());
        }
    }

    void getLut() {
        Variable reds = this.getFirstArrayVariable();
        Variable greens = this.getNextArrayVariable();
        Variable blues = this.getLastArrayVariable();
        this.resetImage();
        ImageProcessor ip = this.getProcessor();
        if (ip instanceof ColorProcessor) {
            this.interp.error("Non-RGB image expected");
        }
        IndexColorModel cm = (IndexColorModel)ip.getColorModel();
        int mapSize = cm.getMapSize();
        byte[] rLUT = new byte[mapSize];
        byte[] gLUT = new byte[mapSize];
        byte[] bLUT = new byte[mapSize];
        cm.getReds(rLUT);
        cm.getGreens(gLUT);
        cm.getBlues(bLUT);
        reds.setArray(new Variable(rLUT).getArray());
        greens.setArray(new Variable(gLUT).getArray());
        blues.setArray(new Variable(bLUT).getArray());
    }

    void setLut() {
        double[] reds = this.getFirstArray();
        double[] greens = this.getNextArray();
        double[] blues = this.getLastArray();
        int length = reds.length;
        if (greens.length != length || blues.length != length) {
            this.interp.error("Arrays are not the same length");
        }
        this.resetImage();
        ImagePlus imp = this.getImage();
        if (imp.getBitDepth() == 24) {
            this.interp.error("Non-RGB image expected");
        }
        ImageProcessor ip = this.getProcessor();
        byte[] r = new byte[length];
        byte[] g = new byte[length];
        byte[] b = new byte[length];
        int i = 0;
        while (i < length) {
            r[i] = (byte)reds[i];
            g[i] = (byte)greens[i];
            b[i] = (byte)blues[i];
            ++i;
        }
        ip.setColorModel(new IndexColorModel(8, length, r, g, b));
        imp.updateAndDraw();
        this.updateNeeded = false;
    }

    void getThreshold() {
        Variable lower = this.getFirstVariable();
        Variable upper = this.getLastVariable();
        ImageProcessor ip = this.getProcessor();
        double t1 = ip.getMinThreshold();
        double t2 = ip.getMaxThreshold();
        if (t1 == -808080.0) {
            t1 = -1.0;
            t2 = -1.0;
        }
        lower.setValue(t1);
        upper.setValue(t2);
    }

    void getPixelSize() {
        Variable unit = this.getFirstVariable();
        Variable width = this.getNextVariable();
        Variable height = this.getNextVariable();
        Variable depth = null;
        if (this.interp.nextToken() == 44) {
            depth = this.getNextVariable();
        }
        this.interp.getRightParen();
        Calibration cal = this.getImage().getCalibration();
        unit.setString(cal.getUnit());
        width.setValue(cal.pixelWidth);
        height.setValue(cal.pixelHeight);
        if (depth != null) {
            depth.setValue(cal.pixelDepth);
        }
    }

    void makeSelection() {
        int n;
        String type = null;
        int roiType = -1;
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            type = this.getString().toLowerCase();
            roiType = 2;
            if (type.indexOf("free") != -1) {
                roiType = 3;
            }
            if (type.indexOf("traced") != -1) {
                roiType = 4;
            }
            if (type.indexOf("line") != -1) {
                roiType = type.indexOf("free") != -1 ? 7 : 6;
            }
            if (type.indexOf("angle") != -1) {
                roiType = 8;
            }
            if (type.indexOf("point") != -1) {
                roiType = 10;
            }
        } else {
            roiType = (int)this.interp.getExpression();
            if (roiType < 0 || roiType == 9 || roiType == 5) {
                this.interp.error("Invalid selection type (" + roiType + ")");
            }
            if (roiType == 0) {
                roiType = 2;
            }
            if (roiType == 1) {
                roiType = 3;
            }
        }
        double[] x = this.getNextArray();
        double[] y = this.getLastArray();
        if (y.length != (n = x.length)) {
            this.interp.error("Arrays are not the same length");
        }
        this.resetImage();
        ImagePlus imp = this.getImage();
        int[] xcoord = new int[n];
        int[] ycoord = new int[n];
        int height = imp.getHeight();
        int i = 0;
        while (i < n) {
            xcoord[i] = (int)x[i];
            ycoord[i] = (int)y[i];
            ++i;
        }
        Roi roi = null;
        roi = roiType == 10 ? new PointRoi(xcoord, ycoord, n) : new PolygonRoi(xcoord, ycoord, n, roiType);
        imp.setRoi(roi);
        if ((roiType == 2 || roiType == 3) && (roi = imp.getRoi()) != null && (IJ.shiftKeyDown() || IJ.altKeyDown())) {
            roi.addOrSubtract();
        }
        this.updateNeeded = false;
    }

    void doPlot() {
        String name;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 134) {
            this.interp.error("Function name expected: ");
        }
        if ((name = this.interp.tokenString).equals("create")) {
            this.newPlot();
            return;
        }
        if (this.plot == null) {
            this.interp.error("No plot defined");
        }
        if (name.equals("show")) {
            this.showPlot();
            return;
        }
        if (name.equals("update")) {
            this.updatePlot();
            return;
        }
        if (name.equals("setLimits")) {
            this.plot.setLimits(this.getFirstArg(), this.getNextArg(), this.getNextArg(), this.getLastArg());
            return;
        }
        if (name.equals("addText") || name.equals("drawLabel")) {
            this.addPlotText();
            return;
        }
        if (name.equals("setColor")) {
            this.setPlotColor();
            return;
        }
        if (name.equals("add")) {
            String arg = this.getFirstString();
            arg = arg.toLowerCase(Locale.US);
            int what = 0;
            if (arg.indexOf("curve") != -1 || arg.indexOf("line") != -1) {
                what = 2;
            } else if (arg.indexOf("box") != -1) {
                what = 3;
            } else if (arg.indexOf("triangle") != -1) {
                what = 4;
            } else if (arg.indexOf("cross") != -1) {
                what = 5;
            } else if (arg.indexOf("dot") != -1) {
                what = 6;
            } else if (arg.indexOf("x") != -1) {
                what = 1;
            } else if (arg.indexOf("error") != -1) {
                what = -1;
            }
            this.addToPlot(what);
            return;
        }
        if (name.startsWith("setLineWidth")) {
            this.plot.setLineWidth((int)this.getArg());
            return;
        }
        if (name.startsWith("setJustification")) {
            this.doFunction(357);
            return;
        }
        this.interp.error("Unrecognized plot function");
    }

    void newPlot() {
        double[] y;
        double[] x;
        String title = this.getFirstString();
        String xLabel = this.getNextString();
        String yLabel = this.getNextString();
        if (this.interp.nextToken() == 41) {
            x = new double[1];
            y = new double[1];
            x[0] = -1.0;
            y[0] = -1.0;
        } else {
            x = this.getNextArray();
            if (this.interp.nextToken() == 41) {
                y = x;
                x = new double[y.length];
                int i = 0;
                while (i < y.length) {
                    x[i] = i;
                    ++i;
                }
            } else {
                y = this.getNextArray();
            }
        }
        this.interp.getRightParen();
        this.plot = new Plot(title, xLabel, yLabel, x, y);
    }

    void showPlot() {
        if (this.plot != null) {
            PlotWindow plotWindow = this.plot.show();
            plotID = plotWindow.getImagePlus().getID();
        }
        this.plot = null;
        this.interp.getParens();
    }

    void updatePlot() {
        if (this.plot != null) {
            ImageWindow win;
            ImagePlus plotImage = WindowManager.getImage(plotID);
            ImageWindow imageWindow = win = plotImage != null ? plotImage.getWindow() : null;
            if (win != null) {
                ((PlotWindow)win).drawPlot(this.plot);
            } else {
                PlotWindow plotWindow = this.plot.show();
                plotID = plotWindow.getImagePlus().getID();
            }
        }
        this.plot = null;
        this.interp.getParens();
    }

    void addPlotText() {
        String str = this.getFirstString();
        double x = this.getNextArg();
        double y = this.getLastArg();
        this.plot.setJustification(this.justification);
        this.plot.addLabel(x, y, str);
    }

    void setPlotColor() {
        this.interp.getLeftParen();
        this.plot.setColor(this.getColor());
        this.interp.getRightParen();
    }

    void addToPlot(int what) {
        double[] y;
        double[] x = this.getNextArray();
        if (this.interp.nextToken() == 41) {
            y = x;
            x = new double[y.length];
            int i = 0;
            while (i < y.length) {
                x[i] = i;
                ++i;
            }
        } else {
            this.interp.getComma();
            y = this.getArray();
        }
        this.interp.getRightParen();
        if (what == -1) {
            this.plot.addErrorBars(y);
        } else {
            this.plot.addPoints(x, y, what);
        }
    }

    void getBounds() {
        Variable x = this.getFirstVariable();
        Variable y = this.getNextVariable();
        Variable width = this.getNextVariable();
        Variable height = this.getLastVariable();
        this.resetImage();
        ImagePlus imp = this.getImage();
        Roi roi = imp.getRoi();
        if (roi != null) {
            Rectangle r = roi.getBounds();
            x.setValue(r.x);
            y.setValue(r.y);
            width.setValue(r.width);
            height.setValue(r.height);
        } else {
            x.setValue(0.0);
            y.setValue(0.0);
            width.setValue(imp.getWidth());
            height.setValue(imp.getHeight());
        }
    }

    void getStatistics() {
    }

    String substring() {
        int index2;
        String s = this.getFirstString();
        int index1 = (int)this.getNextArg();
        if (index1 > (index2 = (int)this.getLastArg())) {
            this.interp.error("beginIndex>endIndex");
        }
        this.checkIndex(index1, 0, s.length());
        this.checkIndex(index2, 0, s.length());
        return s.substring(index1, index2);
    }

    int indexOf() {
        String s1 = this.getFirstString();
        String s2 = this.getNextString();
        int fromIndex = 0;
        if (this.interp.nextToken() == 44) {
            fromIndex = (int)this.getLastArg();
            this.checkIndex(fromIndex, 0, s1.length() - 1);
        } else {
            this.interp.getRightParen();
        }
        if (fromIndex == 0) {
            return s1.indexOf(s2);
        }
        return s1.indexOf(s2, fromIndex);
    }

    int startsWithEndsWith(int type) {
        String s1 = this.getFirstString();
        String s2 = this.getLastString();
        if (type == 1034) {
            return s1.startsWith(s2) ? 1 : 0;
        }
        return s1.endsWith(s2) ? 1 : 0;
    }

    double isActive() {
        int id = (int)this.getArg();
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null || imp.getID() != id) {
            return 0.0;
        }
        return 1.0;
    }

    double isOpen() {
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            String title = this.getString();
            this.interp.getRightParen();
            return WindowManager.getFrame(title) == null ? 0.0 : 1.0;
        }
        int id = (int)this.interp.getExpression();
        this.interp.getRightParen();
        return WindowManager.getImage(id) == null ? 0.0 : 1.0;
    }

    boolean isStringArg() {
        int nextToken = this.pgm.code[this.interp.pc + 1];
        int tok = nextToken & 0xFF;
        if (tok == 133 || tok == 136) {
            return true;
        }
        if (tok != 129) {
            return false;
        }
        Variable v = this.interp.lookupVariable(nextToken >> 16);
        if (v == null) {
            return false;
        }
        return v.getType() == 2;
    }

    void exit() {
        String msg = null;
        if (this.interp.nextToken() == 40) {
            this.interp.getLeftParen();
            if (this.interp.nextToken() == 133 || this.interp.nextToken() == 136) {
                msg = this.getString();
            }
            this.interp.getRightParen();
        }
        this.interp.finishUp();
        if (msg != null) {
            IJ.showMessage("Macro", msg);
        }
        throw new RuntimeException("Macro canceled");
    }

    void showProgress() {
        this.interp.getLeftParen();
        double arg1 = this.interp.getExpression();
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            double arg2 = this.interp.getExpression();
            IJ.showProgress((int)arg1, (int)arg2);
        } else {
            IJ.showProgress(arg1);
        }
        this.interp.getRightParen();
        this.interp.showingProgress = true;
    }

    void saveSettings() {
        this.interp.getParens();
        this.usePointerCursor = Prefs.usePointerCursor;
        this.hideProcessStackDialog = IJ.hideProcessStackDialog;
        this.divideByZeroValue = FloatBlitter.divideByZeroValue;
        this.jpegQuality = JpegWriter.getQuality();
        this.lineWidth = Line.getWidth();
        this.doScaling = ImageConverter.getDoScaling();
        this.weightedColor = Prefs.weightedColor;
        this.weights = ColorProcessor.getWeightingFactors();
        this.interpolateScaledImages = Prefs.interpolateScaledImages;
        this.open100Percent = Prefs.open100Percent;
        this.blackCanvas = Prefs.blackCanvas;
        this.antialiasedText = Prefs.antialiasedText;
        this.useJFileChooser = Prefs.useJFileChooser;
        this.debugMode = IJ.debugMode;
        this.foregroundColor = Toolbar.getForegroundColor();
        this.backgroundColor = Toolbar.getBackgroundColor();
        this.roiColor = Roi.getColor();
        this.pointAutoMeasure = Prefs.pointAutoMeasure;
        this.requireControlKey = Prefs.requireControlKey;
        this.useInvertingLut = Prefs.useInvertingLut;
        this.saveSettingsCalled = true;
    }

    void restoreSettings() {
        this.interp.getParens();
        if (!this.saveSettingsCalled) {
            this.interp.error("saveSettings() not called");
        }
        Prefs.usePointerCursor = this.usePointerCursor;
        IJ.hideProcessStackDialog = this.hideProcessStackDialog;
        FloatBlitter.divideByZeroValue = this.divideByZeroValue;
        JpegWriter.setQuality(this.jpegQuality);
        Line.setWidth(this.lineWidth);
        ImageConverter.setDoScaling(this.doScaling);
        if (this.weightedColor != Prefs.weightedColor) {
            ColorProcessor.setWeightingFactors(this.weights[0], this.weights[1], this.weights[2]);
            Prefs.weightedColor = this.weights[0] != 0.3333333333333333 || this.weights[1] != 0.3333333333333333 || this.weights[2] != 0.3333333333333333;
        }
        Prefs.interpolateScaledImages = this.interpolateScaledImages;
        Prefs.open100Percent = this.open100Percent;
        Prefs.blackCanvas = this.blackCanvas;
        Prefs.antialiasedText = this.antialiasedText;
        Prefs.useJFileChooser = this.useJFileChooser;
        IJ.debugMode = this.debugMode;
        Toolbar.setForegroundColor(this.foregroundColor);
        Toolbar.setBackgroundColor(this.backgroundColor);
        Roi.setColor(this.roiColor);
    }

    void setKeyDown() {
        String key = this.getStringArg();
        if ((key = key.toLowerCase(Locale.US)).indexOf("alt") != -1) {
            IJ.setKeyDown(18);
        } else {
            IJ.setKeyUp(18);
        }
        if (key.indexOf("shift") != -1) {
            IJ.setKeyDown(16);
        } else {
            IJ.setKeyUp(16);
        }
        if (key.equals("space")) {
            IJ.setKeyDown(32);
        } else {
            IJ.setKeyUp(32);
        }
        this.interp.keysSet = true;
    }

    void open() {
        this.interp.getLeftParen();
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
            IJ.open();
        } else {
            String path = this.getString();
            this.interp.getRightParen();
            IJ.open(path);
        }
    }

    void roiManager() {
        boolean twoArgCommand;
        String cmd = this.getFirstString();
        cmd = cmd.toLowerCase();
        String path = null;
        boolean bl = twoArgCommand = cmd.equals("open") || cmd.equals("save");
        if (twoArgCommand) {
            path = this.getLastString();
        } else {
            this.interp.getRightParen();
        }
        Frame frame = WindowManager.getFrame("ROI Manager");
        if (frame == null) {
            IJ.run("ROI Manager...");
        }
        if ((frame = WindowManager.getFrame("ROI Manager")) == null || !(frame instanceof RoiManager)) {
            this.interp.error("ROI Manager not found");
        }
        RoiManager rm = (RoiManager)frame;
        if (twoArgCommand) {
            rm.runCommand(cmd, path);
        } else if (!rm.runCommand(cmd)) {
            this.interp.error("Invalid ROI Manager command");
        }
    }

    void setFont() {
        String name = this.getFirstString();
        int size = (int)this.getNextArg();
        int style = 0;
        if (this.interp.nextToken() == 44) {
            String styles = this.getLastString().toLowerCase();
            if (styles.indexOf("bold") != -1) {
                ++style;
            }
            if (styles.indexOf("italic") != -1) {
                style += 2;
            }
        } else {
            this.interp.getRightParen();
        }
        ImageProcessor ip = this.getProcessor();
        Font font = new Font(name, style, size);
        ip.setFont(font);
    }

    void getMinAndMax() {
        Variable min = this.getFirstVariable();
        Variable max = this.getLastVariable();
        ImagePlus imp = this.getImage();
        ImageProcessor ip = imp.getProcessor();
        double v1 = ip.getMin();
        double v2 = ip.getMax();
        if (imp.getCalibration().isSigned16Bit()) {
            v1 -= 32768.0;
            v2 -= 32768.0;
        }
        min.setValue(v1);
        max.setValue(v2);
    }

    void selectImage() {
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            this.selectImage(this.getString());
            this.interp.getRightParen();
        } else {
            int id = (int)this.interp.getExpression();
            this.interp.getRightParen();
            if (Interpreter.isBatchMode()) {
                ImagePlus imp = null;
                if (Interpreter.imageTable != null) {
                    imp = (ImagePlus)Interpreter.imageTable.get(new Integer(id));
                }
                if (imp == null) {
                    IJ.selectWindow(id);
                } else {
                    WindowManager.setTempCurrentImage(imp);
                }
            } else {
                IJ.selectWindow(id);
            }
        }
        this.resetImage();
    }

    void selectImage(String title) {
        if (Interpreter.isBatchMode()) {
            if (Interpreter.imageTable != null) {
                Enumeration en = Interpreter.imageTable.elements();
                while (en.hasMoreElements()) {
                    ImagePlus imp = (ImagePlus)en.nextElement();
                    if (imp == null || !imp.getTitle().equals(title)) continue;
                    WindowManager.setTempCurrentImage(imp);
                    return;
                }
            }
            this.selectWindowManagerImage(title);
        } else {
            this.selectWindowManagerImage(title);
        }
    }

    void notFound(String title) {
        this.interp.error(title + " not found");
    }

    void selectWindowManagerImage(String title) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 4000L) {
            int[] wList = WindowManager.getIDList();
            int len = wList != null ? wList.length : 0;
            int i = 0;
            while (i < len) {
                ImagePlus imp = WindowManager.getImage(wList[i]);
                if (imp != null && imp.getTitle().equals(title)) {
                    IJ.selectWindow(imp.getID());
                    return;
                }
                ++i;
            }
            IJ.wait(10);
        }
        this.notFound(title);
    }

    void close() {
        this.interp.getParens();
        ImagePlus imp = this.getImage();
        ImageWindow win = imp.getWindow();
        if (win != null) {
            imp.changes = false;
            win.close();
        } else {
            WindowManager.setTempCurrentImage(null);
            imp.killRoi();
            Interpreter.removeBatchModeImage(imp);
        }
        this.resetImage();
    }

    /*
     * Unable to fully structure code
     */
    void setBatchMode() {
        b = this.getBooleanArg();
        if (Interpreter.imageTable == null) ** GOTO lbl-1000
        if (Interpreter.imageTable.size() >= 1) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        imagesOpen = v0;
        Interpreter.setBatchMode(b);
        if (!b) {
            this.resetImage();
            imp2 = null;
            if (imagesOpen && (imp2 = WindowManager.getCurrentImage()) != null) {
                imp2.show();
                roi = imp2.getRoi();
                if (roi != null) {
                    imp2.setRoi(roi);
                }
            }
            WindowManager.setTempCurrentImage(null);
        }
    }

    void setLocation() {
        ImagePlus imp = this.getImage();
        ImageWindow win = imp.getWindow();
        if (win != null) {
            ((Component)win).setLocation((int)this.getFirstArg(), (int)this.getLastArg());
        }
    }

    void setSlice() {
        int n = (int)this.getArg();
        ImagePlus imp = this.getImage();
        int nSlices = imp.getStackSize();
        if (n == 1 && nSlices == 1) {
            return;
        }
        if (n < 1 || n > nSlices) {
            this.interp.error("Argument must be >=1 and <=" + nSlices);
        } else {
            imp.setSlice(n);
        }
    }

    void newImage() {
        String title = this.getFirstString();
        String type = this.getNextString();
        int width = (int)this.getNextArg();
        int height = (int)this.getNextArg();
        int depth = (int)this.getLastArg();
        IJ.newImage(title, type, width, height, depth);
    }

    void saveAs() {
        String format = this.getFirstString();
        String path = this.getLastString();
        IJ.saveAs(format, path);
    }

    double getZoom() {
        this.interp.getParens();
        ImagePlus imp = this.getImage();
        ImageWindow win = imp.getWindow();
        return win != null ? win.getCanvas().getMagnification() : 1.0;
    }

    void setAutoThreshold() {
        double upper;
        double lower;
        boolean notByteData;
        this.interp.getParens();
        ImagePlus imp = this.getImage();
        ImageProcessor ip = this.getProcessor();
        double min = 0.0;
        double max = 0.0;
        boolean bl = notByteData = !(ip instanceof ByteProcessor);
        if (notByteData) {
            ip.resetMinAndMax();
            min = ip.getMin();
            max = ip.getMax();
            ip = new ByteProcessor(ip.createImage());
        }
        ip.setRoi(imp.getRoi());
        ImageStatistics stats = ImageStatistics.getStatistics(ip, 25, null);
        int threshold = ip.getAutoThreshold(stats.histogram);
        if (stats.max - stats.dmode > stats.dmode - stats.min) {
            lower = threshold;
            upper = stats.max;
        } else {
            lower = stats.min;
            upper = threshold;
        }
        if (notByteData) {
            if (max > min) {
                lower = min + lower / 255.0 * (max - min);
                upper = min + upper / 255.0 * (max - min);
            } else {
                lower = -808080.0;
            }
        }
        IJ.setThreshold(lower, upper);
        this.resetImage();
    }

    double parseDouble(String s) {
        if ((s = s.trim()).indexOf(32) != -1) {
            s = s.substring(0, s.indexOf(32));
        }
        if (s.indexOf(44) != -1) {
            s = s.substring(0, s.indexOf(44));
        }
        return Tools.parseDouble(s);
    }

    double parseInt() {
        double n;
        String s = this.getFirstString();
        int radix = 10;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            radix = (int)this.interp.getExpression();
            if (radix < 2 || radix > 36) {
                radix = 10;
            }
        }
        this.interp.getRightParen();
        try {
            if (radix == 10) {
                n = this.parseDouble(s);
                if (!Double.isNaN(n)) {
                    n = Math.round(n);
                }
            } else {
                n = Integer.parseInt(s, radix);
            }
        }
        catch (NumberFormatException e) {
            n = 212.0;
        }
        return n;
    }
}

