/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.Symbol;
import ij.macro.Variable;

public class Program
implements MacroConstants {
    private int maxSymbols = 800;
    private int maxProgramSize = 2000;
    private int pc = -1;
    int stLoc = -1;
    int symTabLoc;
    Symbol[] table = new Symbol[this.maxSymbols];
    static Symbol[] systemTable;
    int[] code = new int[this.maxProgramSize];
    Variable[] globals;
    boolean hasVars;
    static /* synthetic */ Class class$ij$macro$Program;

    public Program() {
        if (systemTable != null) {
            this.stLoc = systemTable.length - 1;
            int i = 0;
            while (i <= this.stLoc) {
                this.table[i] = systemTable[i];
                ++i;
            }
        } else {
            this.addKeywords();
            this.addFunctions();
            this.addNumericFunctions();
            this.addStringFunctions();
            this.addArrayFunctions();
            systemTable = new Symbol[this.stLoc + 1];
            int i = 0;
            while (i <= this.stLoc) {
                Program.systemTable[i] = this.table[i];
                ++i;
            }
            IJ.register(class$ij$macro$Program == null ? (class$ij$macro$Program = Program.class$("ij.macro.Program")) : class$ij$macro$Program);
        }
    }

    public int[] getCode() {
        return this.code;
    }

    public Symbol[] getSymbolTable() {
        return this.table;
    }

    void addKeywords() {
        int i = 0;
        while (i < MacroConstants.keywords.length) {
            this.addSymbol(new Symbol(MacroConstants.keywordIDs[i], MacroConstants.keywords[i]));
            ++i;
        }
    }

    void addFunctions() {
        int i = 0;
        while (i < MacroConstants.functions.length) {
            this.addSymbol(new Symbol(MacroConstants.functionIDs[i], MacroConstants.functions[i]));
            ++i;
        }
    }

    void addNumericFunctions() {
        int i = 0;
        while (i < MacroConstants.numericFunctions.length) {
            this.addSymbol(new Symbol(MacroConstants.numericFunctionIDs[i], MacroConstants.numericFunctions[i]));
            ++i;
        }
    }

    void addStringFunctions() {
        int i = 0;
        while (i < MacroConstants.stringFunctions.length) {
            this.addSymbol(new Symbol(MacroConstants.stringFunctionIDs[i], MacroConstants.stringFunctions[i]));
            ++i;
        }
    }

    void addArrayFunctions() {
        int i = 0;
        while (i < MacroConstants.arrayFunctions.length) {
            this.addSymbol(new Symbol(MacroConstants.arrayFunctionIDs[i], MacroConstants.arrayFunctions[i]));
            ++i;
        }
    }

    void addSymbol(Symbol sym) {
        ++this.stLoc;
        if (this.stLoc == this.table.length) {
            Symbol[] tmp = new Symbol[this.maxSymbols * 2];
            System.arraycopy(this.table, 0, tmp, 0, this.maxSymbols);
            this.table = tmp;
            this.maxSymbols *= 2;
        }
        this.table[this.stLoc] = sym;
    }

    void addToken(int tok) {
        ++this.pc;
        if (this.pc == this.code.length) {
            int[] tmp = new int[this.maxProgramSize * 2];
            System.arraycopy(this.code, 0, tmp, 0, this.maxProgramSize);
            this.code = tmp;
            this.maxProgramSize *= 2;
        }
        this.code[this.pc] = tok;
    }

    Symbol lookupWord(String str) {
        int i = 0;
        while (i <= this.stLoc) {
            Symbol symbol = this.table[i];
            if (symbol.type != 133 && str.equals(symbol.str)) {
                this.symTabLoc = i;
                return symbol;
            }
            ++i;
        }
        return null;
    }

    void saveGlobals(Interpreter interp) {
        if (interp.topOfStack == -1) {
            return;
        }
        int n = interp.topOfStack + 1;
        this.globals = new Variable[n];
        int i = 0;
        while (i < n) {
            this.globals[i] = interp.stack[i];
            ++i;
        }
    }

    public void dumpSymbolTable() {
        IJ.log("");
        IJ.log("Symbol Table");
        int i = 0;
        while (i <= this.maxSymbols) {
            Symbol symbol = this.table[i];
            if (symbol == null) break;
            IJ.log(i + " " + symbol);
            ++i;
        }
    }

    public void dumpProgram() {
        IJ.log("");
        IJ.log("Tokenized Program");
        int i = 0;
        while (i <= this.pc) {
            IJ.log(i + "\t" + (this.code[i] & 0xFFFF) + "  " + this.decodeToken(this.code[i]));
            ++i;
        }
    }

    public Variable[] getGlobals() {
        return this.globals;
    }

    public boolean hasVars() {
        return this.hasVars;
    }

    public String decodeToken(int token) {
        return this.decodeToken(token & 0xFFFF, token >> 16);
    }

    String decodeToken(int token, int address) {
        String str;
        block0 : switch (token) {
            case 129: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                str = this.table[address].str;
                break;
            }
            case 133: {
                str = "\"" + this.table[address].str + "\"";
                break;
            }
            case 130: {
                double v = this.table[address].value;
                if ((double)((int)v) == v) {
                    str = IJ.d2s(v, 0);
                    break;
                }
                str = "" + v;
                break;
            }
            case 132: {
                str = "EOL";
                break;
            }
            case 128: {
                str = "EOF";
                break;
            }
            default: {
                if (token < 32) {
                    switch (token) {
                        case 1: {
                            str = "++";
                            break block0;
                        }
                        case 2: {
                            str = "--";
                            break block0;
                        }
                        case 9: {
                            str = "+=";
                            break block0;
                        }
                        case 10: {
                            str = "-=";
                            break block0;
                        }
                        case 11: {
                            str = "*=";
                            break block0;
                        }
                        case 12: {
                            str = "/=";
                            break block0;
                        }
                        case 13: {
                            str = "&&";
                            break block0;
                        }
                        case 14: {
                            str = "||";
                            break block0;
                        }
                        case 3: {
                            str = "==";
                            break block0;
                        }
                        case 4: {
                            str = "!=";
                            break block0;
                        }
                        case 5: {
                            str = ">";
                            break block0;
                        }
                        case 6: {
                            str = ">=";
                            break block0;
                        }
                        case 7: {
                            str = "<";
                            break block0;
                        }
                        case 8: {
                            str = "<=";
                            break block0;
                        }
                    }
                    str = "";
                    break;
                }
                if (token >= 200) {
                    str = this.table[address].str;
                    break;
                }
                char[] s = new char[]{(char)token};
                str = new String(s);
            }
        }
        return str;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

