/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.plugin.PlugIn;
import ij.plugin.TreePanel;
import ij.util.Java2;
import ij.util.StringSorter;
import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ControlPanel
implements PlugIn {
    private static final String pluginsPath = Menus.getPlugInsPath();
    private static final String pcpVersion = "1.0g";
    private static final String fileSeparator = System.getProperty("file.separator");
    private static final char sep = fileSeparator.charAt(0);
    private static final String jvmversion = System.getProperty("java.version");
    private static final String jvmversionMajor = jvmversion.substring(0, jvmversion.lastIndexOf(46));
    private static ImageJ ij = IJ.getInstance();
    private Hashtable panels = new Hashtable();
    private Vector visiblePanels = new Vector();
    private Vector expandedNodes = new Vector();
    private String defaultArg = "";
    String currentArg = "";
    private Properties pcpProperties = new Properties();
    private File pcpPropsFile = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "PCPanel2.ini");
    private boolean savePropsUponClose = true;
    private boolean propertiesChanged = true;
    private boolean closeChildPanelOnExpand = true;
    private boolean requireDoubleClick = false;
    private boolean quitting = true;
    TreePanel panel;
    Vector menus = new Vector();
    Vector allMenus = new Vector();
    String[] installableMenuLabels = new String[]{"About Plugins", "Filters", "Import", "Plugins", "Save As", "Shortcuts", "Tools", "Utilities"};
    Hashtable commands = new Hashtable();
    Hashtable menuCommands = new Hashtable();
    String[] pluginsArray;
    Hashtable treeCommands = new Hashtable();
    int argLength = 0;
    private String path = null;
    private DefaultMutableTreeNode root;
    MenuItem reloadMI = null;

    public ControlPanel() {
        if (!IJ.isJava2()) {
            IJ.error("This command requires Java 1.2 or later");
            return;
        }
        this.requireDoubleClick = !IJ.isWindows() && !IJ.isMacintosh();
        Java2.setSystemLookAndFeel();
    }

    public void run(String arg) {
        if (!IJ.isJava2()) {
            return;
        }
        this.currentArg = arg.length() == 0 ? this.defaultArg : arg;
        this.argLength = this.currentArg.length();
        this.load();
    }

    synchronized void load() {
        this.commands = Menus.getCommands();
        this.pluginsArray = Menus.getPlugins();
        this.root = this.buildTree(this.currentArg);
        if (this.root == null | this.root.getChildCount() == 0) {
            return;
        }
        this.loadProperties();
        this.restoreVisiblePanels();
        if (this.panels.isEmpty()) {
            this.newPanel(this.root);
        }
    }

    DefaultMutableTreeNode buildTree(String arg) {
        DefaultMutableTreeNode rootNode = null;
        if (arg.length() == 0) {
            return this.doRootFromMenus();
        }
        StringTokenizer argParser = new StringTokenizer(arg, ";");
        int tokens = argParser.countTokens();
        if (tokens == 1) {
            rootNode = this.doRoot(arg);
        } else {
            rootNode = new DefaultMutableTreeNode("Control Panel");
            while (argParser.hasMoreTokens()) {
                String token = argParser.nextToken();
                DefaultMutableTreeNode node = this.doRoot(token);
                if (node == null) continue;
                rootNode.add(node);
            }
        }
        return rootNode;
    }

    private DefaultMutableTreeNode doRoot(String arg) {
        DefaultMutableTreeNode node = null;
        if (arg == null || arg.length() == 0) {
            node = new DefaultMutableTreeNode("");
        }
        if (arg.equals("user plugins")) {
            node = new DefaultMutableTreeNode("User Plugins");
            if (this.argLength == 0) {
                node.setUserObject("Control Panel");
            }
            this.populateNode(this.pluginsArray, null, node);
        }
        if (arg.equals("imagej menus")) {
            node = this.doRootFromMenus();
        }
        if (arg.equals("imagej commands")) {
            node = new DefaultMutableTreeNode("ImageJ Commands");
            if (this.argLength == 0) {
                node.setUserObject("Control Panel");
            }
            this.populateNode(this.commands, node);
        }
        if (arg.equals("about")) {
            this.showHelp();
        }
        return node;
    }

    private synchronized DefaultMutableTreeNode doRootFromMenus() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("ImageJ Menus");
        if (this.argLength == 0) {
            node.setUserObject("Control Panel");
        }
        MenuBar menuBar = Menus.getMenuBar();
        int i = 0;
        while (i < menuBar.getMenuCount()) {
            Menu menu = menuBar.getMenu(i);
            DefaultMutableTreeNode menuNode = new DefaultMutableTreeNode(menu.getLabel());
            this.recurseSubMenu(menu, menuNode);
            node.add(menuNode);
            ++i;
        }
        return node;
    }

    private void recurseSubMenu(Menu menu, DefaultMutableTreeNode node) {
        int items = menu.getItemCount();
        if (items == 0) {
            return;
        }
        int i = 0;
        while (i < items) {
            MenuItem mItem = menu.getItem(i);
            String label = mItem.getLabel();
            if (mItem instanceof Menu) {
                DefaultMutableTreeNode subNode = new DefaultMutableTreeNode(label);
                this.recurseSubMenu((Menu)mItem, subNode);
                node.add(subNode);
            } else if (mItem instanceof MenuItem && !label.equals("-")) {
                DefaultMutableTreeNode leaf = new DefaultMutableTreeNode(label);
                node.add(leaf);
                if (this.treeCommands == null) {
                    this.treeCommands = new Hashtable();
                }
                if (label.equals("Reload Plugins")) {
                    this.reloadMI = mItem;
                    this.treeCommands.put(label, "Reload Plugins From Panel");
                }
            }
            ++i;
        }
    }

    private void populateNode(Hashtable collection, DefaultMutableTreeNode node) {
        Vector<String> labelVector = new Vector<String>();
        Enumeration e = collection.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            labelVector.addElement(key);
        }
        Object[] labels = new String[labelVector.size()];
        String[] items = new String[labelVector.size()];
        labelVector.copyInto(labels);
        StringSorter.sort((String[])labels);
        int i = 0;
        while (i < labels.length) {
            items[i] = (String)collection.get(labels[i]);
            ++i;
        }
        this.populateNode(items, (String[])labels, node);
    }

    private void populateNode(String[] items, String[] labels, DefaultMutableTreeNode node) {
        if (items.length == 0 || items.length != labels.length) {
            return;
        }
        String label = null;
        int i = 0;
        while (i < items.length) {
            if (labels != null && i < labels.length) {
                label = labels[i];
            }
            this.buildTreePath(items[i], label, node);
            ++i;
        }
    }

    private void buildTreePath(String source, String label, DefaultMutableTreeNode topNode) {
        this.buildTreePath(source, label, null, topNode);
    }

    private void buildTreePath(String source, String label, String command, DefaultMutableTreeNode topNode) {
        String local = source;
        String argument = "";
        String delimiter = fileSeparator;
        int leftParen = source.indexOf(40);
        int rightParen = source.indexOf(41);
        if (leftParen > -1 && rightParen > leftParen) {
            argument = source.substring(leftParen + 1, rightParen);
            local = source.substring(0, leftParen);
        }
        if (local.startsWith(pluginsPath)) {
            local = local.substring(pluginsPath.length(), local.length());
        }
        local = local.replace('.', delimiter.charAt(0));
        if (argument.length() > 0) {
            local = local.concat(fileSeparator).concat(argument);
        }
        DefaultMutableTreeNode node = null;
        StringTokenizer pathParser = new StringTokenizer(local, delimiter);
        int tokens = pathParser.countTokens();
        while (pathParser.hasMoreTokens()) {
            String token = pathParser.nextToken();
            --tokens;
            if (topNode.isLeaf() && topNode.getAllowsChildren()) {
                if (token.indexOf("ControlPanel") != -1) continue;
                if (tokens == 0) {
                    if (label != null) {
                        token = label;
                    }
                    if ((token = token.replace('_', ' ')).endsWith(".class")) {
                        token = token.substring(0, token.length() - 6);
                    }
                }
                node = new DefaultMutableTreeNode(token);
                if (tokens == 0) {
                    String cmd;
                    String string = cmd = command == null ? token : command;
                    if (this.treeCommands == null) {
                        this.treeCommands = new Hashtable();
                    }
                    if (!this.treeCommands.containsKey(token)) {
                        this.treeCommands.put(token, cmd);
                    }
                }
                topNode.add(node);
                topNode = node;
                continue;
            }
            boolean hasTokenAsNode = false;
            Enumeration<TreeNode> nodes = topNode.children();
            while (nodes.hasMoreElements()) {
                node = (DefaultMutableTreeNode)nodes.nextElement();
                if (!((String)node.getUserObject()).equals(token)) continue;
                hasTokenAsNode = true;
                topNode = node;
                break;
            }
            if (hasTokenAsNode || token.indexOf("ControlPanel") != -1) continue;
            if (tokens == 0) {
                if (label != null) {
                    token = label;
                }
                if ((token = token.replace('_', ' ')).endsWith(".class")) {
                    token = token.substring(0, token.length() - 6);
                }
            }
            node = new DefaultMutableTreeNode(token);
            topNode.add(node);
            topNode = node;
        }
    }

    TreePanel newPanel(DefaultMutableTreeNode node) {
        boolean main = node.getUserObject().equals(this.root.getUserObject());
        TreePanel panel = new TreePanel(node, this, main);
        return panel;
    }

    TreePanel newPanel(DefaultMutableTreeNode node, Point location) {
        boolean main = node.getUserObject().equals(this.root.getUserObject());
        TreePanel panel = new TreePanel(node, this, main, location);
        return panel;
    }

    TreePanel newPanel(String path) {
        path = this.key2pStr(path);
        TreePanel pnl = null;
        Enumeration<TreeNode> e = this.root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            TreePath p = new TreePath(n.getPath());
            if (!p.toString().equals(path)) continue;
            pnl = this.newPanel(n);
        }
        return pnl;
    }

    boolean requiresDoubleClick() {
        return this.requireDoubleClick;
    }

    void setDoubleClick(boolean dc) {
        this.requireDoubleClick = dc;
    }

    boolean hasPanelForNode(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        return this.panels.containsKey(this.pStr2Key(path.toString()));
    }

    TreePanel getPanelForNode(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        String pathString = path.toString();
        if (this.panels.containsKey(this.pStr2Key(pathString))) {
            return (TreePanel)this.panels.get(this.pStr2Key(pathString));
        }
        return null;
    }

    String getPluginsPath() {
        return pluginsPath;
    }

    public String getVersion() {
        return pcpVersion;
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }

    Hashtable getPanels() {
        return this.panels;
    }

    Hashtable getTreeCommands() {
        return this.treeCommands;
    }

    boolean hasVisiblePanels() {
        return this.visiblePanels.size() > 0;
    }

    int getVisiblePanelsCount() {
        return this.visiblePanels.size();
    }

    void registerPanel(TreePanel panel) {
        String key = this.pStr2Key(panel.getRootPath().toString());
        this.panels.put(key, panel);
        this.setPanelShowingProperty(panel.getRootPath().toString());
        this.propertiesChanged = true;
    }

    void loadProperties() {
        this.visiblePanels.removeAllElements();
        this.expandedNodes.removeAllElements();
        this.panels.clear();
        try {
            if (this.pcpPropsFile.exists() && this.pcpPropsFile.canRead()) {
                this.pcpProperties.load(new FileInputStream(this.pcpPropsFile));
                Enumeration e = ((Hashtable)this.pcpProperties).keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (!key.startsWith("Control_Panel")) continue;
                    String val = this.pcpProperties.getProperty(key);
                    if (Character.isDigit(val.charAt(0))) {
                        this.visiblePanels.addElement(key);
                    }
                    if (!val.equals("expand")) continue;
                    this.expandedNodes.addElement(key);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void saveProperties() {
        if (this.propertiesChanged) {
            ((Hashtable)this.pcpProperties).clear();
            Enumeration e = this.visiblePanels.elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                TreePanel p = (TreePanel)this.panels.get(s);
                if (p == null) continue;
                this.recordGeometry(p);
            }
            Enumeration e2 = this.expandedNodes.elements();
            while (e2.hasMoreElements()) {
                this.pcpProperties.setProperty((String)e2.nextElement(), "expand");
            }
            try {
                if (this.pcpPropsFile.exists() && !this.pcpPropsFile.canWrite()) {
                    return;
                }
                this.pcpProperties.store(new FileOutputStream(this.pcpPropsFile), "Plugins Control Panel properties");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.propertiesChanged = false;
    }

    void setExpandedStateProperty(String item) {
        String s = this.pStr2Key(item);
        this.expandedNodes.addElement(s);
        this.propertiesChanged = true;
    }

    boolean hasExpandedStateProperty(String item) {
        String s = this.pStr2Key(item);
        return this.expandedNodes.contains(s);
    }

    void unsetExpandedStateProperty(String item) {
        String s = this.pStr2Key(item);
        this.expandedNodes.remove(s);
        this.propertiesChanged = true;
    }

    void setPanelShowingProperty(String item) {
        String s = this.pStr2Key(item);
        if (!this.visiblePanels.contains(s)) {
            this.visiblePanels.addElement(s);
        }
        this.propertiesChanged = true;
    }

    void unsetPanelShowingProperty(String item) {
        String s = this.pStr2Key(item);
        if (this.visiblePanels.remove(s)) {
            // empty if block
        }
        this.propertiesChanged = true;
    }

    boolean hasPanelShowingProperty(String item) {
        String s = this.pStr2Key(item);
        return this.visiblePanels.contains(s);
    }

    void restoreVisiblePanels() {
        Object[] visPanls = new String[this.visiblePanels.size()];
        this.visiblePanels.toArray(visPanls);
        Arrays.sort(visPanls);
        int i = 0;
        while (i < visPanls.length) {
            if (!this.panels.containsKey(visPanls[i])) {
                TreePanel treePanel = this.newPanel((String)visPanls[i]);
            }
            ++i;
        }
    }

    void recordGeometry(TreePanel panel) {
        String pTitle = panel.getRootPath().toString();
        pTitle = this.pStr2Key(pTitle);
        JFrame frame = panel.getFrame();
        if (frame != null) {
            Rectangle rect = frame.getBounds();
            String xCoord = new Integer(rect.x).toString();
            String yCoord = new Integer(rect.y).toString();
            String width = new Integer(rect.width).toString();
            String height = new Integer(rect.height).toString();
            String geometry = xCoord + " " + yCoord + " " + width + " " + height;
            this.pcpProperties.setProperty(pTitle, geometry);
        }
    }

    void restoreGeometry(TreePanel panel) {
        if (!((Hashtable)this.pcpProperties).isEmpty()) {
            String pTitle = panel.getRootPath().toString();
            if (((Hashtable)this.pcpProperties).containsKey(pTitle = this.pStr2Key(pTitle))) {
                String geom = this.pcpProperties.getProperty(pTitle);
                int[] coords = this.s2ints(geom);
                if (coords != null && coords.length == 4) {
                    panel.setBounds(coords[0], coords[1], coords[2], coords[3]);
                } else {
                    Point pnt = panel.getDefaultLocation();
                    if (pnt != null) {
                        ((Component)panel.getFrame()).setLocation((int)pnt.getX(), (int)pnt.getY());
                    }
                }
            }
        }
    }

    void closeAll(boolean die) {
        this.quitting = die;
        if (!this.visiblePanels.isEmpty()) {
            this.propertiesChanged = true;
            this.saveProperties();
        }
        Enumeration e = this.panels.elements();
        while (e.hasMoreElements()) {
            TreePanel p = (TreePanel)e.nextElement();
            p.close();
        }
        this.quitting = true;
    }

    void verifyQuit() {
        if (!this.quitting || this.visiblePanels.isEmpty()) {
            // empty if block
        }
    }

    void showHelp() {
        IJ.showMessage("About Control Panel...", "This plugin displays a panel with ImageJ commands in a hierarchical tree structure.\n \nUsage:\n \n     Click on a leaf node to launch the corresponding ImageJ command (or plugin)\n     (double-click on X Window Systems)\n \n     Double-click on a tree branch node (folder) to expand or collapse it\n \n     Click and drag on a tree branch node (folder) to display its descendants,\n     in a separate (child) panel (\"tear-off\" mock-up)\n \n     In a child panel, use the \"Show Parent\" menu item to re-open the parent panel\n     if it was accidentally closed\n \nVersion: 1.0g\nAuthor: Cezar M. Tigaret (c.tigaret@ucl.ac.uk)\nThis code is in the public domain.");
    }

    String pStr2Key(String pathString) {
        String keyword = pathString;
        if (keyword.startsWith("[")) {
            keyword = keyword.substring(keyword.indexOf("[") + 1, keyword.length());
        }
        if (keyword.endsWith("]")) {
            keyword = keyword.substring(0, keyword.lastIndexOf("]"));
        }
        StringTokenizer st = new StringTokenizer(keyword, ",");
        String result = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith(" ")) {
                token = token.substring(1, token.length());
            }
            result = result + token + ".";
        }
        result = result.substring(0, result.length() - 1);
        result = result.replace(' ', '_');
        return result;
    }

    String key2pStr(String keyword) {
        StringTokenizer st = new StringTokenizer(keyword, ".");
        String result = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            result = result + token + ", ";
        }
        result = result.substring(0, result.length() - 2);
        result = "[" + result + "]";
        result = result.replace('_', ' ');
        return result;
    }

    public int[] s2ints(String s) {
        StringTokenizer st = new StringTokenizer(s, ", \t");
        int nInts = st.countTokens();
        if (nInts == 0) {
            return null;
        }
        int[] ints = new int[nInts];
        int i = 0;
        while (i < nInts) {
            try {
                ints[i] = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException e) {
                return null;
            }
            ++i;
        }
        return ints;
    }
}

