/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.GelAnalyzer;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

class PlotsCanvas
extends ImageCanvas {
    public static final int MAX_PEAKS = 200;
    double[] actual = new double[]{428566.0, 351368.0, 233977.0, 99413.0, 60057.0, 31382.0, 14531.0, 7843.0, 2146.0, 752.0, 367.0};
    double[] measured = new double[200];
    Rectangle[] rect = new Rectangle[200];
    int counter;

    public PlotsCanvas(ImagePlus imp) {
        super(imp);
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            return;
        }
        if (roi.getType() == 5) {
            Roi.setColor(Color.blue);
        } else {
            Roi.setColor(Color.yellow);
        }
        if (Toolbar.getToolId() != 8 || IJ.spaceBarDown()) {
            return;
        }
        ImageStatistics s = this.imp.getStatistics();
        if (this.counter == 0) {
            IJ.setColumnHeadings(" \tArea");
        }
        double perimeter = roi.getLength();
        String error = "";
        double circularity = Math.PI * 4 * ((double)s.pixelCount / (perimeter * perimeter));
        if (circularity < 0.025) {
            error = " (error?)";
        }
        double area = (double)s.pixelCount + perimeter / 2.0;
        Calibration cal = this.imp.getCalibration();
        area = area * cal.pixelWidth * cal.pixelHeight;
        this.rect[this.counter] = roi.getBounds();
        IJ.write(this.counter + 1 + "\t" + IJ.d2s(area, 0) + error);
        this.measured[this.counter] = area;
        if (this.counter < 200) {
            ++this.counter;
        }
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() == 5) {
            Undo.setup(1, this.imp);
            this.imp.getProcessor().snapshot();
            roi.drawPixels();
            this.imp.updateAndDraw();
            this.imp.killRoi();
        }
    }

    void reset() {
        this.counter = 0;
    }

    void labelPeaks() {
        this.imp.killRoi();
        double total = 0.0;
        int i = 0;
        while (i < this.counter) {
            total += this.measured[i];
            ++i;
        }
        ImageProcessor ip = this.imp.getProcessor();
        ip.setFont(new Font("SansSerif", 0, 9));
        int i2 = 0;
        while (i2 < this.counter) {
            Rectangle r = this.rect[i2];
            String s = GelAnalyzer.labelWithPercentages ? IJ.d2s(this.measured[i2] / total * 100.0, 2) : IJ.d2s(this.measured[i2], 0);
            int swidth = ip.getStringWidth(s);
            int x = r.x + r.width / 2 - swidth / 2;
            int y = r.y + r.height * 3 / 4 + 9;
            int[] data = new int[swidth];
            ip.getRow(x, y, data, swidth);
            boolean fits = true;
            int j = 0;
            while (j < swidth) {
                if (data[j] != 255) {
                    fits = false;
                    break;
                }
                ++j;
            }
            boolean bl = fits = fits && this.measured[i2] > 500.0;
            if (r.height >= GelAnalyzer.plotHeight - 11) {
                fits = true;
            }
            if (!fits) {
                y = r.y - 2;
            }
            ip.drawString(s, x, y);
            ++i2;
        }
        this.imp.updateAndDraw();
        this.displayPercentages();
        this.reset();
    }

    void displayPercentages() {
        IJ.setColumnHeadings(" \tarea\tpercent");
        double total = 0.0;
        int i = 0;
        while (i < this.counter) {
            total += this.measured[i];
            ++i;
        }
        if (IJ.debugMode && this.counter == this.actual.length) {
            this.debug();
            return;
        }
        int i2 = 0;
        while (i2 < this.counter) {
            double percent = this.measured[i2] / total * 100.0;
            IJ.write(i2 + 1 + "\t" + IJ.d2s(this.measured[i2], 4) + "\t" + IJ.d2s(percent, 4));
            ++i2;
        }
    }

    void debug() {
        int i = 0;
        while (i < this.counter) {
            double a = this.actual[i] / this.actual[0] * 100.0;
            double m = this.measured[i] / this.measured[0] * 100.0;
            IJ.write(IJ.d2s(a, 4) + " " + IJ.d2s(m, 4) + " " + IJ.d2s((m - a) / m * 100.0, 4));
            ++i;
        }
    }
}

