/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.NewImage;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Slicer
implements PlugIn,
TextListener {
    private static final String[] starts = new String[]{"Top", "Left", "Bottom", "Right"};
    private static String startAt = starts[0];
    private static boolean rotate;
    private static boolean flip;
    private double outputZSpacing = 1.0;
    private int outputSlices = 1;
    private boolean noRoi;
    private boolean rgb;
    private Polygon irregularLine;
    private Vector fields;
    private Label message;
    private ImagePlus imp;
    private double gx1;
    private double gy1;
    private double gx2;
    private double gy2;
    private double gLength;
    private int n;
    private double[] x;
    private double[] y;
    private int xbase;
    private int ybase;
    private double length;
    private double segmentLength;
    private double[] segmentLengths;
    private double[] dx;
    private double[] dy;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        int stackSize = this.imp.getStackSize();
        if (stackSize < 2) {
            IJ.error("Reslicer", "Stack required");
            return;
        }
        if (!this.showDialog(this.imp)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        ImagePlus imp2 = null;
        this.rgb = this.imp.getType() == 4;
        imp2 = this.reslice(this.imp);
        if (imp2 == null) {
            return;
        }
        ImageProcessor ip = this.imp.getProcessor();
        double min = ip.getMin();
        double max = ip.getMax();
        imp2.setCalibration(this.imp.getCalibration());
        Calibration cal = imp2.getCalibration();
        cal.pixelDepth = this.outputZSpacing * cal.pixelWidth;
        if (!this.rgb) {
            imp2.getProcessor().setMinAndMax(min, max);
        }
        imp2.show();
        if (this.noRoi) {
            this.imp.killRoi();
        } else {
            this.imp.draw();
        }
        IJ.showStatus(IJ.d2s((double)(System.currentTimeMillis() - startTime) / 1000.0, 2) + " seconds");
    }

    public ImagePlus reslice(ImagePlus imp) {
        int roiType;
        Roi roi = imp.getRoi();
        int n = roiType = roi != null ? roi.getType() : 0;
        if (roi == null || roiType == 0 || roiType == 5) {
            return this.resliceRectOrLine(imp);
        }
        if (roiType == 6 || roiType == 7) {
            String status = imp.getStack().isVirtual() ? "" : null;
            IJ.showStatus("Reslice...");
            ImageProcessor ip2 = this.getSlice(imp, 0.0, 0.0, 0.0, 0.0, status);
            return new ImagePlus("Reslice of  " + imp.getShortTitle(), ip2);
        }
        IJ.error("Reslice...", "Line or rectangular selection required");
        return null;
    }

    boolean showDialog(ImagePlus imp) {
        boolean line;
        Calibration cal = imp.getCalibration();
        String units = cal.getUnits();
        if (cal.pixelWidth == 0.0) {
            cal.pixelWidth = 1.0;
        }
        double outputSpacing = cal.pixelDepth;
        Roi roi = imp.getRoi();
        boolean bl = line = roi != null && roi.getType() == 5;
        if (line) {
            this.saveLineInfo(roi);
        }
        GenericDialog gd = new GenericDialog("Reslice");
        gd.addNumericField("Input Z Spacing (" + units + "):", cal.pixelDepth, 3);
        gd.addNumericField("Output Z Spacing (" + units + "):", outputSpacing, 3);
        if (line) {
            gd.addNumericField("Slice Count:", this.outputSlices, 0);
        } else {
            gd.addChoice("Start At:", starts, startAt);
        }
        gd.addCheckbox("Flip Vertically", flip);
        gd.addCheckbox("Rotate 90 Degrees", rotate);
        gd.addMessage(this.getSize(cal.pixelDepth, outputSpacing, this.outputSlices) + "          ");
        this.fields = gd.getNumericFields();
        int i = 0;
        while (i < this.fields.size()) {
            ((TextField)this.fields.elementAt(i)).addTextListener(this);
            ++i;
        }
        this.message = (Label)gd.getMessage();
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        cal.pixelDepth = gd.getNextNumber();
        if (cal.pixelDepth == 0.0) {
            cal.pixelDepth = 1.0;
        }
        this.outputZSpacing = gd.getNextNumber() / cal.pixelWidth;
        if (line) {
            this.outputSlices = (int)gd.getNextNumber();
            imp.setRoi(roi);
        } else {
            startAt = gd.getNextChoice();
        }
        flip = gd.getNextBoolean();
        rotate = gd.getNextBoolean();
        return true;
    }

    void saveLineInfo(Roi roi) {
        Line line = (Line)roi;
        this.gx1 = line.x1;
        this.gy1 = line.y1;
        this.gx2 = line.x2;
        this.gy2 = line.y2;
        this.gLength = line.getRawLength();
    }

    ImagePlus resliceRectOrLine(ImagePlus imp) {
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double xInc = 0.0;
        double yInc = 0.0;
        this.noRoi = false;
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.noRoi = true;
            imp.setRoi(0, 0, imp.getWidth(), imp.getHeight());
            roi = imp.getRoi();
        }
        if (roi.getType() == 0) {
            Rectangle r = roi.getBounds();
            if (startAt.equals(starts[0])) {
                x1 = r.x;
                y1 = r.y;
                x2 = r.x + r.width;
                y2 = r.y;
                xInc = 0.0;
                yInc = this.outputZSpacing;
                this.outputSlices = (int)((double)r.height / this.outputZSpacing);
            } else if (startAt.equals(starts[1])) {
                x1 = r.x;
                y1 = r.y;
                x2 = r.x;
                y2 = r.y + r.height;
                xInc = this.outputZSpacing;
                yInc = 0.0;
                this.outputSlices = (int)((double)r.width / this.outputZSpacing);
            } else if (startAt.equals(starts[2])) {
                x1 = r.x;
                y1 = r.y + r.height;
                x2 = r.x + r.width;
                y2 = r.y + r.height;
                xInc = 0.0;
                yInc = -this.outputZSpacing;
                this.outputSlices = (int)((double)r.height / this.outputZSpacing);
            } else if (startAt.equals(starts[3])) {
                x1 = r.x + r.width;
                y1 = r.y;
                x2 = r.x + r.width;
                y2 = r.y + r.height;
                xInc = -this.outputZSpacing;
                yInc = 0.0;
                this.outputSlices = (int)((double)r.width / this.outputZSpacing);
            }
        } else if (roi.getType() == 5) {
            Line line = (Line)roi;
            x1 = line.x1;
            y1 = line.y1;
            x2 = line.x2;
            y2 = line.y2;
            double dx = x2 - x1;
            double dy = y2 - y1;
            double nrm = Math.sqrt(dx * dx + dy * dy) / this.outputZSpacing;
            xInc = -(dy / nrm);
            yInc = dx / nrm;
        } else {
            return null;
        }
        if (this.outputSlices == 0) {
            IJ.error("Reslicer", "Output Z spacing (" + IJ.d2s(this.outputZSpacing, 0) + " pixels) is too large.");
            return null;
        }
        boolean virtualStack = imp.getStack().isVirtual();
        String status = null;
        Object imp2 = null;
        ImageStack stack2 = null;
        IJ.resetEscape();
        int i = 0;
        while (i < this.outputSlices) {
            if (virtualStack) {
                status = this.outputSlices > 1 ? i + 1 + "/" + this.outputSlices + ", " : "";
            }
            ImageProcessor ip = this.getSlice(imp, x1, y1, x2, y2, status);
            this.drawLine(x1, y1, x2, y2, imp);
            if (stack2 == null && ((stack2 = this.createOutputStack(imp, ip)) == null || stack2.getSize() < this.outputSlices)) {
                return null;
            }
            stack2.setPixels(ip.getPixels(), i + 1);
            x1 += xInc;
            x2 += xInc;
            y1 += yInc;
            y2 += yInc;
            if (IJ.escapePressed()) {
                IJ.beep();
                imp.draw();
                return null;
            }
            ++i;
        }
        return new ImagePlus("Reslice of  " + imp.getShortTitle(), stack2);
    }

    ImageStack createOutputStack(ImagePlus imp, ImageProcessor ip) {
        int flags;
        int d2;
        int h2;
        int bitDepth = imp.getBitDepth();
        int w2 = ip.getWidth();
        ImagePlus imp2 = NewImage.createImage("temp", w2, h2 = ip.getHeight(), d2 = this.outputSlices, bitDepth, flags = 9);
        if (imp2 != null && imp2.getStackSize() == d2) {
            IJ.showStatus("Reslice... (press 'Esc' to abort)");
        }
        if (imp2 == null) {
            return null;
        }
        ImageStack stack2 = imp2.getStack();
        stack2.setColorModel(ip.getColorModel());
        return stack2;
    }

    ImageProcessor getSlice(ImagePlus imp, double x1, double y1, double x2, double y2, String status) {
        Roi roi = imp.getRoi();
        int roiType = roi != null ? roi.getType() : 0;
        ImageStack stack = imp.getStack();
        int stackSize = stack.getSize();
        ImageProcessor ip2 = null;
        float[] line = null;
        int i = 0;
        while (i < stackSize) {
            ImageProcessor ip = stack.getProcessor(flip ? stackSize - i : i + 1);
            line = roiType == 6 || roiType == 7 ? this.getIrregularProfile(roi, ip) : this.getLine(ip, x1, y1, x2, y2, line);
            if (rotate) {
                if (i == 0) {
                    ip2 = ip.createProcessor(stackSize, line.length);
                }
                this.putColumn(ip2, i, 0, line, line.length);
            } else {
                if (i == 0) {
                    ip2 = ip.createProcessor(line.length, stackSize);
                }
                this.putRow(ip2, 0, i, line, line.length);
            }
            if (status != null) {
                IJ.showStatus("Slicing: " + status + i + "/" + stackSize);
            }
            ++i;
        }
        Calibration cal = imp.getCalibration();
        double zSpacing = cal.pixelDepth / cal.pixelWidth;
        if (zSpacing != 1.0) {
            ip2.setInterpolate(true);
            ip2 = rotate ? ip2.resize((int)((double)stackSize * zSpacing), line.length) : ip2.resize(line.length, (int)((double)stackSize * zSpacing));
        }
        return ip2;
    }

    public void putRow(ImageProcessor ip, int x, int y, float[] data, int length) {
        if (this.rgb) {
            int i = 0;
            while (i < length) {
                ip.putPixel(x++, y, Float.floatToIntBits(data[i]));
                ++i;
            }
        } else {
            int i = 0;
            while (i < length) {
                ip.putPixelValue(x++, y, data[i]);
                ++i;
            }
        }
    }

    public void putColumn(ImageProcessor ip, int x, int y, float[] data, int length) {
        if (this.rgb) {
            int i = 0;
            while (i < length) {
                ip.putPixel(x, y++, Float.floatToIntBits(data[i]));
                ++i;
            }
        } else {
            int i = 0;
            while (i < length) {
                ip.putPixelValue(x, y++, data[i]);
                ++i;
            }
        }
    }

    float[] getIrregularProfile(Roi roi, ImageProcessor ip) {
        if (this.x == null) {
            this.doIrregularSetup(roi);
        }
        float[] values = new float[(int)this.length];
        double leftOver = 1.0;
        double distance = 0.0;
        double oldx = this.xbase;
        double oldy = this.ybase;
        int i = 0;
        while (i < this.n) {
            double len = this.segmentLengths[i];
            if (len != 0.0) {
                double xinc = this.dx[i] / len;
                double yinc = this.dy[i] / len;
                double start = 1.0 - leftOver;
                double rx = (double)this.xbase + this.x[i] + start * xinc;
                double ry = (double)this.ybase + this.y[i] + start * yinc;
                double len2 = len - start;
                int n2 = (int)len2;
                int j = 0;
                while (j <= n2) {
                    int index = (int)distance + j;
                    if (index < values.length) {
                        if (this.rgb) {
                            int rgbPixel = ((ColorProcessor)ip).getInterpolatedRGBPixel(rx, ry);
                            values[index] = Float.intBitsToFloat(rgbPixel & 0xFFFFFF);
                        } else {
                            values[index] = (float)ip.getInterpolatedValue(rx, ry);
                        }
                    }
                    rx += xinc;
                    ry += yinc;
                    ++j;
                }
                distance += len;
                leftOver = len2 - (double)n2;
            }
            ++i;
        }
        return values;
    }

    void doIrregularSetup(Roi roi) {
        this.n = ((PolygonRoi)roi).getNCoordinates();
        int[] ix = ((PolygonRoi)roi).getXCoordinates();
        int[] iy = ((PolygonRoi)roi).getYCoordinates();
        this.x = new double[this.n];
        this.y = new double[this.n];
        int i = 0;
        while (i < this.n) {
            this.x[i] = ix[i];
            this.y[i] = iy[i];
            ++i;
        }
        if (roi.getType() == 7) {
            int i2 = 1;
            while (i2 < this.n - 1) {
                this.x[i2] = (this.x[i2 - 1] + this.x[i2] + this.x[i2 + 1]) / 3.0 + 0.5;
                this.y[i2] = (this.y[i2 - 1] + this.y[i2] + this.y[i2 + 1]) / 3.0 + 0.5;
                ++i2;
            }
        }
        Rectangle r = roi.getBounds();
        this.xbase = r.x;
        this.ybase = r.y;
        this.length = 0.0;
        this.segmentLengths = new double[this.n];
        this.dx = new double[this.n];
        this.dy = new double[this.n];
        int i3 = 0;
        while (i3 < this.n - 1) {
            double xdelta = this.x[i3 + 1] - this.x[i3];
            double ydelta = this.y[i3 + 1] - this.y[i3];
            double segmentLength = Math.sqrt(xdelta * xdelta + ydelta * ydelta);
            this.length += segmentLength;
            this.segmentLengths[i3] = segmentLength;
            this.dx[i3] = xdelta;
            this.dy[i3] = ydelta;
            ++i3;
        }
    }

    private float[] getLine(ImageProcessor ip, double x1, double y1, double x2, double y2, float[] data) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        int n = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
        if (data == null) {
            data = new float[n];
        }
        double xinc = dx / (double)n;
        double yinc = dy / (double)n;
        double rx = x1;
        double ry = y1;
        int i = 0;
        while (i < n) {
            if (this.rgb) {
                int rgbPixel = ((ColorProcessor)ip).getInterpolatedRGBPixel(rx, ry);
                data[i] = Float.intBitsToFloat(rgbPixel & 0xFFFFFF);
            } else {
                data[i] = (float)ip.getInterpolatedValue(rx, ry);
            }
            rx += xinc;
            ry += yinc;
            ++i;
        }
        return data;
    }

    void drawLine(double x1, double y1, double x2, double y2, ImagePlus imp) {
        ImageWindow win = imp.getWindow();
        if (win == null) {
            return;
        }
        ImageCanvas ic = win.getCanvas();
        Graphics g = ic.getGraphics();
        g.setColor(Roi.getColor());
        g.setXORMode(Color.black);
        g.drawLine(ic.screenX((int)(x1 + 0.5)), ic.screenY((int)(y1 + 0.5)), ic.screenX((int)(x2 + 0.5)), ic.screenY((int)(y2 + 0.5)));
    }

    public void textValueChanged(TextEvent e) {
        boolean lineSelection;
        double inSpacing = Tools.parseDouble(((TextField)this.fields.elementAt(0)).getText(), 0.0);
        double outSpacing = Tools.parseDouble(((TextField)this.fields.elementAt(1)).getText(), 0.0);
        int count = 0;
        boolean bl = lineSelection = this.fields.size() == 3;
        if (lineSelection && (count = (int)Tools.parseDouble(((TextField)this.fields.elementAt(2)).getText(), 0.0)) > 0) {
            this.makePolygon(count, outSpacing);
        }
        String size = this.getSize(inSpacing, outSpacing, count);
        this.message.setText(size);
    }

    String getSize(double inSpacing, double outSpacing, int count) {
        String available;
        int size = this.getOutputStackSize(inSpacing, outSpacing, count);
        int mem = this.getAvailableMemory();
        String string = available = mem != -1 ? " (" + mem + "MB)" : "";
        if (this.message != null) {
            this.message.setForeground(mem != -1 && size > mem ? Color.red : Color.black);
        }
        if (size > 0) {
            return size + "MB" + available;
        }
        return "<1MB" + available;
    }

    void makePolygon(int count, double outSpacing) {
        int[] x = new int[4];
        int[] y = new int[4];
        x[0] = (int)this.gx1;
        y[0] = (int)this.gy1;
        x[1] = (int)this.gx2;
        y[1] = (int)this.gy2;
        double dx = this.gx2 - this.gx1;
        double dy = this.gy2 - this.gy1;
        double nrm = Math.sqrt(dx * dx + dy * dy) / outSpacing;
        double xInc = -(dy / nrm);
        double yInc = dx / nrm;
        x[2] = x[1] + (int)(xInc * (double)count);
        y[2] = y[1] + (int)(yInc * (double)count);
        x[3] = x[0] + (int)(xInc * (double)count);
        y[3] = y[0] + (int)(yInc * (double)count);
        this.imp.setRoi(new PolygonRoi(x, y, 4, 3));
    }

    int getOutputStackSize(double inSpacing, double outSpacing, int count) {
        Roi roi = this.imp.getRoi();
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        if (roi != null) {
            Rectangle r = roi.getBounds();
            width = r.width;
            width = r.height;
        }
        int type = roi != null ? roi.getType() : 0;
        int stackSize = this.imp.getStackSize();
        double size = 0.0;
        if (type == 0) {
            size = width * height * stackSize;
            if (outSpacing > 0.0) {
                size /= outSpacing;
            }
        } else {
            size = this.gLength * (double)count * (double)stackSize;
        }
        Calibration cal = this.imp.getCalibration();
        double zSpacing = inSpacing / cal.pixelWidth;
        if (zSpacing != 0.0 && zSpacing != 1.0) {
            size *= zSpacing;
        }
        return (int)Math.round(size / 1048576.0);
    }

    int getAvailableMemory() {
        long max = IJ.maxMemory();
        if (max == 0L) {
            return -1;
        }
        long inUse = IJ.currentMemory();
        long available = max - inUse;
        return (int)((available + 524288L) / 0x100000L);
    }
}

