/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.plugin.RGBStackMerge;
import ij.plugin.filter.RGBStackSplitter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class ZProjector
implements PlugIn {
    public static final int AVG_METHOD = 0;
    public static final int MAX_METHOD = 1;
    public static final int MIN_METHOD = 2;
    public static final int SUM_METHOD = 3;
    public static final int SD_METHOD = 4;
    public static final int MEDIAN_METHOD = 5;
    public static final String[] METHODS = new String[]{"Average Intensity", "Max Intensity", "Min Intensity", "Sum Slices", "Standard Deviation", "Median"};
    private static int method = 0;
    private static final int BYTE_TYPE = 0;
    private static final int SHORT_TYPE = 1;
    private static final int FLOAT_TYPE = 2;
    public static final String lutMessage = "Stacks with inverter LUTs may not project correctly.\nTo create a standard LUT, invert the stack (Edit/Invert)\nand invert the LUT (Image/Lookup Tables/Invert LUT).";
    private ImagePlus projImage = null;
    private ImagePlus imp = null;
    private int startSlice = 1;
    private int stopSlice = 1;
    private String color = "";
    static /* synthetic */ Class class$ij$plugin$ZProjector;

    public ZProjector() {
    }

    public ZProjector(ImagePlus imp) {
        this.setImage(imp);
    }

    public void setImage(ImagePlus imp) {
        this.imp = imp;
        this.startSlice = 1;
        this.stopSlice = imp.getStackSize();
    }

    public void setStartSlice(int slice) {
        if (this.imp == null || slice < 1 || slice > this.imp.getStackSize()) {
            return;
        }
        this.startSlice = slice;
    }

    public void setStopSlice(int slice) {
        if (this.imp == null || slice < 1 || slice > this.imp.getStackSize()) {
            return;
        }
        this.stopSlice = slice;
    }

    public void setMethod(int projMethod) {
        method = projMethod;
    }

    public ImagePlus getProjection() {
        return this.projImage;
    }

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (this.imp.getStackSize() == 1) {
            IJ.error("ZProjection", "Stack required");
            return;
        }
        if (this.imp.getProcessor().isInvertedLut() && !IJ.showMessageWithCancel("ZProjection", lutMessage)) {
            return;
        }
        this.startSlice = 1;
        this.stopSlice = this.imp.getStackSize();
        GenericDialog gd = this.buildControlDialog(this.startSlice, this.stopSlice);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        long tstart = System.currentTimeMillis();
        this.setStartSlice((int)gd.getNextNumber());
        this.setStopSlice((int)gd.getNextNumber());
        method = gd.getNextChoiceIndex();
        if (this.imp.getType() == 4) {
            if (method == 3 || method == 4 || method == 5) {
                IJ.error("ZProjection", "Sum, StdDev and Median methods \nnot available with RGB stacks.");
                this.imp.unlock();
                return;
            }
            this.doRGBProjection();
        } else {
            this.doProjection();
        }
        if (arg.equals("")) {
            long tstop = System.currentTimeMillis();
            this.projImage.setCalibration(this.imp.getCalibration());
            this.projImage.show("ZProjector: " + IJ.d2s((double)(tstop - tstart) / 1000.0, 2) + " seconds");
        }
        this.imp.unlock();
        IJ.register(class$ij$plugin$ZProjector == null ? (class$ij$plugin$ZProjector = ZProjector.class$("ij.plugin.ZProjector")) : class$ij$plugin$ZProjector);
    }

    public void doRGBProjection() {
        RGBStackSplitter splitter = new RGBStackSplitter();
        splitter.split(this.imp.getStack(), true);
        ImagePlus red = new ImagePlus("Red", splitter.red);
        ImagePlus green = new ImagePlus("Green", splitter.green);
        ImagePlus blue = new ImagePlus("Blue", splitter.blue);
        this.imp.unlock();
        ImagePlus saveImp = this.imp;
        this.imp = red;
        this.color = "(red)";
        this.doProjection();
        ImagePlus red2 = this.projImage;
        this.imp = green;
        this.color = "(green)";
        this.doProjection();
        ImagePlus green2 = this.projImage;
        this.imp = blue;
        this.color = "(blue)";
        this.doProjection();
        ImagePlus blue2 = this.projImage;
        int w = red2.getWidth();
        int h = red2.getHeight();
        int d = red2.getStackSize();
        RGBStackMerge merge = new RGBStackMerge();
        ImageStack stack = merge.mergeStacks(w, h, d, red2.getStack(), green2.getStack(), blue2.getStack(), true);
        this.imp = saveImp;
        this.projImage = new ImagePlus("ZProjection of " + this.imp.getShortTitle(), stack);
    }

    protected GenericDialog buildControlDialog(int start, int stop) {
        GenericDialog gd = new GenericDialog("ZProjection", IJ.getInstance());
        gd.addNumericField("Start slice:", this.startSlice, 0);
        gd.addNumericField("Stop slice:", this.stopSlice, 0);
        gd.addChoice("Projection Type", METHODS, METHODS[method]);
        return gd;
    }

    public void doProjection() {
        int ptype;
        if (this.imp == null) {
            return;
        }
        if (method == 5) {
            this.projImage = this.doMedianProjection();
            return;
        }
        FloatProcessor fp = new FloatProcessor(this.imp.getWidth(), this.imp.getHeight());
        ImageStack stack = this.imp.getStack();
        RayFunction rayFunc = this.getRayFunction(method, fp);
        if (IJ.debugMode) {
            IJ.log("\nProjecting stack from: " + this.startSlice + " to: " + this.stopSlice);
        }
        if (stack.getProcessor(1) instanceof ByteProcessor) {
            ptype = 0;
        } else if (stack.getProcessor(1) instanceof ShortProcessor) {
            ptype = 1;
        } else if (stack.getProcessor(1) instanceof FloatProcessor) {
            ptype = 2;
        } else {
            IJ.error("ZProjector: Unknown processor type.");
            return;
        }
        int n = this.startSlice;
        while (n <= this.stopSlice) {
            IJ.showStatus("ZProjection " + this.color + ": " + n + "/" + this.stopSlice);
            IJ.showProgress(n - this.startSlice, this.stopSlice - this.startSlice);
            this.projectSlice(stack.getPixels(n), rayFunc, ptype);
            ++n;
        }
        if (method == 3) {
            fp.resetMinAndMax();
            this.projImage = new ImagePlus("Sum", fp);
        } else if (method == 4) {
            rayFunc.postProcess();
            fp.resetMinAndMax();
            this.projImage = new ImagePlus("Standard Deviation", fp);
        } else {
            rayFunc.postProcess();
            this.projImage = this.makeOutputImage(this.imp, fp, ptype);
        }
        if (this.projImage == null) {
            IJ.error("ZProjection - error computing projection.");
        }
    }

    private RayFunction getRayFunction(int method, FloatProcessor fp) {
        switch (method) {
            case 0: 
            case 3: {
                return new AverageIntensity(fp, this.stopSlice - this.startSlice + 1);
            }
            case 1: {
                return new MaxIntensity(fp);
            }
            case 2: {
                return new MinIntensity(fp);
            }
            case 4: {
                return new StandardDeviation(fp, this.stopSlice - this.startSlice + 1);
            }
        }
        IJ.error("ZProjection - unknown method.");
        return null;
    }

    private ImagePlus makeOutputImage(ImagePlus imp, FloatProcessor fp, int ptype) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        float[] pixels = (float[])fp.getPixels();
        ImageProcessor oip = null;
        int size = pixels.length;
        switch (ptype) {
            case 0: {
                oip = imp.getProcessor().createProcessor(width, height);
                byte[] pixels8 = (byte[])oip.getPixels();
                int i = 0;
                while (i < size) {
                    pixels8[i] = (byte)pixels[i];
                    ++i;
                }
                break;
            }
            case 1: {
                oip = imp.getProcessor().createProcessor(width, height);
                short[] pixels16 = (short[])oip.getPixels();
                int i = 0;
                while (i < size) {
                    pixels16[i] = (short)pixels[i];
                    ++i;
                }
                break;
            }
            case 2: {
                oip = new FloatProcessor(width, height, pixels, null);
            }
        }
        oip.resetMinAndMax();
        return new ImagePlus("ZProjection of " + imp.getShortTitle(), oip);
    }

    private void projectSlice(Object pixelArray, RayFunction rayFunc, int ptype) {
        switch (ptype) {
            case 0: {
                rayFunc.projectSlice((byte[])pixelArray);
                break;
            }
            case 1: {
                rayFunc.projectSlice((short[])pixelArray);
                break;
            }
            case 2: {
                rayFunc.projectSlice((float[])pixelArray);
            }
        }
    }

    ImagePlus doMedianProjection() {
        IJ.showStatus("Calculating median...");
        ImageStack stack = this.imp.getStack();
        int nSlices = this.stopSlice - this.startSlice + 1;
        ImageProcessor[] slices = new ImageProcessor[nSlices];
        int index = 0;
        int slice = this.startSlice;
        while (slice <= this.stopSlice) {
            slices[index++] = stack.getProcessor(slice);
            ++slice;
        }
        ImageProcessor ip2 = slices[0].duplicate();
        ip2 = ip2.convertToFloat();
        float[] values = new float[nSlices];
        int width = ip2.getWidth();
        int height = ip2.getHeight();
        int inc = Math.min(height / 30, 1);
        int y = 0;
        while (y < height) {
            if (y % inc == 0) {
                IJ.showProgress(y, height - 1);
            }
            int x = 0;
            while (x < width) {
                int i = 0;
                while (i < nSlices) {
                    values[i] = slices[i].getPixelValue(x, y);
                    ++i;
                }
                ip2.putPixelValue(x, y, this.median(values));
                ++x;
            }
            ++y;
        }
        return new ImagePlus("Median of " + this.imp.getShortTitle(), ip2);
    }

    float median(float[] a) {
        this.sort(a);
        int length = a.length;
        if ((length & 1) == 0) {
            return (a[length / 2 - 1] + a[length / 2]) / 2.0f;
        }
        return a[length / 2];
    }

    void sort(float[] a) {
        if (!this.alreadySorted(a)) {
            this.sort(a, 0, a.length - 1);
        }
    }

    void sort(float[] a, int from, int to) {
        int i = from;
        int j = to;
        float center = a[(from + to) / 2];
        while (true) {
            if (i < to && center > a[i]) {
                ++i;
                continue;
            }
            while (j > from && center < a[j]) {
                --j;
            }
            if (i < j) {
                float temp = a[i];
                a[i] = a[j];
                a[j] = temp;
            }
            if (i <= j) {
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (from < j) {
            this.sort(a, from, j);
        }
        if (i < to) {
            this.sort(a, i, to);
        }
    }

    boolean alreadySorted(float[] a) {
        int i = 1;
        while (i < a.length) {
            if (a[i] < a[i - 1]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class StandardDeviation
    extends RayFunction {
        FloatProcessor fp;
        private float[] sum;
        private float[] sum2;
        private int num;
        private int len;

        public StandardDeviation(FloatProcessor fp, int num) {
            this.sum = (float[])fp.getPixels();
            this.len = this.sum.length;
            this.sum2 = new float[this.len];
            this.num = num;
        }

        public void projectSlice(byte[] pixels) {
            int i = 0;
            while (i < this.len) {
                int v = pixels[i] & 0xFF;
                int n = i;
                this.sum[n] = this.sum[n] + (float)v;
                int n2 = i++;
                this.sum2[n2] = this.sum2[n2] + (float)(v * v);
            }
        }

        public void projectSlice(short[] pixels) {
            int i = 0;
            while (i < this.len) {
                int v = pixels[i] & 0xFFFF;
                int n = i;
                this.sum[n] = this.sum[n] + (float)v;
                int n2 = i++;
                this.sum2[n2] = this.sum2[n2] + (float)(v * v);
            }
        }

        public void projectSlice(float[] pixels) {
            int i = 0;
            while (i < this.len) {
                float v = pixels[i];
                int n = i;
                this.sum[n] = this.sum[n] + v;
                int n2 = i++;
                this.sum2[n2] = this.sum2[n2] + v * v;
            }
        }

        public void postProcess() {
            double n = this.num;
            int i = 0;
            while (i < this.len) {
                double stdDev;
                this.sum[i] = this.num > 1 ? ((stdDev = (n * (double)this.sum2[i] - (double)(this.sum[i] * this.sum[i])) / n) > 0.0 ? (float)Math.sqrt(stdDev / (n - 1.0)) : 0.0f) : 0.0f;
                ++i;
            }
        }
    }

    class MinIntensity
    extends RayFunction {
        private FloatProcessor fp;
        private float[] fpixels;
        private int len;

        public MinIntensity(FloatProcessor fp) {
            this.fpixels = (float[])fp.getPixels();
            this.len = this.fpixels.length;
            int i = 0;
            while (i < this.len) {
                this.fpixels[i] = Float.MAX_VALUE;
                ++i;
            }
        }

        public void projectSlice(byte[] pixels) {
            int i = 0;
            while (i < this.len) {
                if ((float)(pixels[i] & 0xFF) < this.fpixels[i]) {
                    this.fpixels[i] = pixels[i] & 0xFF;
                }
                ++i;
            }
        }

        public void projectSlice(short[] pixels) {
            int i = 0;
            while (i < this.len) {
                if ((float)(pixels[i] & 0xFFFF) < this.fpixels[i]) {
                    this.fpixels[i] = pixels[i] & 0xFFFF;
                }
                ++i;
            }
        }

        public void projectSlice(float[] pixels) {
            int i = 0;
            while (i < this.len) {
                if (pixels[i] < this.fpixels[i]) {
                    this.fpixels[i] = pixels[i];
                }
                ++i;
            }
        }
    }

    class MaxIntensity
    extends RayFunction {
        private FloatProcessor fp;
        private float[] fpixels;
        private int len;

        public MaxIntensity(FloatProcessor fp) {
            this.fpixels = (float[])fp.getPixels();
            this.len = this.fpixels.length;
            int i = 0;
            while (i < this.len) {
                this.fpixels[i] = -3.4028235E38f;
                ++i;
            }
        }

        public void projectSlice(byte[] pixels) {
            int i = 0;
            while (i < this.len) {
                if ((float)(pixels[i] & 0xFF) > this.fpixels[i]) {
                    this.fpixels[i] = pixels[i] & 0xFF;
                }
                ++i;
            }
        }

        public void projectSlice(short[] pixels) {
            int i = 0;
            while (i < this.len) {
                if ((float)(pixels[i] & 0xFFFF) > this.fpixels[i]) {
                    this.fpixels[i] = pixels[i] & 0xFFFF;
                }
                ++i;
            }
        }

        public void projectSlice(float[] pixels) {
            int i = 0;
            while (i < this.len) {
                if (pixels[i] > this.fpixels[i]) {
                    this.fpixels[i] = pixels[i];
                }
                ++i;
            }
        }
    }

    class AverageIntensity
    extends RayFunction {
        private float[] fpixels;
        private int num;
        private int len;

        public AverageIntensity(FloatProcessor fp, int num) {
            this.fpixels = (float[])fp.getPixels();
            this.len = this.fpixels.length;
            this.num = num;
        }

        public void projectSlice(byte[] pixels) {
            int i = 0;
            while (i < this.len) {
                int n = i;
                this.fpixels[n] = this.fpixels[n] + (float)(pixels[i] & 0xFF);
                ++i;
            }
        }

        public void projectSlice(short[] pixels) {
            int i = 0;
            while (i < this.len) {
                int n = i;
                this.fpixels[n] = this.fpixels[n] + (float)(pixels[i] & 0xFFFF);
                ++i;
            }
        }

        public void projectSlice(float[] pixels) {
            int i = 0;
            while (i < this.len) {
                int n = i;
                this.fpixels[n] = this.fpixels[n] + pixels[i];
                ++i;
            }
        }

        public void postProcess() {
            float fnum = this.num;
            int i = 0;
            while (i < this.len) {
                int n = i++;
                this.fpixels[n] = this.fpixels[n] / fnum;
            }
        }
    }

    abstract class RayFunction {
        RayFunction() {
        }

        public abstract void projectSlice(byte[] var1);

        public abstract void projectSlice(short[] var1);

        public abstract void projectSlice(float[] var1);

        public void postProcess() {
        }
    }
}

