/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import java.awt.Point;
import java.awt.Rectangle;

public class Zoom
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        ImageWindow win = imp.getWindow();
        if (win == null) {
            return;
        }
        ImageCanvas ic = win.getCanvas();
        Point loc = ic.getCursorLoc();
        int x = ic.screenX(loc.x);
        int y = ic.screenY(loc.y);
        if (arg.equals("in")) {
            ic.zoomIn(x, y);
            if (ic.getMagnification() <= 1.0) {
                imp.repaintWindow();
            }
        } else if (arg.equals("out")) {
            ic.zoomOut(x, y);
            if (ic.getMagnification() < 1.0) {
                imp.repaintWindow();
            }
        } else if (arg.equals("orig")) {
            ic.unzoom();
        } else if (arg.equals("100%")) {
            while (ic.getMagnification() < 1.0) {
                ic.zoomIn(0, 0);
            }
            while (ic.getMagnification() > 1.0) {
                ic.zoomOut(0, 0);
            }
        } else if (arg.equals("to")) {
            this.zoomToSelection(imp, ic);
        }
    }

    void zoomToSelection(ImagePlus imp, ImageCanvas ic) {
        Roi roi = imp.getRoi();
        if (roi == null) {
            IJ.error("Zoom", "Selection required");
            return;
        }
        Rectangle w = imp.getWindow().getBounds();
        Rectangle r = roi.getBounds();
        int x = r.x + r.width / 2;
        int y = r.y + r.height / 2;
        double mag = ImageCanvas.getHigherZoomLevel(ic.getMagnification());
        while ((double)r.width * mag < (double)w.width && (double)r.height * mag < (double)w.height) {
            ic.zoomIn(ic.screenX(x), ic.screenY(y));
            mag = ImageCanvas.getHigherZoomLevel(ic.getMagnification());
            w = imp.getWindow().getBounds();
        }
        while ((double)r.width * mag > (double)w.width || (double)r.height * mag > (double)w.height) {
            ic.zoomOut(ic.screenX(x), ic.screenY(y));
            mag = ImageCanvas.getHigherZoomLevel(ic.getMagnification());
            w = imp.getWindow().getBounds();
        }
    }
}

