/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class Binary
implements PlugInFilter {
    String arg;
    ImagePlus imp;
    static int iterations = 1;
    static int count = 1;
    static boolean blackBackground = Prefs.blackBackground;
    int foreground;
    int background;
    static /* synthetic */ Class class$ij$plugin$filter$Binary;

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        IJ.register(class$ij$plugin$filter$Binary == null ? (class$ij$plugin$filter$Binary = Binary.class$("ij.plugin.filter.Binary")) : class$ij$plugin$filter$Binary);
        if (arg.equals("options")) {
            this.showDialog();
            return 4096;
        }
        if (arg.equals("outline") || arg.equals("skel")) {
            if (imp != null && (imp.getType() == 0 || imp.getType() == 3)) {
                ImageStatistics stats = imp.getStatistics();
                if (stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
                    IJ.error("8-bit binary (black and white only) image required.");
                    return 4096;
                }
            }
            return IJ.setupDialog(imp, 67);
        }
        return IJ.setupDialog(imp, 83);
    }

    public void run(ImageProcessor ip) {
        int n = this.foreground = blackBackground ? 255 : 0;
        if (ip.isInvertedLut()) {
            this.foreground = 255 - this.foreground;
        }
        this.background = 255 - this.foreground;
        if (this.arg.equals("erode")) {
            this.erode(ip);
        } else if (this.arg.equals("dilate")) {
            this.dilate(ip);
        } else if (this.arg.equals("open")) {
            this.open(ip);
        } else if (this.arg.equals("close")) {
            this.close(ip);
        } else if (this.arg.equals("outline")) {
            this.outline(ip);
        } else if (this.arg.equals("skel")) {
            this.skeletonize(ip);
        }
    }

    void erode(ImageProcessor ip) {
        int i = 0;
        while (i < iterations) {
            ((ByteProcessor)ip).erode(count, this.background);
            ++i;
        }
    }

    void dilate(ImageProcessor ip) {
        int i = 0;
        while (i < iterations) {
            ((ByteProcessor)ip).dilate(count, this.background);
            ++i;
        }
    }

    void open(ImageProcessor ip) {
        int i = 0;
        while (i < iterations) {
            ((ByteProcessor)ip).erode(count, this.background);
            ++i;
        }
        int i2 = 0;
        while (i2 < iterations) {
            ((ByteProcessor)ip).dilate(count, this.background);
            ++i2;
        }
    }

    void close(ImageProcessor ip) {
        int i = 0;
        while (i < iterations) {
            ((ByteProcessor)ip).dilate(count, this.background);
            ++i;
        }
        int i2 = 0;
        while (i2 < iterations) {
            ((ByteProcessor)ip).erode(count, this.background);
            ++i2;
        }
    }

    void outline(ImageProcessor ip) {
        if (blackBackground) {
            ip.invert();
        }
        ((ByteProcessor)ip).outline();
        if (blackBackground) {
            ip.invert();
        }
    }

    void skeletonize(ImageProcessor ip) {
        if (blackBackground) {
            ip.invert();
        }
        boolean edgePixels = this.hasEdgePixels(ip);
        ImageProcessor ip2 = this.expand(ip, edgePixels);
        ((ByteProcessor)ip2).skeletonize();
        ip = this.shrink(ip, ip2, edgePixels);
        if (blackBackground) {
            ip.invert();
        }
    }

    void showDialog() {
        GenericDialog gd = new GenericDialog("Binary Options");
        gd.addNumericField("Iterations (1-25):", iterations, 0, 3, "");
        gd.addNumericField("Count (1-8):", count, 0, 3, "");
        gd.addCheckbox("Black Background", blackBackground);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int n = (int)gd.getNextNumber();
        Prefs.blackBackground = blackBackground = gd.getNextBoolean();
        if (n > 25) {
            n = 25;
        }
        if (n < 1) {
            n = 1;
        }
        iterations = n;
        count = (int)gd.getNextNumber();
        if (count < 1) {
            count = 1;
        }
        if (count > 8) {
            count = 8;
        }
    }

    boolean hasEdgePixels(ImageProcessor ip) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        boolean edgePixels = false;
        int x = 0;
        while (x < width) {
            if (ip.getPixel(x, 0) == this.foreground) {
                edgePixels = true;
            }
            ++x;
        }
        int x2 = 0;
        while (x2 < width) {
            if (ip.getPixel(x2, height - 1) == this.foreground) {
                edgePixels = true;
            }
            ++x2;
        }
        int y = 0;
        while (y < height) {
            if (ip.getPixel(0, y) == this.foreground) {
                edgePixels = true;
            }
            ++y;
        }
        int y2 = 0;
        while (y2 < height) {
            if (ip.getPixel(height - 1, y2) == this.foreground) {
                edgePixels = true;
            }
            ++y2;
        }
        return edgePixels;
    }

    ImageProcessor expand(ImageProcessor ip, boolean hasEdgePixels) {
        if (hasEdgePixels) {
            ImageProcessor ip2 = ip.createProcessor(ip.getWidth() + 2, ip.getHeight() + 2);
            if (this.foreground == 0) {
                ip2.setColor(255);
                ip2.fill();
            }
            ip2.insert(ip, 1, 1);
            return ip2;
        }
        return ip;
    }

    ImageProcessor shrink(ImageProcessor ip, ImageProcessor ip2, boolean hasEdgePixels) {
        if (hasEdgePixels) {
            int width = ip.getWidth();
            int height = ip.getHeight();
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    ip.putPixel(x, y, ip2.getPixel(x + 1, y + 1));
                    ++x;
                }
                ++y;
            }
        }
        return ip;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

