/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.plugin.TextReader;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class Convolver
implements PlugInFilter,
ActionListener {
    static final int BYTE = 0;
    static final int SHORT = 1;
    static final int FLOAT = 2;
    static final int RGB = 3;
    ImagePlus imp;
    int kw;
    int kh;
    int slice = 1;
    boolean canceled;
    float[] kernel;
    boolean isLineRoi;
    Button open;
    Button save;
    GenericDialog gd;
    static String kernelText = "-1 -1 -1 -1 -1\n-1 -1 -1 -1 -1\n-1 -1 24 -1 -1\n-1 -1 -1 -1 -1\n-1 -1 -1 -1 -1\n";
    static boolean normalize = true;
    static /* synthetic */ Class class$ij$plugin$filter$Convolver;

    public int setup(String arg, ImagePlus imp) {
        IJ.register(class$ij$plugin$filter$Convolver == null ? (class$ij$plugin$filter$Convolver = Convolver.class$("ij.plugin.filter.Convolver")) : class$ij$plugin$filter$Convolver);
        this.imp = imp;
        this.canceled = false;
        if (imp == null) {
            IJ.noImage();
            return 4096;
        }
        IJ.resetEscape();
        Roi roi = imp.getRoi();
        this.isLineRoi = roi != null && roi.isLine();
        this.kernel = this.getKernel();
        if (this.kernel == null) {
            return 4096;
        }
        if ((this.kw & 1) == 0) {
            IJ.error("Convolver", "The kernel must be square and have an\nodd width. This kernel is " + this.kw + "x" + this.kh + ".");
            return 4096;
        }
        int flags = IJ.setupDialog(imp, 31);
        if ((flags & 0x1000) != 0) {
            return 4096;
        }
        IJ.showStatus("Convolve: " + this.kw + "x" + this.kh + " kernel");
        imp.startTiming();
        return flags;
    }

    public void run(ImageProcessor ip) {
        if (this.canceled) {
            return;
        }
        if (this.isLineRoi) {
            ip.resetRoi();
        }
        this.convolve(ip, this.kernel, this.kw, this.kh);
        if (this.slice > 1) {
            IJ.showStatus("Convolve: " + this.slice + "/" + this.imp.getStackSize());
        }
        if (this.slice == this.imp.getStackSize()) {
            ip.resetMinAndMax();
        }
        ++this.slice;
        if (this.canceled) {
            Undo.undo();
        }
    }

    float[] getKernel() {
        this.gd = new GenericDialog("Convolver...", IJ.getInstance());
        this.gd.addTextAreas(kernelText, null, 10, 30);
        this.gd.addPanel(this.makeButtonPanel(this.gd));
        this.gd.addCheckbox("Normalize Kernel", normalize);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            this.canceled = true;
            return null;
        }
        kernelText = this.gd.getNextText();
        normalize = this.gd.getNextBoolean();
        StringTokenizer st = new StringTokenizer(kernelText);
        int n = st.countTokens();
        this.kh = this.kw = (int)Math.sqrt(n);
        n = this.kw * this.kh;
        float[] k = new float[n];
        int i = 0;
        while (i < n) {
            k[i] = (float)this.getNum(st);
            ++i;
        }
        return k;
    }

    Panel makeButtonPanel(GenericDialog gd) {
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(1, 5, 0));
        this.open = new Button("Open...");
        this.open.addActionListener(this);
        buttons.add(this.open);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        buttons.add(this.save);
        return buttons;
    }

    double getNum(StringTokenizer st) {
        Double d;
        String token = st.nextToken();
        try {
            d = new Double(token);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    public boolean convolve(ImageProcessor ip, float[] kernel, int kw, int kh) {
        if (this.canceled) {
            return false;
        }
        if ((kw & 1) != 1 || (kh & 1) != 1) {
            throw new IllegalArgumentException("Kernel width or height not odd");
        }
        int type = ip instanceof ByteProcessor ? 0 : (ip instanceof ShortProcessor ? 1 : (ip instanceof FloatProcessor ? 2 : 3));
        if (type == 3) {
            this.convolveRGB(ip, kernel, kw, kh);
            return !this.canceled;
        }
        ip.setCalibrationTable(null);
        ImageProcessor ip2 = ip.convertToFloat();
        ip2.setMask(ip.getMask());
        ip2.setRoi(ip.getRoi());
        this.convolveFloat(ip2, kernel, kw, kh);
        switch (type) {
            case 0: {
                ip2 = ip2.convertToByte(false);
                byte[] pixels = (byte[])ip.getPixels();
                byte[] pixels2 = (byte[])ip2.getPixels();
                System.arraycopy(pixels2, 0, pixels, 0, pixels.length);
                break;
            }
            case 1: {
                ip2 = ip2.convertToShort(false);
                short[] pixels16 = (short[])ip.getPixels();
                short[] pixels16b = (short[])ip2.getPixels();
                System.arraycopy(pixels16b, 0, pixels16, 0, pixels16.length);
                break;
            }
        }
        return !this.canceled;
    }

    public void setNormalize(boolean normalizeKernel) {
        normalize = normalizeKernel;
    }

    public void convolveRGB(ImageProcessor ip, float[] kernel, int kw, int kh) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        ImageProcessor mask = ip.getMask();
        int size = width * height;
        if (this.slice == 1) {
            IJ.showStatus("Convolve (red)");
        }
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        ((ColorProcessor)ip).getRGB(r, g, b);
        ByteProcessor rip = new ByteProcessor(width, height, r, null);
        ByteProcessor gip = new ByteProcessor(width, height, g, null);
        ByteProcessor bip = new ByteProcessor(width, height, b, null);
        Rectangle rect = ip.getRoi();
        ImageProcessor ip2 = rip.convertToFloat();
        ip2.setMask(mask);
        ip2.setRoi(roi);
        this.convolveFloat(ip2, kernel, kw, kh);
        ImageProcessor r2 = ip2.convertToByte(false);
        if (this.slice == 1) {
            IJ.showStatus("Convolve (green)");
        }
        ip2 = gip.convertToFloat();
        ip2.setMask(mask);
        ip2.setRoi(roi);
        this.convolveFloat(ip2, kernel, kw, kh);
        ImageProcessor g2 = ip2.convertToByte(false);
        ip2 = bip.convertToFloat();
        ip2.setMask(mask);
        ip2.setRoi(roi);
        if (this.slice == 1) {
            IJ.showStatus("Convolve (blue)");
        }
        this.convolveFloat(ip2, kernel, kw, kh);
        ImageProcessor b2 = ip2.convertToByte(false);
        ((ColorProcessor)ip).setRGB((byte[])r2.getPixels(), (byte[])g2.getPixels(), (byte[])b2.getPixels());
    }

    public boolean convolveFloat(ImageProcessor ip, float[] kernel, int kw, int kh) {
        boolean nonRectRoi;
        if (this.canceled) {
            return false;
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle r = ip.getRoi();
        boolean isRoi = r.width != width || r.height != height;
        boolean bl = nonRectRoi = ip.getMask() != null;
        if (nonRectRoi) {
            ip.snapshot();
        }
        int x1 = r.x;
        int y1 = r.y;
        int x2 = x1 + r.width;
        int y2 = y1 + r.height;
        int uc = kw / 2;
        int vc = kh / 2;
        float[] pixels = (float[])ip.getPixels();
        float[] pixels2 = (float[])ip.getPixelsCopy();
        double scale = 1.0;
        if (normalize) {
            double sum = 0.0;
            int i = 0;
            while (i < kernel.length) {
                sum += (double)kernel[i];
                ++i;
            }
            if (sum != 0.0) {
                scale = (float)(1.0 / sum);
            }
        }
        int progress = Math.max((y2 - y1) / 25, 1);
        int xedge = width - uc;
        int yedge = height - vc;
        int y = y1;
        while (y < y2) {
            if (y % progress == 0) {
                IJ.showProgress((double)y / (double)height);
                if (IJ.escapePressed()) {
                    this.canceled = true;
                    IJ.beep();
                    IJ.showProgress(1.0);
                    return false;
                }
            }
            int x = x1;
            while (x < x2) {
                double sum = 0.0;
                int i = 0;
                boolean edgePixel = y < vc || y >= yedge || x < uc || x >= xedge;
                int v = -vc;
                while (v <= vc) {
                    int offset = x + (y + v) * width;
                    int u = -uc;
                    while (u <= uc) {
                        sum = edgePixel ? (sum += (double)(this.getPixel(x + u, y + v, pixels2, width, height) * kernel[i++])) : (sum += (double)(pixels2[offset + u] * kernel[i++]));
                        ++u;
                    }
                    ++v;
                }
                pixels[x + y * width] = (float)(sum * scale);
                ++x;
            }
            ++y;
        }
        if (nonRectRoi) {
            ip.reset(ip.getMask());
        }
        IJ.showProgress(1.0);
        return true;
    }

    private float getPixel(int x, int y, float[] pixels, int width, int height) {
        if (x <= 0) {
            x = 0;
        }
        if (x >= width) {
            x = width - 1;
        }
        if (y <= 0) {
            y = 0;
        }
        if (y >= height) {
            y = height - 1;
        }
        return pixels[x + y * width];
    }

    void save() {
        TextArea ta1 = this.gd.getTextArea1();
        ta1.selectAll();
        String text = ta1.getText();
        ta1.select(0, 0);
        if (text == null || text.length() == 0) {
            return;
        }
        text = text + "\n";
        SaveDialog sd = new SaveDialog("Save as Text...", "kernel", ".txt");
        String name = sd.getFileName();
        if (name == null) {
            return;
        }
        String directory = sd.getDirectory();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(directory + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            IJ.error("" + e);
            return;
        }
        IJ.wait(250);
        pw.print(text);
        pw.close();
    }

    void open() {
        OpenDialog od = new OpenDialog("Open Calibration...", "");
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        TextReader tr = new TextReader();
        String path = directory + name;
        ImageProcessor ip = tr.open(path);
        if (ip == null) {
            return;
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        if ((width & 1) != 1 || width != height) {
            IJ.error("Convolver", "Kernel must be square and have an odd width");
            return;
        }
        StringBuffer sb = new StringBuffer();
        boolean integers = true;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                double v = ip.getPixelValue(x, y);
                if ((double)((int)v) != v) {
                    integers = false;
                }
                ++x;
            }
            ++y;
        }
        int y2 = 0;
        while (y2 < height) {
            int x = 0;
            while (x < width) {
                if (x != 0) {
                    sb.append(" ");
                }
                double v = ip.getPixelValue(x, y2);
                if (integers) {
                    sb.append(IJ.d2s(ip.getPixelValue(x, y2), 0));
                } else {
                    sb.append("" + ip.getPixelValue(x, y2));
                }
                ++x;
            }
            if (y2 != height - 1) {
                sb.append("\n");
            }
            ++y2;
        }
        this.gd.getTextArea1().setText(new String(sb));
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.save) {
            this.save();
        } else if (source == this.open) {
            this.open();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

