/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.filter.Convolver;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.text.TextWindow;
import java.awt.Rectangle;

public class GaussianBlur
implements PlugInFilter {
    private static final int BYTE = 0;
    private static final int SHORT = 1;
    private static final int FLOAT = 2;
    private static final int RGB = 3;
    private ImagePlus imp;
    private boolean canceled;
    private int slice;
    private boolean isLineRoi;
    private boolean isAreaRoi;
    private boolean displayKernel;
    private static int radius = 2;
    static /* synthetic */ Class class$ij$plugin$filter$GaussianBlur;

    public int setup(String arg, ImagePlus imp) {
        IJ.register(class$ij$plugin$filter$GaussianBlur == null ? (class$ij$plugin$filter$GaussianBlur = GaussianBlur.class$("ij.plugin.filter.GaussianBlur")) : class$ij$plugin$filter$GaussianBlur);
        this.imp = imp;
        if (imp != null) {
            IJ.resetEscape();
            Roi roi = imp.getRoi();
            this.isLineRoi = roi != null && roi.isLine();
            boolean bl = this.isAreaRoi = roi != null && !this.isLineRoi;
        }
        if (imp != null && !this.showDialog()) {
            return 4096;
        }
        return IJ.setupDialog(imp, 31);
    }

    public void run(ImageProcessor ip) {
        if (this.canceled) {
            return;
        }
        ++this.slice;
        if (this.slice == 1) {
            if (this.imp.getType() == 2 && !this.isAreaRoi && this.imp.getStackSize() == 1) {
                Undo.setup(4, this.imp);
                this.blur(ip, radius);
                Undo.setup(5, this.imp);
                return;
            }
        } else {
            IJ.showStatus("Gaussian Blur: " + this.slice + "/" + this.imp.getStackSize());
        }
        if (this.isLineRoi) {
            ip.resetRoi();
        }
        this.blur(ip, radius);
        if (this.canceled) {
            Undo.undo();
        }
    }

    public boolean blur(ImageProcessor ip, double radius) {
        boolean nonRectRoi;
        Rectangle rect = ip.getRoi();
        ImageProcessor ip2 = ip;
        boolean isRoi = rect.width != ip.getWidth() || rect.height != ip.getHeight();
        boolean bl = nonRectRoi = ip.getMask() != null;
        if (isRoi) {
            ip2.setRoi(rect);
            ip2 = ip2.crop();
        }
        int type = ip2 instanceof ByteProcessor ? 0 : (ip2 instanceof ShortProcessor ? 1 : (ip2 instanceof FloatProcessor ? 2 : 3));
        float[] kernel = this.makeKernel(radius);
        if (this.slice == 1 && this.displayKernel) {
            TextWindow tw = new TextWindow("Kernel", "", 150, 300);
            int i = 0;
            while (i < kernel.length) {
                tw.append(i + "  " + IJ.d2s(kernel[i], 3));
                ++i;
            }
        }
        if (type == 3) {
            if (nonRectRoi) {
                ip2.snapshot();
                this.blurRGB(ip2, kernel);
                ip2.reset(ip.getMask());
            } else {
                this.blurRGB(ip2, kernel);
            }
            if (nonRectRoi) {
                ip2.reset(ip.getMask());
            }
            if (isRoi) {
                ip.insert(ip2, rect.x, rect.y);
            }
            return !this.canceled;
        }
        ip2.setCalibrationTable(null);
        ip2 = ip2.convertToFloat();
        this.blurFloat(ip2, kernel);
        if (nonRectRoi) {
            ip.snapshot();
        }
        switch (type) {
            case 0: {
                ip2 = ip2.convertToByte(false);
                ip.insert(ip2, rect.x, rect.y);
                break;
            }
            case 1: {
                ip2 = ip2.convertToShort(false);
                ip.insert(ip2, rect.x, rect.y);
                break;
            }
            case 2: {
                if (!isRoi) break;
                ip.insert(ip2, rect.x, rect.y);
            }
        }
        if (nonRectRoi) {
            ip.reset(ip.getMask());
        }
        return !this.canceled;
    }

    void blurFloat(ImageProcessor ip, float[] kernel) {
        if (this.canceled) {
            return;
        }
        Convolver c = new Convolver();
        if (!c.convolve(ip, kernel, kernel.length, 1)) {
            this.canceled = true;
            return;
        }
        ip.snapshot();
        if (!c.convolve(ip, kernel, 1, kernel.length)) {
            this.canceled = true;
            return;
        }
    }

    public void blurRGB(ImageProcessor ip, float[] kernel) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        int size = width * height;
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        ((ColorProcessor)ip).getRGB(r, g, b);
        ByteProcessor rip = new ByteProcessor(width, height, r, null);
        ByteProcessor gip = new ByteProcessor(width, height, g, null);
        ByteProcessor bip = new ByteProcessor(width, height, b, null);
        ImageProcessor ip2 = rip.convertToFloat();
        this.blurFloat(ip2, kernel);
        ImageProcessor r2 = ip2.convertToByte(false);
        ip2 = gip.convertToFloat();
        this.blurFloat(ip2, kernel);
        ImageProcessor g2 = ip2.convertToByte(false);
        ip2 = bip.convertToFloat();
        this.blurFloat(ip2, kernel);
        ImageProcessor b2 = ip2.convertToByte(false);
        ((ColorProcessor)ip).setRGB((byte[])r2.getPixels(), (byte[])g2.getPixels(), (byte[])b2.getPixels());
    }

    public float[] makeKernel(double radius) {
        int size = (int)(radius += 1.0) * 2 + 1;
        float[] kernel = new float[size];
        int i = 0;
        while (i < size) {
            kernel[i] = (float)Math.exp(-0.5 * this.sqr(((double)i - radius) / (radius * 2.0)) / this.sqr(0.2));
            ++i;
        }
        float[] kernel2 = new float[size - 2];
        int i2 = 0;
        while (i2 < size - 2) {
            kernel2[i2] = kernel[i2 + 1];
            ++i2;
        }
        if (kernel2.length == 1) {
            kernel2[0] = 1.0f;
        }
        return kernel2;
    }

    double sqr(double x) {
        return x * x;
    }

    public boolean showDialog() {
        GenericDialog gd = new GenericDialog("Gaussian Blur...");
        gd.addNumericField("Radius (pixels)", radius, 0);
        gd.addCheckbox("Show Kernel", this.displayKernel);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.canceled = true;
            return false;
        }
        radius = (int)gd.getNextNumber();
        this.displayKernel = gd.getNextBoolean();
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

