/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Macro;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ByteStatistics;
import ij.process.FloatProcessor;
import ij.process.FloatStatistics;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.PolygonFiller;
import ij.process.ShortProcessor;
import ij.process.ShortStatistics;
import ij.text.TextWindow;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.util.Hashtable;
import java.util.Properties;

public class ParticleAnalyzer
implements PlugInFilter,
Measurements {
    public static final int SHOW_RESULTS = 1;
    public static final int SHOW_SUMMARY = 2;
    public static final int SHOW_OUTLINES = 4;
    public static final int EXCLUDE_EDGE_PARTICLES = 8;
    public static final int SHOW_SIZE_DISTRIBUTION = 16;
    public static final int SHOW_PROGRESS = 32;
    public static final int CLEAR_WORKSHEET = 64;
    public static final int RECORD_STARTS = 128;
    public static final int DISPLAY_SUMMARY = 256;
    public static final int SHOW_NONE = 512;
    static final String OPTIONS = "ap.options";
    static final String BINS = "ap.bins";
    static final int BYTE = 0;
    static final int SHORT = 1;
    static final int FLOAT = 2;
    private static int staticMinSize = 1;
    private static int staticMaxSize = 999999;
    private static int staticOptions = Prefs.getInt("ap.options", 64);
    private static int staticBins = Prefs.getInt("ap.bins", 20);
    private static String[] showStrings = new String[]{"Nothing", "Outlines", "Masks", "Ellipses"};
    protected static final int NOTHING = 0;
    protected static final int OUTLINES = 1;
    protected static final int MASKS = 2;
    protected static final int ELLIPSES = 3;
    protected static int showChoice;
    protected ImagePlus imp;
    protected ResultsTable rt;
    protected Analyzer analyzer;
    protected int slice;
    protected boolean processStack;
    protected boolean showResults;
    protected boolean excludeEdgeParticles;
    protected boolean showSizeDistribution;
    protected boolean resetCounter;
    protected boolean showProgress;
    protected boolean recordStarts;
    protected boolean displaySummary;
    private double level1;
    private double level2;
    private int minSize;
    private int maxSize;
    private int sizeBins;
    private int options;
    private int measurements;
    private Calibration calibration;
    private String arg;
    private double fillColor;
    private boolean thresholdingLUT;
    private ImageProcessor drawIP;
    private int width;
    private int height;
    private boolean canceled;
    private ImageStack outlines;
    private IndexColorModel customLut;
    private int particleCount;
    private int totalCount;
    private TextWindow tw;
    private Wand wand;
    private int imageType;
    private int imageType2;
    private int xStartC;
    private int yStartC;
    private boolean roiNeedsImage;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private ImagePlus redirectImp;
    private ImageProcessor redirectIP;
    private PolygonFiller pf;
    private Roi saveRoi;
    private int beginningCount;
    private Rectangle r;
    private ImageProcessor mask;
    static /* synthetic */ Class class$ij$plugin$filter$ParticleAnalyzer;

    public ParticleAnalyzer(int options, int measurements, ResultsTable rt, double minSize, double maxSize) {
        this.options = options;
        this.measurements = measurements;
        this.rt = rt;
        if (this.rt == null) {
            this.rt = new ResultsTable();
        }
        this.minSize = (int)minSize;
        this.maxSize = (int)maxSize;
        this.sizeBins = staticBins;
        this.slice = 1;
    }

    public ParticleAnalyzer() {
        this.slice = 1;
    }

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        IJ.register(class$ij$plugin$filter$ParticleAnalyzer == null ? (class$ij$plugin$filter$ParticleAnalyzer = ParticleAnalyzer.class$("ij.plugin.filter.ParticleAnalyzer")) : class$ij$plugin$filter$ParticleAnalyzer);
        if (imp == null) {
            IJ.noImage();
            return 4096;
        }
        if (!this.showDialog()) {
            return 4096;
        }
        int baseFlags = 397;
        int flags = Analyzer.isRedirectImage() ? baseFlags : IJ.setupDialog(imp, baseFlags);
        this.processStack = (flags & 0x20) != 0;
        this.slice = 0;
        this.saveRoi = imp.getRoi();
        imp.startTiming();
        return flags;
    }

    public void run(ImageProcessor ip) {
        if (this.canceled) {
            return;
        }
        ++this.slice;
        if (this.imp.getStackSize() > 1 && this.processStack) {
            this.imp.setSlice(this.slice);
        }
        if (!this.analyze(this.imp, ip)) {
            this.canceled = true;
        }
        if (this.slice == this.imp.getStackSize()) {
            this.imp.updateAndDraw();
            if (this.saveRoi != null) {
                this.imp.setRoi(this.saveRoi);
            }
        }
    }

    public boolean showDialog() {
        GenericDialog gd = new GenericDialog("Analyze Particles");
        this.minSize = staticMinSize;
        this.maxSize = staticMaxSize;
        this.sizeBins = staticBins;
        this.options = staticOptions;
        gd.addNumericField("Minimum Size (pixels):", this.minSize, 0);
        gd.addNumericField("Maximum Size (pixels):", this.maxSize, 0);
        gd.addNumericField("Bins (2-256):", this.sizeBins, 0);
        gd.addChoice("Show:", showStrings, showStrings[showChoice]);
        gd.addCheckbox("Display Results", (this.options & 1) != 0);
        gd.addCheckbox("Exclude Edge Particles", (this.options & 8) != 0);
        gd.addCheckbox("Size Distribution", (this.options & 0x10) != 0);
        gd.addCheckbox("Clear Results Table", (this.options & 0x40) != 0);
        gd.addCheckbox("Record Starts", (this.options & 0x80) != 0);
        gd.addCheckbox("Summarize", (this.options & 0x100) != 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.minSize = (int)gd.getNextNumber();
        this.maxSize = (int)gd.getNextNumber();
        this.sizeBins = (int)gd.getNextNumber();
        if (gd.invalidNumber()) {
            IJ.error("Minimum Size, Maximum Size or Bins invalid.");
            this.canceled = true;
            return false;
        }
        staticMinSize = this.minSize;
        staticMaxSize = this.maxSize;
        staticBins = this.sizeBins;
        showChoice = gd.getNextChoiceIndex();
        this.options = gd.getNextBoolean() ? (this.options |= 1) : (this.options &= 0xFFFFFFFE);
        this.options = gd.getNextBoolean() ? (this.options |= 8) : (this.options &= 0xFFFFFFF7);
        this.options = gd.getNextBoolean() ? (this.options |= 0x10) : (this.options &= 0xFFFFFFEF);
        this.options = gd.getNextBoolean() ? (this.options |= 0x40) : (this.options &= 0xFFFFFFBF);
        this.options = gd.getNextBoolean() ? (this.options |= 0x80) : (this.options &= 0xFFFFFF7F);
        this.options = gd.getNextBoolean() ? (this.options |= 0x100) : (this.options &= 0xFFFFFEFF);
        staticOptions = this.options;
        this.options |= 0x20;
        if ((this.options & 0x100) != 0 || (this.options & 0x10) != 0) {
            Analyzer.setMeasurements(Analyzer.getMeasurements() | 1);
        }
        return true;
    }

    public boolean analyze(ImagePlus imp) {
        return this.analyze(imp, imp.getProcessor());
    }

    public boolean analyze(ImagePlus imp, ImageProcessor ip) {
        ImageWindow win;
        this.showResults = (this.options & 1) != 0;
        this.excludeEdgeParticles = (this.options & 8) != 0;
        this.showSizeDistribution = (this.options & 0x10) != 0;
        this.resetCounter = (this.options & 0x40) != 0;
        this.showProgress = (this.options & 0x20) != 0;
        this.recordStarts = (this.options & 0x80) != 0;
        boolean bl = this.displaySummary = (this.options & 0x100) != 0;
        if ((this.options & 4) != 0) {
            showChoice = 1;
        }
        if ((this.options & 0x200) != 0) {
            showChoice = 0;
        }
        ip.snapshot();
        ip.setProgressBar(null);
        if (Analyzer.isRedirectImage()) {
            this.redirectImp = Analyzer.getRedirectImage(imp);
            if (this.redirectImp == null) {
                return false;
            }
            this.redirectIP = this.redirectImp.getProcessor();
        }
        if (!this.setThresholdLevels(imp, ip)) {
            return false;
        }
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        if (showChoice != 0) {
            if (this.slice == 1) {
                this.outlines = new ImageStack(this.width, this.height);
            }
            this.drawIP = new ByteProcessor(this.width, this.height);
            if (showChoice == 2) {
                this.drawIP.invertLut();
            } else if (showChoice == 1) {
                if (this.customLut == null) {
                    this.makeCustomLut();
                }
                this.drawIP.setColorModel(this.customLut);
                this.drawIP.setFont(new Font("SansSerif", 0, 9));
            }
            this.outlines.addSlice(null, this.drawIP);
            this.drawIP.setColor(Color.white);
            this.drawIP.fill();
            this.drawIP.setColor(Color.black);
        }
        Calibration calibration = this.calibration = this.redirectImp != null ? this.redirectImp.getCalibration() : imp.getCalibration();
        if (this.rt == null) {
            this.rt = Analyzer.getResultsTable();
            this.analyzer = new Analyzer(imp);
        } else {
            this.analyzer = new Analyzer(imp, this.measurements, this.rt);
        }
        if (this.resetCounter && this.slice == 1 && !Analyzer.resetCounter()) {
            return false;
        }
        this.beginningCount = Analyzer.getCounter();
        byte[] pixels = null;
        if (ip instanceof ByteProcessor) {
            pixels = (byte[])ip.getPixels();
        }
        if (this.r == null) {
            this.r = ip.getRoi();
            this.mask = ip.getMask();
        }
        if (this.r.width < this.width || this.r.height < this.height || this.mask != null) {
            this.eraseOutsideRoi(ip, this.r, this.mask);
        }
        this.minX = this.r.x;
        this.maxX = this.r.x + this.r.width;
        this.minY = this.r.y;
        this.maxY = this.r.y + this.r.height;
        int inc = Math.max(this.r.height / 25, 1);
        boolean mi = false;
        if (this.recordStarts) {
            this.xStartC = this.getColumnID("XStart");
            this.yStartC = this.getColumnID("YStart");
        }
        if ((win = imp.getWindow()) != null) {
            win.running = true;
        }
        if (this.measurements == 0) {
            this.measurements = Analyzer.getMeasurements();
        }
        if (showChoice == 3) {
            this.measurements |= 0x800;
        }
        this.roiNeedsImage = (this.measurements & 0x80) != 0 || (this.measurements & 0x2000) != 0 || (this.measurements & 0x4000) != 0;
        this.particleCount = 0;
        this.wand = new Wand(ip);
        this.pf = new PolygonFiller();
        int y = this.r.y;
        while (y < this.r.y + this.r.height) {
            int offset = y * this.width;
            int x = this.r.x;
            while (x < this.r.x + this.r.width) {
                double value = pixels != null ? (double)(pixels[offset + x] & 0xFF) : (this.imageType == 1 ? (double)ip.getPixel(x, y) : (double)ip.getPixelValue(x, y));
                if (value >= this.level1 && value <= this.level2) {
                    this.analyzeParticle(x, y, imp, ip);
                }
                ++x;
            }
            if (this.showProgress && y % inc == 0) {
                IJ.showProgress((double)(y - this.r.y) / (double)this.r.height);
            }
            if (win != null) {
                boolean bl2 = this.canceled = !win.running;
            }
            if (this.canceled) {
                Macro.abort();
                break;
            }
            ++y;
        }
        if (this.showProgress) {
            IJ.showProgress(1.0);
        }
        imp.killRoi();
        ip.resetRoi();
        ip.reset();
        if (this.displaySummary && this.processStack && IJ.getInstance() != null) {
            this.updateSliceSummary();
        }
        this.totalCount += this.particleCount;
        if (!this.canceled) {
            this.showResults();
        }
        return true;
    }

    void updateSliceSummary() {
        String aLine;
        float[] areas = this.rt.getColumn(0);
        String label = this.imp.getStack().getShortSliceLabel(this.slice);
        String string = label = label != null && !label.equals("") ? label : "" + this.slice;
        if (areas != null) {
            double sum = 0.0;
            int start = areas.length - this.particleCount;
            if (start < 0) {
                return;
            }
            int i = start;
            while (i < areas.length) {
                sum += (double)areas[i];
                ++i;
            }
            int places = Analyzer.getPrecision();
            Calibration cal = this.imp.getCalibration();
            String total = "\t" + IJ.d2s(sum, places);
            String average = "\t" + IJ.d2s(sum / (double)this.particleCount, places);
            double imageArea = (double)this.imp.getWidth() * cal.pixelWidth * (double)this.imp.getHeight() * cal.pixelHeight;
            String fraction = "\t" + IJ.d2s(sum * 100.0 / imageArea, 1);
            aLine = label + "\t" + this.particleCount + total + average + fraction;
        } else {
            aLine = label + "\t" + this.particleCount;
        }
        if (this.tw == null) {
            String title = "Summary of " + this.imp.getTitle();
            String headings = "Slice\tCount\tTotal Area\tAverage Size\tArea Fraction";
            this.tw = new TextWindow(title, headings, aLine, 180, 360);
        } else {
            this.tw.append(aLine);
        }
    }

    void eraseOutsideRoi(ImageProcessor ip, Rectangle r, ImageProcessor mask) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        ip.setRoi(r);
        ip.setValue(this.fillColor);
        if (mask != null) {
            mask = mask.duplicate();
            mask.invert();
            ip.setMask(mask);
            ip.fill();
            ip.reset(mask);
        }
        ip.setRoi(0, 0, r.x, height);
        ip.fill();
        ip.setRoi(r.x, 0, r.width, r.y);
        ip.fill();
        ip.setRoi(r.x, r.y + r.height, r.width, height - (r.y + r.height));
        ip.fill();
        ip.setRoi(r.x + r.width, 0, width - (r.x + r.width), height);
        ip.fill();
        ip.resetRoi();
    }

    boolean setThresholdLevels(ImagePlus imp, ImageProcessor ip) {
        double t1 = ip.getMinThreshold();
        double t2 = ip.getMaxThreshold();
        boolean invertedLut = imp.isInvertedLut();
        boolean byteImage = ip instanceof ByteProcessor;
        this.imageType = ip instanceof ShortProcessor ? 1 : (ip instanceof FloatProcessor ? 2 : 0);
        if (t1 == -808080.0) {
            ImageStatistics stats = imp.getStatistics();
            if (this.imageType != 0 || stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
                IJ.error("Particle Analyzer", "A thresholded image or an 8-bit binary image is\nrequired. Refer to Image->Adjust->Threshold\nor to Process->Binary->Threshold.");
                this.canceled = true;
                return false;
            }
            if (invertedLut) {
                this.level1 = 255.0;
                this.level2 = 255.0;
                this.fillColor = 64.0;
            } else {
                this.level1 = 0.0;
                this.level2 = 0.0;
                this.fillColor = 192.0;
            }
        } else {
            this.level1 = t1;
            this.level2 = t2;
            if (this.imageType == 0) {
                if (this.level1 > 0.0) {
                    this.fillColor = 0.0;
                } else if (this.level2 < 255.0) {
                    this.fillColor = 255.0;
                }
            } else if (this.imageType == 1) {
                if (this.level1 > 0.0) {
                    this.fillColor = 0.0;
                } else if (this.level2 < 65535.0) {
                    this.fillColor = 65535.0;
                }
            } else if (this.imageType == 2) {
                this.fillColor = -3.4028234663852886E38;
            } else {
                return false;
            }
        }
        this.imageType2 = this.imageType;
        if (this.redirectIP != null) {
            this.imageType2 = this.redirectIP instanceof ShortProcessor ? 1 : (this.redirectIP instanceof FloatProcessor ? 2 : 0);
        }
        return true;
    }

    void analyzeParticle(int x, int y, ImagePlus imp, ImageProcessor ip) {
        ImageProcessor ip2 = this.redirectIP != null ? this.redirectIP : ip;
        this.wand.autoOutline(x, y, this.level1, this.level2);
        if (this.wand.npoints == 0) {
            IJ.log("wand error: " + x + " " + y);
            return;
        }
        PolygonRoi roi = new PolygonRoi(this.wand.xpoints, this.wand.ypoints, this.wand.npoints, 4);
        Rectangle r = roi.getBounds();
        if (r.width > 1 && r.height > 1) {
            PolygonRoi proi = roi;
            this.pf.setPolygon(proi.getXCoordinates(), proi.getYCoordinates(), proi.getNCoordinates());
            ip2.setMask(this.pf.getMask(r.width, r.height));
        }
        ip2.setRoi(r);
        ip.setValue(this.fillColor);
        ImageStatistics stats = this.getStatistics(ip2, this.measurements, this.calibration);
        boolean include = true;
        if (this.excludeEdgeParticles && (r.x == this.minX || r.y == this.minY || r.x + r.width == this.maxX || r.y + r.height == this.maxY)) {
            include = false;
        }
        ImageProcessor mask = ip2.getMask();
        if (stats.pixelCount >= this.minSize && stats.pixelCount <= this.maxSize && include) {
            ++this.particleCount;
            if (this.roiNeedsImage) {
                roi.setImage(imp);
            }
            this.saveResults(stats, roi);
            if (showChoice != 0) {
                this.drawParticle(this.drawIP, roi, stats, mask);
            }
        }
        if (this.redirectIP != null) {
            ip.setRoi(r);
        }
        ip.fill(mask);
    }

    ImageStatistics getStatistics(ImageProcessor ip, int mOptions, Calibration cal) {
        switch (this.imageType2) {
            case 0: {
                return new ByteStatistics(ip, mOptions, cal);
            }
            case 1: {
                return new ShortStatistics(ip, mOptions, cal);
            }
            case 2: {
                return new FloatStatistics(ip, mOptions, cal);
            }
        }
        return null;
    }

    protected void saveResults(ImageStatistics stats, Roi roi) {
        this.analyzer.saveResults(stats, roi);
        if (this.recordStarts) {
            int coordinates = ((PolygonRoi)roi).getNCoordinates();
            Rectangle r = roi.getBounds();
            int x = r.x + ((PolygonRoi)roi).getXCoordinates()[coordinates - 1];
            int y = r.y + ((PolygonRoi)roi).getYCoordinates()[coordinates - 1];
            this.rt.addValue(this.xStartC, (double)x);
            this.rt.addValue(this.yStartC, (double)y);
        }
        if (this.showResults) {
            this.analyzer.displayResults();
        }
    }

    protected void drawParticle(ImageProcessor drawIP, Roi roi, ImageStatistics stats, ImageProcessor mask) {
        switch (showChoice) {
            case 2: {
                this.drawFilledParticle(drawIP, roi, mask);
                break;
            }
            case 1: {
                this.drawOutline(drawIP, roi, this.rt.getCounter());
                break;
            }
            case 3: {
                this.drawEllipse(drawIP, stats, this.rt.getCounter());
                break;
            }
        }
    }

    void drawFilledParticle(ImageProcessor ip, Roi roi, ImageProcessor mask) {
        ip.setRoi(roi.getBounds());
        ip.fill(mask);
    }

    void drawOutline(ImageProcessor ip, Roi roi, int count) {
        Rectangle r = roi.getBounds();
        int nPoints = ((PolygonRoi)roi).getNCoordinates();
        int[] xp = ((PolygonRoi)roi).getXCoordinates();
        int[] yp = ((PolygonRoi)roi).getYCoordinates();
        int x = r.x;
        int y = r.y;
        ip.setValue(0.0);
        ip.moveTo(x + xp[0], y + yp[0]);
        int i = 1;
        while (i < nPoints) {
            ip.lineTo(x + xp[i], y + yp[i]);
            ++i;
        }
        ip.lineTo(x + xp[0], y + yp[0]);
        String s = IJ.d2s(count, 0);
        ip.moveTo(r.x + r.width / 2 - ip.getStringWidth(s) / 2, r.y + r.height / 2 + 4);
        ip.setValue(1.0);
        ip.drawString(s);
    }

    void drawEllipse(ImageProcessor ip, ImageStatistics stats, int count) {
        stats.drawEllipse(ip);
    }

    void showResults() {
        float[] areas;
        boolean lastSlice;
        int count = this.rt.getCounter();
        if (count == 0) {
            return;
        }
        boolean bl = lastSlice = !this.processStack || this.slice == this.imp.getStackSize();
        if (this.displaySummary && lastSlice && this.rt == Analyzer.getResultsTable() && this.imp != null) {
            this.showSummary();
        }
        if (this.showSizeDistribution && lastSlice && (areas = this.rt.getColumn(0)) != null) {
            FloatProcessor ip = new FloatProcessor(count, 1, areas, null);
            new HistogramWindow("Particle Size Distribution", new ImagePlus("", ip), this.sizeBins);
        }
        if (this.outlines != null && lastSlice) {
            String title = this.imp != null ? this.imp.getTitle() : "Outlines";
            String prefix = showChoice == 2 ? "Mask of " : "Drawing of ";
            new ImagePlus(prefix + title, this.outlines).show();
        }
        if (this.showResults && !this.processStack) {
            Analyzer.firstParticle = this.beginningCount;
            Analyzer.lastParticle = Analyzer.getCounter() - 1;
        } else {
            Analyzer.lastParticle = 0;
            Analyzer.firstParticle = 0;
        }
    }

    void showSummary() {
        String aLine;
        String s = "";
        s = s + "Threshold: ";
        s = (double)((int)this.level1) == this.level1 && (double)((int)this.level2) == this.level2 ? s + (int)this.level1 + "-" + (int)this.level2 + "\n" : s + IJ.d2s(this.level1, 2) + "-" + IJ.d2s(this.level2, 2) + "\n";
        s = s + "Count: " + this.totalCount + "\n";
        float[] areas = this.rt.getColumn(0);
        if (areas != null) {
            double sum = 0.0;
            int start = areas.length - this.totalCount;
            if (start < 0) {
                return;
            }
            int i = start;
            while (i < areas.length) {
                sum += (double)areas[i];
                ++i;
            }
            int places = Analyzer.getPrecision();
            Calibration cal = this.imp.getCalibration();
            String unit = cal.getUnit();
            String total = IJ.d2s(sum, places);
            s = s + "Total Area: " + total + " " + unit + "^2\n";
            String average = IJ.d2s(sum / (double)this.totalCount, places);
            s = s + "Average Size: " + IJ.d2s(sum / (double)this.totalCount, places) + " " + unit + "^2\n";
            double totalArea = (double)this.imp.getWidth() * cal.pixelWidth * (double)this.imp.getHeight() * cal.pixelHeight;
            if (this.processStack) {
                totalArea *= (double)this.imp.getStackSize();
            }
            String fraction = IJ.d2s(sum * 100.0 / totalArea, 1);
            s = s + "Area Fraction: " + fraction + "%";
            aLine = " \t" + this.totalCount + "\t" + total + "\t" + average + "\t" + fraction;
        } else {
            aLine = " \t" + this.totalCount;
        }
        if (this.tw != null) {
            this.tw.append("");
            this.tw.append(aLine);
        } else {
            new TextWindow("Summary of " + this.imp.getTitle(), s, 300, 200);
        }
    }

    int getColumnID(String name) {
        int id = this.rt.getFreeColumn(name);
        if (id == -2) {
            id = this.rt.getColumnIndex(name);
        }
        return id;
    }

    void makeCustomLut() {
        IndexColorModel cm = (IndexColorModel)LookUpTable.createGrayscaleColorModel(false);
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        cm.getReds(reds);
        cm.getGreens(greens);
        cm.getBlues(blues);
        reds[1] = -1;
        greens[1] = 0;
        blues[1] = 0;
        this.customLut = new IndexColorModel(8, 256, reds, greens, blues);
    }

    public static void savePreferences(Properties prefs) {
        ((Hashtable)prefs).put(OPTIONS, Integer.toString(staticOptions));
        ((Hashtable)prefs).put(BINS, Integer.toString(staticBins));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

