/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import ij.util.Tools;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Scaler
implements PlugInFilter,
TextListener {
    private ImagePlus imp;
    private static double xscale = 0.5;
    private static double yscale = 0.5;
    private static boolean newWindow = true;
    private static boolean interpolate = true;
    private static boolean processStack = true;
    private static String title = "Untitled";
    private Vector fields;
    private boolean duplicateScale = true;
    static /* synthetic */ Class class$ij$plugin$filter$Scaler;

    public int setup(String arg, ImagePlus imp) {
        Roi roi;
        this.imp = imp;
        IJ.register(class$ij$plugin$filter$Scaler == null ? (class$ij$plugin$filter$Scaler = Scaler.class$("ij.plugin.filter.Scaler")) : class$ij$plugin$filter$Scaler);
        if (imp != null && (roi = imp.getRoi()) != null && !roi.isArea()) {
            imp.killRoi();
        }
        return 31;
    }

    public void run(ImageProcessor ip) {
        if (!this.showDialog()) {
            return;
        }
        ip.setInterpolate(interpolate);
        this.imp.startTiming();
        try {
            if (newWindow && this.imp.getStackSize() > 1 && processStack) {
                this.createNewStack(this.imp, ip);
            } else {
                this.scale(ip);
            }
        }
        catch (OutOfMemoryError o) {
            IJ.outOfMemory("Scale");
        }
        IJ.showProgress(1.0);
    }

    void createNewStack(ImagePlus imp, ImageProcessor ip) {
        Rectangle r = ip.getRoi();
        boolean crop = r.width != imp.getWidth() || r.height != imp.getHeight();
        int newWidth = (int)((double)r.width * xscale);
        int newHeight = (int)((double)r.height * yscale);
        int nSlices = imp.getStackSize();
        ImageStack stack1 = imp.getStack();
        ImageStack stack2 = new ImageStack(newWidth, newHeight);
        int i = 1;
        while (i <= nSlices) {
            IJ.showStatus("Scale: " + i + "/" + nSlices);
            ImageProcessor ip1 = stack1.getProcessor(i);
            String label = stack1.getSliceLabel(i);
            if (crop) {
                ip1.setRoi(r);
                ip1 = ip1.crop();
            }
            ip1.setInterpolate(interpolate);
            ImageProcessor ip2 = ip1.resize(newWidth, newHeight);
            if (ip2 != null) {
                stack2.addSlice(label, ip2);
            }
            IJ.showProgress(i, nSlices);
            ++i;
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack(title, stack2);
        Calibration cal = imp2.getCalibration();
        if (cal.scaled()) {
            cal.pixelWidth *= 1.0 / xscale;
            cal.pixelHeight *= 1.0 / yscale;
        }
        IJ.showProgress(1.0);
        imp2.show();
    }

    void scale(ImageProcessor ip) {
        if (newWindow) {
            Rectangle r = ip.getRoi();
            int newWidth = (int)(xscale * (double)r.width);
            int newHeight = (int)(yscale * (double)r.height);
            ImagePlus imp2 = this.imp.createImagePlus();
            imp2.setProcessor(title, ip.resize(newWidth, newHeight));
            Calibration cal = imp2.getCalibration();
            if (cal.scaled()) {
                cal.pixelWidth *= 1.0 / xscale;
                cal.pixelHeight *= 1.0 / yscale;
            }
            imp2.show();
            this.imp.trimProcessor();
            imp2.trimProcessor();
        } else {
            if (processStack && this.imp.getStackSize() > 1) {
                Undo.reset();
                StackProcessor sp = new StackProcessor(this.imp.getStack(), ip);
                sp.scale(xscale, yscale);
            } else {
                ip.scale(xscale, yscale);
            }
            this.imp.killRoi();
        }
    }

    boolean showDialog() {
        boolean isStack = this.imp.getStackSize() > 1;
        GenericDialog gd = new GenericDialog("Scale");
        gd.addNumericField("X Scale (0.05-25):", xscale, 2);
        gd.addNumericField("Y Scale (0.05-25):", yscale, 2);
        this.fields = gd.getNumericFields();
        int i = 0;
        while (i < this.fields.size()) {
            ((TextField)this.fields.elementAt(i)).addTextListener(this);
            ++i;
        }
        gd.addCheckbox("Interpolate", interpolate);
        if (isStack) {
            gd.addCheckbox("Process Entire Stack", processStack);
        }
        gd.addCheckbox("Create New Window", newWindow);
        gd.addStringField("Title:", title);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        xscale = gd.getNextNumber();
        yscale = gd.getNextNumber();
        if (gd.invalidNumber()) {
            IJ.error("X or Y scale are invalid.");
            return false;
        }
        if (xscale > 25.0) {
            xscale = 25.0;
        }
        if (xscale < 0.05) {
            xscale = 0.05;
        }
        if (yscale > 25.0) {
            yscale = 25.0;
        }
        if (yscale < 0.05) {
            yscale = 0.05;
        }
        interpolate = gd.getNextBoolean();
        if (isStack) {
            processStack = gd.getNextBoolean();
        }
        newWindow = gd.getNextBoolean();
        title = gd.getNextString();
        return true;
    }

    public void textValueChanged(TextEvent e) {
        TextField xField = (TextField)this.fields.elementAt(0);
        TextField yField = (TextField)this.fields.elementAt(1);
        String newXText = xField.getText();
        double newXScale = Tools.parseDouble(newXText, -99.0);
        String newYText = yField.getText();
        double newYScale = Tools.parseDouble(newYText, -99.0);
        if (newXScale == -99.0 || newYScale == -99.0) {
            return;
        }
        if (newYScale != xscale) {
            this.duplicateScale = false;
        }
        if (this.duplicateScale && newXScale != xscale && newXScale != -99.0) {
            yField.setText("" + newXText);
        }
        xscale = newXScale;
        yscale = newYScale;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

