/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Measurements;
import ij.plugin.filter.GaussianBlur;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Rectangle;

public class UnsharpMask
implements PlugInFilter,
Measurements {
    private ImagePlus imp;
    private int slice;
    private boolean canceled;
    private static double radius = 2.0;
    private static double weight = 0.6;
    private boolean isLineRoi;
    static /* synthetic */ Class class$ij$plugin$filter$UnsharpMask;

    public int setup(String arg, ImagePlus imp) {
        IJ.register(class$ij$plugin$filter$UnsharpMask == null ? (class$ij$plugin$filter$UnsharpMask = UnsharpMask.class$("ij.plugin.filter.UnsharpMask")) : class$ij$plugin$filter$UnsharpMask);
        this.imp = imp;
        if (imp != null) {
            IJ.resetEscape();
            Roi roi = imp.getRoi();
            boolean bl = this.isLineRoi = roi != null && roi.isLine();
        }
        if (imp != null && !this.showDialog()) {
            return 4096;
        }
        return IJ.setupDialog(imp, 31);
    }

    public void run(ImageProcessor ip) {
        if (this.canceled) {
            return;
        }
        ++this.slice;
        if (this.isLineRoi) {
            ip.resetRoi();
        }
        this.sharpen(ip, radius, weight);
        if (this.canceled) {
            Undo.undo();
        }
    }

    void showStatus(String msg) {
        if (this.slice > 1) {
            IJ.showStatus("Unsharp Mask: " + this.slice + "/" + this.imp.getStackSize());
        } else {
            IJ.showStatus("Unsharp Mask: " + msg);
        }
    }

    public void sharpen(ImageProcessor ip, double radius, double weight) {
        ip.setCalibrationTable(null);
        Rectangle rect = ip.getRoi();
        boolean isRoi = rect.width != ip.getWidth() || rect.height != ip.getHeight();
        boolean nonRectRoi = ip.getMask() != null;
        ImageProcessor ip2 = ip;
        if (isRoi) {
            ip2.setRoi(rect);
            this.showStatus("cropping");
            ip2 = ip2.crop();
        }
        if (ip instanceof ColorProcessor) {
            this.showStatus("extracting brightness");
            ip2 = ((ColorProcessor)ip2).getBrightness();
        } else {
            this.showStatus("converting to float");
            ip2 = ip2.convertToFloat();
        }
        if (this.abort()) {
            return;
        }
        this.showStatus("getting statistics");
        ImageStatistics stats = ImageStatistics.getStatistics(ip2, 16, null);
        if (this.abort()) {
            return;
        }
        double min = stats.min;
        double max = stats.max;
        this.showStatus("Gaussian blur");
        ImageProcessor mask = ip2.duplicate();
        if (this.abort()) {
            return;
        }
        GaussianBlur gb = new GaussianBlur();
        if (!gb.blur(mask, radius)) {
            this.canceled = true;
            IJ.beep();
            return;
        }
        this.showStatus("Subtracting blurred mask");
        mask.multiply(weight);
        if (this.abort()) {
            return;
        }
        ip2.copyBits(mask, 0, 0, 4);
        if (this.abort()) {
            return;
        }
        ip2.multiply(1.0 / (1.0 - weight));
        if (this.abort()) {
            return;
        }
        if (!(ip2 instanceof ColorProcessor)) {
            ip2.min(min);
            ip2.max(max);
        }
        this.showStatus("converting back");
        if (nonRectRoi) {
            ip.snapshot();
        }
        ImageProcessor ip3 = null;
        int bitDepth = this.imp.getBitDepth();
        boolean scale = bitDepth == 8 && this.imp.getStackSize() == 1;
        switch (bitDepth) {
            case 8: {
                ip3 = ip2.convertToByte(scale);
                break;
            }
            case 16: {
                ip3 = ip2.convertToShort(scale);
                break;
            }
            case 24: {
                ip3 = nonRectRoi || isRoi ? ip.crop() : ip;
                ((ColorProcessor)ip3).setBrightness((FloatProcessor)ip2);
                break;
            }
            case 32: {
                ip3 = ip2;
            }
        }
        ip.insert(ip3, rect.x, rect.y);
        if (nonRectRoi) {
            ip.reset(ip.getMask());
        }
    }

    boolean abort() {
        if (IJ.escapePressed()) {
            this.canceled = true;
            IJ.beep();
            return true;
        }
        return false;
    }

    public boolean showDialog() {
        GenericDialog gd = new GenericDialog("Unsharp Mask...");
        gd.addNumericField("Gaussian Radius (1-15)", radius, 0);
        gd.addNumericField("Mask Weight (0.2-0.9)", weight, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.canceled = true;
            return false;
        }
        radius = gd.getNextNumber();
        weight = gd.getNextNumber();
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

