/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.Menus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.SaveChangesDialog;
import ij.io.SaveDialog;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.MacroRunner;
import ij.macro.Program;
import ij.plugin.MacroInstaller;
import ij.plugin.NewPlugin;
import ij.plugin.frame.PlugInFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Properties;
import java.util.StringTokenizer;

public class Editor
extends PlugInFrame
implements ActionListener,
TextListener,
ClipboardOwner,
MacroConstants {
    public static final int MAX_SIZE = 28000;
    public static final int MAX_MACROS = 50;
    public static final int XINC = 10;
    public static final int YINC = 18;
    private TextArea ta;
    private String path;
    private boolean changes;
    private static String searchString = "";
    private static int lineNumber = 1;
    private static int xoffset;
    private static int yoffset;
    private static int nWindows;
    private Menu fileMenu;
    private Menu editMenu;
    private Properties p = new Properties();
    private int[] macroStarts;
    private String[] macroNames;
    private MenuBar mb = new MenuBar();
    private Menu macrosMenu;
    private int nMacros;
    private Program pgm;
    private int eventCount;
    private String shortcutsInUse;
    private int inUseCount;
    private int nShortcuts;
    private MacroInstaller installer;
    private static String defaultDir;
    static /* synthetic */ Class class$ij$plugin$frame$Editor;

    public Editor() {
        super("Editor");
        WindowManager.addWindow(this);
        Menu m = new Menu("File");
        m.add(new MenuItem("Save", new MenuShortcut(83)));
        m.add(new MenuItem("Save As..."));
        m.add(new MenuItem("Print...", new MenuShortcut(80)));
        m.addSeparator();
        m.add(new MenuItem("Compile and Run", new MenuShortcut(82)));
        m.addActionListener(this);
        this.fileMenu = m;
        this.mb.add(m);
        m = new Menu("Edit");
        String key = IJ.isMacintosh() ? "  Cmd " : "  Ctrl+";
        MenuItem item = new MenuItem("Undo" + key + "Z");
        item.setEnabled(false);
        m.add(item);
        m.addSeparator();
        boolean shortcutsBroken = IJ.isWindows() && (System.getProperty("java.version").indexOf("1.1.8") >= 0 || System.getProperty("java.version").indexOf("1.5.") >= 0);
        item = shortcutsBroken ? new MenuItem("Cut  Ctrl+X") : new MenuItem("Cut", new MenuShortcut(88));
        m.add(item);
        item = shortcutsBroken ? new MenuItem("Copy  Ctrl+C") : new MenuItem("Copy", new MenuShortcut(67));
        m.add(item);
        item = shortcutsBroken ? new MenuItem("Paste  Ctrl+V") : new MenuItem("Paste", new MenuShortcut(86));
        m.add(item);
        m.addSeparator();
        m.add(new MenuItem("Find...", new MenuShortcut(70)));
        m.add(new MenuItem("Find Next", new MenuShortcut(71)));
        m.add(new MenuItem("Go to Line...", new MenuShortcut(76)));
        m.addSeparator();
        m.add(new MenuItem("Select All", new MenuShortcut(65)));
        m.add(new MenuItem("Zap Gremlins"));
        m.addActionListener(this);
        this.mb.add(m);
        this.editMenu = m;
        this.setMenuBar(this.mb);
        this.ta = new TextArea(16, 60);
        this.ta.addTextListener(this);
        if (IJ.isMacOSX() && !IJ.isJava14()) {
            this.ta.setFont(new Font("SansSerif", 0, 12));
        }
        this.addKeyListener(IJ.getInstance());
        this.add(this.ta);
        this.pack();
        this.positionWindow();
        IJ.register(class$ij$plugin$frame$Editor == null ? (class$ij$plugin$frame$Editor = Editor.class$("ij.plugin.frame.Editor")) : class$ij$plugin$frame$Editor);
    }

    public void positionWindow() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        if (window.width == 0) {
            return;
        }
        int left = screen.width / 2 - window.width / 2;
        int top = (screen.height - window.height) / 4;
        if (top < 0) {
            top = 0;
        }
        if (nWindows <= 0 || xoffset > 80) {
            xoffset = 0;
            yoffset = 0;
        }
        ((Component)this).setLocation(left + xoffset, top + yoffset);
        xoffset += 10;
        yoffset += 18;
        ++nWindows;
    }

    void setWindowTitle(String title) {
        Menus.updateWindowMenuItem(this.getTitle(), title);
        this.setTitle(title);
    }

    public void create(String name, String text) {
        this.ta.append(text);
        if (IJ.isMacOSX()) {
            IJ.wait(25);
        }
        this.ta.setCaretPosition(0);
        this.setWindowTitle(name);
        if (name.endsWith(".txt")) {
            this.fileMenu.remove(4);
            this.fileMenu.insert(new MenuItem("Run Macro", new MenuShortcut(82)), 4);
            int itemCount = this.fileMenu.getItemCount();
            if (itemCount == 5) {
                this.fileMenu.insert(new MenuItem("Abort Macro"), 5);
            }
            this.macrosMenu = new Menu("Macros");
            this.macrosMenu.add(new MenuItem("Install Macros", new MenuShortcut(73)));
            this.macrosMenu.addSeparator();
            this.macrosMenu.addActionListener(this);
            this.mb.add(this.macrosMenu);
            if (text.indexOf("macro ") != -1) {
                this.installMacros(text, false);
            }
        }
        if (IJ.getInstance() != null) {
            this.show();
        }
        WindowManager.setWindow(this);
        this.changes = false;
    }

    public void createMacro(String name, String text) {
        this.create(name, text);
        this.editMenu.add(new MenuItem("Convert to Plugin"));
    }

    void installMacros(String text, boolean installInPluginsMenu) {
        this.installer = new MacroInstaller();
        this.installer.setFileName(this.getTitle());
        int nShortcuts = this.installer.install(text, this.macrosMenu);
        if (text.indexOf("AutoRun") == -1 && (installInPluginsMenu || nShortcuts > 0)) {
            this.installer.install(null);
        }
    }

    public void open(String dir, String name) {
        this.path = dir + name;
        File file = new File(this.path);
        int size = (int)file.length();
        if (size > 28000 && !IJ.isJava2() && !IJ.isMacintosh()) {
            IJ.error("This file is too large for ImageJ to open.\n \n\t  File size: " + size + " bytes\n" + "\t  Max. size: " + 28000 + " bytes");
            this.dispose();
            return;
        }
        try {
            String s;
            StringBuffer sb = new StringBuffer(5000);
            BufferedReader r = new BufferedReader(new FileReader(file));
            while ((s = r.readLine()) != null) {
                sb.append(s + "\n");
            }
            r.close();
            this.create(name, new String(sb));
            this.changes = false;
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return;
        }
    }

    public String getText() {
        if (this.ta == null) {
            return "";
        }
        return this.ta.getText();
    }

    public void display(String title, String text) {
        this.ta.selectAll();
        this.ta.replaceRange(text, this.ta.getSelectionStart(), this.ta.getSelectionEnd());
        this.ta.setCaretPosition(0);
        this.setWindowTitle(title);
        this.changes = false;
        if (IJ.getInstance() != null) {
            this.show();
        }
        WindowManager.setWindow(this);
    }

    void save() {
        if (this.path == null) {
            this.saveAs();
            return;
        }
        File f = new File(this.path);
        if (f.exists() & !f.canWrite()) {
            IJ.showMessage("Editor", "Unable to save because file is write-protected. \n \n" + this.path);
            return;
        }
        String text = this.ta.getText();
        char[] chars = new char[text.length()];
        text.getChars(0, text.length(), chars, 0);
        try {
            String s;
            BufferedReader br = new BufferedReader(new CharArrayReader(chars));
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.path));
            while ((s = br.readLine()) != null) {
                bw.write(s, 0, s.length());
                bw.newLine();
            }
            bw.close();
            IJ.showStatus(text.length() + " chars saved to " + this.path);
            this.changes = false;
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    void compileAndRun() {
        if (this.path == null) {
            this.saveAs();
        }
        if (this.path != null) {
            this.save();
            IJ.runPlugIn("ij.plugin.Compiler", this.path);
        }
    }

    void runMacro() {
        int end;
        int start = this.ta.getSelectionStart();
        String text = start == (end = this.ta.getSelectionEnd()) ? this.ta.getText() : this.ta.getSelectedText();
        new MacroRunner(text);
    }

    void print() {
        PrintJob pjob = Toolkit.getDefaultToolkit().getPrintJob(this, "Cool Stuff", this.p);
        if (pjob != null) {
            Graphics pg = pjob.getGraphics();
            if (pg != null) {
                String s = this.ta.getText();
                this.printString(pjob, pg, s);
                pg.dispose();
            }
            pjob.end();
        }
    }

    void printString(PrintJob pjob, Graphics pg, String s) {
        int pageNum = 1;
        int linesForThisPage = 0;
        int linesForThisJob = 0;
        int topMargin = 30;
        int leftMargin = 30;
        int bottomMargin = 30;
        if (!(pg instanceof PrintGraphics)) {
            throw new IllegalArgumentException("Graphics contextt not PrintGraphics");
        }
        if (IJ.isMacintosh()) {
            topMargin = 0;
            leftMargin = 0;
            bottomMargin = 0;
        }
        StringReader sr = new StringReader(s);
        LineNumberReader lnr = new LineNumberReader(sr);
        int pageHeight = pjob.getPageDimension().height - bottomMargin;
        Font helv = new Font("Helvetica", 0, 10);
        pg.setFont(helv);
        FontMetrics fm = pg.getFontMetrics(helv);
        int fontHeight = fm.getHeight();
        int fontDescent = fm.getDescent();
        int curHeight = topMargin;
        try {
            String nextLine;
            do {
                if ((nextLine = lnr.readLine()) == null) continue;
                nextLine = this.detabLine(nextLine);
                if (curHeight + fontHeight > pageHeight) {
                    ++pageNum;
                    linesForThisPage = 0;
                    pg.dispose();
                    pg = pjob.getGraphics();
                    if (pg != null) {
                        pg.setFont(helv);
                    }
                    curHeight = topMargin;
                }
                curHeight += fontHeight;
                if (pg == null) continue;
                pg.drawString(nextLine, leftMargin, curHeight - fontDescent);
                ++linesForThisPage;
                ++linesForThisJob;
            } while (nextLine != null);
        }
        catch (EOFException eof) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    String detabLine(String s) {
        if (s.indexOf(9) < 0) {
            return s;
        }
        int tabSize = 4;
        StringBuffer sb = new StringBuffer((int)((double)s.length() * 1.25));
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\t') {
                int j = 0;
                while (j < tabSize) {
                    sb.append(' ');
                    ++j;
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    boolean copy() {
        String s = this.ta.getSelectedText();
        Clipboard clip = this.getToolkit().getSystemClipboard();
        if (clip != null) {
            StringSelection cont = new StringSelection(s);
            clip.setContents(cont, this);
            return true;
        }
        return false;
    }

    void cut() {
        if (this.copy()) {
            int start = this.ta.getSelectionStart();
            int end = this.ta.getSelectionEnd();
            this.ta.replaceRange("", start, end);
            if (IJ.isMacOSX()) {
                this.ta.setCaretPosition(start);
            }
        }
    }

    void paste() {
        String s = this.ta.getSelectedText();
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable clipData = clipboard.getContents(s);
        try {
            s = (String)clipData.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            s = e.toString();
        }
        int start = this.ta.getSelectionStart();
        int end = this.ta.getSelectionEnd();
        this.ta.replaceRange(s, start, end);
        if (IJ.isMacOSX()) {
            this.ta.setCaretPosition(start + s.length());
        }
    }

    public void actionPerformed(ActionEvent evt) {
        String what = evt.getActionCommand();
        if ("Save".equals(what)) {
            this.save();
        } else if ("Compile and Run".equals(what)) {
            this.compileAndRun();
        } else if ("Run Macro".equals(what)) {
            this.runMacro();
        } else if ("Abort Macro".equals(what)) {
            Interpreter.abort();
            IJ.beep();
        } else if ("Install Macros".equals(what)) {
            this.installMacros(this.ta.getText(), true);
        } else if ("Print...".equals(what)) {
            this.print();
        } else if (what.startsWith("Paste")) {
            this.paste();
        } else if (what.startsWith("Copy")) {
            this.copy();
        } else if (what.startsWith("Cut")) {
            this.cut();
        } else if ("Save As...".equals(what)) {
            this.saveAs();
        } else if ("Select All".equals(what)) {
            this.selectAll();
        } else if ("Find...".equals(what)) {
            this.find(null);
        } else if ("Find Next".equals(what)) {
            this.find(searchString);
        } else if ("Go to Line...".equals(what)) {
            this.gotoLine();
        } else if ("Zap Gremlins".equals(what)) {
            this.zapGremlins();
        } else if ("Convert to Plugin".equals(what)) {
            this.convertToPlugin();
        } else {
            this.installer.runMacro(what);
        }
    }

    public void textValueChanged(TextEvent evt) {
        ++this.eventCount;
        if (this.eventCount > 2 || !IJ.isMacOSX() && this.eventCount > 1) {
            this.changes = true;
        }
        if (IJ.isMacOSX()) {
            this.ta.setCaretPosition(this.ta.getCaretPosition());
        }
    }

    public void windowActivated(WindowEvent e) {
        WindowManager.setWindow(this);
    }

    public void windowClosing(WindowEvent e) {
        this.close();
    }

    public void close() {
        boolean okayToClose = true;
        if (!this.getTitle().equals("Errors") && this.changes) {
            SaveChangesDialog d = new SaveChangesDialog((Frame)this, this.getTitle());
            if (d.cancelPressed()) {
                okayToClose = false;
            } else if (d.savePressed()) {
                this.save();
            }
        }
        if (okayToClose) {
            ((Component)this).setVisible(false);
            this.dispose();
            WindowManager.removeWindow(this);
            --nWindows;
        }
    }

    void saveAs() {
        String name1 = this.getTitle();
        if (defaultDir == null) {
            defaultDir = name1.endsWith(".txt") ? Menus.getMacrosPath() : Menus.getPlugInsPath();
        }
        SaveDialog sd = new SaveDialog("Save Plugin As...", defaultDir, name1, null);
        String name2 = sd.getFileName();
        String dir = sd.getDirectory();
        if (name2 != null) {
            if (name2.endsWith(".java")) {
                this.updateClassName(name1, name2);
            }
            this.path = dir + name2;
            this.save();
            this.changes = false;
            this.setWindowTitle(name2);
        }
    }

    public void updateClassName(String oldName, String newName) {
        if (newName.indexOf("_") < 0) {
            IJ.showMessage("Plugin Editor", "Plugins without an underscore in their name will not\nbe automatically installed when ImageJ is restarted.");
        }
        if (oldName.equals(newName) || !oldName.endsWith(".java") || !newName.endsWith(".java")) {
            return;
        }
        oldName = oldName.substring(0, oldName.length() - 5);
        newName = newName.substring(0, newName.length() - 5);
        String text1 = this.ta.getText();
        int index = text1.indexOf("public class " + oldName);
        if (index < 0) {
            return;
        }
        String text2 = text1.substring(0, index + 13) + newName + text1.substring(index + 13 + oldName.length(), text1.length());
        this.ta.setText(text2);
    }

    void find(String s) {
        if (s == null) {
            GenericDialog gd = new GenericDialog("Find", this);
            gd.addStringField("Find: ", searchString, 20);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            s = gd.getNextString();
        }
        if (s.equals("")) {
            return;
        }
        String text = this.ta.getText();
        int index = text.indexOf(s, this.ta.getCaretPosition() + 1);
        if (index < 0) {
            IJ.beep();
            return;
        }
        this.ta.setSelectionStart(index);
        this.ta.setSelectionEnd(index + s.length());
        searchString = s;
    }

    void gotoLine() {
        GenericDialog gd = new GenericDialog("Go to Line", this);
        gd.addNumericField("Go to line number: ", lineNumber, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int n = (int)gd.getNextNumber();
        if (n < 1) {
            return;
        }
        String text = this.ta.getText();
        char[] chars = new char[text.length()];
        chars = text.toCharArray();
        int count = 1;
        int loc = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\n') {
                ++count;
            }
            if (count == n) {
                loc = i + 1;
                break;
            }
            ++i;
        }
        this.ta.setCaretPosition(loc);
        lineNumber = n;
    }

    void zapGremlins() {
        String text = this.ta.getText();
        char[] chars = new char[text.length()];
        chars = text.toCharArray();
        int count = 0;
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (!(inQuotes || c != '\"' && c != '\'')) {
                inQuotes = true;
                quoteChar = c;
            } else if (inQuotes && (c == quoteChar || c == '\n')) {
                inQuotes = false;
            }
            if (!(inQuotes || c == '\n' || c == '\t' || c >= ' ' && c <= '\u007f')) {
                ++count;
                chars[i] = 32;
            }
            ++i;
        }
        if (count > 0) {
            text = new String(chars);
            this.ta.setText(text);
        }
        if (count > 0) {
            IJ.showMessage("Zap Gremlins", count + " invalid characters converted to spaces");
        } else {
            IJ.showMessage("Zap Gremlins", "No invalid characters found");
        }
    }

    void selectAll() {
        this.ta.selectAll();
    }

    void convertToPlugin() {
        if (!this.getTitle().endsWith(".txt")) {
            return;
        }
        String text = this.ta.getText();
        if (text == null || text.equals("")) {
            IJ.runPlugIn("ij.plugin.NewPlugin", " ");
            return;
        }
        if (text.indexOf("{") > -1) {
            IJ.showMessage("Convert to Plugin", "Conversion limited to recorder generated macro code.");
            return;
        }
        StringTokenizer st = new StringTokenizer(text, "\n");
        int n = st.countTokens();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < n) {
            String line = st.nextToken();
            if (line != null && line.length() > 3) {
                sb.append("\t\tIJ.");
                if (line.startsWith("//run")) {
                    line = line.substring(2);
                }
                sb.append(line);
                sb.append('\n');
            }
            ++i;
        }
        NewPlugin np = (NewPlugin)IJ.runPlugIn("ij.plugin.NewPlugin", new String(sb));
        Editor ed = np.getEditor();
        String title = this.getTitle();
        if (title.endsWith(".txt")) {
            title = title.substring(0, title.length() - 4);
        }
        if (title.indexOf(95) == -1) {
            title = title + "_";
        }
        title = title + ".java";
        ed.updateClassName(ed.getTitle(), title);
        ed.setTitle(title);
    }

    public void setFont(Font font) {
        this.ta.setFont(font);
    }

    public static void setDefaultDirectory(String defaultDirectory) {
        defaultDir = defaultDirectory;
    }

    public void lostOwnership(Clipboard clip, Transferable cont) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

