/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.MessageDialog;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.YesNoCancelDialog;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.RoiDecoder;
import ij.io.RoiEncoder;
import ij.io.SaveDialog;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.util.Tools;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class RoiManager
extends PlugInFrame
implements ActionListener,
ItemListener {
    Panel panel;
    static Frame instance;
    List list;
    Hashtable rois = new Hashtable();
    Roi roiCopy;
    int slice2;
    boolean canceled;
    boolean macro;

    public RoiManager() {
        super("ROI Manager");
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        ImageJ ij = IJ.getInstance();
        this.addKeyListener(ij);
        WindowManager.addWindow(this);
        this.setLayout(new FlowLayout(1, 5, 5));
        int rows = 16;
        this.list = new List(rows, true);
        this.list.add("0123456789012");
        this.list.addItemListener(this);
        this.list.addKeyListener(ij);
        this.add(this.list);
        this.panel = new Panel();
        int nButtons = IJ.isJava2() ? 10 : 9;
        this.panel.setLayout(new GridLayout(nButtons, 1, 5, 0));
        this.addButton("Add");
        this.addButton("Add & Draw");
        this.addButton("Update");
        this.addButton("Delete");
        this.addButton("Open");
        this.addButton("Open All");
        this.addButton("Save");
        this.addButton("Measure");
        this.addButton("Draw");
        if (IJ.isJava2()) {
            this.addButton("Combine");
        }
        this.add(this.panel);
        this.pack();
        this.list.remove(0);
        GUI.center(this);
        this.show();
    }

    void addButton(String label) {
        Button b = new Button(label);
        b.addActionListener(this);
        this.panel.add(b);
    }

    public void actionPerformed(ActionEvent e) {
        String label = e.getActionCommand();
        if (label == null) {
            return;
        }
        String command = label;
        if (command.equals("Add")) {
            this.add();
        } else if (command.equals("Add & Draw")) {
            this.addAndDraw();
        } else if (command.equals("Update")) {
            this.update();
        } else if (command.equals("Delete")) {
            this.delete(false);
        } else if (command.equals("Open")) {
            this.open(null);
        } else if (command.equals("Open All")) {
            this.openAll();
        } else if (command.equals("Save")) {
            this.save();
        } else if (command.equals("Measure")) {
            this.measure();
        } else if (command.equals("Draw")) {
            this.draw();
        } else if (command.equals("Combine")) {
            this.combine();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && WindowManager.getCurrentImage() != null) {
            int index = 0;
            try {
                index = Integer.parseInt(e.getItem().toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (index < 0) {
                index = 0;
            }
            this.restore(index, true);
        }
    }

    boolean add() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.error("The active image does not have a selection.");
            return false;
        }
        String type = null;
        switch (roi.getType()) {
            case 0: {
                type = "R";
                break;
            }
            case 1: {
                type = "O";
                break;
            }
            case 2: {
                type = "P";
                break;
            }
            case 3: {
                type = "F";
                break;
            }
            case 4: {
                type = "T";
                break;
            }
            case 5: {
                type = "L";
                break;
            }
            case 6: {
                type = "PL";
                break;
            }
            case 7: {
                type = "FL";
                break;
            }
            case 8: {
                type = "A";
                break;
            }
            case 9: {
                type = "C";
                break;
            }
            case 10: {
                type = "p";
            }
        }
        if (type == null) {
            return false;
        }
        String name = roi.getName();
        int slice1 = imp.getCurrentSlice();
        if (name != null && this.roiCopy != null && name.equals(this.roiCopy.getName()) && name.indexOf(45) != -1) {
            Rectangle r1 = roi.getBounds();
            Rectangle r2 = this.roiCopy.getBounds();
            if (r1.x != r2.x || r1.y != r2.y || slice1 != this.slice2) {
                name = null;
            }
        }
        String label = name != null ? name : this.getLabel(imp, roi, type);
        label = this.getUniqueName(label);
        this.list.add(label);
        roi.setName(label);
        this.roiCopy = (Roi)roi.clone();
        this.slice2 = slice1;
        this.rois.put(label, this.roiCopy);
        if (Recorder.record) {
            Recorder.record("roiManager", "Add");
        }
        return true;
    }

    String getLabel(ImagePlus imp, Roi roi, String type) {
        String ys;
        Rectangle r = roi.getBounds();
        int xc = r.x + r.width / 2;
        int yc = r.y + r.height / 2;
        int digits = 4;
        String xs = "" + xc;
        if (xs.length() > digits) {
            digits = xs.length();
        }
        if ((ys = "" + yc).length() > digits) {
            digits = ys.length();
        }
        xs = "000" + xc;
        ys = "000" + yc;
        String label = ys.substring(ys.length() - digits) + "-" + xs.substring(xs.length() - digits);
        if (imp.getStackSize() > 1) {
            String zs = "000" + imp.getCurrentSlice();
            label = zs.substring(zs.length() - digits) + "-" + label;
        }
        return label;
    }

    void addAndDraw() {
        if (!this.add()) {
            return;
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        Undo.setup(4, imp);
        IJ.run("Draw");
        Undo.setup(5, imp);
        if (Recorder.record) {
            Recorder.record("roiManager", "Add & Draw");
        }
    }

    boolean delete(boolean replacing) {
        int count = this.list.getItemCount();
        if (count == 0) {
            return this.error("The list is empty.");
        }
        int[] index = this.list.getSelectedIndexes();
        if (index.length == 0 || replacing && count > 1) {
            String msg = "Delete all items on the list?";
            if (replacing) {
                msg = "Replace items on the list?";
            }
            this.canceled = false;
            if (!IJ.macroRunning() && !this.macro) {
                YesNoCancelDialog d = new YesNoCancelDialog((Frame)this, "ROI Manager", msg);
                if (d.cancelPressed()) {
                    this.canceled = true;
                    return false;
                }
                if (!d.yesPressed()) {
                    return false;
                }
            }
            index = this.getAllIndexes();
        }
        int i = count - 1;
        while (i >= 0) {
            boolean delete = false;
            int j = 0;
            while (j < index.length) {
                if (index[j] == i) {
                    delete = true;
                }
                ++j;
            }
            if (delete) {
                this.rois.remove(this.list.getItem(i));
                this.list.remove(i);
            }
            --i;
        }
        return true;
    }

    boolean update() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.error("The active image does not have a selection.");
            return false;
        }
        int index = this.list.getSelectedIndex();
        if (index < 0) {
            return this.error("Exactly one item in the list must be selected.");
        }
        String name = this.list.getItem(index);
        this.rois.remove(name);
        this.rois.put(name, roi);
        return true;
    }

    boolean restore(int index, boolean setSlice) {
        int slice;
        String label = this.list.getItem(index);
        Roi roi = (Roi)this.rois.get(label);
        ImagePlus imp = this.getImage();
        if (imp == null || roi == null) {
            return false;
        }
        if (setSlice && (slice = this.getSlice(label)) >= 1 && slice <= imp.getStackSize()) {
            imp.setSlice(slice);
        }
        imp.setRoi((Roi)roi.clone());
        return true;
    }

    int getSlice(String label) {
        int slice = -1;
        if (label.length() == 14 && label.charAt(4) == '-' || label.length() > 14 && label.charAt(14) == '-') {
            slice = (int)Tools.parseDouble(label.substring(0, 4), -1.0);
        }
        return slice;
    }

    void open(String path) {
        Roi roi;
        Macro.setOptions(null);
        String name = null;
        if (path == null) {
            OpenDialog od = new OpenDialog("Open Selection(s)...", "");
            String directory = od.getDirectory();
            name = od.getFileName();
            if (name == null) {
                return;
            }
            path = directory + name;
        }
        if (Recorder.record) {
            Recorder.record("roiManager", "Open", path);
        }
        if (path.endsWith(".zip")) {
            this.openZip(path);
            return;
        }
        Opener o = new Opener();
        if (name == null) {
            name = o.getName(path);
        }
        if ((roi = o.openRoi(path)) != null) {
            if (name.endsWith(".roi")) {
                name = name.substring(0, name.length() - 4);
            }
            name = this.getUniqueName(name);
            this.list.add(name);
            this.rois.put(name, roi);
        }
    }

    /*
     * WARNING - void declaration
     */
    void openZip(String path) {
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(new FileInputStream(path));
            byte[] buf = new byte[1024];
            boolean firstTime = true;
            while (true) {
                int len;
                ZipEntry entry;
                if ((entry = in.getNextEntry()) == null) {
                    in.close();
                    return;
                }
                String name = entry.getName();
                if (!name.endsWith(".roi")) {
                    this.error("This ZIP archive does not appear to contain \".roi\" files");
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((len = in.read(buf)) > 0) {
                    void var5_7;
                    out.write(buf, 0, (int)var5_7);
                }
                out.close();
                byte[] bytes = out.toByteArray();
                RoiDecoder rd = new RoiDecoder(bytes, name);
                Roi roi = rd.getRoi();
                if (roi == null) continue;
                if (firstTime) {
                    if (this.list.getItemCount() > 0) {
                        this.delete(true);
                    }
                    if (this.canceled) {
                        in.close();
                        return;
                    }
                    firstTime = false;
                }
                if (name.endsWith(".roi")) {
                    name = name.substring(0, name.length() - 4);
                }
                name = this.getUniqueName(name);
                this.list.add(name);
                this.rois.put(name, roi);
            }
        }
        catch (IOException e) {
            this.error("" + e);
            return;
        }
    }

    String getUniqueName(String name) {
        String name2 = name;
        int n = 1;
        Roi roi2 = (Roi)this.rois.get(name2);
        while (roi2 != null) {
            roi2 = (Roi)this.rois.get(name2);
            if (roi2 != null) {
                name2 = name + "-" + n;
            }
            ++n;
            roi2 = (Roi)this.rois.get(name2);
        }
        return name2;
    }

    void openAll() {
        IJ.setKeyUp(18);
        Macro.setOptions(null);
        String dir = IJ.getDirectory("Open All...");
        if (dir == null) {
            return;
        }
        String[] files = new File(dir).list();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            Roi roi;
            File f = new File(dir + files[i]);
            if (!f.isDirectory() && files[i].endsWith(".roi") && (roi = new Opener().openRoi(dir + files[i])) != null) {
                String name = files[i];
                if (name.endsWith(".roi")) {
                    name = name.substring(0, name.length() - 4);
                }
                name = this.getUniqueName(name);
                this.list.add(name);
                this.rois.put(name, roi);
            }
            ++i;
        }
    }

    boolean save() {
        if (this.list.getItemCount() == 0) {
            return this.error("The selection list is empty.");
        }
        int[] indexes = this.list.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        if (indexes.length > 1) {
            return this.saveMultiple(indexes, null);
        }
        String name = this.list.getItem(indexes[0]);
        Macro.setOptions(null);
        SaveDialog sd = new SaveDialog("Save Selection...", name, ".roi");
        String name2 = sd.getFileName();
        if (name2 == null) {
            return false;
        }
        String dir = sd.getDirectory();
        Roi roi = (Roi)this.rois.get(name);
        this.rois.remove(name);
        if (!name2.endsWith(".roi")) {
            name2 = name2 + ".roi";
        }
        String newName = name2.substring(0, name2.length() - 4);
        this.rois.put(newName, roi);
        roi.setName(newName);
        this.list.replaceItem(newName, indexes[0]);
        if (this.restore(indexes[0], true)) {
            IJ.run("Selection...", "path='" + dir + name2 + "'");
        }
        return true;
    }

    boolean saveMultiple(int[] indexes, String path) {
        Macro.setOptions(null);
        if (path == null) {
            SaveDialog sd = new SaveDialog("Save ROIs...", "RoiSet", ".zip");
            String name = sd.getFileName();
            if (name == null) {
                return false;
            }
            String dir = sd.getDirectory();
            path = dir + name;
        }
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(path));
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(zos));
            RoiEncoder re = new RoiEncoder(out);
            int i = 0;
            while (i < indexes.length) {
                String label = this.list.getItem(indexes[i]);
                Roi roi = (Roi)this.rois.get(label);
                if (!label.endsWith(".roi")) {
                    label = label + ".roi";
                }
                zos.putNextEntry(new ZipEntry(label));
                re.write(roi);
                out.flush();
                ++i;
            }
            out.close();
        }
        catch (IOException e) {
            this.error("" + e);
            return false;
        }
        if (Recorder.record) {
            Recorder.record("roiManager", "Save", path);
        }
        return true;
    }

    boolean measure() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        int[] indexes = this.list.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        if (indexes.length == 0) {
            return false;
        }
        int nLines = 0;
        int i = 0;
        while (i < indexes.length) {
            String label = this.list.getItem(indexes[i]);
            Roi roi = (Roi)this.rois.get(label);
            if (roi.isLine()) {
                ++nLines;
            }
            ++i;
        }
        if (nLines > 0 && nLines != indexes.length) {
            this.error("All items must be areas or all must be lines.");
            return false;
        }
        int nSlices = 1;
        String label = this.list.getItem(indexes[0]);
        if (this.getSlice(label) == -1 || indexes.length == 1) {
            int setup = IJ.setupDialog(imp, 0);
            if (setup == 4096) {
                return false;
            }
            nSlices = setup == 32 ? imp.getStackSize() : 1;
        }
        int currentSlice = imp.getCurrentSlice();
        int slice = 1;
        while (slice <= nSlices) {
            if (nSlices > 1) {
                imp.setSlice(slice);
            }
            int i2 = 0;
            while (i2 < indexes.length) {
                if (!this.restore(indexes[i2], nSlices == 1)) break;
                IJ.run("Measure");
                ++i2;
            }
            ++slice;
        }
        imp.setSlice(currentSlice);
        if (indexes.length > 1) {
            IJ.run("Select None");
        }
        if (Recorder.record) {
            Recorder.record("roiManager", "Measure");
        }
        return true;
    }

    boolean draw() {
        int[] indexes = this.list.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        Undo.setup(4, imp);
        int i = 0;
        while (i < indexes.length) {
            if (!this.restore(indexes[i], true)) break;
            IJ.run("Draw");
            IJ.run("Select None");
            ++i;
        }
        Undo.setup(5, imp);
        if (Recorder.record) {
            Recorder.record("roiManager", "Draw");
        }
        return true;
    }

    void combine() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        int[] indexes = this.list.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        ShapeRoi s1 = null;
        ShapeRoi s2 = null;
        int i = 0;
        while (i < indexes.length) {
            Roi roi = (Roi)this.rois.get(this.list.getItem(indexes[i]));
            if (!roi.isLine() && roi.getType() != 10) {
                if (s1 == null) {
                    s1 = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
                    if (s1 == null) {
                        return;
                    }
                } else {
                    s2 = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
                    if (s2 != null && roi.isArea()) {
                        s1.or(s2);
                    }
                }
            }
            ++i;
        }
        if (s1 != null) {
            imp.setRoi(s1);
        }
        if (Recorder.record) {
            Recorder.record("roiManager", "Combine");
        }
    }

    void split() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        Roi roi = imp.getRoi();
        if (roi == null || roi.getType() != 9) {
            this.error("Image with composite selection required");
            return;
        }
        Roi[] rois = ((ShapeRoi)roi).getRois();
        if (rois.length < 2) {
            this.error("Enable to decompose this composite ROI into two or more simple ROIs.");
            return;
        }
        if (this.list.getItemCount() > 0 && !this.delete(true)) {
            return;
        }
        int i = 0;
        while (i < rois.length) {
            imp.setRoi(rois[i]);
            this.add();
            ++i;
        }
        if (Recorder.record) {
            Recorder.record("roiManager", "Split");
        }
    }

    int[] getAllIndexes() {
        int count = this.list.getItemCount();
        int[] indexes = new int[count];
        int i = 0;
        while (i < count) {
            indexes[i] = i;
            ++i;
        }
        return indexes;
    }

    ImagePlus getImage() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            this.error("There are no images open.");
            return null;
        }
        return imp;
    }

    boolean error(String msg) {
        new MessageDialog((Frame)this, "ROI Manager", msg);
        Macro.abort();
        return false;
    }

    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            instance = null;
        }
    }

    public static RoiManager getInstance() {
        return (RoiManager)instance;
    }

    public Hashtable getROIs() {
        return this.rois;
    }

    public List getList() {
        return this.list;
    }

    public boolean runCommand(String cmd) {
        cmd = cmd.toLowerCase();
        this.macro = true;
        boolean ok = true;
        if (cmd.equals("add")) {
            this.add();
        } else if (cmd.equals("add & draw")) {
            this.addAndDraw();
        } else if (cmd.equals("delete")) {
            this.delete(false);
        } else if (cmd.equals("measure")) {
            this.measure();
        } else if (cmd.equals("draw")) {
            this.draw();
        } else if (cmd.equals("combine")) {
            this.combine();
        } else {
            ok = false;
        }
        this.macro = false;
        return ok;
    }

    public boolean runCommand(String cmd, String path) {
        cmd = cmd.toLowerCase();
        this.macro = true;
        if (cmd.equals("open")) {
            this.open(path);
            this.macro = false;
            return true;
        }
        if (cmd.equals("save")) {
            if (!path.endsWith(".zip")) {
                return this.error("Path must end with '.zip'");
            }
            if (this.list.getItemCount() == 0) {
                return this.error("The selection list is empty.");
            }
            int[] indexes = this.list.getSelectedIndexes();
            if (indexes.length == 0) {
                indexes = this.getAllIndexes();
            }
            boolean ok = this.saveMultiple(indexes, path);
            this.macro = false;
            return ok;
        }
        return false;
    }

    public void close() {
        super.close();
        instance = null;
    }
}

