/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class ColorStatistics
extends ImageStatistics {
    public ColorStatistics(ImageProcessor ip) {
        this(ip, 27, null);
    }

    public ColorStatistics(ImageProcessor ip, int mOptions, Calibration cal) {
        ColorProcessor cp = (ColorProcessor)ip;
        this.histogram = cp.getHistogram();
        this.setup(ip, cal);
        this.getRawStatistics(0, 255);
        if ((mOptions & 0x10) != 0) {
            this.getRawMinAndMax(0, 255);
        }
        if ((mOptions & 0x800) != 0) {
            this.fitEllipse(ip);
        } else if ((mOptions & 0x20) != 0) {
            this.getCentroid(ip);
        }
        if ((mOptions & 0x40) != 0) {
            this.getCenterOfMass(ip);
        }
    }

    void getCenterOfMass(ImageProcessor ip) {
        byte[] mask = ip.getMaskArray();
        double count = 0.0;
        double xsum = 0.0;
        double ysum = 0.0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            int x = this.rx;
            while (x < this.rx + this.rw) {
                if (mask == null || mask[mi++] != 0) {
                    double v = ip.getPixelValue(x, y);
                    count += v;
                    xsum += (double)x * v;
                    ysum += (double)y * v;
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
        this.xCenterOfMass = (xsum / count + 0.5) * this.pw;
        this.yCenterOfMass = (ysum / count + 0.5) * this.ph;
    }
}

