/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.MedianCut;
import java.awt.image.ColorModel;

public class ImageConverter {
    private ImagePlus imp;
    private int type;
    private static boolean doScaling = true;

    public ImageConverter(ImagePlus imp) {
        this.imp = imp;
        this.type = imp.getType();
    }

    public synchronized void convertToGray8() {
        if (this.imp.getStackSize() > 1) {
            throw new IllegalArgumentException("Unsupported conversion");
        }
        ImageProcessor ip = this.imp.getProcessor();
        if (this.type == 1 || this.type == 2) {
            this.imp.setProcessor(null, ip.convertToByte(doScaling));
            this.imp.setCalibration(this.imp.getCalibration());
        } else if (this.type == 4) {
            this.imp.setProcessor(null, ip.convertToByte(doScaling));
        } else if (ip.isPseudoColorLut()) {
            boolean invertedLut = ip.isInvertedLut();
            ip.setColorModel(LookUpTable.createGrayscaleColorModel(invertedLut));
            this.imp.updateAndDraw();
        } else {
            ip = new ColorProcessor(this.imp.getImage());
            this.imp.setProcessor(null, ip.convertToByte(doScaling));
        }
    }

    public void convertToGray16() {
        if (this.type == 1) {
            return;
        }
        if (this.type != 0 && this.type != 2) {
            throw new IllegalArgumentException("Unsupported conversion");
        }
        ImageProcessor ip = this.imp.getProcessor();
        this.imp.trimProcessor();
        this.imp.setProcessor(null, ip.convertToShort(doScaling));
        this.imp.setCalibration(this.imp.getCalibration());
    }

    public void convertToGray32() {
        if (this.type == 2) {
            return;
        }
        if (this.type != 0 && this.type != 1) {
            throw new IllegalArgumentException("Unsupported conversion");
        }
        ImageProcessor ip = this.imp.getProcessor();
        this.imp.trimProcessor();
        Calibration cal = this.imp.getCalibration();
        ip.setCalibrationTable(cal.getCTable());
        this.imp.setProcessor(null, ip.convertToFloat());
        this.imp.setCalibration(cal);
    }

    public void convertToRGB() {
        ImageProcessor ip = this.imp.getProcessor();
        this.imp.setProcessor(null, ip.convertToRGB());
        this.imp.setCalibration(this.imp.getCalibration());
    }

    public void convertToRGBStack() {
        if (this.type != 4) {
            throw new IllegalArgumentException("Image must be RGB");
        }
        ColorProcessor cp = this.imp.getType() == 4 ? (ColorProcessor)this.imp.getProcessor() : new ColorProcessor(this.imp.getImage());
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        byte[] R = new byte[width * height];
        byte[] G = new byte[width * height];
        byte[] B = new byte[width * height];
        cp.getRGB(R, G, B);
        this.imp.trimProcessor();
        ColorModel cm = LookUpTable.createGrayscaleColorModel(false);
        ImageStack stack = new ImageStack(width, height, cm);
        stack.addSlice("Red", R);
        stack.addSlice("Green", G);
        stack.addSlice("Blue", B);
        this.imp.setStack(null, stack);
    }

    public void convertToHSB() {
        if (this.type != 4) {
            throw new IllegalArgumentException("Image must be RGB");
        }
        ColorProcessor cp = this.imp.getType() == 4 ? (ColorProcessor)this.imp.getProcessor() : new ColorProcessor(this.imp.getImage());
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        byte[] H = new byte[width * height];
        byte[] S = new byte[width * height];
        byte[] B = new byte[width * height];
        cp.getHSB(H, S, B);
        this.imp.trimProcessor();
        ColorModel cm = LookUpTable.createGrayscaleColorModel(false);
        ImageStack stack = new ImageStack(width, height, cm);
        stack.addSlice("Hue", H);
        stack.addSlice("Saturation", S);
        stack.addSlice("Brightness", B);
        this.imp.setStack(null, stack);
    }

    public void convertRGBStackToRGB() {
        int stackSize = this.imp.getStackSize();
        if (stackSize < 2 || stackSize > 4 || this.type != 0) {
            throw new IllegalArgumentException("2 or 3 slice 8-bit stack required");
        }
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        ImageStack stack = this.imp.getStack();
        byte[] R = (byte[])stack.getPixels(1);
        byte[] G = (byte[])stack.getPixels(2);
        byte[] B = stackSize > 2 ? (byte[])stack.getPixels(3) : new byte[width * height];
        this.imp.trimProcessor();
        ColorProcessor cp = new ColorProcessor(width, height);
        cp.setRGB(R, G, B);
        if (this.imp.isInvertedLut()) {
            cp.invert();
        }
        this.imp.setImage(cp.createImage());
        this.imp.killStack();
    }

    public void convertHSBToRGB() {
        if (this.imp.getStackSize() != 3) {
            throw new IllegalArgumentException("3-slice 8-bit stack required");
        }
        ImageStack stack = this.imp.getStack();
        byte[] H = (byte[])stack.getPixels(1);
        byte[] S = (byte[])stack.getPixels(2);
        byte[] B = (byte[])stack.getPixels(3);
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        this.imp.trimProcessor();
        ColorProcessor cp = new ColorProcessor(width, height);
        cp.setHSB(H, S, B);
        this.imp.setImage(cp.createImage());
        this.imp.killStack();
    }

    public void convertRGBtoIndexedColor(int nColors) {
        if (this.type != 4) {
            throw new IllegalArgumentException("Image must be RGB");
        }
        if (nColors < 2) {
            nColors = 2;
        }
        if (nColors > 256) {
            nColors = 256;
        }
        IJ.showProgress(0.1);
        IJ.showStatus("Grabbing pixels");
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        ImageProcessor ip = this.imp.getProcessor();
        ip.snapshot();
        int[] pixels = (int[])ip.getPixels();
        this.imp.trimProcessor();
        long start = System.currentTimeMillis();
        MedianCut mc = new MedianCut(pixels, width, height);
        ImageProcessor ip2 = mc.convertToByte(nColors);
        this.imp.setProcessor(null, ip2);
    }

    public static void setDoScaling(boolean scaleConversions) {
        doScaling = scaleConversions;
    }

    public static boolean getDoScaling() {
        return doScaling;
    }
}

