/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.plugin.filter.Convolver;
import ij.process.ImageProcessor;
import ij.process.ShortBlitter;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Random;

public class ShortProcessor
extends ImageProcessor {
    private int min;
    private int max;
    private int snapshotMin;
    private int snapshotMax;
    private short[] pixels;
    private short[] snapshotPixels;
    private byte[] pixels8;
    private byte[] LUT;
    private boolean fixedScale;

    public ShortProcessor(int width, int height, short[] pixels, ColorModel cm) {
        if (pixels != null && width * height != pixels.length) {
            throw new IllegalArgumentException("(width*height) != pixels.length");
        }
        this.width = width;
        this.height = height;
        this.pixels = pixels;
        this.cm = cm;
        this.resetRoi();
        if (pixels != null) {
            this.findMinAndMax();
        }
        this.fgColor = this.max;
    }

    public ShortProcessor(int width, int height) {
        this(width, height, new short[width * height], null);
    }

    public ShortProcessor(int width, int height, short[] pixels, ColorModel cm, boolean unsigned) {
        this(width, height, pixels, cm);
    }

    public ShortProcessor(int width, int height, boolean unsigned) {
        this(width, height);
    }

    public void findMinAndMax() {
        if (this.fixedScale) {
            return;
        }
        int size = this.width * this.height;
        this.min = 65535;
        this.max = 0;
        int i = 0;
        while (i < size) {
            int value = this.pixels[i] & 0xFFFF;
            if (value < this.min) {
                this.min = value;
            }
            if (value > this.max) {
                this.max = value;
            }
            ++i;
        }
        this.hideProgress();
    }

    public Image createImage() {
        boolean firstTime;
        boolean bl = firstTime = this.pixels8 == null;
        if (firstTime || !this.lutAnimation) {
            int size = this.width * this.height;
            if (this.pixels8 == null) {
                this.pixels8 = new byte[size];
            }
            double scale = 256.0 / (double)(this.max - this.min + 1);
            int i = 0;
            while (i < size) {
                int value = (this.pixels[i] & 0xFFFF) - this.min;
                if (value < 0) {
                    value = 0;
                }
                if ((value = (int)((double)value * scale)) > 255) {
                    value = 255;
                }
                this.pixels8[i] = (byte)value;
                ++i;
            }
        }
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (this.source == null || IJ.isMacintosh() && (!IJ.isJava2() || this.lutAnimation)) {
            this.source = new MemoryImageSource(this.width, this.height, this.cm, this.pixels8, 0, this.width);
            this.source.setAnimated(true);
            this.source.setFullBufferUpdates(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.source);
        } else if (this.newPixels) {
            this.source.newPixels(this.pixels8, this.cm, 0, this.width);
            this.newPixels = false;
        } else {
            this.source.newPixels();
        }
        this.lutAnimation = false;
        return this.img;
    }

    public ImageProcessor createProcessor(int width, int height) {
        ShortProcessor ip2 = new ShortProcessor(width, height, new short[width * height], this.getColorModel());
        ((ImageProcessor)ip2).setMinAndMax(this.getMin(), this.getMax());
        return ip2;
    }

    public void snapshot() {
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
        this.snapshotMin = this.min;
        this.snapshotMax = this.max;
        if (this.snapshotPixels == null || this.snapshotPixels != null && this.snapshotPixels.length != this.pixels.length) {
            this.snapshotPixels = new short[this.width * this.height];
        }
        System.arraycopy(this.pixels, 0, this.snapshotPixels, 0, this.width * this.height);
        this.newSnapshot = true;
    }

    public void reset() {
        if (this.snapshotPixels == null) {
            return;
        }
        this.min = this.snapshotMin;
        this.max = this.snapshotMax;
        System.arraycopy(this.snapshotPixels, 0, this.pixels, 0, this.width * this.height);
        this.newSnapshot = true;
    }

    public void reset(ImageProcessor mask) {
        if (mask == null || this.snapshotPixels == null) {
            return;
        }
        if (mask.getWidth() != this.roiWidth || mask.getHeight() != this.roiHeight) {
            throw new IllegalArgumentException(this.maskSizeError(mask));
        }
        byte[] mpixels = (byte[])mask.getPixels();
        int y = this.roiY;
        int my = 0;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int mi = my * this.roiWidth;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                if (mpixels[mi++] == 0) {
                    this.pixels[i] = this.snapshotPixels[i];
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMinAndMax(double min, double max) {
        if (min == 0.0 && max == 0.0) {
            this.resetMinAndMax();
            return;
        }
        if (min < 0.0) {
            min = 0.0;
        }
        if (max > 65535.0) {
            max = 65535.0;
        }
        this.min = (int)min;
        this.max = (int)max;
        this.fixedScale = true;
        this.resetThreshold();
    }

    public void resetMinAndMax() {
        this.fixedScale = false;
        this.findMinAndMax();
        this.resetThreshold();
    }

    public int getPixel(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return this.pixels[y * this.width + x] & 0xFFFF;
        }
        return 0;
    }

    public double getInterpolatedPixel(double x, double y) {
        if (x < 0.0) {
            x = 0.0;
        }
        if (x >= (double)this.width - 1.0) {
            x = (double)this.width - 1.001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if (y >= (double)this.height - 1.0) {
            y = (double)this.height - 1.001;
        }
        return this.getInterpolatedPixel(x, y, this.pixels);
    }

    public double getInterpolatedValue(double x, double y) {
        double value = this.getInterpolatedPixel(x, y);
        if (this.cTable == null) {
            return value;
        }
        return this.cTable[(int)(value + 0.5)];
    }

    public void putPixel(int x, int y, int value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            if (value > 65535) {
                value = 65535;
            }
            if (value < 0) {
                value = 0;
            }
            this.pixels[y * this.width + x] = (short)value;
        }
    }

    public void putPixelValue(int x, int y, double value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            if (this.cTable != null && this.cTable[0] == -32768.0f) {
                value += 32768.0;
            }
            if (value > 65535.0) {
                value = 65535.0;
            } else if (value < 0.0) {
                value = 0.0;
            }
            this.pixels[y * this.width + x] = (short)(value + 0.5);
        }
    }

    public void drawPixel(int x, int y) {
        if (x >= this.clipXMin && x <= this.clipXMax && y >= this.clipYMin && y <= this.clipYMax) {
            this.putPixel(x, y, this.fgColor);
        }
    }

    public float getPixelValue(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            if (this.cTable == null) {
                return this.pixels[y * this.width + x] & 0xFFFF;
            }
            return this.cTable[this.pixels[y * this.width + x] & 0xFFFF];
        }
        return 0.0f;
    }

    public Object getPixels() {
        return this.pixels;
    }

    public Object getPixelsCopy() {
        if (this.newSnapshot) {
            return this.snapshotPixels;
        }
        short[] pixels2 = new short[this.width * this.height];
        System.arraycopy(this.pixels, 0, pixels2, 0, this.width * this.height);
        return pixels2;
    }

    public void setPixels(Object pixels) {
        this.pixels = (short[])pixels;
        this.resetPixels(pixels);
        this.snapshotPixels = null;
        if (pixels == null) {
            this.pixels8 = null;
        }
    }

    void getRow2(int x, int y, int[] data, int length) {
        int i = 0;
        while (i < length) {
            data[i] = this.pixels[y * this.width + x + i] & 0xFFFF;
            ++i;
        }
    }

    void putColumn2(int x, int y, int[] data, int length) {
        int i = 0;
        while (i < length) {
            this.pixels[(y + i) * this.width + x] = (short)data[i];
            ++i;
        }
    }

    public void copyBits(ImageProcessor ip, int xloc, int yloc, int mode) {
        if (!(ip instanceof ShortProcessor)) {
            throw new IllegalArgumentException("16-bit image required");
        }
        new ShortBlitter(this).copyBits(ip, xloc, yloc, mode);
    }

    public void applyTable(int[] lut) {
        if (lut.length != 65536) {
            throw new IllegalArgumentException("lut.length!=65536");
        }
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int lineEnd;
            int lineStart = y * this.width + this.roiX;
            int i = lineEnd = lineStart + this.roiWidth;
            while (--i >= lineStart) {
                int v = lut[this.pixels[i] & 0xFFFF];
                this.pixels[i] = (short)v;
            }
            ++y;
        }
        this.findMinAndMax();
    }

    private void process(int op, double value) {
        double range = this.max - this.min;
        boolean resetMinMax = this.roiWidth == this.width && this.roiHeight == this.height && op != 1;
        int offset = this.cTable != null && this.cTable[0] == -32768.0f ? 32768 : 0;
        int min2 = this.min - offset;
        int max2 = this.max - offset;
        int fgColor2 = this.fgColor - offset;
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                int v2;
                int v1 = (this.pixels[i] & 0xFFFF) - offset;
                switch (op) {
                    case 0: {
                        v2 = max2 - (v1 - min2);
                        break;
                    }
                    case 1: {
                        v2 = fgColor2;
                        break;
                    }
                    case 2: {
                        v2 = v1 + (int)value;
                        break;
                    }
                    case 3: {
                        v2 = (int)Math.round((double)v1 * value);
                        break;
                    }
                    case 4: {
                        v2 = v1 & (int)value;
                        break;
                    }
                    case 5: {
                        v2 = v1 | (int)value;
                        break;
                    }
                    case 6: {
                        v2 = v1 ^ (int)value;
                        break;
                    }
                    case 7: {
                        if (range <= 0.0 || v1 == min2) {
                            v2 = v1;
                            break;
                        }
                        v2 = (int)(Math.exp(value * Math.log((double)(v1 - min2) / range)) * range + (double)min2);
                        break;
                    }
                    case 8: {
                        if (v1 <= 0) {
                            v2 = 0;
                            break;
                        }
                        v2 = (int)(Math.log(v1) * ((double)max2 / Math.log(max2)));
                        break;
                    }
                    case 11: {
                        v2 = v1 * v1;
                        break;
                    }
                    case 12: {
                        v2 = (int)Math.sqrt(v1);
                        break;
                    }
                    case 9: {
                        if ((double)v1 < value) {
                            v2 = (int)value;
                            break;
                        }
                        v2 = v1;
                        break;
                    }
                    case 10: {
                        if ((double)v1 > value) {
                            v2 = (int)value;
                            break;
                        }
                        v2 = v1;
                        break;
                    }
                    default: {
                        v2 = v1;
                    }
                }
                if ((v2 += offset) < 0) {
                    v2 = 0;
                }
                if (v2 > 65535) {
                    v2 = 65535;
                }
                this.pixels[i++] = (short)v2;
                ++x;
            }
            if (y % 20 == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        if (resetMinMax) {
            this.findMinAndMax();
        }
        this.showProgress(1.0);
    }

    public void invert() {
        this.resetMinAndMax();
        this.process(0, 0.0);
    }

    public void add(int value) {
        this.process(2, value);
    }

    public void add(double value) {
        this.process(2, value);
    }

    public void multiply(double value) {
        this.process(3, value);
    }

    public void and(int value) {
        this.process(4, value);
    }

    public void or(int value) {
        this.process(5, value);
    }

    public void xor(int value) {
        this.process(6, value);
    }

    public void gamma(double value) {
        this.process(7, value);
    }

    public void log() {
        this.process(8, 0.0);
    }

    public void sqr() {
        this.process(11, 0.0);
    }

    public void sqrt() {
        this.process(12, 0.0);
    }

    public void min(double value) {
        this.process(9, value);
    }

    public void max(double value) {
        this.process(10, value);
    }

    public void fill() {
        this.process(1, 0.0);
    }

    public void fill(ImageProcessor mask) {
        if (mask == null) {
            this.fill();
            return;
        }
        if (mask.getWidth() != this.roiWidth || mask.getHeight() != this.roiHeight) {
            throw new IllegalArgumentException(this.maskSizeError(mask));
        }
        byte[] mpixels = (byte[])mask.getPixels();
        int y = this.roiY;
        int my = 0;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int mi = my * this.roiWidth;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                if (mpixels[mi++] != 0) {
                    this.pixels[i] = (short)this.fgColor;
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
    }

    public void convolve3x3(int[] kernel) {
        int inc;
        int k1 = kernel[0];
        int k2 = kernel[1];
        int k3 = kernel[2];
        int k4 = kernel[3];
        int k5 = kernel[4];
        int k6 = kernel[5];
        int k7 = kernel[6];
        int k8 = kernel[7];
        int k9 = kernel[8];
        int scale = 0;
        int i = 0;
        while (i < kernel.length) {
            scale += kernel[i];
            ++i;
        }
        if (scale == 0) {
            scale = 1;
        }
        if ((inc = this.roiHeight / 25) < 1) {
            inc = 1;
        }
        short[] pixels2 = (short[])this.getPixelsCopy();
        int rowOffset = this.width;
        int y = this.yMin;
        while (y <= this.yMax) {
            int offset = this.xMin + y * this.width;
            int p1 = 0;
            int p2 = pixels2[offset - rowOffset - 1] & 0xFFFF;
            int p3 = pixels2[offset - rowOffset] & 0xFFFF;
            int p4 = 0;
            int p5 = pixels2[offset - 1] & 0xFFFF;
            int p6 = pixels2[offset] & 0xFFFF;
            int p7 = 0;
            int p8 = pixels2[offset + rowOffset - 1] & 0xFFFF;
            int p9 = pixels2[offset + rowOffset] & 0xFFFF;
            int x = this.xMin;
            while (x <= this.xMax) {
                p1 = p2;
                p2 = p3;
                p3 = pixels2[offset - rowOffset + 1] & 0xFFFF;
                p4 = p5;
                p5 = p6;
                p6 = pixels2[offset + 1] & 0xFFFF;
                p7 = p8;
                p8 = p9;
                p9 = pixels2[offset + rowOffset + 1] & 0xFFFF;
                int sum = k1 * p1 + k2 * p2 + k3 * p3 + k4 * p4 + k5 * p5 + k6 * p6 + k7 * p7 + k8 * p8 + k9 * p9;
                if ((sum /= scale) > 65535) {
                    sum = 65535;
                }
                if (sum < 0) {
                    sum = 0;
                }
                this.pixels[offset++] = (short)sum;
                ++x;
            }
            if (y % inc == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        this.hideProgress();
    }

    public void filter(int type) {
        int inc = this.roiHeight / 25;
        if (inc < 1) {
            inc = 1;
        }
        short[] pixels2 = (short[])this.getPixelsCopy();
        int sum = 0;
        int rowOffset = this.width;
        int y = this.yMin;
        while (y <= this.yMax) {
            int offset = this.xMin + y * this.width;
            int p1 = 0;
            int p2 = pixels2[offset - rowOffset - 1] & 0xFFFF;
            int p3 = pixels2[offset - rowOffset] & 0xFFFF;
            int p4 = 0;
            int p5 = pixels2[offset - 1] & 0xFFFF;
            int p6 = pixels2[offset] & 0xFFFF;
            int p7 = 0;
            int p8 = pixels2[offset + rowOffset - 1] & 0xFFFF;
            int p9 = pixels2[offset + rowOffset] & 0xFFFF;
            int x = this.xMin;
            while (x <= this.xMax) {
                p1 = p2;
                p2 = p3;
                p3 = pixels2[offset - rowOffset + 1] & 0xFFFF;
                p4 = p5;
                p5 = p6;
                p6 = pixels2[offset + 1] & 0xFFFF;
                p7 = p8;
                p8 = p9;
                p9 = pixels2[offset + rowOffset + 1] & 0xFFFF;
                switch (type) {
                    case 0: {
                        sum = (p1 + p2 + p3 + p4 + p5 + p6 + p7 + p8 + p9) / 9;
                        break;
                    }
                    case 1: {
                        int sum1 = p1 + 2 * p2 + p3 - p7 - 2 * p8 - p9;
                        int sum2 = p1 + 2 * p4 + p7 - p3 - 2 * p6 - p9;
                        sum = (int)Math.sqrt(sum1 * sum1 + sum2 * sum2);
                    }
                }
                this.pixels[offset++] = (short)sum;
                ++x;
            }
            if (y % inc == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        if (type == 0) {
            this.hideProgress();
        } else {
            this.findMinAndMax();
        }
    }

    public void rotate(double angle) {
        short[] pixels2 = (short[])this.getPixelsCopy();
        double centerX = (double)this.roiX + (double)(this.roiWidth - 1) / 2.0;
        double centerY = (double)this.roiY + (double)(this.roiHeight - 1) / 2.0;
        int xMax = this.roiX + this.roiWidth - 1;
        double angleRadians = -angle / 57.29577951308232;
        double ca = Math.cos(angleRadians);
        double sa = Math.sin(angleRadians);
        double tmp1 = centerY * sa - centerX * ca;
        double tmp2 = -centerX * sa - centerY * ca;
        double dwidth = this.width;
        double dheight = this.height;
        double xlimit = (double)this.width - 1.0;
        double xlimit2 = (double)this.width - 1.001;
        double ylimit = (double)this.height - 1.0;
        double ylimit2 = (double)this.height - 1.001;
        int background = this.cTable != null && this.cTable[0] == -32768.0f ? 32768 : 0;
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int index = y * this.width + this.roiX;
            double tmp3 = tmp1 - (double)y * sa + centerX;
            double tmp4 = tmp2 + (double)y * ca + centerY;
            int x = this.roiX;
            while (x <= xMax) {
                double xs = (double)x * ca + tmp3;
                double ys = (double)x * sa + tmp4;
                if (xs >= -0.01 && xs < dwidth && ys >= -0.01 && ys < dheight) {
                    if (this.interpolate) {
                        if (xs < 0.0) {
                            xs = 0.0;
                        }
                        if (xs >= xlimit) {
                            xs = xlimit2;
                        }
                        if (ys < 0.0) {
                            ys = 0.0;
                        }
                        if (ys >= ylimit) {
                            ys = ylimit2;
                        }
                        this.pixels[index++] = (short)(this.getInterpolatedPixel(xs, ys, pixels2) + 0.5);
                    } else {
                        int ixs = (int)(xs + 0.5);
                        int iys = (int)(ys + 0.5);
                        if (ixs >= this.width) {
                            ixs = this.width - 1;
                        }
                        if (iys >= this.height) {
                            iys = this.height - 1;
                        }
                        this.pixels[index++] = pixels2[this.width * iys + ixs];
                    }
                } else {
                    this.pixels[index++] = (short)background;
                }
                ++x;
            }
            if (y % 30 == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        this.hideProgress();
    }

    public void flipVertical() {
        int y = 0;
        while (y < this.roiHeight / 2) {
            int index1 = (this.roiY + y) * this.width + this.roiX;
            int index2 = (this.roiY + this.roiHeight - 1 - y) * this.width + this.roiX;
            int i = 0;
            while (i < this.roiWidth) {
                short tmp = this.pixels[index1];
                this.pixels[index1++] = this.pixels[index2];
                this.pixels[index2++] = tmp;
                ++i;
            }
            ++y;
        }
        this.newSnapshot = false;
    }

    public void scale(double xScale, double yScale) {
        int ymax;
        int ymin;
        int xmax;
        int xmin;
        double xCenter = (double)this.roiX + (double)this.roiWidth / 2.0;
        double yCenter = (double)this.roiY + (double)this.roiHeight / 2.0;
        if (xScale > 1.0 && yScale > 1.0) {
            xmin = (int)(xCenter - (xCenter - (double)this.roiX) * xScale);
            if (xmin < 0) {
                xmin = 0;
            }
            if ((xmax = xmin + (int)((double)this.roiWidth * xScale) - 1) >= this.width) {
                xmax = this.width - 1;
            }
            if ((ymin = (int)(yCenter - (yCenter - (double)this.roiY) * yScale)) < 0) {
                ymin = 0;
            }
            if ((ymax = ymin + (int)((double)this.roiHeight * yScale) - 1) >= this.height) {
                ymax = this.height - 1;
            }
        } else {
            xmin = this.roiX;
            xmax = this.roiX + this.roiWidth - 1;
            ymin = this.roiY;
            ymax = this.roiY + this.roiHeight - 1;
        }
        short[] pixels2 = (short[])this.getPixelsCopy();
        boolean checkCoordinates = xScale < 1.0 || yScale < 1.0;
        double xlimit = (double)this.width - 1.0;
        double xlimit2 = (double)this.width - 1.001;
        double ylimit = (double)this.height - 1.0;
        double ylimit2 = (double)this.height - 1.001;
        int y = ymin;
        while (y <= ymax) {
            double ys = ((double)y - yCenter) / yScale + yCenter;
            int ysi = (int)ys;
            if (ys < 0.0) {
                ys = 0.0;
            }
            if (ys >= ylimit) {
                ys = ylimit2;
            }
            int index1 = y * this.width + xmin;
            int index2 = this.width * (int)ys;
            int x = xmin;
            while (x <= xmax) {
                double xs = ((double)x - xCenter) / xScale + xCenter;
                int xsi = (int)xs;
                if (checkCoordinates && (xsi < xmin || xsi > xmax || ysi < ymin || ysi > ymax)) {
                    this.pixels[index1++] = (short)this.min;
                } else if (this.interpolate) {
                    if (xs < 0.0) {
                        xs = 0.0;
                    }
                    if (xs >= xlimit) {
                        xs = xlimit2;
                    }
                    this.pixels[index1++] = (short)(this.getInterpolatedPixel(xs, ys, pixels2) + 0.5);
                } else {
                    this.pixels[index1++] = pixels2[index2 + xsi];
                }
                ++x;
            }
            if (y % 20 == 0) {
                this.showProgress((double)(y - ymin) / (double)this.height);
            }
            ++y;
        }
        this.hideProgress();
    }

    private final double getInterpolatedPixel(double x, double y, short[] pixels) {
        int xbase = (int)x;
        int ybase = (int)y;
        double xFraction = x - (double)xbase;
        double yFraction = y - (double)ybase;
        int offset = ybase * this.width + xbase;
        int lowerLeft = pixels[offset] & 0xFFFF;
        int lowerRight = pixels[offset + 1] & 0xFFFF;
        int upperRight = pixels[offset + this.width + 1] & 0xFFFF;
        int upperLeft = pixels[offset + this.width] & 0xFFFF;
        double upperAverage = (double)upperLeft + xFraction * (double)(upperRight - upperLeft);
        double lowerAverage = (double)lowerLeft + xFraction * (double)(lowerRight - lowerLeft);
        return lowerAverage + yFraction * (upperAverage - lowerAverage);
    }

    public ImageProcessor resize(int dstWidth, int dstHeight) {
        double srcCenterX = (double)this.roiX + (double)this.roiWidth / 2.0;
        double srcCenterY = (double)this.roiY + (double)this.roiHeight / 2.0;
        double dstCenterX = (double)dstWidth / 2.0;
        double dstCenterY = (double)dstHeight / 2.0;
        double xScale = (double)dstWidth / (double)this.roiWidth;
        double yScale = (double)dstHeight / (double)this.roiHeight;
        if (this.interpolate) {
            dstCenterX += xScale / 2.0;
            dstCenterY += yScale / 2.0;
        }
        ImageProcessor ip2 = this.createProcessor(dstWidth, dstHeight);
        short[] pixels2 = (short[])ip2.getPixels();
        double xlimit = (double)this.width - 1.0;
        double xlimit2 = (double)this.width - 1.001;
        double ylimit = (double)this.height - 1.0;
        double ylimit2 = (double)this.height - 1.001;
        int y = 0;
        while (y <= dstHeight - 1) {
            double ys = ((double)y - dstCenterY) / yScale + srcCenterY;
            if (this.interpolate) {
                if (ys < 0.0) {
                    ys = 0.0;
                }
                if (ys >= ylimit) {
                    ys = ylimit2;
                }
            }
            int index1 = this.width * (int)ys;
            int index2 = y * dstWidth;
            int x = 0;
            while (x <= dstWidth - 1) {
                double xs = ((double)x - dstCenterX) / xScale + srcCenterX;
                if (this.interpolate) {
                    if (xs < 0.0) {
                        xs = 0.0;
                    }
                    if (xs >= xlimit) {
                        xs = xlimit2;
                    }
                    pixels2[index2++] = (short)(this.getInterpolatedPixel(xs, ys, this.pixels) + 0.5);
                } else {
                    pixels2[index2++] = this.pixels[index1 + (int)xs];
                }
                ++x;
            }
            if (y % 20 == 0) {
                this.showProgress((double)y / (double)dstHeight);
            }
            ++y;
        }
        this.hideProgress();
        return ip2;
    }

    public ImageProcessor crop() {
        ImageProcessor ip2 = this.createProcessor(this.roiWidth, this.roiHeight);
        short[] pixels2 = (short[])ip2.getPixels();
        int ys = this.roiY;
        while (ys < this.roiY + this.roiHeight) {
            int offset1 = (ys - this.roiY) * this.roiWidth;
            int offset2 = ys * this.width + this.roiX;
            int xs = 0;
            while (xs < this.roiWidth) {
                pixels2[offset1++] = this.pixels[offset2++];
                ++xs;
            }
            ++ys;
        }
        return ip2;
    }

    public void setColor(Color color) {
        int bestIndex = this.getBestIndex(color);
        if (bestIndex > 0 && this.getMin() == 0.0 && this.getMax() == 0.0) {
            this.setValue(bestIndex);
            this.setMinAndMax(0.0, 255.0);
        } else if (bestIndex == 0 && this.getMin() > 0.0 && (color.getRGB() & 0xFFFFFF) == 0) {
            this.setValue(0.0);
        } else {
            this.fgColor = (int)(this.getMin() + (this.getMax() - this.getMin()) * ((double)bestIndex / 255.0));
        }
    }

    public void setValue(double value) {
        this.fgColor = (int)value;
        if (this.fgColor < 0) {
            this.fgColor = 0;
        }
        if (this.fgColor > 65535) {
            this.fgColor = 65535;
        }
    }

    public int[] getHistogram() {
        if (this.mask != null) {
            return this.getHistogram(this.mask);
        }
        int[] histogram = new int[65536];
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                int n = this.pixels[i++] & 0xFFFF;
                histogram[n] = histogram[n] + 1;
                ++x;
            }
            ++y;
        }
        return histogram;
    }

    int[] getHistogram(ImageProcessor mask) {
        if (mask.getWidth() != this.roiWidth || mask.getHeight() != this.roiHeight) {
            throw new IllegalArgumentException(this.maskSizeError(mask));
        }
        byte[] mpixels = (byte[])mask.getPixels();
        int[] histogram = new int[65536];
        int y = this.roiY;
        int my = 0;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int mi = my * this.roiWidth;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                if (mpixels[mi++] != 0) {
                    int n = this.pixels[i] & 0xFFFF;
                    histogram[n] = histogram[n] + 1;
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
        return histogram;
    }

    public void setThreshold(double minThreshold, double maxThreshold, int lutUpdate) {
        if (minThreshold != -808080.0 && this.max > this.min) {
            double minT = Math.round((minThreshold - (double)this.min) / (double)(this.max - this.min) * 255.0);
            double maxT = Math.round((maxThreshold - (double)this.min) / (double)(this.max - this.min) * 255.0);
            super.setThreshold(minT, maxT, lutUpdate);
            this.minThreshold = Math.round(minThreshold);
            this.maxThreshold = Math.round(maxThreshold);
        } else {
            super.resetThreshold();
        }
    }

    public void convolve(float[] kernel, int kernelWidth, int kernelHeight) {
        ImageProcessor ip2 = this.convertToFloat();
        ip2.setRoi(this.getRoi());
        new Convolver().convolve(ip2, kernel, kernelWidth, kernelHeight);
        ip2 = ip2.convertToShort(false);
        short[] pixels2 = (short[])ip2.getPixels();
        System.arraycopy(pixels2, 0, this.pixels, 0, this.pixels.length);
    }

    public void noise(double range) {
        Random rnd = new Random();
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                int RandomBrightness = (int)Math.round(rnd.nextGaussian() * range);
                int v = (this.pixels[i] & 0xFFFF) + RandomBrightness;
                if (v < 0) {
                    v = 0;
                }
                if (v > 65535) {
                    v = 65535;
                }
                this.pixels[i] = (short)v;
                ++i;
                ++x;
            }
            ++y;
        }
        this.findMinAndMax();
    }

    public void threshold(int level) {
        int i = 0;
        while (i < this.width * this.height) {
            this.pixels[i] = (this.pixels[i] & 0xFFFF) <= level ? 0 : 255;
            ++i;
        }
        this.newSnapshot = false;
        this.findMinAndMax();
    }

    public void medianFilter() {
    }

    public void erode() {
    }

    public void dilate() {
    }
}

