# This is an Ishmael settings file.  It is okay to edit it with a text
# editor or word processor, provided you save it as TEXT ONLY.  It's
# generally safe to change the values here in ways that seem reasonable,
# though you could undoubtedly make Ishmael fail with some really poor
# choices of values.
# 
# Also:
#    * Keep each line in its original section (Unit) or it will be ignored.
#
#    * A line beginning with '#', like this one, is a comment.
#
#    * Spaces and capitalization in parameter names ARE significant.
#
#    * If you delete a line containing a certain parameter, then loading
#      this settings file will not affect Ishmael's current value of that
#      parameter.  So you can create a settings file with only a handful of
#      lines for your favorite values, and when you load that file, it will
#      set those parameters and leave everything else alone.
#
#    * When you save settings, beware that ALL parameter values are written
#      out, not just the ones you may have set in your parameters file.
#
#    * Ishmael's default settings file -- the one it loads at startup -- is
#      called IshDefault.ipf .


Unit: File input, prefs version 1
    active               = true
    file name            = C:\IshExtras\simu-100,300.wav
    file start time      = 0
    enabled channels     = 11100000000000000000000000000000
    pause after each file = true
    fit file to window   = true
    time source          = 2033329410
    time template        = %2y%2M%2D_%2h%2m%2s.aif
    explicit date        = 1/1/2000
    explicit time        = 9:00:00
    time zone seconds    = 0

Unit: Sound recording, prefs version 1
    recording enabled    = false
    max file length      = 600.000000
    time align files     = true
    record only realtime = true
    directory            = C:\MyDetectedCalls
    sampling enabled     = false
    sampling cycle time  = 86400.000000
    sampling start time  = 21600.000000
    sampling stop time   = 64800.000000
    time align sampling  = false

Unit: Time-domain beamforming, prefs version 1
    beamforming enabled  = false
    0 degrees is Y-axis  = true
    beam angles          = 0:45:180
    plot beam angles     = 70
    plot beam freqs      = 500
    weighting enabled    = true

Unit: Matched filter, prefs version 1
    enabled              = false
    filter file name     = 
    min detected freq    = 0
    max detected freq    = +INF

Unit: Time series display, prefs version 1
    display enabled      = false
    tickmark font name   = Arial
    tickmark font size   = 10
    tickmark font bold   = false
    tickmark length      = 4

Unit: Spectrogram calculation, prefs version 1
    frame size, samples  = 256
    frame size, sec      = 0.032000002
    zero pad             = 0
    hop size             = 128
    window type          = Hamming
    keep same duration   = false
    quadratic scaling    = false

Unit: Equalization, prefs version 1
    equalization enabled = false
    equalization time    = 20
    floor enabled        = false
    floor is automatic   = true
    gram floor value     = 3.632
    ceiling enabled      = false
    ceiling is automatic = true
    gram ceiling value   = 5.2524157

Unit: Energy sum, prefs version 1
    enabled              = false
    lower frequency bound = 50
    upper frequency bound = 400
    ratio enabled        = false
    ratio lower freq bound = 1000
    ratio upper freq bound = 2000

Unit: Spectrogram display, prefs version 1
    brightness           = 3.632
    contrast             = 0.61712563
    color map name       = hot
    display enabled      = true
    tickmark font name   = Arial
    tickmark font size   = 10
    tickmark font bold   = false
    tickmark length      = 4

Unit: Sequence recognition, prefs version 1
    sumautocorr enabled  = false
    sac window length    = 200
    sac hop size fraction = 0.1
    sac min period       = 5
    sac max period       = 10
    use old method       = false

Unit: Detector, prefs version 1
    time averaging enabled = true
    time averaging constant = 20
    detection threshold  = 5
    min call duration    = 3
    max call duration    = 20
    detection neighborhood = 20
    detection channels   = 10000000000000000000000000000000
    save all channels    = false
    time before call     = 60
    time after call      = 60
    retrigger            = true
    display amplitude min = 0
    display amplitude max = 26
    old nbd method       = false

Unit: Matlab, prefs version 1
    matlab command       = plot(ishSelectionSamples(:,1))
    matlab run dir       = C:\MyHome\MyMatlabDir
    do startup.m         = true

Unit: Hyperbolic localization, prefs version 1
    array file name      = C:\IshExtras\simu-100,300.arr
    speed of sound       = 1490.000000
    pair loc phone 1     = 1
    pair loc phone 2     = 3
    map left edge        = -1000
    map right edge       = 1000
    map top edge         = -1000
    map bottom edge      = 1000
    contour beamforming  = false
    contour strip width  = 1000
    map window position  = (555,497,1056,1022)
    bearing/time window position = (447,461,819,675)
    xcorr window position = (2,751,432,963)
    serial com port      = 1
    show xcorr display   = 1
    InstaLoc time before = 0.050000
    InstaLoc time after  = 0.050000
    InstaLoc low freq    = 2000
    InstaLoc high freq   = 8000
    InstaLoc loc method  = 256
    reload array file    = false
    log intermediates    = false

Unit: Spectrogram correlator, prefs version 1
    enabled              = false
    kernel               = %   t0     t1     f0        f1^015^012     0    12.77  50.67     47.59^015^012
    kernel bandwidth     = 3

Unit: Sound card I/O, prefs version 1
    input active         = false
    in device ID         = 0
    sample rate          = 22050.000000
    in channels enabled  = 1000000000000000
    out device ID        = 0
    out speedup          = 1
    out chan left        = 0
    out chan right       = 0
    unprepare buffers    = true

Unit: Sound file I/O, prefs version 1
    time zone offset     = 0
    name template        = sound-%y%M%D-%H%m%s.wav
    binread sample rate  = 44100.000000
    binread #channels    = 1
    binread bytes/sample = 2
    binread float samples = false
    binread ignore start = 0
    binread ignore end   = 0
    binread win byteorder = true
    binread ask unrecognized = false
    binread recog template = *.myExten
    binread name hack    = C:\Ishmael 0.9\bin\foo.i16win
    binwrite bytes/sample = 2
    binwrite float samples = false
    binwrite win byteorder = true
    binwrite name hack   = *.i16win

Unit: Actions and logging, prefs version 1
    log file enabled     = false
    log file name        = C:\DeleteMe\logfile.txt
    action array, size   = 1
    ac name              = Call detected
    ac log name          = false
    ac key               = 
    ac log input name    = false
    ac log outfile       = false
    ac log sel T/F       = false
    ac log key           = false
    ac log comment       = false
    ac comment           = 
    ac next file         = false
    ac save sel          = false
    ac save dir          = C:\IshExtras\retriggerTest
    ac unpause           = false
    ac send Matlab cmd   = false
    ac beamform locate   = false
    ac phone-pair locate = false
    ac hyperbolic locate = false
    action array end     = end of array

Unit: Channels displayed, prefs version 1
    channels displayed   = 11100000000000000000000000000000

Unit: Display scaling, prefs version 1
    main window position = (0,3,720,447)
    time scaling         = 0.3595441
    time scale preferred = true
    lowest amplitude     = -1.4102136
    highest amplitude    = 1.4182135
    amp scale preferred  = false
    lowest frequency     = 0
    highest frequency    = 2500
    freq scale preferred = false
